/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.saber;

import org.bouncycastle.pqc.crypto.saber.SABEREngine;
import org.bouncycastle.pqc.crypto.saber.Utils;

class Poly {
    private static final int KARATSUBA_N = 64;
    private static int SCHB_N = 16;
    private final int N_RES;
    private final int N_SB;
    private final int N_SB_RES;
    private final int SABER_N;
    private final int SABER_L;
    private final SABEREngine engine;
    private final Utils utils;

    public Poly(SABEREngine sABEREngine) {
        this.engine = sABEREngine;
        this.SABER_L = sABEREngine.getSABER_L();
        this.SABER_N = sABEREngine.getSABER_N();
        this.N_RES = this.SABER_N << 1;
        this.N_SB = this.SABER_N >> 2;
        this.N_SB_RES = 2 * this.N_SB - 1;
        this.utils = sABEREngine.getUtils();
    }

    public void GenMatrix(short[][][] sArray, byte[] byArray) {
        byte[] byArray2 = new byte[this.SABER_L * this.engine.getSABER_POLYVECBYTES()];
        this.engine.symmetric.prf(byArray2, byArray, this.engine.getSABER_SEEDBYTES(), byArray2.length);
        int n = 0;
        while (n < this.SABER_L) {
            this.utils.BS2POLVECq(byArray2, n * this.engine.getSABER_POLYVECBYTES(), sArray[n]);
            ++n;
        }
    }

    public void GenSecret(short[][] sArray, byte[] byArray) {
        byte[] byArray2 = new byte[this.SABER_L * this.engine.getSABER_POLYCOINBYTES()];
        this.engine.symmetric.prf(byArray2, byArray, this.engine.getSABER_NOISE_SEEDBYTES(), byArray2.length);
        int n = 0;
        while (n < this.SABER_L) {
            if (!this.engine.usingEffectiveMasking) {
                this.cbd(sArray[n], byArray2, n * this.engine.getSABER_POLYCOINBYTES());
            } else {
                int n2 = 0;
                while (n2 < this.SABER_N / 4) {
                    sArray[n][4 * n2] = (short)((byArray2[n2 + n * this.engine.getSABER_POLYCOINBYTES()] & 3 ^ 2) - 2);
                    sArray[n][4 * n2 + 1] = (short)((byArray2[n2 + n * this.engine.getSABER_POLYCOINBYTES()] >>> 2 & 3 ^ 2) - 2);
                    sArray[n][4 * n2 + 2] = (short)((byArray2[n2 + n * this.engine.getSABER_POLYCOINBYTES()] >>> 4 & 3 ^ 2) - 2);
                    sArray[n][4 * n2 + 3] = (short)((byArray2[n2 + n * this.engine.getSABER_POLYCOINBYTES()] >>> 6 & 3 ^ 2) - 2);
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void InnerProd(short[][] sArray, short[][] sArray2, short[] sArray3) {
        int n = 0;
        while (n < this.SABER_L) {
            this.poly_mul_acc(sArray[n], sArray2[n], sArray3);
            ++n;
        }
    }

    public void MatrixVectorMul(short[][][] sArray, short[][] sArray2, short[][] sArray3, int n) {
        int n2 = 0;
        while (n2 < this.SABER_L) {
            int n3 = 0;
            while (n3 < this.SABER_L) {
                if (n == 1) {
                    this.poly_mul_acc(sArray[n3][n2], sArray2[n3], sArray3[n2]);
                } else {
                    this.poly_mul_acc(sArray[n2][n3], sArray2[n3], sArray3[n2]);
                }
                ++n3;
            }
            ++n2;
        }
    }

    private short OVERFLOWING_MUL(int n, int n2) {
        return (short)(n * n2);
    }

    private void cbd(short[] sArray, byte[] byArray, int n) {
        block7: {
            int[] nArray;
            int[] nArray2;
            block8: {
                block6: {
                    nArray2 = new int[4];
                    nArray = new int[4];
                    if (this.engine.getSABER_MU() != 6) break block6;
                    int n2 = 0;
                    while (n2 < this.SABER_N / 4) {
                        int n3 = (int)this.load_littleendian(byArray, n + 3 * n2, 3);
                        int n4 = 0;
                        int n5 = 0;
                        while (n5 < 3) {
                            n4 += n3 >> n5 & 0x249249;
                            ++n5;
                        }
                        nArray2[0] = n4 & 7;
                        nArray[0] = n4 >>> 3 & 7;
                        nArray2[1] = n4 >>> 6 & 7;
                        nArray[1] = n4 >>> 9 & 7;
                        nArray2[2] = n4 >>> 12 & 7;
                        nArray[2] = n4 >>> 15 & 7;
                        nArray2[3] = n4 >>> 18 & 7;
                        nArray[3] = n4 >>> 21;
                        sArray[4 * n2] = (short)(nArray2[0] - nArray[0]);
                        sArray[4 * n2 + 1] = (short)(nArray2[1] - nArray[1]);
                        sArray[4 * n2 + 2] = (short)(nArray2[2] - nArray[2]);
                        sArray[4 * n2 + 3] = (short)(nArray2[3] - nArray[3]);
                        ++n2;
                    }
                    break block7;
                }
                if (this.engine.getSABER_MU() != 8) break block8;
                int n6 = 0;
                while (n6 < this.SABER_N / 4) {
                    int n7 = (int)this.load_littleendian(byArray, n + 4 * n6, 4);
                    int n8 = 0;
                    int n9 = 0;
                    while (n9 < 4) {
                        n8 += n7 >>> n9 & 0x11111111;
                        ++n9;
                    }
                    nArray2[0] = n8 & 0xF;
                    nArray[0] = n8 >>> 4 & 0xF;
                    nArray2[1] = n8 >>> 8 & 0xF;
                    nArray[1] = n8 >>> 12 & 0xF;
                    nArray2[2] = n8 >>> 16 & 0xF;
                    nArray[2] = n8 >>> 20 & 0xF;
                    nArray2[3] = n8 >>> 24 & 0xF;
                    nArray[3] = n8 >>> 28;
                    sArray[4 * n6] = (short)(nArray2[0] - nArray[0]);
                    sArray[4 * n6 + 1] = (short)(nArray2[1] - nArray[1]);
                    sArray[4 * n6 + 2] = (short)(nArray2[2] - nArray[2]);
                    sArray[4 * n6 + 3] = (short)(nArray2[3] - nArray[3]);
                    ++n6;
                }
                break block7;
            }
            if (this.engine.getSABER_MU() != 10) break block7;
            int n10 = 0;
            while (n10 < this.SABER_N / 4) {
                long l = this.load_littleendian(byArray, n + 5 * n10, 5);
                long l2 = 0L;
                int n11 = 0;
                while (n11 < 5) {
                    l2 += l >>> n11 & 0x842108421L;
                    ++n11;
                }
                nArray2[0] = (int)(l2 & 0x1FL);
                nArray[0] = (int)(l2 >>> 5 & 0x1FL);
                nArray2[1] = (int)(l2 >>> 10 & 0x1FL);
                nArray[1] = (int)(l2 >>> 15 & 0x1FL);
                nArray2[2] = (int)(l2 >>> 20 & 0x1FL);
                nArray[2] = (int)(l2 >>> 25 & 0x1FL);
                nArray2[3] = (int)(l2 >>> 30 & 0x1FL);
                nArray[3] = (int)(l2 >>> 35);
                sArray[4 * n10] = (short)(nArray2[0] - nArray[0]);
                sArray[4 * n10 + 1] = (short)(nArray2[1] - nArray[1]);
                sArray[4 * n10 + 2] = (short)(nArray2[2] - nArray[2]);
                sArray[4 * n10 + 3] = (short)(nArray2[3] - nArray[3]);
                ++n10;
            }
        }
    }

    private void karatsuba_simple(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = new int[31];
        int[] nArray5 = new int[31];
        int[] nArray6 = new int[31];
        int[] nArray7 = new int[63];
        int n = 0;
        while (n < 16) {
            int n2 = nArray[n];
            int n3 = nArray[n + 16];
            int n4 = nArray[n + 32];
            int n5 = nArray[n + 48];
            int n6 = 0;
            while (n6 < 16) {
                int n7 = nArray2[n6];
                int n8 = nArray2[n6 + 16];
                nArray3[n + n6] = nArray3[n + n6] + this.OVERFLOWING_MUL(n2, n7);
                nArray3[n + n6 + 32] = nArray3[n + n6 + 32] + this.OVERFLOWING_MUL(n3, n8);
                int n9 = n7 + n8;
                int n10 = n2 + n3;
                nArray4[n + n6] = (int)((long)nArray4[n + n6] + (long)n9 * (long)n10);
                n9 = nArray2[n6 + 32];
                n10 = nArray2[n6 + 48];
                nArray3[n + n6 + 64] = nArray3[n + n6 + 64] + this.OVERFLOWING_MUL(n9, n4);
                nArray3[n + n6 + 96] = nArray3[n + n6 + 96] + this.OVERFLOWING_MUL(n10, n5);
                int n11 = n4 + n5;
                int n12 = n9 + n10;
                nArray6[n + n6] = nArray6[n + n6] + this.OVERFLOWING_MUL(n11, n12);
                n7 += n9;
                n9 = n2 + n4;
                nArray7[n + n6] = nArray7[n + n6] + this.OVERFLOWING_MUL(n7, n9);
                n8 += n10;
                n10 = n3 + n5;
                nArray7[n + n6 + 32] = nArray7[n + n6 + 32] + this.OVERFLOWING_MUL(n8, n10);
                nArray5[n + n6] = nArray5[n + n6] + this.OVERFLOWING_MUL(n7 += n8, n9 += n10);
                ++n6;
            }
            ++n;
        }
        n = 0;
        while (n < 31) {
            nArray5[n] = nArray5[n] - nArray7[n] - nArray7[n + 32];
            nArray4[n] = nArray4[n] - nArray3[n] - nArray3[n + 32];
            nArray6[n] = nArray6[n] - nArray3[n + 64] - nArray3[n + 96];
            ++n;
        }
        n = 0;
        while (n < 31) {
            nArray7[n + 16] = nArray7[n + 16] + nArray5[n];
            nArray3[n + 16] = nArray3[n + 16] + nArray4[n];
            nArray3[n + 80] = nArray3[n + 80] + nArray6[n];
            ++n;
        }
        n = 0;
        while (n < 63) {
            nArray7[n] = nArray7[n] - nArray3[n] - nArray3[n + 64];
            ++n;
        }
        n = 0;
        while (n < 63) {
            nArray3[n + 32] = nArray3[n + 32] + nArray7[n];
            ++n;
        }
    }

    private long load_littleendian(byte[] byArray, int n, int n2) {
        long l = byArray[n] & 0xFF;
        int n3 = 1;
        while (n3 < n2) {
            l |= (long)(byArray[n + n3] & 0xFF) << 8 * n3;
            ++n3;
        }
        return l;
    }

    private void poly_mul_acc(short[] sArray, short[] sArray2, short[] sArray3) {
        short[] sArray4 = new short[2 * this.SABER_N];
        this.toom_cook_4way(sArray, sArray2, sArray4);
        int n = this.SABER_N;
        while (n < 2 * this.SABER_N) {
            int n2 = n - this.SABER_N;
            sArray3[n2] = (short)(sArray3[n2] + (sArray4[n - this.SABER_N] - sArray4[n]));
            ++n;
        }
    }

    private void toom_cook_4way(short[] sArray, short[] sArray2, short[] sArray3) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = 43691;
        int n10 = 36409;
        int n11 = 61167;
        int[] nArray = new int[this.N_SB];
        int[] nArray2 = new int[this.N_SB];
        int[] nArray3 = new int[this.N_SB];
        int[] nArray4 = new int[this.N_SB];
        int[] nArray5 = new int[this.N_SB];
        int[] nArray6 = new int[this.N_SB];
        int[] nArray7 = new int[this.N_SB];
        int[] nArray8 = new int[this.N_SB];
        int[] nArray9 = new int[this.N_SB];
        int[] nArray10 = new int[this.N_SB];
        int[] nArray11 = new int[this.N_SB];
        int[] nArray12 = new int[this.N_SB];
        int[] nArray13 = new int[this.N_SB];
        int[] nArray14 = new int[this.N_SB];
        int[] nArray15 = new int[this.N_SB_RES];
        int[] nArray16 = new int[this.N_SB_RES];
        int[] nArray17 = new int[this.N_SB_RES];
        int[] nArray18 = new int[this.N_SB_RES];
        int[] nArray19 = new int[this.N_SB_RES];
        int[] nArray20 = new int[this.N_SB_RES];
        int[] nArray21 = new int[this.N_SB_RES];
        short[] sArray4 = sArray3;
        int n12 = 0;
        while (n12 < this.N_SB) {
            n8 = sArray[n12];
            n7 = sArray[n12 + this.N_SB];
            n6 = sArray[n12 + this.N_SB * 2];
            n5 = sArray[n12 + this.N_SB * 3];
            n4 = n8 + n6;
            n3 = n7 + n5;
            n2 = n4 + n3;
            n = n4 - n3;
            nArray3[n12] = n2;
            nArray4[n12] = n;
            n4 = (short)((n8 << 2) + n6 << 1);
            n3 = (short)((n7 << 2) + n5);
            n2 = (short)(n4 + n3);
            n = (short)(n4 - n3);
            nArray5[n12] = n2;
            nArray6[n12] = n;
            nArray2[n12] = n4 = (int)((short)((n5 << 3) + (n6 << 2) + (n7 << 1) + n8));
            nArray7[n12] = n8;
            nArray[n12] = n5;
            ++n12;
        }
        n12 = 0;
        while (n12 < this.N_SB) {
            n8 = sArray2[n12];
            n7 = sArray2[n12 + this.N_SB];
            n6 = sArray2[n12 + this.N_SB * 2];
            n5 = sArray2[n12 + this.N_SB * 3];
            n4 = n8 + n6;
            n3 = n7 + n5;
            n2 = n4 + n3;
            n = n4 - n3;
            nArray10[n12] = n2;
            nArray11[n12] = n;
            n4 = (n8 << 2) + n6 << 1;
            n3 = (n7 << 2) + n5;
            n2 = n4 + n3;
            n = n4 - n3;
            nArray12[n12] = n2;
            nArray13[n12] = n;
            nArray9[n12] = n4 = (n5 << 3) + (n6 << 2) + (n7 << 1) + n8;
            nArray14[n12] = n8;
            nArray8[n12] = n5;
            ++n12;
        }
        this.karatsuba_simple(nArray, nArray8, nArray15);
        this.karatsuba_simple(nArray2, nArray9, nArray16);
        this.karatsuba_simple(nArray3, nArray10, nArray17);
        this.karatsuba_simple(nArray4, nArray11, nArray18);
        this.karatsuba_simple(nArray5, nArray12, nArray19);
        this.karatsuba_simple(nArray6, nArray13, nArray20);
        this.karatsuba_simple(nArray7, nArray14, nArray21);
        int n13 = 0;
        while (n13 < this.N_SB_RES) {
            n8 = nArray15[n13];
            n7 = nArray16[n13];
            n6 = nArray17[n13];
            n5 = nArray18[n13];
            n4 = nArray19[n13];
            n3 = nArray20[n13];
            n2 = nArray21[n13];
            n7 += n4;
            n3 -= n4;
            n5 = (n5 & 0xFFFF) - (n6 & 0xFFFF) >>> 1;
            n4 -= n8;
            n4 -= n2 << 6;
            n4 = (n4 << 1) + n3;
            n7 = n7 - ((n6 += n5) << 6) - n6;
            n6 -= n2;
            n4 = ((n4 & 0xFFFF) - (n6 << 3)) * n9 >> 3;
            n3 += (n7 += 45 * (n6 -= n8));
            n7 = ((n7 & 0xFFFF) + ((n5 & 0xFFFF) << 4)) * n10 >> 1;
            n5 = -(n5 + n7);
            n3 = (30 * (n7 & 0xFFFF) - (n3 & 0xFFFF)) * n11 >> 2;
            n6 -= n4;
            n7 -= n3;
            int n14 = n13;
            sArray4[n14] = (short)(sArray4[n14] + (n2 & 0xFFFF));
            int n15 = n13 + 64;
            sArray4[n15] = (short)(sArray4[n15] + (n3 & 0xFFFF));
            int n16 = n13 + 128;
            sArray4[n16] = (short)(sArray4[n16] + (n4 & 0xFFFF));
            int n17 = n13 + 192;
            sArray4[n17] = (short)(sArray4[n17] + (n5 & 0xFFFF));
            int n18 = n13 + 256;
            sArray4[n18] = (short)(sArray4[n18] + (n6 & 0xFFFF));
            int n19 = n13 + 320;
            sArray4[n19] = (short)(sArray4[n19] + (n7 & 0xFFFF));
            int n20 = n13 + 384;
            sArray4[n20] = (short)(sArray4[n20] + (n8 & 0xFFFF));
            ++n13;
        }
    }
}

