/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.picnic;

import org.bouncycastle.pqc.crypto.picnic.PicnicEngine;
import org.bouncycastle.pqc.crypto.picnic.Utils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

class Tree {
    private static final int MAX_SEED_SIZE_BYTES = 32;
    private int depth;
    byte[][] nodes;
    private int dataSize;
    private boolean[] haveNode;
    private boolean[] exists;
    private int numNodes;
    private int numLeaves;
    private PicnicEngine engine;

    public Tree(PicnicEngine picnicEngine, int n, int n2) {
        this.engine = picnicEngine;
        this.depth = Utils.ceil_log2(n) + 1;
        this.numNodes = (1 << this.depth) - 1 - ((1 << this.depth - 1) - n);
        this.numLeaves = n;
        this.dataSize = n2;
        this.nodes = new byte[this.numNodes][n2];
        int n3 = 0;
        while (n3 < this.numNodes) {
            this.nodes[n3] = new byte[n2];
            ++n3;
        }
        this.haveNode = new boolean[this.numNodes];
        this.exists = new boolean[this.numNodes];
        Arrays.fill(this.exists, this.numNodes - this.numLeaves, this.numNodes, true);
        int n4 = this.numNodes - this.numLeaves;
        while (n4 > 0) {
            if (this.exists(2 * n4 + 1) || this.exists(2 * n4 + 2)) {
                this.exists[n4] = true;
            }
            --n4;
        }
        this.exists[0] = true;
    }

    protected int addMerkleNodes(int[] nArray, int n, byte[] byArray, int n2) {
        int n3 = n2;
        int[] nArray2 = new int[]{0};
        int[] nArray3 = this.getRevealedMerkleNodes(nArray, n, nArray2);
        int n4 = 0;
        while (n4 < nArray2[0]) {
            if ((n3 -= this.dataSize) < 0) {
                return -1;
            }
            System.arraycopy(byArray, n4 * this.dataSize, this.nodes[nArray3[n4]], 0, this.dataSize);
            this.haveNode[nArray3[n4]] = true;
            ++n4;
        }
        if (n3 != 0) {
            return -1;
        }
        return 0;
    }

    protected void buildMerkleTree(byte[][] byArray, byte[] byArray2) {
        int n = this.numNodes - this.numLeaves;
        int n2 = 0;
        while (n2 < this.numLeaves) {
            if (byArray[n2] != null) {
                System.arraycopy(byArray[n2], 0, this.nodes[n + n2], 0, this.dataSize);
                this.haveNode[n + n2] = true;
            }
            ++n2;
        }
        int n3 = this.numNodes;
        while (n3 > 0) {
            this.computeParentHash(n3, byArray2);
            --n3;
        }
    }

    private void computeParentHash(int n, byte[] byArray) {
        if (!this.exists(n)) {
            return;
        }
        int n2 = this.getParent(n);
        if (this.haveNode[n2]) {
            return;
        }
        if (!this.haveNode[2 * n2 + 1]) {
            return;
        }
        if (this.exists(2 * n2 + 2) && !this.haveNode[2 * n2 + 2]) {
            return;
        }
        this.engine.digest.update((byte)3);
        this.engine.digest.update(this.nodes[2 * n2 + 1], 0, this.engine.digestSizeBytes);
        if (this.hasRightChild(n2)) {
            this.engine.digest.update(this.nodes[2 * n2 + 2], 0, this.engine.digestSizeBytes);
        }
        this.engine.digest.update(byArray, 0, 32);
        this.engine.digest.update(Pack.intToLittleEndian(n2), 0, 2);
        this.engine.digest.doFinal(this.nodes[n2], 0, this.engine.digestSizeBytes);
        this.haveNode[n2] = true;
    }

    private boolean contains(int[] nArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n) {
            if (nArray[n3] == n2) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    private boolean exists(int n) {
        if (n >= this.numNodes) {
            return false;
        }
        return this.exists[n];
    }

    private void expandSeeds(byte[] byArray, int n) {
        byte[] byArray2 = new byte[64];
        int n2 = this.getParent(this.numNodes - 1);
        int n3 = 0;
        while (n3 <= n2) {
            if (this.haveNode[n3]) {
                this.hashSeed(byArray2, this.nodes[n3], byArray, (byte)1, n, n3);
                if (!this.haveNode[2 * n3 + 1]) {
                    System.arraycopy(byArray2, 0, this.nodes[2 * n3 + 1], 0, this.engine.seedSizeBytes);
                    this.haveNode[2 * n3 + 1] = true;
                }
                if (this.exists(2 * n3 + 2) && !this.haveNode[2 * n3 + 2]) {
                    System.arraycopy(byArray2, this.engine.seedSizeBytes, this.nodes[2 * n3 + 2], 0, this.engine.seedSizeBytes);
                    this.haveNode[2 * n3 + 2] = true;
                }
            }
            ++n3;
        }
    }

    protected void generateSeeds(byte[] byArray, byte[] byArray2, int n) {
        this.nodes[0] = byArray;
        this.haveNode[0] = true;
        this.expandSeeds(byArray2, n);
    }

    protected byte[] getLeaf(int n) {
        int n2 = this.numNodes - this.numLeaves;
        return this.nodes[n2 + n];
    }

    protected byte[][] getLeaves() {
        return this.nodes;
    }

    protected int getLeavesOffset() {
        return this.numNodes - this.numLeaves;
    }

    private int getParent(int n) {
        if (this.isLeftChild(n)) {
            return (n - 1) / 2;
        }
        return (n - 2) / 2;
    }

    private int[] getRevealedMerkleNodes(int[] nArray, int n, int[] nArray2) {
        int n2;
        int n3 = this.numNodes - this.numLeaves;
        boolean[] blArray = new boolean[this.numNodes];
        int n4 = 0;
        while (n4 < n) {
            blArray[n3 + nArray[n4]] = true;
            ++n4;
        }
        int n5 = n2 = this.getParent(this.numNodes - 1);
        while (n5 > 0) {
            if (this.exists(n5)) {
                if (this.exists(2 * n5 + 2)) {
                    if (blArray[2 * n5 + 1] && blArray[2 * n5 + 2]) {
                        blArray[n5] = true;
                    }
                } else if (blArray[2 * n5 + 1]) {
                    blArray[n5] = true;
                }
            }
            --n5;
        }
        int[] nArray3 = new int[this.numLeaves];
        int n6 = 0;
        int n7 = 0;
        while (n7 < n) {
            int n8 = nArray[n7] + n3;
            do {
                if (blArray[this.getParent(n8)]) continue;
                if (this.contains(nArray3, n6, n8)) break;
                nArray3[n6] = n8;
                ++n6;
                break;
            } while ((n8 = this.getParent(n8)) != 0);
            ++n7;
        }
        nArray2[0] = n6;
        return nArray3;
    }

    private int[] getRevealedNodes(int[] nArray, int n, int[] nArray2) {
        int n2;
        int n3 = this.depth - 1;
        int[][] nArray3 = new int[n3][n];
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            nArray3[n5][n4] = n2 = nArray[n4] + (this.numNodes - this.numLeaves);
            ++n5;
            while ((n2 = this.getParent(n2)) != 0) {
                nArray3[n5][n4] = n2;
                ++n5;
            }
            ++n4;
        }
        int[] nArray4 = new int[this.numLeaves];
        n2 = 0;
        int n6 = 0;
        while (n6 < n3) {
            int n7 = 0;
            while (n7 < n) {
                int n8;
                if (this.hasSibling(nArray3[n6][n7]) && !this.contains(nArray3[n6], n, n8 = this.getSibling(nArray3[n6][n7]))) {
                    while (!this.hasRightChild(n8) && !this.isLeafNode(n8)) {
                        n8 = 2 * n8 + 1;
                    }
                    if (!this.contains(nArray4, n2, n8)) {
                        nArray4[n2] = n8;
                        ++n2;
                    }
                }
                ++n7;
            }
            ++n6;
        }
        nArray2[0] = n2;
        return nArray4;
    }

    private int getSibling(int n) {
        if (this.isLeftChild(n)) {
            if (n + 1 < this.numNodes) {
                return n + 1;
            }
            return 0;
        }
        return n - 1;
    }

    boolean hasLeftChild(Tree tree, int n) {
        return 2 * n + 1 < this.numNodes;
    }

    private boolean hasRightChild(int n) {
        return 2 * n + 2 < this.numNodes && this.exists(n);
    }

    private boolean hasSibling(int n) {
        if (!this.exists(n)) {
            return false;
        }
        return !this.isLeftChild(n) || this.exists(n + 1);
    }

    private void hashSeed(byte[] byArray, byte[] byArray2, byte[] byArray3, byte by, int n, int n2) {
        this.engine.digest.update(by);
        this.engine.digest.update(byArray2, 0, this.engine.seedSizeBytes);
        this.engine.digest.update(byArray3, 0, 32);
        this.engine.digest.update(Pack.shortToLittleEndian((short)(n & 0xFFFF)), 0, 2);
        this.engine.digest.update(Pack.shortToLittleEndian((short)(n2 & 0xFFFF)), 0, 2);
        this.engine.digest.doFinal(byArray, 0, 2 * this.engine.seedSizeBytes);
    }

    private boolean isLeafNode(int n) {
        return 2 * n + 1 >= this.numNodes;
    }

    private boolean isLeftChild(int n) {
        return n % 2 == 1;
    }

    protected byte[] openMerkleTree(int[] nArray, int n, int[] nArray2) {
        byte[] byArray;
        int[] nArray3 = new int[1];
        int[] nArray4 = this.getRevealedMerkleNodes(nArray, n, nArray3);
        nArray2[0] = nArray3[0] * this.dataSize;
        byte[] byArray2 = byArray = new byte[nArray2[0]];
        int n2 = 0;
        while (n2 < nArray3[0]) {
            System.arraycopy(this.nodes[nArray4[n2]], 0, byArray, n2 * this.dataSize, this.dataSize);
            ++n2;
        }
        return byArray2;
    }

    protected int openMerkleTreeSize(int[] nArray, int n) {
        int[] nArray2 = new int[1];
        this.getRevealedMerkleNodes(nArray, n, nArray2);
        return nArray2[0] * this.engine.digestSizeBytes;
    }

    protected int reconstructSeeds(int[] nArray, int n, byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4 = 0;
        int n5 = n2;
        int[] nArray2 = new int[]{0};
        int[] nArray3 = this.getRevealedNodes(nArray, n, nArray2);
        int n6 = 0;
        while (n6 < nArray2[0]) {
            if ((n5 -= this.engine.seedSizeBytes) < 0) {
                return -1;
            }
            System.arraycopy(byArray, n6 * this.engine.seedSizeBytes, this.nodes[nArray3[n6]], 0, this.engine.seedSizeBytes);
            this.haveNode[nArray3[n6]] = true;
            ++n6;
        }
        this.expandSeeds(byArray2, n3);
        return n4;
    }

    protected int revealSeeds(int[] nArray, int n, byte[] byArray, int n2) {
        int[] nArray2 = new int[]{0};
        int n3 = n2;
        int[] nArray3 = this.getRevealedNodes(nArray, n, nArray2);
        int n4 = 0;
        while (n4 < nArray2[0]) {
            if ((n3 -= this.engine.seedSizeBytes) < 0) {
                return 0;
            }
            System.arraycopy(this.nodes[nArray3[n4]], 0, byArray, n4 * this.engine.seedSizeBytes, this.engine.seedSizeBytes);
            ++n4;
        }
        return byArray.length - n3;
    }

    protected int revealSeedsSize(int[] nArray, int n) {
        int[] nArray2 = new int[]{0};
        this.getRevealedNodes(nArray, n, nArray2);
        return nArray2[0] * this.engine.seedSizeBytes;
    }

    protected int verifyMerkleTree(byte[][] byArray, byte[] byArray2) {
        int n = this.numNodes - this.numLeaves;
        int n2 = 0;
        while (n2 < this.numLeaves) {
            if (byArray[n2] != null) {
                if (this.haveNode[n + n2]) {
                    return -1;
                }
                if (byArray[n2] != null) {
                    System.arraycopy(byArray[n2], 0, this.nodes[n + n2], 0, this.dataSize);
                    this.haveNode[n + n2] = true;
                }
            }
            ++n2;
        }
        int n3 = this.numNodes;
        while (n3 > 0) {
            this.computeParentHash(n3, byArray2);
            --n3;
        }
        if (!this.haveNode[0]) {
            return -1;
        }
        return 0;
    }
}

