/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.ntru;

import org.bouncycastle.pqc.crypto.ntru.PolynomialPair;
import org.bouncycastle.pqc.math.ntru.HPSPolynomial;
import org.bouncycastle.pqc.math.ntru.HRSSPolynomial;
import org.bouncycastle.pqc.math.ntru.Polynomial;
import org.bouncycastle.pqc.math.ntru.parameters.NTRUHPSParameterSet;
import org.bouncycastle.pqc.math.ntru.parameters.NTRUHRSSParameterSet;
import org.bouncycastle.pqc.math.ntru.parameters.NTRUParameterSet;
import org.bouncycastle.util.Arrays;

class NTRUSampling {
    private final NTRUParameterSet params;

    public NTRUSampling(NTRUParameterSet nTRUParameterSet) {
        this.params = nTRUParameterSet;
    }

    private static int mod3(int n) {
        return n % 3;
    }

    public PolynomialPair sampleFg(byte[] byArray) {
        if (this.params instanceof NTRUHRSSParameterSet) {
            HRSSPolynomial hRSSPolynomial = this.sampleIidPlus(Arrays.copyOfRange(byArray, 0, this.params.sampleIidBytes()));
            HRSSPolynomial hRSSPolynomial2 = this.sampleIidPlus(Arrays.copyOfRange(byArray, this.params.sampleIidBytes(), byArray.length));
            return new PolynomialPair(hRSSPolynomial, hRSSPolynomial2);
        }
        if (this.params instanceof NTRUHPSParameterSet) {
            HPSPolynomial hPSPolynomial = (HPSPolynomial)this.sampleIid(Arrays.copyOfRange(byArray, 0, this.params.sampleIidBytes()));
            HPSPolynomial hPSPolynomial2 = this.sampleFixedType(Arrays.copyOfRange(byArray, this.params.sampleIidBytes(), byArray.length));
            return new PolynomialPair(hPSPolynomial, hPSPolynomial2);
        }
        throw new IllegalArgumentException("Invalid polynomial type");
    }

    public HPSPolynomial sampleFixedType(byte[] byArray) {
        int n = this.params.n();
        int n2 = ((NTRUHPSParameterSet)this.params).weight();
        HPSPolynomial hPSPolynomial = new HPSPolynomial((NTRUHPSParameterSet)this.params);
        int[] nArray = new int[n - 1];
        int n3 = 0;
        while (n3 < (n - 1) / 4) {
            nArray[4 * n3] = ((byArray[15 * n3] & 0xFF) << 2) + ((byArray[15 * n3 + 1] & 0xFF) << 10) + ((byArray[15 * n3 + 2] & 0xFF) << 18) + ((byArray[15 * n3 + 3] & 0xFF) << 26);
            nArray[4 * n3 + 1] = ((byArray[15 + n3 * 3] & 0xFF & 0xC0) >> 4) + ((byArray[15 * n3 + 4] & 0xFF) << 4) + ((byArray[15 * n3 + 5] & 0xFF) << 12) + ((byArray[15 * n3 + 6] & 0xFF) << 20) + ((byArray[15 * n3 + 7] & 0xFF) << 28);
            nArray[4 * n3 + 2] = ((byArray[15 + n3 * 7] & 0xFF & 0xF0) >> 2) + ((byArray[15 * n3 + 8] & 0xFF) << 6) + ((byArray[15 * n3 + 9] & 0xFF) << 14) + ((byArray[15 * n3 + 10] & 0xFF) << 22) + ((byArray[15 * n3 + 11] & 0xFF) << 30);
            nArray[4 * n3 + 3] = (byArray[15 * n3 + 11] & 0xFF & 0xFC) + ((byArray[15 * n3 + 12] & 0xFF) << 8) + ((byArray[15 * n3 + 13] & 0xFF) << 16) + ((byArray[15 * n3 + 14] & 0xFF) << 24);
            ++n3;
        }
        if (n - 1 > (n - 1) / 4 * 4) {
            n3 = (n - 1) / 4;
            nArray[4 * n3] = ((byArray[15 * n3] & 0xFF) << 2) + ((byArray[15 * n3 + 1] & 0xFF) << 10) + ((byArray[15 * n3 + 2] & 0xFF) << 18) + ((byArray[15 * n3 + 3] & 0xFF) << 26);
            nArray[4 * n3 + 1] = ((byArray[15 + n3 * 3] & 0xFF & 0xC0) >> 4) + ((byArray[15 * n3 + 4] & 0xFF) << 4) + ((byArray[15 * n3 + 5] & 0xFF) << 12) + ((byArray[15 * n3 + 6] & 0xFF) << 20) + ((byArray[15 * n3 + 7] & 0xFF) << 28);
        }
        n3 = 0;
        while (n3 < n2 / 2) {
            int n4 = n3++;
            nArray[n4] = nArray[n4] | 1;
        }
        n3 = n2 / 2;
        while (n3 < n2) {
            int n5 = n3++;
            nArray[n5] = nArray[n5] | 2;
        }
        java.util.Arrays.sort(nArray);
        n3 = 0;
        while (n3 < n - 1) {
            hPSPolynomial.coeffs[n3] = (short)(nArray[n3] & 3);
            ++n3;
        }
        hPSPolynomial.coeffs[n - 1] = 0;
        return hPSPolynomial;
    }

    public Polynomial sampleIid(byte[] byArray) {
        Polynomial polynomial = this.params.createPolynomial();
        int n = 0;
        while (n < this.params.n() - 1) {
            polynomial.coeffs[n] = (short)NTRUSampling.mod3(byArray[n] & 0xFF);
            ++n;
        }
        polynomial.coeffs[this.params.n() - 1] = 0;
        return polynomial;
    }

    public HRSSPolynomial sampleIidPlus(byte[] byArray) {
        int n = this.params.n();
        int n2 = 0;
        HRSSPolynomial hRSSPolynomial = (HRSSPolynomial)this.sampleIid(byArray);
        int n3 = 0;
        while (n3 < n - 1) {
            hRSSPolynomial.coeffs[n3] = (short)(hRSSPolynomial.coeffs[n3] | -(hRSSPolynomial.coeffs[n3] >>> 1));
            ++n3;
        }
        n3 = 0;
        while (n3 < n - 1) {
            n2 = (short)(n2 + (short)(hRSSPolynomial.coeffs[n3 + 1] * hRSSPolynomial.coeffs[n3]));
            ++n3;
        }
        n2 = (short)(1 | -((n2 & 0xFFFF) >>> 15));
        n3 = 0;
        while (n3 < n - 1) {
            hRSSPolynomial.coeffs[n3] = (short)(n2 * hRSSPolynomial.coeffs[n3]);
            n3 += 2;
        }
        n3 = 0;
        while (n3 < n - 1) {
            hRSSPolynomial.coeffs[n3] = (short)(3 & (hRSSPolynomial.coeffs[n3] & 0xFFFF ^ (hRSSPolynomial.coeffs[n3] & 0xFFFF) >>> 15));
            ++n3;
        }
        return hRSSPolynomial;
    }

    public PolynomialPair sampleRm(byte[] byArray) {
        if (this.params instanceof NTRUHRSSParameterSet) {
            HRSSPolynomial hRSSPolynomial = (HRSSPolynomial)this.sampleIid(Arrays.copyOfRange(byArray, 0, this.params.sampleIidBytes()));
            HRSSPolynomial hRSSPolynomial2 = (HRSSPolynomial)this.sampleIid(Arrays.copyOfRange(byArray, this.params.sampleIidBytes(), byArray.length));
            return new PolynomialPair(hRSSPolynomial, hRSSPolynomial2);
        }
        if (this.params instanceof NTRUHPSParameterSet) {
            HPSPolynomial hPSPolynomial = (HPSPolynomial)this.sampleIid(Arrays.copyOfRange(byArray, 0, this.params.sampleIidBytes()));
            HPSPolynomial hPSPolynomial2 = this.sampleFixedType(Arrays.copyOfRange(byArray, this.params.sampleIidBytes(), byArray.length));
            return new PolynomialPair(hPSPolynomial, hPSPolynomial2);
        }
        throw new IllegalArgumentException("Invalid polynomial type");
    }
}

