/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.ntru;

import org.bouncycastle.pqc.crypto.ntru.NTRUSampling;
import org.bouncycastle.pqc.crypto.ntru.OWCPADecryptResult;
import org.bouncycastle.pqc.crypto.ntru.OWCPAKeyPair;
import org.bouncycastle.pqc.crypto.ntru.PolynomialPair;
import org.bouncycastle.pqc.math.ntru.HPSPolynomial;
import org.bouncycastle.pqc.math.ntru.Polynomial;
import org.bouncycastle.pqc.math.ntru.parameters.NTRUHPSParameterSet;
import org.bouncycastle.pqc.math.ntru.parameters.NTRUHRSSParameterSet;
import org.bouncycastle.pqc.math.ntru.parameters.NTRUParameterSet;
import org.bouncycastle.util.Arrays;

class NTRUOWCPA {
    private final NTRUParameterSet params;
    private final NTRUSampling sampling;

    public NTRUOWCPA(NTRUParameterSet nTRUParameterSet) {
        this.params = nTRUParameterSet;
        this.sampling = new NTRUSampling(nTRUParameterSet);
    }

    private int checkCiphertext(byte[] byArray) {
        short s = byArray[this.params.ntruCiphertextBytes() - 1];
        s = (short)(s & 255 << 8 - (7 & this.params.logQ() * this.params.packDegree()));
        return 1 & ~s + 1 >>> 15;
    }

    private int checkM(HPSPolynomial hPSPolynomial) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.params.n() - 1) {
            n2 = (short)(n2 + (hPSPolynomial.coeffs[n4] & 1));
            n3 = (short)(n3 + (hPSPolynomial.coeffs[n4] & 2));
            ++n4;
        }
        n |= n2 ^ n3 >>> 1;
        return 1 & ~(n |= n3 ^ ((NTRUHPSParameterSet)this.params).weight()) + 1 >>> 31;
    }

    private int checkR(Polynomial polynomial) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.params.n() - 1) {
            short s = polynomial.coeffs[n2];
            n |= s + 1 & this.params.q() - 4;
            n |= s + 2 & 4;
            ++n2;
        }
        return 1 & ~(n |= polynomial.coeffs[this.params.n() - 1]) + 1 >>> 31;
    }

    public OWCPADecryptResult decrypt(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = byArray2;
        byte[] byArray4 = new byte[this.params.owcpaMsgBytes()];
        Polynomial polynomial = this.params.createPolynomial();
        Polynomial polynomial2 = this.params.createPolynomial();
        Polynomial polynomial3 = this.params.createPolynomial();
        Polynomial polynomial4 = this.params.createPolynomial();
        Polynomial polynomial5 = polynomial;
        Polynomial polynomial6 = polynomial2;
        Polynomial polynomial7 = polynomial3;
        Polynomial polynomial8 = polynomial2;
        Polynomial polynomial9 = polynomial3;
        Polynomial polynomial10 = polynomial4;
        Polynomial polynomial11 = polynomial2;
        Polynomial polynomial12 = polynomial3;
        Polynomial polynomial13 = polynomial4;
        Polynomial polynomial14 = polynomial;
        polynomial5.rqSumZeroFromBytes(byArray);
        polynomial6.s3FromBytes(byArray3);
        polynomial6.z3ToZq();
        polynomial7.rqMul(polynomial5, polynomial6);
        polynomial8.rqToS3(polynomial7);
        polynomial9.s3FromBytes(Arrays.copyOfRange(byArray3, this.params.packTrinaryBytes(), byArray3.length));
        polynomial10.s3Mul(polynomial8, polynomial9);
        byte[] byArray5 = polynomial10.s3ToBytes(byArray4.length - this.params.packTrinaryBytes());
        int n = 0;
        n |= this.checkCiphertext(byArray);
        if (this.params instanceof NTRUHPSParameterSet) {
            n |= this.checkM((HPSPolynomial)polynomial10);
        }
        polynomial11.lift(polynomial10);
        int n2 = 0;
        while (n2 < this.params.n()) {
            polynomial14.coeffs[n2] = (short)(polynomial5.coeffs[n2] - polynomial11.coeffs[n2]);
            ++n2;
        }
        polynomial12.sqFromBytes(Arrays.copyOfRange(byArray3, 2 * this.params.packTrinaryBytes(), byArray3.length));
        polynomial13.sqMul(polynomial14, polynomial12);
        polynomial13.trinaryZqToZ3();
        byte[] byArray6 = polynomial13.s3ToBytes(this.params.owcpaMsgBytes());
        System.arraycopy(byArray6, 0, byArray4, 0, byArray6.length);
        System.arraycopy(byArray5, 0, byArray4, this.params.packTrinaryBytes(), byArray5.length);
        return new OWCPADecryptResult(byArray4, n |= this.checkR(polynomial13));
    }

    public byte[] encrypt(Polynomial polynomial, Polynomial polynomial2, byte[] byArray) {
        Polynomial polynomial3 = this.params.createPolynomial();
        Polynomial polynomial4 = this.params.createPolynomial();
        Polynomial polynomial5 = polynomial3;
        Polynomial polynomial6 = polynomial3;
        Polynomial polynomial7 = polynomial4;
        polynomial5.rqSumZeroFromBytes(byArray);
        polynomial7.rqMul(polynomial, polynomial5);
        polynomial6.lift(polynomial2);
        int n = 0;
        while (n < this.params.n()) {
            int n2 = n;
            polynomial7.coeffs[n2] = (short)(polynomial7.coeffs[n2] + polynomial6.coeffs[n]);
            ++n;
        }
        return polynomial7.rqSumZeroToBytes(this.params.ntruCiphertextBytes());
    }

    public OWCPAKeyPair keypair(byte[] byArray) {
        byte[] byArray2 = new byte[this.params.owcpaSecretKeyBytes()];
        int n = this.params.n();
        int n2 = this.params.q();
        Polynomial polynomial = this.params.createPolynomial();
        Polynomial polynomial2 = this.params.createPolynomial();
        Polynomial polynomial3 = this.params.createPolynomial();
        Polynomial polynomial4 = polynomial;
        Polynomial polynomial5 = polynomial;
        Polynomial polynomial6 = polynomial2;
        Polynomial polynomial7 = polynomial3;
        Polynomial polynomial8 = polynomial;
        Polynomial polynomial9 = polynomial;
        PolynomialPair polynomialPair = this.sampling.sampleFg(byArray);
        Polynomial polynomial10 = polynomialPair.f();
        Polynomial polynomial11 = polynomialPair.g();
        polynomial4.s3Inv(polynomial10);
        byte[] byArray3 = polynomial10.s3ToBytes(this.params.owcpaMsgBytes());
        System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
        byte[] byArray4 = polynomial4.s3ToBytes(byArray2.length - this.params.packTrinaryBytes());
        System.arraycopy(byArray4, 0, byArray2, this.params.packTrinaryBytes(), byArray4.length);
        polynomial10.z3ToZq();
        polynomial11.z3ToZq();
        if (this.params instanceof NTRUHRSSParameterSet) {
            int n3 = n - 1;
            while (n3 > 0) {
                polynomial11.coeffs[n3] = (short)(3 * (polynomial11.coeffs[n3 - 1] - polynomial11.coeffs[n3]));
                --n3;
            }
            polynomial11.coeffs[0] = (short)(-(3 * polynomial11.coeffs[0]));
        } else {
            int n4 = 0;
            while (n4 < n) {
                polynomial11.coeffs[n4] = (short)(3 * polynomial11.coeffs[n4]);
                ++n4;
            }
        }
        polynomial5.rqMul(polynomial11, polynomial10);
        polynomial6.rqInv(polynomial5);
        polynomial7.rqMul(polynomial6, polynomial10);
        polynomial8.sqMul(polynomial7, polynomial10);
        byte[] byArray5 = polynomial8.sqToBytes(byArray2.length - 2 * this.params.packTrinaryBytes());
        System.arraycopy(byArray5, 0, byArray2, 2 * this.params.packTrinaryBytes(), byArray5.length);
        polynomial7.rqMul(polynomial6, polynomial11);
        polynomial9.rqMul(polynomial7, polynomial11);
        byte[] byArray6 = polynomial9.rqSumZeroToBytes(this.params.owcpaPublicKeyBytes());
        return new OWCPAKeyPair(byArray6, byArray2);
    }
}

