/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.ntru;

import org.bouncycastle.crypto.EncapsulatedSecretExtractor;
import org.bouncycastle.crypto.digests.SHA3Digest;
import org.bouncycastle.pqc.crypto.ntru.NTRUOWCPA;
import org.bouncycastle.pqc.crypto.ntru.NTRUParameters;
import org.bouncycastle.pqc.crypto.ntru.NTRUPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.ntru.OWCPADecryptResult;
import org.bouncycastle.pqc.math.ntru.parameters.NTRUParameterSet;
import org.bouncycastle.util.Arrays;

public class NTRUKEMExtractor
implements EncapsulatedSecretExtractor {
    private final NTRUParameters params;
    private final NTRUPrivateKeyParameters ntruPrivateKey;

    public NTRUKEMExtractor(NTRUPrivateKeyParameters nTRUPrivateKeyParameters) {
        this.params = nTRUPrivateKeyParameters.getParameters();
        this.ntruPrivateKey = nTRUPrivateKeyParameters;
    }

    private void cmov(byte[] byArray, byte[] byArray2, byte by) {
        by = (byte)(~by + 1);
        int n = 0;
        while (n < byArray.length) {
            int n2 = n;
            byArray[n2] = (byte)(byArray[n2] ^ by & (byArray2[n] ^ byArray[n]));
            ++n;
        }
    }

    public byte[] extractSecret(byte[] byArray) {
        NTRUParameterSet nTRUParameterSet = this.params.parameterSet;
        byte[] byArray2 = this.ntruPrivateKey.privateKey;
        byte[] byArray3 = new byte[nTRUParameterSet.prfKeyBytes() + nTRUParameterSet.ntruCiphertextBytes()];
        NTRUOWCPA nTRUOWCPA = new NTRUOWCPA(nTRUParameterSet);
        OWCPADecryptResult oWCPADecryptResult = nTRUOWCPA.decrypt(byArray, this.ntruPrivateKey.privateKey);
        byte[] byArray4 = oWCPADecryptResult.rm;
        int n = oWCPADecryptResult.fail;
        SHA3Digest sHA3Digest = new SHA3Digest(256);
        byte[] byArray5 = new byte[sHA3Digest.getDigestSize()];
        sHA3Digest.update(byArray4, 0, byArray4.length);
        sHA3Digest.doFinal(byArray5, 0);
        int n2 = 0;
        while (n2 < nTRUParameterSet.prfKeyBytes()) {
            byArray3[n2] = byArray2[n2 + nTRUParameterSet.owcpaSecretKeyBytes()];
            ++n2;
        }
        n2 = 0;
        while (n2 < nTRUParameterSet.ntruCiphertextBytes()) {
            byArray3[nTRUParameterSet.prfKeyBytes() + n2] = byArray[n2];
            ++n2;
        }
        sHA3Digest.reset();
        sHA3Digest.update(byArray3, 0, byArray3.length);
        sHA3Digest.doFinal(byArray4, 0);
        this.cmov(byArray5, byArray4, (byte)n);
        byte[] byArray6 = Arrays.copyOfRange(byArray5, 0, nTRUParameterSet.sharedKeyBytes());
        Arrays.clear(byArray5);
        return byArray6;
    }

    public int getEncapsulationLength() {
        return this.params.parameterSet.ntruCiphertextBytes();
    }
}

