/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mlkem;

import org.bouncycastle.pqc.crypto.mlkem.MLKEMEngine;
import org.bouncycastle.pqc.crypto.mlkem.Poly;
import org.bouncycastle.util.Arrays;

class PolyVec {
    Poly[] vec;
    private MLKEMEngine engine;
    private int kyberK;
    private int polyVecBytes;

    public PolyVec() throws Exception {
        throw new Exception("Requires Parameter");
    }

    public PolyVec(MLKEMEngine mLKEMEngine) {
        this.engine = mLKEMEngine;
        this.kyberK = mLKEMEngine.getKyberK();
        this.polyVecBytes = mLKEMEngine.getKyberPolyVecBytes();
        this.vec = new Poly[this.kyberK];
        int n = 0;
        while (n < this.kyberK) {
            this.vec[n] = new Poly(mLKEMEngine);
            ++n;
        }
    }

    public void addPoly(PolyVec polyVec) {
        int n = 0;
        while (n < this.kyberK) {
            this.getVectorIndex(n).addCoeffs(polyVec.getVectorIndex(n));
            ++n;
        }
    }

    public byte[] compressPolyVec() {
        this.conditionalSubQ();
        byte[] byArray = new byte[this.engine.getKyberPolyVecCompressedBytes()];
        int n = 0;
        if (this.engine.getKyberPolyVecCompressedBytes() == this.kyberK * 320) {
            short[] sArray = new short[4];
            int n2 = 0;
            while (n2 < this.kyberK) {
                int n3 = 0;
                while (n3 < 64) {
                    int n4 = 0;
                    while (n4 < 4) {
                        long l = this.getVectorIndex(n2).getCoeffIndex(4 * n3 + n4);
                        l <<= 10;
                        l += 1665L;
                        l *= 1290167L;
                        l >>= 32;
                        sArray[n4] = (short)(l &= 0x3FFL);
                        ++n4;
                    }
                    byArray[n] = (byte)sArray[0];
                    byArray[n + 1] = (byte)(sArray[0] >> 8 | sArray[1] << 2);
                    byArray[n + 2] = (byte)(sArray[1] >> 6 | sArray[2] << 4);
                    byArray[n + 3] = (byte)(sArray[2] >> 4 | sArray[3] << 6);
                    byArray[n + 4] = (byte)(sArray[3] >> 2);
                    n += 5;
                    ++n3;
                }
                ++n2;
            }
        } else if (this.engine.getKyberPolyVecCompressedBytes() == this.kyberK * 352) {
            short[] sArray = new short[8];
            int n5 = 0;
            while (n5 < this.kyberK) {
                int n6 = 0;
                while (n6 < 32) {
                    int n7 = 0;
                    while (n7 < 8) {
                        long l = this.getVectorIndex(n5).getCoeffIndex(8 * n6 + n7);
                        l <<= 11;
                        l += 1664L;
                        l *= 645084L;
                        l >>= 31;
                        sArray[n7] = (short)(l &= 0x7FFL);
                        ++n7;
                    }
                    byArray[n] = (byte)sArray[0];
                    byArray[n + 1] = (byte)(sArray[0] >> 8 | sArray[1] << 3);
                    byArray[n + 2] = (byte)(sArray[1] >> 5 | sArray[2] << 6);
                    byArray[n + 3] = (byte)(sArray[2] >> 2);
                    byArray[n + 4] = (byte)(sArray[2] >> 10 | sArray[3] << 1);
                    byArray[n + 5] = (byte)(sArray[3] >> 7 | sArray[4] << 4);
                    byArray[n + 6] = (byte)(sArray[4] >> 4 | sArray[5] << 7);
                    byArray[n + 7] = (byte)(sArray[5] >> 1);
                    byArray[n + 8] = (byte)(sArray[5] >> 9 | sArray[6] << 2);
                    byArray[n + 9] = (byte)(sArray[6] >> 6 | sArray[7] << 5);
                    byArray[n + 10] = (byte)(sArray[7] >> 3);
                    n += 11;
                    ++n6;
                }
                ++n5;
            }
        } else {
            throw new RuntimeException("Kyber PolyVecCompressedBytes neither 320 * KyberK or 352 * KyberK!");
        }
        return byArray;
    }

    public void conditionalSubQ() {
        int n = 0;
        while (n < this.kyberK) {
            this.getVectorIndex(n).conditionalSubQ();
            ++n;
        }
    }

    public void decompressPolyVec(byte[] byArray) {
        int n = 0;
        if (this.engine.getKyberPolyVecCompressedBytes() == this.kyberK * 320) {
            short[] sArray = new short[4];
            int n2 = 0;
            while (n2 < this.kyberK) {
                int n3 = 0;
                while (n3 < 64) {
                    sArray[0] = (short)(byArray[n] & 0xFF | (short)((byArray[n + 1] & 0xFF) << 8));
                    sArray[1] = (short)((byArray[n + 1] & 0xFF) >> 2 | (short)((byArray[n + 2] & 0xFF) << 6));
                    sArray[2] = (short)((byArray[n + 2] & 0xFF) >> 4 | (short)((byArray[n + 3] & 0xFF) << 4));
                    sArray[3] = (short)((byArray[n + 3] & 0xFF) >> 6 | (short)((byArray[n + 4] & 0xFF) << 2));
                    n += 5;
                    int n4 = 0;
                    while (n4 < 4) {
                        this.vec[n2].setCoeffIndex(4 * n3 + n4, (short)((sArray[n4] & 0x3FF) * 3329 + 512 >> 10));
                        ++n4;
                    }
                    ++n3;
                }
                ++n2;
            }
        } else if (this.engine.getKyberPolyVecCompressedBytes() == this.kyberK * 352) {
            short[] sArray = new short[8];
            int n5 = 0;
            while (n5 < this.kyberK) {
                int n6 = 0;
                while (n6 < 32) {
                    sArray[0] = (short)(byArray[n] & 0xFF | (short)(byArray[n + 1] & 0xFF) << 8);
                    sArray[1] = (short)((byArray[n + 1] & 0xFF) >> 3 | (short)(byArray[n + 2] & 0xFF) << 5);
                    sArray[2] = (short)((byArray[n + 2] & 0xFF) >> 6 | (short)(byArray[n + 3] & 0xFF) << 2 | (short)((byArray[n + 4] & 0xFF) << 10));
                    sArray[3] = (short)((byArray[n + 4] & 0xFF) >> 1 | (short)(byArray[n + 5] & 0xFF) << 7);
                    sArray[4] = (short)((byArray[n + 5] & 0xFF) >> 4 | (short)(byArray[n + 6] & 0xFF) << 4);
                    sArray[5] = (short)((byArray[n + 6] & 0xFF) >> 7 | (short)(byArray[n + 7] & 0xFF) << 1 | (short)((byArray[n + 8] & 0xFF) << 9));
                    sArray[6] = (short)((byArray[n + 8] & 0xFF) >> 2 | (short)(byArray[n + 9] & 0xFF) << 6);
                    sArray[7] = (short)((byArray[n + 9] & 0xFF) >> 5 | (short)(byArray[n + 10] & 0xFF) << 3);
                    n += 11;
                    int n7 = 0;
                    while (n7 < 8) {
                        this.vec[n5].setCoeffIndex(8 * n6 + n7, (short)((sArray[n7] & 0x7FF) * 3329 + 1024 >> 11));
                        ++n7;
                    }
                    ++n6;
                }
                ++n5;
            }
        } else {
            throw new RuntimeException("Kyber PolyVecCompressedBytes neither 320 * KyberK or 352 * KyberK!");
        }
    }

    public void fromBytes(byte[] byArray) {
        int n = 0;
        while (n < this.kyberK) {
            this.getVectorIndex(n).fromBytes(Arrays.copyOfRange(byArray, n * 384, (n + 1) * 384));
            ++n;
        }
    }

    public Poly getVectorIndex(int n) {
        return this.vec[n];
    }

    public static void pointwiseAccountMontgomery(Poly poly, PolyVec polyVec, PolyVec polyVec2, MLKEMEngine mLKEMEngine) {
        Poly poly2 = new Poly(mLKEMEngine);
        Poly.baseMultMontgomery(poly, polyVec.getVectorIndex(0), polyVec2.getVectorIndex(0));
        int n = 1;
        while (n < mLKEMEngine.getKyberK()) {
            Poly.baseMultMontgomery(poly2, polyVec.getVectorIndex(n), polyVec2.getVectorIndex(n));
            poly.addCoeffs(poly2);
            ++n;
        }
        poly.reduce();
    }

    public void polyVecInverseNttToMont() {
        int n = 0;
        while (n < this.kyberK) {
            this.getVectorIndex(n).polyInverseNttToMont();
            ++n;
        }
    }

    public void polyVecNtt() {
        int n = 0;
        while (n < this.kyberK) {
            this.getVectorIndex(n).polyNtt();
            ++n;
        }
    }

    public void reducePoly() {
        int n = 0;
        while (n < this.kyberK) {
            this.getVectorIndex(n).reduce();
            ++n;
        }
    }

    public byte[] toBytes() {
        byte[] byArray = new byte[this.polyVecBytes];
        int n = 0;
        while (n < this.kyberK) {
            System.arraycopy(this.vec[n].toBytes(), 0, byArray, n * 384, 384);
            ++n;
        }
        return byArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = 0;
        while (n < this.kyberK) {
            stringBuffer.append(this.vec[n].toString());
            if (n != this.kyberK - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

