/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mldsa;

import org.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;
import org.bouncycastle.pqc.crypto.mldsa.PolyVecK;
import org.bouncycastle.pqc.crypto.mldsa.PolyVecL;

class PolyVecMatrix {
    private final int dilithiumK;
    private final int dilithiumL;
    private final PolyVecL[] mat;

    public PolyVecMatrix(MLDSAEngine mLDSAEngine) {
        this.dilithiumK = mLDSAEngine.getDilithiumK();
        this.dilithiumL = mLDSAEngine.getDilithiumL();
        this.mat = new PolyVecL[this.dilithiumK];
        int n = 0;
        while (n < this.dilithiumK) {
            this.mat[n] = new PolyVecL(mLDSAEngine);
            ++n;
        }
    }

    private String addString() {
        String string = "[";
        int n = 0;
        while (n < this.dilithiumK) {
            string = String.valueOf(string) + "Outer Matrix " + n + " [";
            string = String.valueOf(string) + this.mat[n].toString();
            string = n == this.dilithiumK - 1 ? String.valueOf(string) + "]\n" : String.valueOf(string) + "],\n";
            ++n;
        }
        string = String.valueOf(string) + "]\n";
        return string;
    }

    public void expandMatrix(byte[] byArray) {
        int n = 0;
        while (n < this.dilithiumK) {
            int n2 = 0;
            while (n2 < this.dilithiumL) {
                this.mat[n].getVectorIndex(n2).uniformBlocks(byArray, (short)((n << 8) + n2));
                ++n2;
            }
            ++n;
        }
    }

    public void pointwiseMontgomery(PolyVecK polyVecK, PolyVecL polyVecL) {
        int n = 0;
        while (n < this.dilithiumK) {
            polyVecK.getVectorIndex(n).pointwiseAccountMontgomery(this.mat[n], polyVecL);
            ++n;
        }
    }

    public String toString(String string) {
        return string.concat(": \n" + this.addString());
    }
}

