/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mldsa;

import org.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;
import org.bouncycastle.pqc.crypto.mldsa.Poly;

class PolyVecL {
    Poly[] vec;
    private MLDSAEngine engine;
    private int mode;
    private int polyVecBytes;
    private int dilithiumL;
    private int dilithiumK;

    public PolyVecL() throws Exception {
        throw new Exception("Requires Parameter");
    }

    public PolyVecL(MLDSAEngine mLDSAEngine) {
        this.engine = mLDSAEngine;
        this.mode = mLDSAEngine.getDilithiumMode();
        this.dilithiumL = mLDSAEngine.getDilithiumL();
        this.dilithiumK = mLDSAEngine.getDilithiumK();
        this.vec = new Poly[this.dilithiumL];
        int n = 0;
        while (n < this.dilithiumL) {
            this.vec[n] = new Poly(mLDSAEngine);
            ++n;
        }
    }

    public void addPolyVecL(PolyVecL polyVecL) {
        int n = 0;
        while (n < this.dilithiumL) {
            this.getVectorIndex(n).addPoly(polyVecL.getVectorIndex(n));
            ++n;
        }
    }

    public boolean checkNorm(int n) {
        int n2 = 0;
        while (n2 < this.dilithiumL) {
            if (this.getVectorIndex(n2).checkNorm(n)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void copyPolyVecL(PolyVecL polyVecL) {
        int n = 0;
        while (n < this.dilithiumL) {
            int n2 = 0;
            while (n2 < 256) {
                polyVecL.getVectorIndex(n).setCoeffIndex(n2, this.getVectorIndex(n).getCoeffIndex(n2));
                ++n2;
            }
            ++n;
        }
    }

    public void expandMatrix(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < this.dilithiumL) {
            this.vec[n2].uniformBlocks(byArray, (short)((n << 8) + n2));
            ++n2;
        }
    }

    public Poly getVectorIndex(int n) {
        return this.vec[n];
    }

    public void invNttToMont() {
        int n = 0;
        while (n < this.dilithiumL) {
            this.getVectorIndex(n).invNttToMont();
            ++n;
        }
    }

    public void pointwisePolyMontgomery(Poly poly, PolyVecL polyVecL) {
        int n = 0;
        while (n < this.dilithiumL) {
            this.getVectorIndex(n).pointwiseMontgomery(poly, polyVecL.getVectorIndex(n));
            ++n;
        }
    }

    public void polyVecNtt() {
        int n = 0;
        while (n < this.dilithiumL) {
            this.vec[n].polyNtt();
            ++n;
        }
    }

    public void reduce() {
        int n = 0;
        while (n < this.dilithiumL) {
            this.getVectorIndex(n).reduce();
            ++n;
        }
    }

    public String toString() {
        String string = "\n[";
        int n = 0;
        while (n < this.dilithiumL) {
            string = String.valueOf(string) + "Inner Matrix " + n + " " + this.getVectorIndex(n).toString();
            if (n != this.dilithiumL - 1) {
                string = String.valueOf(string) + ",\n";
            }
            ++n;
        }
        string = String.valueOf(string) + "]";
        return string;
    }

    public String toString(String string) {
        return String.valueOf(string) + ": " + this.toString();
    }

    public void uniformEta(byte[] byArray, short s) {
        short s2 = s;
        int n = 0;
        while (n < this.dilithiumL) {
            short s3 = s2;
            s2 = (short)(s3 + 1);
            this.getVectorIndex(n).uniformEta(byArray, s3);
            ++n;
        }
    }

    public void uniformGamma1(byte[] byArray, short s) {
        int n = 0;
        while (n < this.dilithiumL) {
            this.getVectorIndex(n).uniformGamma1(byArray, (short)(this.dilithiumL * s + n));
            ++n;
        }
    }
}

