/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mldsa;

import org.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;
import org.bouncycastle.pqc.crypto.mldsa.Poly;

class PolyVecK {
    Poly[] vec;
    private MLDSAEngine engine;
    private int mode;
    private int polyVecBytes;
    private int dilithiumK;
    private int dilithiumL;

    public PolyVecK() throws Exception {
        throw new Exception("Requires Parameter");
    }

    public PolyVecK(MLDSAEngine mLDSAEngine) {
        this.engine = mLDSAEngine;
        this.mode = mLDSAEngine.getDilithiumMode();
        this.dilithiumK = mLDSAEngine.getDilithiumK();
        this.dilithiumL = mLDSAEngine.getDilithiumL();
        this.vec = new Poly[this.dilithiumK];
        int n = 0;
        while (n < this.dilithiumK) {
            this.vec[n] = new Poly(mLDSAEngine);
            ++n;
        }
    }

    public void addPolyVecK(PolyVecK polyVecK) {
        int n = 0;
        while (n < this.dilithiumK) {
            this.getVectorIndex(n).addPoly(polyVecK.getVectorIndex(n));
            ++n;
        }
    }

    public boolean checkNorm(int n) {
        int n2 = 0;
        while (n2 < this.dilithiumK) {
            if (this.getVectorIndex(n2).checkNorm(n)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void conditionalAddQ() {
        int n = 0;
        while (n < this.dilithiumK) {
            this.getVectorIndex(n).conditionalAddQ();
            ++n;
        }
    }

    public void decompose(PolyVecK polyVecK) {
        int n = 0;
        while (n < this.dilithiumK) {
            this.getVectorIndex(n).decompose(polyVecK.getVectorIndex(n));
            ++n;
        }
    }

    public Poly getVectorIndex(int n) {
        return this.vec[n];
    }

    public void invNttToMont() {
        int n = 0;
        while (n < this.dilithiumK) {
            this.getVectorIndex(n).invNttToMont();
            ++n;
        }
    }

    public int makeHint(PolyVecK polyVecK, PolyVecK polyVecK2) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.dilithiumK) {
            n += this.getVectorIndex(n2).polyMakeHint(polyVecK.getVectorIndex(n2), polyVecK2.getVectorIndex(n2));
            ++n2;
        }
        return n;
    }

    public byte[] packW1() {
        byte[] byArray = new byte[this.dilithiumK * this.engine.getDilithiumPolyW1PackedBytes()];
        int n = 0;
        while (n < this.dilithiumK) {
            System.arraycopy(this.getVectorIndex(n).w1Pack(), 0, byArray, n * this.engine.getDilithiumPolyW1PackedBytes(), this.engine.getDilithiumPolyW1PackedBytes());
            ++n;
        }
        return byArray;
    }

    public void pointwisePolyMontgomery(Poly poly, PolyVecK polyVecK) {
        int n = 0;
        while (n < this.dilithiumK) {
            this.getVectorIndex(n).pointwiseMontgomery(poly, polyVecK.getVectorIndex(n));
            ++n;
        }
    }

    public void polyVecNtt() {
        int n = 0;
        while (n < this.dilithiumK) {
            this.vec[n].polyNtt();
            ++n;
        }
    }

    public void power2Round(PolyVecK polyVecK) {
        int n = 0;
        while (n < this.dilithiumK) {
            this.getVectorIndex(n).power2Round(polyVecK.getVectorIndex(n));
            ++n;
        }
    }

    public void reduce() {
        int n = 0;
        while (n < this.dilithiumK) {
            this.getVectorIndex(n).reduce();
            ++n;
        }
    }

    public void setVectorIndex(int n, Poly poly) {
        this.vec[n] = poly;
    }

    public void shiftLeft() {
        int n = 0;
        while (n < this.dilithiumK) {
            this.getVectorIndex(n).shiftLeft();
            ++n;
        }
    }

    public void subtract(PolyVecK polyVecK) {
        int n = 0;
        while (n < this.dilithiumK) {
            this.getVectorIndex(n).subtract(polyVecK.getVectorIndex(n));
            ++n;
        }
    }

    public String toString() {
        String string = "[";
        int n = 0;
        while (n < this.dilithiumK) {
            string = String.valueOf(string) + n + " " + this.getVectorIndex(n).toString();
            if (n != this.dilithiumK - 1) {
                string = String.valueOf(string) + ",\n";
            }
            ++n;
        }
        string = String.valueOf(string) + "]";
        return string;
    }

    public String toString(String string) {
        return String.valueOf(string) + ": " + this.toString();
    }

    public void uniformEta(byte[] byArray, short s) {
        short s2 = s;
        int n = 0;
        while (n < this.dilithiumK) {
            short s3 = s2;
            s2 = (short)(s3 + 1);
            this.getVectorIndex(n).uniformEta(byArray, s3);
            ++n;
        }
    }

    public void useHint(PolyVecK polyVecK, PolyVecK polyVecK2) {
        int n = 0;
        while (n < this.dilithiumK) {
            this.getVectorIndex(n).polyUseHint(polyVecK.getVectorIndex(n), polyVecK2.getVectorIndex(n));
            ++n;
        }
    }
}

