/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mldsa;

import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;
import org.bouncycastle.pqc.crypto.mldsa.Ntt;
import org.bouncycastle.pqc.crypto.mldsa.PolyVecL;
import org.bouncycastle.pqc.crypto.mldsa.Reduce;
import org.bouncycastle.pqc.crypto.mldsa.Rounding;
import org.bouncycastle.pqc.crypto.mldsa.Symmetric;

class Poly {
    private final int polyUniformNBlocks;
    private int[] coeffs;
    private final MLDSAEngine engine;
    private final int dilithiumN;
    private final Symmetric symmetric;

    public Poly(MLDSAEngine mLDSAEngine) {
        this.dilithiumN = 256;
        this.coeffs = new int[this.dilithiumN];
        this.engine = mLDSAEngine;
        this.symmetric = mLDSAEngine.GetSymmetric();
        this.polyUniformNBlocks = (768 + this.symmetric.stream128BlockBytes - 1) / this.symmetric.stream128BlockBytes;
    }

    public void addPoly(Poly poly) {
        int n = 0;
        while (n < this.dilithiumN) {
            this.setCoeffIndex(n, this.getCoeffIndex(n) + poly.getCoeffIndex(n));
            ++n;
        }
    }

    public void challenge(byte[] byArray) {
        int n = 0;
        byte[] byArray2 = new byte[this.symmetric.stream256BlockBytes];
        SHAKEDigest sHAKEDigest = new SHAKEDigest(256);
        sHAKEDigest.update(byArray, 0, this.engine.getDilithiumCTilde());
        sHAKEDigest.doOutput(byArray2, 0, this.symmetric.stream256BlockBytes);
        long l = 0L;
        int n2 = 0;
        while (n2 < 8) {
            l |= (long)(byArray2[n2] & 0xFF) << 8 * n2;
            ++n2;
        }
        int n3 = 8;
        n2 = 0;
        while (n2 < this.dilithiumN) {
            this.setCoeffIndex(n2, 0);
            ++n2;
        }
        n2 = this.dilithiumN - this.engine.getDilithiumTau();
        while (n2 < this.dilithiumN) {
            do {
                if (n3 < this.symmetric.stream256BlockBytes) continue;
                sHAKEDigest.doOutput(byArray2, 0, this.symmetric.stream256BlockBytes);
                n3 = 0;
            } while ((n = byArray2[n3++] & 0xFF) > n2);
            this.setCoeffIndex(n2, this.getCoeffIndex(n));
            this.setCoeffIndex(n, (int)(1L - 2L * (l & 1L)));
            l >>= 1;
            ++n2;
        }
    }

    public boolean checkNorm(int n) {
        if (n > 1047552) {
            return true;
        }
        int n2 = 0;
        while (n2 < this.dilithiumN) {
            int n3 = this.getCoeffIndex(n2) >> 31;
            n3 = this.getCoeffIndex(n2) - (n3 & 2 * this.getCoeffIndex(n2));
            if (n3 >= n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void conditionalAddQ() {
        int n = 0;
        while (n < this.dilithiumN) {
            this.setCoeffIndex(n, Reduce.conditionalAddQ(this.getCoeffIndex(n)));
            ++n;
        }
    }

    public void decompose(Poly poly) {
        int n = 0;
        while (n < this.dilithiumN) {
            int[] nArray = Rounding.decompose(this.getCoeffIndex(n), this.engine.getDilithiumGamma2());
            this.setCoeffIndex(n, nArray[1]);
            poly.setCoeffIndex(n, nArray[0]);
            ++n;
        }
    }

    public int getCoeffIndex(int n) {
        return this.coeffs[n];
    }

    public int[] getCoeffs() {
        return this.coeffs;
    }

    public void invNttToMont() {
        this.setCoeffs(Ntt.invNttToMont(this.getCoeffs()));
    }

    public void pointwiseAccountMontgomery(PolyVecL polyVecL, PolyVecL polyVecL2) {
        Poly poly = new Poly(this.engine);
        this.pointwiseMontgomery(polyVecL.getVectorIndex(0), polyVecL2.getVectorIndex(0));
        int n = 1;
        while (n < this.engine.getDilithiumL()) {
            poly.pointwiseMontgomery(polyVecL.getVectorIndex(n), polyVecL2.getVectorIndex(n));
            this.addPoly(poly);
            ++n;
        }
    }

    public void pointwiseMontgomery(Poly poly, Poly poly2) {
        int n = 0;
        while (n < this.dilithiumN) {
            this.setCoeffIndex(n, Reduce.montgomeryReduce((long)poly.getCoeffIndex(n) * (long)poly2.getCoeffIndex(n)));
            ++n;
        }
    }

    public byte[] polyEtaPack(byte[] byArray, int n) {
        byte[] byArray2 = new byte[8];
        if (this.engine.getDilithiumEta() == 2) {
            int n2 = 0;
            while (n2 < this.dilithiumN / 8) {
                byArray2[0] = (byte)(this.engine.getDilithiumEta() - this.getCoeffIndex(8 * n2));
                byArray2[1] = (byte)(this.engine.getDilithiumEta() - this.getCoeffIndex(8 * n2 + 1));
                byArray2[2] = (byte)(this.engine.getDilithiumEta() - this.getCoeffIndex(8 * n2 + 2));
                byArray2[3] = (byte)(this.engine.getDilithiumEta() - this.getCoeffIndex(8 * n2 + 3));
                byArray2[4] = (byte)(this.engine.getDilithiumEta() - this.getCoeffIndex(8 * n2 + 4));
                byArray2[5] = (byte)(this.engine.getDilithiumEta() - this.getCoeffIndex(8 * n2 + 5));
                byArray2[6] = (byte)(this.engine.getDilithiumEta() - this.getCoeffIndex(8 * n2 + 6));
                byArray2[7] = (byte)(this.engine.getDilithiumEta() - this.getCoeffIndex(8 * n2 + 7));
                byArray[n + 3 * n2] = (byte)(byArray2[0] | byArray2[1] << 3 | byArray2[2] << 6);
                byArray[n + 3 * n2 + 1] = (byte)(byArray2[2] >> 2 | byArray2[3] << 1 | byArray2[4] << 4 | byArray2[5] << 7);
                byArray[n + 3 * n2 + 2] = (byte)(byArray2[5] >> 1 | byArray2[6] << 2 | byArray2[7] << 5);
                ++n2;
            }
        } else if (this.engine.getDilithiumEta() == 4) {
            int n3 = 0;
            while (n3 < this.dilithiumN / 2) {
                byArray2[0] = (byte)(this.engine.getDilithiumEta() - this.getCoeffIndex(2 * n3));
                byArray2[1] = (byte)(this.engine.getDilithiumEta() - this.getCoeffIndex(2 * n3 + 1));
                byArray[n + n3] = (byte)(byArray2[0] | byArray2[1] << 4);
                ++n3;
            }
        } else {
            throw new RuntimeException("Eta needs to be 2 or 4!");
        }
        return byArray;
    }

    public void polyEtaUnpack(byte[] byArray, int n) {
        block3: {
            int n2;
            block2: {
                n2 = this.engine.getDilithiumEta();
                if (this.engine.getDilithiumEta() != 2) break block2;
                int n3 = 0;
                while (n3 < this.dilithiumN / 8) {
                    int n4 = n + 3 * n3;
                    this.setCoeffIndex(8 * n3, byArray[n4] & 0xFF & 7);
                    this.setCoeffIndex(8 * n3 + 1, (byArray[n4] & 0xFF) >> 3 & 7);
                    this.setCoeffIndex(8 * n3 + 2, (byArray[n4] & 0xFF) >> 6 | (byArray[n4 + 1] & 0xFF) << 2 & 7);
                    this.setCoeffIndex(8 * n3 + 3, (byArray[n4 + 1] & 0xFF) >> 1 & 7);
                    this.setCoeffIndex(8 * n3 + 4, (byArray[n4 + 1] & 0xFF) >> 4 & 7);
                    this.setCoeffIndex(8 * n3 + 5, (byArray[n4 + 1] & 0xFF) >> 7 | (byArray[n4 + 2] & 0xFF) << 1 & 7);
                    this.setCoeffIndex(8 * n3 + 6, (byArray[n4 + 2] & 0xFF) >> 2 & 7);
                    this.setCoeffIndex(8 * n3 + 7, (byArray[n4 + 2] & 0xFF) >> 5 & 7);
                    this.setCoeffIndex(8 * n3, n2 - this.getCoeffIndex(8 * n3));
                    this.setCoeffIndex(8 * n3 + 1, n2 - this.getCoeffIndex(8 * n3 + 1));
                    this.setCoeffIndex(8 * n3 + 2, n2 - this.getCoeffIndex(8 * n3 + 2));
                    this.setCoeffIndex(8 * n3 + 3, n2 - this.getCoeffIndex(8 * n3 + 3));
                    this.setCoeffIndex(8 * n3 + 4, n2 - this.getCoeffIndex(8 * n3 + 4));
                    this.setCoeffIndex(8 * n3 + 5, n2 - this.getCoeffIndex(8 * n3 + 5));
                    this.setCoeffIndex(8 * n3 + 6, n2 - this.getCoeffIndex(8 * n3 + 6));
                    this.setCoeffIndex(8 * n3 + 7, n2 - this.getCoeffIndex(8 * n3 + 7));
                    ++n3;
                }
                break block3;
            }
            if (this.engine.getDilithiumEta() != 4) break block3;
            int n5 = 0;
            while (n5 < this.dilithiumN / 2) {
                this.setCoeffIndex(2 * n5, byArray[n + n5] & 0xF);
                this.setCoeffIndex(2 * n5 + 1, (byArray[n + n5] & 0xFF) >> 4);
                this.setCoeffIndex(2 * n5, n2 - this.getCoeffIndex(2 * n5));
                this.setCoeffIndex(2 * n5 + 1, n2 - this.getCoeffIndex(2 * n5 + 1));
                ++n5;
            }
        }
    }

    public int polyMakeHint(Poly poly, Poly poly2) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.dilithiumN) {
            this.setCoeffIndex(n2, Rounding.makeHint(poly.getCoeffIndex(n2), poly2.getCoeffIndex(n2), this.engine));
            n += this.getCoeffIndex(n2);
            ++n2;
        }
        return n;
    }

    public void polyNtt() {
        this.setCoeffs(Ntt.ntt(this.coeffs));
    }

    public void polyUseHint(Poly poly, Poly poly2) {
        int n = 0;
        while (n < this.dilithiumN) {
            this.setCoeffIndex(n, Rounding.useHint(poly.getCoeffIndex(n), poly2.getCoeffIndex(n), this.engine.getDilithiumGamma2()));
            ++n;
        }
    }

    public byte[] polyt0Pack(byte[] byArray, int n) {
        int[] nArray = new int[8];
        int n2 = 0;
        while (n2 < this.dilithiumN / 8) {
            nArray[0] = 4096 - this.getCoeffIndex(8 * n2);
            nArray[1] = 4096 - this.getCoeffIndex(8 * n2 + 1);
            nArray[2] = 4096 - this.getCoeffIndex(8 * n2 + 2);
            nArray[3] = 4096 - this.getCoeffIndex(8 * n2 + 3);
            nArray[4] = 4096 - this.getCoeffIndex(8 * n2 + 4);
            nArray[5] = 4096 - this.getCoeffIndex(8 * n2 + 5);
            nArray[6] = 4096 - this.getCoeffIndex(8 * n2 + 6);
            nArray[7] = 4096 - this.getCoeffIndex(8 * n2 + 7);
            int n3 = n + 13 * n2;
            byArray[n3] = (byte)nArray[0];
            byArray[n3 + 1] = (byte)(nArray[0] >> 8);
            byArray[n3 + 1] = (byte)(byArray[n3 + 1] | (byte)(nArray[1] << 5));
            byArray[n3 + 2] = (byte)(nArray[1] >> 3);
            byArray[n3 + 3] = (byte)(nArray[1] >> 11);
            byArray[n3 + 3] = (byte)(byArray[n3 + 3] | (byte)(nArray[2] << 2));
            byArray[n3 + 4] = (byte)(nArray[2] >> 6);
            byArray[n3 + 4] = (byte)(byArray[n3 + 4] | (byte)(nArray[3] << 7));
            byArray[n3 + 5] = (byte)(nArray[3] >> 1);
            byArray[n3 + 6] = (byte)(nArray[3] >> 9);
            byArray[n3 + 6] = (byte)(byArray[n3 + 6] | (byte)(nArray[4] << 4));
            byArray[n3 + 7] = (byte)(nArray[4] >> 4);
            byArray[n3 + 8] = (byte)(nArray[4] >> 12);
            byArray[n3 + 8] = (byte)(byArray[n3 + 8] | (byte)(nArray[5] << 1));
            byArray[n3 + 9] = (byte)(nArray[5] >> 7);
            byArray[n3 + 9] = (byte)(byArray[n3 + 9] | (byte)(nArray[6] << 6));
            byArray[n3 + 10] = (byte)(nArray[6] >> 2);
            byArray[n3 + 11] = (byte)(nArray[6] >> 10);
            byArray[n3 + 11] = (byte)(byArray[n3 + 11] | (byte)(nArray[7] << 3));
            byArray[n3 + 12] = (byte)(nArray[7] >> 5);
            ++n2;
        }
        return byArray;
    }

    public void polyt0Unpack(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < this.dilithiumN / 8) {
            int n3 = n + 13 * n2;
            this.setCoeffIndex(8 * n2, (byArray[n3] & 0xFF | (byArray[n3 + 1] & 0xFF) << 8) & 0x1FFF);
            this.setCoeffIndex(8 * n2 + 1, ((byArray[n3 + 1] & 0xFF) >> 5 | (byArray[n3 + 2] & 0xFF) << 3 | (byArray[n3 + 3] & 0xFF) << 11) & 0x1FFF);
            this.setCoeffIndex(8 * n2 + 2, ((byArray[n3 + 3] & 0xFF) >> 2 | (byArray[n3 + 4] & 0xFF) << 6) & 0x1FFF);
            this.setCoeffIndex(8 * n2 + 3, ((byArray[n3 + 4] & 0xFF) >> 7 | (byArray[n3 + 5] & 0xFF) << 1 | (byArray[n3 + 6] & 0xFF) << 9) & 0x1FFF);
            this.setCoeffIndex(8 * n2 + 4, ((byArray[n3 + 6] & 0xFF) >> 4 | (byArray[n3 + 7] & 0xFF) << 4 | (byArray[n3 + 8] & 0xFF) << 12) & 0x1FFF);
            this.setCoeffIndex(8 * n2 + 5, ((byArray[n3 + 8] & 0xFF) >> 1 | (byArray[n3 + 9] & 0xFF) << 7) & 0x1FFF);
            this.setCoeffIndex(8 * n2 + 6, ((byArray[n3 + 9] & 0xFF) >> 6 | (byArray[n3 + 10] & 0xFF) << 2 | (byArray[n3 + 11] & 0xFF) << 10) & 0x1FFF);
            this.setCoeffIndex(8 * n2 + 7, ((byArray[n3 + 11] & 0xFF) >> 3 | (byArray[n3 + 12] & 0xFF) << 5) & 0x1FFF);
            this.setCoeffIndex(8 * n2, 4096 - this.getCoeffIndex(8 * n2));
            this.setCoeffIndex(8 * n2 + 1, 4096 - this.getCoeffIndex(8 * n2 + 1));
            this.setCoeffIndex(8 * n2 + 2, 4096 - this.getCoeffIndex(8 * n2 + 2));
            this.setCoeffIndex(8 * n2 + 3, 4096 - this.getCoeffIndex(8 * n2 + 3));
            this.setCoeffIndex(8 * n2 + 4, 4096 - this.getCoeffIndex(8 * n2 + 4));
            this.setCoeffIndex(8 * n2 + 5, 4096 - this.getCoeffIndex(8 * n2 + 5));
            this.setCoeffIndex(8 * n2 + 6, 4096 - this.getCoeffIndex(8 * n2 + 6));
            this.setCoeffIndex(8 * n2 + 7, 4096 - this.getCoeffIndex(8 * n2 + 7));
            ++n2;
        }
    }

    public byte[] polyt1Pack() {
        byte[] byArray = new byte[320];
        int n = 0;
        while (n < this.dilithiumN / 4) {
            byArray[5 * n] = (byte)this.coeffs[4 * n];
            byArray[5 * n + 1] = (byte)(this.coeffs[4 * n] >> 8 | this.coeffs[4 * n + 1] << 2);
            byArray[5 * n + 2] = (byte)(this.coeffs[4 * n + 1] >> 6 | this.coeffs[4 * n + 2] << 4);
            byArray[5 * n + 3] = (byte)(this.coeffs[4 * n + 2] >> 4 | this.coeffs[4 * n + 3] << 6);
            byArray[5 * n + 4] = (byte)(this.coeffs[4 * n + 3] >> 2);
            ++n;
        }
        return byArray;
    }

    public void polyt1Unpack(byte[] byArray) {
        int n = 0;
        while (n < this.dilithiumN / 4) {
            this.setCoeffIndex(4 * n, (byArray[5 * n] & 0xFF | (byArray[5 * n + 1] & 0xFF) << 8) & 0x3FF);
            this.setCoeffIndex(4 * n + 1, ((byArray[5 * n + 1] & 0xFF) >> 2 | (byArray[5 * n + 2] & 0xFF) << 6) & 0x3FF);
            this.setCoeffIndex(4 * n + 2, ((byArray[5 * n + 2] & 0xFF) >> 4 | (byArray[5 * n + 3] & 0xFF) << 4) & 0x3FF);
            this.setCoeffIndex(4 * n + 3, ((byArray[5 * n + 3] & 0xFF) >> 6 | (byArray[5 * n + 4] & 0xFF) << 2) & 0x3FF);
            ++n;
        }
    }

    public void power2Round(Poly poly) {
        int n = 0;
        while (n < this.dilithiumN) {
            int[] nArray = Rounding.power2Round(this.getCoeffIndex(n));
            this.setCoeffIndex(n, nArray[0]);
            poly.setCoeffIndex(n, nArray[1]);
            ++n;
        }
    }

    public void reduce() {
        int n = 0;
        while (n < this.dilithiumN) {
            this.setCoeffIndex(n, Reduce.reduce32(this.getCoeffIndex(n)));
            ++n;
        }
    }

    private static int rejectEta(Poly poly, int n, int n2, byte[] byArray, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2 && n5 < n3) {
            int n7 = byArray[n5] & 0xFF & 0xF;
            int n8 = (byArray[n5++] & 0xFF) >> 4;
            if (n4 == 2) {
                if (n7 < 15) {
                    n7 -= (205 * n7 >> 10) * 5;
                    poly.setCoeffIndex(n + n6, 2 - n7);
                    ++n6;
                }
                if (n8 >= 15 || n6 >= n2) continue;
                n8 -= (205 * n8 >> 10) * 5;
                poly.setCoeffIndex(n + n6, 2 - n8);
                ++n6;
                continue;
            }
            if (n4 != 4) continue;
            if (n7 < 9) {
                poly.setCoeffIndex(n + n6, 4 - n7);
                ++n6;
            }
            if (n8 >= 9 || n6 >= n2) continue;
            poly.setCoeffIndex(n + n6, 4 - n8);
            ++n6;
        }
        return n6;
    }

    private static int rejectUniform(Poly poly, int n, int n2, byte[] byArray, int n3) {
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2 && n4 + 3 <= n3) {
            int n6 = byArray[n4++] & 0xFF;
            n6 |= (byArray[n4++] & 0xFF) << 8;
            n6 |= (byArray[n4++] & 0xFF) << 16;
            if ((n6 &= 0x7FFFFF) >= 8380417) continue;
            poly.setCoeffIndex(n + n5, n6);
            ++n5;
        }
        return n5;
    }

    public void setCoeffIndex(int n, int n2) {
        this.coeffs[n] = n2;
    }

    public void setCoeffs(int[] nArray) {
        this.coeffs = nArray;
    }

    public void shiftLeft() {
        int n = 0;
        while (n < this.dilithiumN) {
            this.setCoeffIndex(n, this.getCoeffIndex(n) << 13);
            ++n;
        }
    }

    public void subtract(Poly poly) {
        int n = 0;
        while (n < this.dilithiumN) {
            this.setCoeffIndex(n, this.getCoeffIndex(n) - poly.getCoeffIndex(n));
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = 0;
        while (n < this.coeffs.length) {
            stringBuffer.append(this.coeffs[n]);
            if (n != this.coeffs.length - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void uniformBlocks(byte[] byArray, short s) {
        int n = this.polyUniformNBlocks * this.symmetric.stream128BlockBytes;
        byte[] byArray2 = new byte[n + 2];
        this.symmetric.stream128init(byArray, s);
        this.symmetric.stream128squeezeBlocks(byArray2, 0, n);
        int n2 = Poly.rejectUniform(this, 0, this.dilithiumN, byArray2, n);
        while (n2 < this.dilithiumN) {
            int n3 = n % 3;
            int n4 = 0;
            while (n4 < n3) {
                byArray2[n4] = byArray2[n - n3 + n4];
                ++n4;
            }
            this.symmetric.stream128squeezeBlocks(byArray2, n3, this.symmetric.stream128BlockBytes);
            n = this.symmetric.stream128BlockBytes + n3;
            n2 += Poly.rejectUniform(this, n2, this.dilithiumN - n2, byArray2, n);
        }
    }

    public void uniformEta(byte[] byArray, short s) {
        int n;
        int n2 = this.engine.getDilithiumEta();
        if (this.engine.getDilithiumEta() == 2) {
            n = (136 + this.symmetric.stream256BlockBytes - 1) / this.symmetric.stream256BlockBytes;
        } else if (this.engine.getDilithiumEta() == 4) {
            n = (227 + this.symmetric.stream256BlockBytes - 1) / this.symmetric.stream256BlockBytes;
        } else {
            throw new RuntimeException("Wrong Dilithium Eta!");
        }
        int n3 = n * this.symmetric.stream256BlockBytes;
        byte[] byArray2 = new byte[n3];
        this.symmetric.stream256init(byArray, s);
        this.symmetric.stream256squeezeBlocks(byArray2, 0, n3);
        int n4 = Poly.rejectEta(this, 0, this.dilithiumN, byArray2, n3, n2);
        while (n4 < 256) {
            this.symmetric.stream256squeezeBlocks(byArray2, 0, this.symmetric.stream256BlockBytes);
            n4 += Poly.rejectEta(this, n4, this.dilithiumN - n4, byArray2, this.symmetric.stream256BlockBytes, n2);
        }
    }

    public void uniformGamma1(byte[] byArray, short s) {
        byte[] byArray2 = new byte[this.engine.getPolyUniformGamma1NBlocks() * this.symmetric.stream256BlockBytes];
        this.symmetric.stream256init(byArray, s);
        this.symmetric.stream256squeezeBlocks(byArray2, 0, this.engine.getPolyUniformGamma1NBlocks() * this.symmetric.stream256BlockBytes);
        this.unpackZ(byArray2);
    }

    private void unpackZ(byte[] byArray) {
        if (this.engine.getDilithiumGamma1() == 131072) {
            int n = 0;
            while (n < this.dilithiumN / 4) {
                this.setCoeffIndex(4 * n, (byArray[9 * n] & 0xFF | (byArray[9 * n + 1] & 0xFF) << 8 | (byArray[9 * n + 2] & 0xFF) << 16) & 0x3FFFF);
                this.setCoeffIndex(4 * n + 1, ((byArray[9 * n + 2] & 0xFF) >> 2 | (byArray[9 * n + 3] & 0xFF) << 6 | (byArray[9 * n + 4] & 0xFF) << 14) & 0x3FFFF);
                this.setCoeffIndex(4 * n + 2, ((byArray[9 * n + 4] & 0xFF) >> 4 | (byArray[9 * n + 5] & 0xFF) << 4 | (byArray[9 * n + 6] & 0xFF) << 12) & 0x3FFFF);
                this.setCoeffIndex(4 * n + 3, ((byArray[9 * n + 6] & 0xFF) >> 6 | (byArray[9 * n + 7] & 0xFF) << 2 | (byArray[9 * n + 8] & 0xFF) << 10) & 0x3FFFF);
                this.setCoeffIndex(4 * n, this.engine.getDilithiumGamma1() - this.getCoeffIndex(4 * n));
                this.setCoeffIndex(4 * n + 1, this.engine.getDilithiumGamma1() - this.getCoeffIndex(4 * n + 1));
                this.setCoeffIndex(4 * n + 2, this.engine.getDilithiumGamma1() - this.getCoeffIndex(4 * n + 2));
                this.setCoeffIndex(4 * n + 3, this.engine.getDilithiumGamma1() - this.getCoeffIndex(4 * n + 3));
                ++n;
            }
        } else if (this.engine.getDilithiumGamma1() == 524288) {
            int n = 0;
            while (n < this.dilithiumN / 2) {
                this.setCoeffIndex(2 * n, (byArray[5 * n] & 0xFF | (byArray[5 * n + 1] & 0xFF) << 8 | (byArray[5 * n + 2] & 0xFF) << 16) & 0xFFFFF);
                this.setCoeffIndex(2 * n + 1, ((byArray[5 * n + 2] & 0xFF) >> 4 | (byArray[5 * n + 3] & 0xFF) << 4 | (byArray[5 * n + 4] & 0xFF) << 12) & 0xFFFFF);
                this.setCoeffIndex(2 * n, this.engine.getDilithiumGamma1() - this.getCoeffIndex(2 * n));
                this.setCoeffIndex(2 * n + 1, this.engine.getDilithiumGamma1() - this.getCoeffIndex(2 * n + 1));
                ++n;
            }
        } else {
            throw new RuntimeException("Wrong Dilithiumn Gamma1!");
        }
    }

    public byte[] w1Pack() {
        byte[] byArray;
        block3: {
            block2: {
                byArray = new byte[this.engine.getDilithiumPolyW1PackedBytes()];
                if (this.engine.getDilithiumGamma2() != 95232) break block2;
                int n = 0;
                while (n < this.dilithiumN / 4) {
                    byArray[3 * n] = (byte)((byte)this.getCoeffIndex(4 * n) | this.getCoeffIndex(4 * n + 1) << 6);
                    byArray[3 * n + 1] = (byte)((byte)(this.getCoeffIndex(4 * n + 1) >> 2) | this.getCoeffIndex(4 * n + 2) << 4);
                    byArray[3 * n + 2] = (byte)((byte)(this.getCoeffIndex(4 * n + 2) >> 4) | this.getCoeffIndex(4 * n + 3) << 2);
                    ++n;
                }
                break block3;
            }
            if (this.engine.getDilithiumGamma2() != 261888) break block3;
            int n = 0;
            while (n < this.dilithiumN / 2) {
                byArray[n] = (byte)(this.getCoeffIndex(2 * n) | this.getCoeffIndex(2 * n + 1) << 4);
                ++n;
            }
        }
        return byArray;
    }

    public byte[] zPack() {
        byte[] byArray = new byte[this.engine.getDilithiumPolyZPackedBytes()];
        int[] nArray = new int[4];
        if (this.engine.getDilithiumGamma1() == 131072) {
            int n = 0;
            while (n < this.dilithiumN / 4) {
                nArray[0] = this.engine.getDilithiumGamma1() - this.getCoeffIndex(4 * n);
                nArray[1] = this.engine.getDilithiumGamma1() - this.getCoeffIndex(4 * n + 1);
                nArray[2] = this.engine.getDilithiumGamma1() - this.getCoeffIndex(4 * n + 2);
                nArray[3] = this.engine.getDilithiumGamma1() - this.getCoeffIndex(4 * n + 3);
                byArray[9 * n] = (byte)nArray[0];
                byArray[9 * n + 1] = (byte)(nArray[0] >> 8);
                byArray[9 * n + 2] = (byte)((byte)(nArray[0] >> 16) | nArray[1] << 2);
                byArray[9 * n + 3] = (byte)(nArray[1] >> 6);
                byArray[9 * n + 4] = (byte)((byte)(nArray[1] >> 14) | nArray[2] << 4);
                byArray[9 * n + 5] = (byte)(nArray[2] >> 4);
                byArray[9 * n + 6] = (byte)((byte)(nArray[2] >> 12) | nArray[3] << 6);
                byArray[9 * n + 7] = (byte)(nArray[3] >> 2);
                byArray[9 * n + 8] = (byte)(nArray[3] >> 10);
                ++n;
            }
        } else if (this.engine.getDilithiumGamma1() == 524288) {
            int n = 0;
            while (n < this.dilithiumN / 2) {
                nArray[0] = this.engine.getDilithiumGamma1() - this.getCoeffIndex(2 * n);
                nArray[1] = this.engine.getDilithiumGamma1() - this.getCoeffIndex(2 * n + 1);
                byArray[5 * n] = (byte)nArray[0];
                byArray[5 * n + 1] = (byte)(nArray[0] >> 8);
                byArray[5 * n + 2] = (byte)((byte)(nArray[0] >> 16) | nArray[1] << 4);
                byArray[5 * n + 3] = (byte)(nArray[1] >> 4);
                byArray[5 * n + 4] = (byte)(nArray[1] >> 12);
                ++n;
            }
        } else {
            throw new RuntimeException("Wrong Dilithium Gamma1!");
        }
        return byArray;
    }

    void zUnpack(byte[] byArray) {
        if (this.engine.getDilithiumGamma1() == 131072) {
            int n = 0;
            while (n < this.dilithiumN / 4) {
                this.setCoeffIndex(4 * n, (byArray[9 * n] & 0xFF | (byArray[9 * n + 1] & 0xFF) << 8 | (byArray[9 * n + 2] & 0xFF) << 16) & 0x3FFFF);
                this.setCoeffIndex(4 * n + 1, ((byArray[9 * n + 2] & 0xFF) >>> 2 | (byArray[9 * n + 3] & 0xFF) << 6 | (byArray[9 * n + 4] & 0xFF) << 14) & 0x3FFFF);
                this.setCoeffIndex(4 * n + 2, ((byArray[9 * n + 4] & 0xFF) >>> 4 | (byArray[9 * n + 5] & 0xFF) << 4 | (byArray[9 * n + 6] & 0xFF) << 12) & 0x3FFFF);
                this.setCoeffIndex(4 * n + 3, ((byArray[9 * n + 6] & 0xFF) >>> 6 | (byArray[9 * n + 7] & 0xFF) << 2 | (byArray[9 * n + 8] & 0xFF) << 10) & 0x3FFFF);
                this.setCoeffIndex(4 * n, this.engine.getDilithiumGamma1() - this.getCoeffIndex(4 * n));
                this.setCoeffIndex(4 * n + 1, this.engine.getDilithiumGamma1() - this.getCoeffIndex(4 * n + 1));
                this.setCoeffIndex(4 * n + 2, this.engine.getDilithiumGamma1() - this.getCoeffIndex(4 * n + 2));
                this.setCoeffIndex(4 * n + 3, this.engine.getDilithiumGamma1() - this.getCoeffIndex(4 * n + 3));
                ++n;
            }
        } else if (this.engine.getDilithiumGamma1() == 524288) {
            int n = 0;
            while (n < this.dilithiumN / 2) {
                this.setCoeffIndex(2 * n, (byArray[5 * n] & 0xFF | (byArray[5 * n + 1] & 0xFF) << 8 | (byArray[5 * n + 2] & 0xFF) << 16) & 0xFFFFF);
                this.setCoeffIndex(2 * n + 1, ((byArray[5 * n + 2] & 0xFF) >>> 4 | (byArray[5 * n + 3] & 0xFF) << 4 | (byArray[5 * n + 4] & 0xFF) << 12) & 0xFFFFF);
                this.setCoeffIndex(2 * n, this.engine.getDilithiumGamma1() - this.getCoeffIndex(2 * n));
                this.setCoeffIndex(2 * n + 1, this.engine.getDilithiumGamma1() - this.getCoeffIndex(2 * n + 1));
                ++n;
            }
        } else {
            throw new RuntimeException("Wrong Dilithium Gamma1!");
        }
    }
}

