/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mldsa;

import org.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;
import org.bouncycastle.pqc.crypto.mldsa.PolyVecK;
import org.bouncycastle.pqc.crypto.mldsa.PolyVecL;
import org.bouncycastle.util.Arrays;

class Packing {
    Packing() {
    }

    static byte[] packPublicKey(PolyVecK polyVecK, MLDSAEngine mLDSAEngine) {
        byte[] byArray = new byte[mLDSAEngine.getCryptoPublicKeyBytes() - 32];
        int n = 0;
        while (n < mLDSAEngine.getDilithiumK()) {
            System.arraycopy(polyVecK.getVectorIndex(n).polyt1Pack(), 0, byArray, n * 320, 320);
            ++n;
        }
        return byArray;
    }

    static byte[][] packSecretKey(byte[] byArray, byte[] byArray2, byte[] byArray3, PolyVecK polyVecK, PolyVecL polyVecL, PolyVecK polyVecK2, MLDSAEngine mLDSAEngine) {
        byte[][] byArray4 = new byte[6][];
        byArray4[0] = byArray;
        byArray4[1] = byArray3;
        byArray4[2] = byArray2;
        byArray4[3] = new byte[mLDSAEngine.getDilithiumL() * mLDSAEngine.getDilithiumPolyEtaPackedBytes()];
        int n = 0;
        while (n < mLDSAEngine.getDilithiumL()) {
            polyVecL.getVectorIndex(n).polyEtaPack(byArray4[3], n * mLDSAEngine.getDilithiumPolyEtaPackedBytes());
            ++n;
        }
        byArray4[4] = new byte[mLDSAEngine.getDilithiumK() * mLDSAEngine.getDilithiumPolyEtaPackedBytes()];
        int n2 = 0;
        while (n2 < mLDSAEngine.getDilithiumK()) {
            polyVecK2.getVectorIndex(n2).polyEtaPack(byArray4[4], n2 * mLDSAEngine.getDilithiumPolyEtaPackedBytes());
            ++n2;
        }
        byArray4[5] = new byte[mLDSAEngine.getDilithiumK() * 416];
        int n3 = 0;
        while (n3 < mLDSAEngine.getDilithiumK()) {
            polyVecK.getVectorIndex(n3).polyt0Pack(byArray4[5], n3 * 416);
            ++n3;
        }
        return byArray4;
    }

    static byte[] packSignature(byte[] byArray, PolyVecL polyVecL, PolyVecK polyVecK, MLDSAEngine mLDSAEngine) {
        int n = 0;
        byte[] byArray2 = new byte[mLDSAEngine.getCryptoBytes()];
        System.arraycopy(byArray, 0, byArray2, 0, mLDSAEngine.getDilithiumCTilde());
        n += mLDSAEngine.getDilithiumCTilde();
        int n2 = 0;
        while (n2 < mLDSAEngine.getDilithiumL()) {
            System.arraycopy(polyVecL.getVectorIndex(n2).zPack(), 0, byArray2, n + n2 * mLDSAEngine.getDilithiumPolyZPackedBytes(), mLDSAEngine.getDilithiumPolyZPackedBytes());
            ++n2;
        }
        n += mLDSAEngine.getDilithiumL() * mLDSAEngine.getDilithiumPolyZPackedBytes();
        n2 = 0;
        while (n2 < mLDSAEngine.getDilithiumOmega() + mLDSAEngine.getDilithiumK()) {
            byArray2[n + n2] = 0;
            ++n2;
        }
        int n3 = 0;
        n2 = 0;
        while (n2 < mLDSAEngine.getDilithiumK()) {
            int n4 = 0;
            while (n4 < 256) {
                if (polyVecK.getVectorIndex(n2).getCoeffIndex(n4) != 0) {
                    byArray2[n + n3++] = (byte)n4;
                }
                ++n4;
            }
            byArray2[n + mLDSAEngine.getDilithiumOmega() + n2] = (byte)n3;
            ++n2;
        }
        return byArray2;
    }

    static PolyVecK unpackPublicKey(PolyVecK polyVecK, byte[] byArray, MLDSAEngine mLDSAEngine) {
        int n = 0;
        while (n < mLDSAEngine.getDilithiumK()) {
            polyVecK.getVectorIndex(n).polyt1Unpack(Arrays.copyOfRange(byArray, n * 320, (n + 1) * 320));
            ++n;
        }
        return polyVecK;
    }

    static void unpackSecretKey(PolyVecK polyVecK, PolyVecL polyVecL, PolyVecK polyVecK2, byte[] byArray, byte[] byArray2, byte[] byArray3, MLDSAEngine mLDSAEngine) {
        int n = 0;
        while (n < mLDSAEngine.getDilithiumL()) {
            polyVecL.getVectorIndex(n).polyEtaUnpack(byArray2, n * mLDSAEngine.getDilithiumPolyEtaPackedBytes());
            ++n;
        }
        int n2 = 0;
        while (n2 < mLDSAEngine.getDilithiumK()) {
            polyVecK2.getVectorIndex(n2).polyEtaUnpack(byArray3, n2 * mLDSAEngine.getDilithiumPolyEtaPackedBytes());
            ++n2;
        }
        int n3 = 0;
        while (n3 < mLDSAEngine.getDilithiumK()) {
            polyVecK.getVectorIndex(n3).polyt0Unpack(byArray, n3 * 416);
            ++n3;
        }
    }

    static boolean unpackSignature(PolyVecL polyVecL, PolyVecK polyVecK, byte[] byArray, MLDSAEngine mLDSAEngine) {
        int n;
        int n2 = mLDSAEngine.getDilithiumCTilde();
        int n3 = 0;
        while (n3 < mLDSAEngine.getDilithiumL()) {
            polyVecL.getVectorIndex(n3).zUnpack(Arrays.copyOfRange(byArray, n2 + n3 * mLDSAEngine.getDilithiumPolyZPackedBytes(), n2 + (n3 + 1) * mLDSAEngine.getDilithiumPolyZPackedBytes()));
            ++n3;
        }
        n2 += mLDSAEngine.getDilithiumL() * mLDSAEngine.getDilithiumPolyZPackedBytes();
        int n4 = 0;
        n3 = 0;
        while (n3 < mLDSAEngine.getDilithiumK()) {
            n = 0;
            while (n < 256) {
                polyVecK.getVectorIndex(n3).setCoeffIndex(n, 0);
                ++n;
            }
            if ((byArray[n2 + mLDSAEngine.getDilithiumOmega() + n3] & 0xFF) < n4 || (byArray[n2 + mLDSAEngine.getDilithiumOmega() + n3] & 0xFF) > mLDSAEngine.getDilithiumOmega()) {
                return false;
            }
            n = n4;
            while (n < (byArray[n2 + mLDSAEngine.getDilithiumOmega() + n3] & 0xFF)) {
                if (n > n4 && (byArray[n2 + n] & 0xFF) <= (byArray[n2 + n - 1] & 0xFF)) {
                    return false;
                }
                polyVecK.getVectorIndex(n3).setCoeffIndex(byArray[n2 + n] & 0xFF, 1);
                ++n;
            }
            n4 = byArray[n2 + mLDSAEngine.getDilithiumOmega() + n3];
            ++n3;
        }
        n = n4;
        while (n < mLDSAEngine.getDilithiumOmega()) {
            if ((byArray[n2 + n] & 0xFF) != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

