/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.hqc;

import org.bouncycastle.util.Pack;

class Utils {
    Utils() {
    }

    static long bitMask(long l, long l2) {
        return (1L << (int)(l % l2)) - 1L;
    }

    static void copyBytes(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        System.arraycopy(nArray, n, nArray2, n2, n3 / 2);
    }

    static void fromByte16ArrayToLongArray(long[] lArray, int[] nArray) {
        int n = 0;
        while (n != nArray.length) {
            lArray[n / 4] = (long)nArray[n] & 0xFFFFL;
            int n2 = n / 4;
            lArray[n2] = lArray[n2] | (long)nArray[n + 1] << 16;
            int n3 = n / 4;
            lArray[n3] = lArray[n3] | (long)nArray[n + 2] << 32;
            int n4 = n / 4;
            lArray[n4] = lArray[n4] | (long)nArray[n + 3] << 48;
            n += 4;
        }
    }

    static void fromByte32ArrayToLongArray(long[] lArray, int[] nArray) {
        int n = 0;
        while (n != nArray.length) {
            lArray[n / 2] = (long)nArray[n] & 0xFFFFFFFFL;
            int n2 = n / 2;
            lArray[n2] = lArray[n2] | (long)nArray[n + 1] << 32;
            n += 2;
        }
    }

    static void fromByteArrayToByte16Array(int[] nArray, byte[] byArray) {
        byte[] byArray2 = byArray;
        if (byArray.length % 2 != 0) {
            byArray2 = new byte[(byArray.length + 1) / 2 * 2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        }
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = Pack.littleEndianToShort(byArray2, n) & 0xFFFF;
            n += 2;
            ++n2;
        }
    }

    static void fromByteArrayToLongArray(long[] lArray, byte[] byArray) {
        byte[] byArray2 = byArray;
        if (byArray.length % 8 != 0) {
            byArray2 = new byte[(byArray.length + 7) / 8 * 8];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        }
        int n = 0;
        int n2 = 0;
        while (n2 < lArray.length) {
            lArray[n2] = Pack.littleEndianToLong(byArray2, n);
            n += 8;
            ++n2;
        }
    }

    static void fromLongArrayToByte32Array(int[] nArray, long[] lArray) {
        int n = 0;
        while (n != lArray.length) {
            nArray[2 * n] = (int)lArray[n];
            nArray[2 * n + 1] = (int)(lArray[n] >> 32);
            ++n;
        }
    }

    static void fromLongArrayToByteArray(byte[] byArray, long[] lArray) {
        int n = byArray.length / 8;
        int n2 = 0;
        while (n2 != n) {
            Pack.longToLittleEndian(lArray[n2], byArray, n2 * 8);
            ++n2;
        }
        if (byArray.length % 8 != 0) {
            int n3 = n * 8;
            int n4 = 0;
            while (n3 < byArray.length) {
                byArray[n3++] = (byte)(lArray[n] >>> n4++ * 8);
            }
        }
    }

    static int getByte64SizeFromBitSize(int n) {
        return (n + 63) / 64;
    }

    static int getByteSizeFromBitSize(int n) {
        return (n + 7) / 8;
    }

    static void resizeArray(long[] lArray, int n, long[] lArray2, int n2, int n3, int n4) {
        long l = Long.MAX_VALUE;
        int n5 = 0;
        if (n < n2) {
            if (n % 64 != 0) {
                n5 = 64 - n % 64;
            }
            System.arraycopy(lArray2, 0, lArray, 0, n3);
            int n6 = 0;
            while (n6 < n5) {
                int n7 = n4 - 1;
                lArray[n7] = lArray[n7] & l >> n6;
                ++n6;
            }
        } else {
            System.arraycopy(lArray2, 0, lArray, 0, (n2 + 7) / 8);
        }
    }

    static int toUnsigned16Bits(int n) {
        return n & 0xFFFF;
    }

    static int toUnsigned8bits(int n) {
        return n & 0xFF;
    }

    static void xorLongToByte16Array(int[] nArray, long l, int n) {
        int n2 = n;
        nArray[n2] = nArray[n2] ^ (int)l & 0xFFFF;
        int n3 = n + 1;
        nArray[n3] = nArray[n3] ^ (int)(l >>> 16) & 0xFFFF;
        int n4 = n + 2;
        nArray[n4] = nArray[n4] ^ (int)(l >>> 32) & 0xFFFF;
        int n5 = n + 3;
        nArray[n5] = nArray[n5] ^ (int)(l >>> 48) & 0xFFFF;
    }
}

