/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.hqc;

import org.bouncycastle.pqc.crypto.hqc.Utils;
import org.bouncycastle.util.Arrays;

class ReedMuller {
    ReedMuller() {
    }

    private static int Bit0Mask(int n) {
        return -(n & 1) & 0xFFFFFFFF;
    }

    public static void decode(byte[] byArray, long[] lArray, int n, int n2) {
        int[] nArray;
        byte[] byArray2 = Arrays.clone(byArray);
        Codeword[] codewordArray = new Codeword[lArray.length / 2];
        int[] nArray2 = new int[lArray.length * 2];
        Utils.fromLongArrayToByte32Array(nArray2, lArray);
        int n3 = 0;
        while (n3 < codewordArray.length) {
            codewordArray[n3] = new Codeword();
            int n4 = 0;
            while (n4 < 4) {
                codewordArray[n3].type32[n4] = nArray2[n3 * 4 + n4];
                ++n4;
            }
            ++n3;
        }
        int[] nArray3 = new int[128];
        int n5 = 0;
        while (n5 < n) {
            ReedMuller.expandThenSum(nArray3, codewordArray, n5 * n2, n2);
            nArray = new int[128];
            ReedMuller.hadamardTransform(nArray3, nArray);
            nArray[0] = nArray[0] - 64 * n2;
            byArray2[n5] = (byte)ReedMuller.findPeaks(nArray);
            ++n5;
        }
        nArray = new int[codewordArray.length * 4];
        int n6 = 0;
        int n7 = 0;
        while (n7 < codewordArray.length) {
            System.arraycopy(codewordArray[n7].type32, 0, nArray, n6, codewordArray[n7].type32.length);
            n6 += 4;
            ++n7;
        }
        Utils.fromByte32ArrayToLongArray(lArray, nArray);
        System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
    }

    public static void encode(long[] lArray, byte[] byArray, int n, int n2) {
        int n3;
        byte[] byArray2 = Arrays.clone(byArray);
        Codeword[] codewordArray = new Codeword[n * n2];
        int n4 = 0;
        while (n4 < codewordArray.length) {
            codewordArray[n4] = new Codeword();
            ++n4;
        }
        int n5 = 0;
        while (n5 < n) {
            int n6 = n5 * n2;
            ReedMuller.encodeSub(codewordArray[n6], byArray2[n5]);
            n3 = 1;
            while (n3 < n2) {
                codewordArray[n6 + n3] = codewordArray[n6];
                ++n3;
            }
            ++n5;
        }
        int[] nArray = new int[codewordArray.length * 4];
        n3 = 0;
        int n7 = 0;
        while (n7 < codewordArray.length) {
            System.arraycopy(codewordArray[n7].type32, 0, nArray, n3, codewordArray[n7].type32.length);
            n3 += 4;
            ++n7;
        }
        Utils.fromByte32ArrayToLongArray(lArray, nArray);
    }

    static void encodeSub(Codeword codeword, int n) {
        int n2 = ReedMuller.Bit0Mask(n >> 7);
        n2 ^= ReedMuller.Bit0Mask(n) & 0xAAAAAAAA;
        n2 ^= ReedMuller.Bit0Mask(n >> 1) & 0xCCCCCCCC;
        n2 ^= ReedMuller.Bit0Mask(n >> 2) & 0xF0F0F0F0;
        n2 ^= ReedMuller.Bit0Mask(n >> 3) & 0xFF00FF00;
        codeword.type32[0] = n2 ^= ReedMuller.Bit0Mask(n >> 4) & 0xFFFF0000;
        codeword.type32[1] = n2 ^= ReedMuller.Bit0Mask(n >> 5);
        codeword.type32[3] = n2 ^= ReedMuller.Bit0Mask(n >> 6);
        codeword.type32[2] = n2 ^= ReedMuller.Bit0Mask(n >> 5);
    }

    private static void expandThenSum(int[] nArray, Codeword[] codewordArray, int n, int n2) {
        int n3;
        int n4 = 0;
        while (n4 < 4) {
            n3 = 0;
            while (n3 < 32) {
                long l = codewordArray[n].type32[n4] >> n3 & 1;
                nArray[n4 * 32 + n3] = codewordArray[n].type32[n4] >> n3 & 1;
                ++n3;
            }
            ++n4;
        }
        n3 = 1;
        while (n3 < n2) {
            int n5 = 0;
            while (n5 < 4) {
                int n6 = 0;
                while (n6 < 32) {
                    int n7 = n5 * 32 + n6;
                    nArray[n7] = nArray[n7] + (codewordArray[n3 + n].type32[n5] >> n6 & 1);
                    ++n6;
                }
                ++n5;
            }
            ++n3;
        }
    }

    private static int findPeaks(int[] nArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < 128) {
            n = nArray[n5];
            int n6 = n > 0 ? -1 : 0;
            int n7 = n6 & n | ~n6 & -n;
            n3 = n7 > n2 ? n : n3;
            n4 = n7 > n2 ? n5 : n4;
            n2 = n7 > n2 ? n7 : n2;
            ++n5;
        }
        n = n3 > 0 ? 1 : 0;
        return n4 |= 128 * n;
    }

    private static void hadamardTransform(int[] nArray, int[] nArray2) {
        int[] nArray3 = Arrays.clone(nArray);
        int[] nArray4 = Arrays.clone(nArray2);
        int n = 0;
        while (n < 7) {
            int n2 = 0;
            while (n2 < 64) {
                nArray4[n2] = nArray3[2 * n2] + nArray3[2 * n2 + 1];
                nArray4[n2 + 64] = nArray3[2 * n2] - nArray3[2 * n2 + 1];
                ++n2;
            }
            int[] nArray5 = nArray3;
            nArray3 = nArray4;
            nArray4 = nArray5;
            ++n;
        }
        System.arraycopy(nArray4, 0, nArray, 0, nArray.length);
        System.arraycopy(nArray3, 0, nArray2, 0, nArray2.length);
    }

    static class Codeword {
        int[] type32 = new int[4];
        int[] type8 = new int[16];
    }
}

