/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.frodo;

import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.Pack;

abstract class FrodoMatrixGenerator {
    int n;
    int q;

    public FrodoMatrixGenerator(int n, int n2) {
        this.n = n;
        this.q = n2;
    }

    abstract short[] genMatrix(byte[] var1);

    static class Shake128MatrixGenerator
    extends FrodoMatrixGenerator {
        public Shake128MatrixGenerator(int n, int n2) {
            super(n, n2);
        }

        short[] genMatrix(byte[] byArray) {
            short[] sArray = new short[this.n * this.n];
            byte[] byArray2 = new byte[16 * this.n / 8];
            byte[] byArray3 = new byte[2 + byArray.length];
            System.arraycopy(byArray, 0, byArray3, 2, byArray.length);
            SHAKEDigest sHAKEDigest = new SHAKEDigest(128);
            short s = 0;
            while (s < this.n) {
                Pack.shortToLittleEndian(s, byArray3, 0);
                sHAKEDigest.update(byArray3, 0, byArray3.length);
                sHAKEDigest.doFinal(byArray2, 0, byArray2.length);
                int n = 0;
                while (n < this.n) {
                    sArray[s * this.n + n] = (short)(Pack.littleEndianToShort(byArray2, 2 * n) & this.q - 1);
                    n = (short)(n + 1);
                }
                s = (short)(s + 1);
            }
            return sArray;
        }
    }

    static class Aes128MatrixGenerator
    extends FrodoMatrixGenerator {
        public Aes128MatrixGenerator(int n, int n2) {
            super(n, n2);
        }

        short[] genMatrix(byte[] byArray) {
            short[] sArray = new short[this.n * this.n];
            byte[] byArray2 = new byte[16];
            byte[] byArray3 = new byte[16];
            AESEngine aESEngine = new AESEngine();
            aESEngine.init(true, new KeyParameter(byArray));
            int n = 0;
            while (n < this.n) {
                Pack.shortToLittleEndian((short)n, byArray2, 0);
                int n2 = 0;
                while (n2 < this.n) {
                    Pack.shortToLittleEndian((short)n2, byArray2, 2);
                    aESEngine.processBlock(byArray2, 0, byArray3, 0);
                    int n3 = 0;
                    while (n3 < 8) {
                        sArray[n * this.n + n2 + n3] = (short)(Pack.littleEndianToShort(byArray3, 2 * n3) & this.q - 1);
                        ++n3;
                    }
                    n2 += 8;
                }
                ++n;
            }
            return sArray;
        }
    }
}

