/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.falcon;

import org.bouncycastle.pqc.crypto.falcon.FPREngine;
import org.bouncycastle.pqc.crypto.falcon.FalconCodec;
import org.bouncycastle.pqc.crypto.falcon.FalconFFT;
import org.bouncycastle.pqc.crypto.falcon.FalconFPR;
import org.bouncycastle.pqc.crypto.falcon.FalconSmallPrime;
import org.bouncycastle.pqc.crypto.falcon.FalconSmallPrimeList;
import org.bouncycastle.pqc.crypto.falcon.FalconVrfy;
import org.bouncycastle.pqc.crypto.falcon.SHAKE256;

class FalconKeyGen {
    FPREngine fpr;
    FalconSmallPrimeList primes;
    FalconFFT fft;
    FalconCodec codec;
    FalconVrfy vrfy;
    private short[] REV10;
    final long[] gauss_1024_12289;
    final int[] MAX_BL_SMALL;
    final int[] MAX_BL_LARGE;
    final int[] bitlength_avg;
    final int[] bitlength_std;
    final int DEPTH_INT_FG = 4;

    FalconKeyGen() {
        short[] sArray = new short[1024];
        sArray[1] = 512;
        sArray[2] = 256;
        sArray[3] = 768;
        sArray[4] = 128;
        sArray[5] = 640;
        sArray[6] = 384;
        sArray[7] = 896;
        sArray[8] = 64;
        sArray[9] = 576;
        sArray[10] = 320;
        sArray[11] = 832;
        sArray[12] = 192;
        sArray[13] = 704;
        sArray[14] = 448;
        sArray[15] = 960;
        sArray[16] = 32;
        sArray[17] = 544;
        sArray[18] = 288;
        sArray[19] = 800;
        sArray[20] = 160;
        sArray[21] = 672;
        sArray[22] = 416;
        sArray[23] = 928;
        sArray[24] = 96;
        sArray[25] = 608;
        sArray[26] = 352;
        sArray[27] = 864;
        sArray[28] = 224;
        sArray[29] = 736;
        sArray[30] = 480;
        sArray[31] = 992;
        sArray[32] = 16;
        sArray[33] = 528;
        sArray[34] = 272;
        sArray[35] = 784;
        sArray[36] = 144;
        sArray[37] = 656;
        sArray[38] = 400;
        sArray[39] = 912;
        sArray[40] = 80;
        sArray[41] = 592;
        sArray[42] = 336;
        sArray[43] = 848;
        sArray[44] = 208;
        sArray[45] = 720;
        sArray[46] = 464;
        sArray[47] = 976;
        sArray[48] = 48;
        sArray[49] = 560;
        sArray[50] = 304;
        sArray[51] = 816;
        sArray[52] = 176;
        sArray[53] = 688;
        sArray[54] = 432;
        sArray[55] = 944;
        sArray[56] = 112;
        sArray[57] = 624;
        sArray[58] = 368;
        sArray[59] = 880;
        sArray[60] = 240;
        sArray[61] = 752;
        sArray[62] = 496;
        sArray[63] = 1008;
        sArray[64] = 8;
        sArray[65] = 520;
        sArray[66] = 264;
        sArray[67] = 776;
        sArray[68] = 136;
        sArray[69] = 648;
        sArray[70] = 392;
        sArray[71] = 904;
        sArray[72] = 72;
        sArray[73] = 584;
        sArray[74] = 328;
        sArray[75] = 840;
        sArray[76] = 200;
        sArray[77] = 712;
        sArray[78] = 456;
        sArray[79] = 968;
        sArray[80] = 40;
        sArray[81] = 552;
        sArray[82] = 296;
        sArray[83] = 808;
        sArray[84] = 168;
        sArray[85] = 680;
        sArray[86] = 424;
        sArray[87] = 936;
        sArray[88] = 104;
        sArray[89] = 616;
        sArray[90] = 360;
        sArray[91] = 872;
        sArray[92] = 232;
        sArray[93] = 744;
        sArray[94] = 488;
        sArray[95] = 1000;
        sArray[96] = 24;
        sArray[97] = 536;
        sArray[98] = 280;
        sArray[99] = 792;
        sArray[100] = 152;
        sArray[101] = 664;
        sArray[102] = 408;
        sArray[103] = 920;
        sArray[104] = 88;
        sArray[105] = 600;
        sArray[106] = 344;
        sArray[107] = 856;
        sArray[108] = 216;
        sArray[109] = 728;
        sArray[110] = 472;
        sArray[111] = 984;
        sArray[112] = 56;
        sArray[113] = 568;
        sArray[114] = 312;
        sArray[115] = 824;
        sArray[116] = 184;
        sArray[117] = 696;
        sArray[118] = 440;
        sArray[119] = 952;
        sArray[120] = 120;
        sArray[121] = 632;
        sArray[122] = 376;
        sArray[123] = 888;
        sArray[124] = 248;
        sArray[125] = 760;
        sArray[126] = 504;
        sArray[127] = 1016;
        sArray[128] = 4;
        sArray[129] = 516;
        sArray[130] = 260;
        sArray[131] = 772;
        sArray[132] = 132;
        sArray[133] = 644;
        sArray[134] = 388;
        sArray[135] = 900;
        sArray[136] = 68;
        sArray[137] = 580;
        sArray[138] = 324;
        sArray[139] = 836;
        sArray[140] = 196;
        sArray[141] = 708;
        sArray[142] = 452;
        sArray[143] = 964;
        sArray[144] = 36;
        sArray[145] = 548;
        sArray[146] = 292;
        sArray[147] = 804;
        sArray[148] = 164;
        sArray[149] = 676;
        sArray[150] = 420;
        sArray[151] = 932;
        sArray[152] = 100;
        sArray[153] = 612;
        sArray[154] = 356;
        sArray[155] = 868;
        sArray[156] = 228;
        sArray[157] = 740;
        sArray[158] = 484;
        sArray[159] = 996;
        sArray[160] = 20;
        sArray[161] = 532;
        sArray[162] = 276;
        sArray[163] = 788;
        sArray[164] = 148;
        sArray[165] = 660;
        sArray[166] = 404;
        sArray[167] = 916;
        sArray[168] = 84;
        sArray[169] = 596;
        sArray[170] = 340;
        sArray[171] = 852;
        sArray[172] = 212;
        sArray[173] = 724;
        sArray[174] = 468;
        sArray[175] = 980;
        sArray[176] = 52;
        sArray[177] = 564;
        sArray[178] = 308;
        sArray[179] = 820;
        sArray[180] = 180;
        sArray[181] = 692;
        sArray[182] = 436;
        sArray[183] = 948;
        sArray[184] = 116;
        sArray[185] = 628;
        sArray[186] = 372;
        sArray[187] = 884;
        sArray[188] = 244;
        sArray[189] = 756;
        sArray[190] = 500;
        sArray[191] = 1012;
        sArray[192] = 12;
        sArray[193] = 524;
        sArray[194] = 268;
        sArray[195] = 780;
        sArray[196] = 140;
        sArray[197] = 652;
        sArray[198] = 396;
        sArray[199] = 908;
        sArray[200] = 76;
        sArray[201] = 588;
        sArray[202] = 332;
        sArray[203] = 844;
        sArray[204] = 204;
        sArray[205] = 716;
        sArray[206] = 460;
        sArray[207] = 972;
        sArray[208] = 44;
        sArray[209] = 556;
        sArray[210] = 300;
        sArray[211] = 812;
        sArray[212] = 172;
        sArray[213] = 684;
        sArray[214] = 428;
        sArray[215] = 940;
        sArray[216] = 108;
        sArray[217] = 620;
        sArray[218] = 364;
        sArray[219] = 876;
        sArray[220] = 236;
        sArray[221] = 748;
        sArray[222] = 492;
        sArray[223] = 1004;
        sArray[224] = 28;
        sArray[225] = 540;
        sArray[226] = 284;
        sArray[227] = 796;
        sArray[228] = 156;
        sArray[229] = 668;
        sArray[230] = 412;
        sArray[231] = 924;
        sArray[232] = 92;
        sArray[233] = 604;
        sArray[234] = 348;
        sArray[235] = 860;
        sArray[236] = 220;
        sArray[237] = 732;
        sArray[238] = 476;
        sArray[239] = 988;
        sArray[240] = 60;
        sArray[241] = 572;
        sArray[242] = 316;
        sArray[243] = 828;
        sArray[244] = 188;
        sArray[245] = 700;
        sArray[246] = 444;
        sArray[247] = 956;
        sArray[248] = 124;
        sArray[249] = 636;
        sArray[250] = 380;
        sArray[251] = 892;
        sArray[252] = 252;
        sArray[253] = 764;
        sArray[254] = 508;
        sArray[255] = 1020;
        sArray[256] = 2;
        sArray[257] = 514;
        sArray[258] = 258;
        sArray[259] = 770;
        sArray[260] = 130;
        sArray[261] = 642;
        sArray[262] = 386;
        sArray[263] = 898;
        sArray[264] = 66;
        sArray[265] = 578;
        sArray[266] = 322;
        sArray[267] = 834;
        sArray[268] = 194;
        sArray[269] = 706;
        sArray[270] = 450;
        sArray[271] = 962;
        sArray[272] = 34;
        sArray[273] = 546;
        sArray[274] = 290;
        sArray[275] = 802;
        sArray[276] = 162;
        sArray[277] = 674;
        sArray[278] = 418;
        sArray[279] = 930;
        sArray[280] = 98;
        sArray[281] = 610;
        sArray[282] = 354;
        sArray[283] = 866;
        sArray[284] = 226;
        sArray[285] = 738;
        sArray[286] = 482;
        sArray[287] = 994;
        sArray[288] = 18;
        sArray[289] = 530;
        sArray[290] = 274;
        sArray[291] = 786;
        sArray[292] = 146;
        sArray[293] = 658;
        sArray[294] = 402;
        sArray[295] = 914;
        sArray[296] = 82;
        sArray[297] = 594;
        sArray[298] = 338;
        sArray[299] = 850;
        sArray[300] = 210;
        sArray[301] = 722;
        sArray[302] = 466;
        sArray[303] = 978;
        sArray[304] = 50;
        sArray[305] = 562;
        sArray[306] = 306;
        sArray[307] = 818;
        sArray[308] = 178;
        sArray[309] = 690;
        sArray[310] = 434;
        sArray[311] = 946;
        sArray[312] = 114;
        sArray[313] = 626;
        sArray[314] = 370;
        sArray[315] = 882;
        sArray[316] = 242;
        sArray[317] = 754;
        sArray[318] = 498;
        sArray[319] = 1010;
        sArray[320] = 10;
        sArray[321] = 522;
        sArray[322] = 266;
        sArray[323] = 778;
        sArray[324] = 138;
        sArray[325] = 650;
        sArray[326] = 394;
        sArray[327] = 906;
        sArray[328] = 74;
        sArray[329] = 586;
        sArray[330] = 330;
        sArray[331] = 842;
        sArray[332] = 202;
        sArray[333] = 714;
        sArray[334] = 458;
        sArray[335] = 970;
        sArray[336] = 42;
        sArray[337] = 554;
        sArray[338] = 298;
        sArray[339] = 810;
        sArray[340] = 170;
        sArray[341] = 682;
        sArray[342] = 426;
        sArray[343] = 938;
        sArray[344] = 106;
        sArray[345] = 618;
        sArray[346] = 362;
        sArray[347] = 874;
        sArray[348] = 234;
        sArray[349] = 746;
        sArray[350] = 490;
        sArray[351] = 1002;
        sArray[352] = 26;
        sArray[353] = 538;
        sArray[354] = 282;
        sArray[355] = 794;
        sArray[356] = 154;
        sArray[357] = 666;
        sArray[358] = 410;
        sArray[359] = 922;
        sArray[360] = 90;
        sArray[361] = 602;
        sArray[362] = 346;
        sArray[363] = 858;
        sArray[364] = 218;
        sArray[365] = 730;
        sArray[366] = 474;
        sArray[367] = 986;
        sArray[368] = 58;
        sArray[369] = 570;
        sArray[370] = 314;
        sArray[371] = 826;
        sArray[372] = 186;
        sArray[373] = 698;
        sArray[374] = 442;
        sArray[375] = 954;
        sArray[376] = 122;
        sArray[377] = 634;
        sArray[378] = 378;
        sArray[379] = 890;
        sArray[380] = 250;
        sArray[381] = 762;
        sArray[382] = 506;
        sArray[383] = 1018;
        sArray[384] = 6;
        sArray[385] = 518;
        sArray[386] = 262;
        sArray[387] = 774;
        sArray[388] = 134;
        sArray[389] = 646;
        sArray[390] = 390;
        sArray[391] = 902;
        sArray[392] = 70;
        sArray[393] = 582;
        sArray[394] = 326;
        sArray[395] = 838;
        sArray[396] = 198;
        sArray[397] = 710;
        sArray[398] = 454;
        sArray[399] = 966;
        sArray[400] = 38;
        sArray[401] = 550;
        sArray[402] = 294;
        sArray[403] = 806;
        sArray[404] = 166;
        sArray[405] = 678;
        sArray[406] = 422;
        sArray[407] = 934;
        sArray[408] = 102;
        sArray[409] = 614;
        sArray[410] = 358;
        sArray[411] = 870;
        sArray[412] = 230;
        sArray[413] = 742;
        sArray[414] = 486;
        sArray[415] = 998;
        sArray[416] = 22;
        sArray[417] = 534;
        sArray[418] = 278;
        sArray[419] = 790;
        sArray[420] = 150;
        sArray[421] = 662;
        sArray[422] = 406;
        sArray[423] = 918;
        sArray[424] = 86;
        sArray[425] = 598;
        sArray[426] = 342;
        sArray[427] = 854;
        sArray[428] = 214;
        sArray[429] = 726;
        sArray[430] = 470;
        sArray[431] = 982;
        sArray[432] = 54;
        sArray[433] = 566;
        sArray[434] = 310;
        sArray[435] = 822;
        sArray[436] = 182;
        sArray[437] = 694;
        sArray[438] = 438;
        sArray[439] = 950;
        sArray[440] = 118;
        sArray[441] = 630;
        sArray[442] = 374;
        sArray[443] = 886;
        sArray[444] = 246;
        sArray[445] = 758;
        sArray[446] = 502;
        sArray[447] = 1014;
        sArray[448] = 14;
        sArray[449] = 526;
        sArray[450] = 270;
        sArray[451] = 782;
        sArray[452] = 142;
        sArray[453] = 654;
        sArray[454] = 398;
        sArray[455] = 910;
        sArray[456] = 78;
        sArray[457] = 590;
        sArray[458] = 334;
        sArray[459] = 846;
        sArray[460] = 206;
        sArray[461] = 718;
        sArray[462] = 462;
        sArray[463] = 974;
        sArray[464] = 46;
        sArray[465] = 558;
        sArray[466] = 302;
        sArray[467] = 814;
        sArray[468] = 174;
        sArray[469] = 686;
        sArray[470] = 430;
        sArray[471] = 942;
        sArray[472] = 110;
        sArray[473] = 622;
        sArray[474] = 366;
        sArray[475] = 878;
        sArray[476] = 238;
        sArray[477] = 750;
        sArray[478] = 494;
        sArray[479] = 1006;
        sArray[480] = 30;
        sArray[481] = 542;
        sArray[482] = 286;
        sArray[483] = 798;
        sArray[484] = 158;
        sArray[485] = 670;
        sArray[486] = 414;
        sArray[487] = 926;
        sArray[488] = 94;
        sArray[489] = 606;
        sArray[490] = 350;
        sArray[491] = 862;
        sArray[492] = 222;
        sArray[493] = 734;
        sArray[494] = 478;
        sArray[495] = 990;
        sArray[496] = 62;
        sArray[497] = 574;
        sArray[498] = 318;
        sArray[499] = 830;
        sArray[500] = 190;
        sArray[501] = 702;
        sArray[502] = 446;
        sArray[503] = 958;
        sArray[504] = 126;
        sArray[505] = 638;
        sArray[506] = 382;
        sArray[507] = 894;
        sArray[508] = 254;
        sArray[509] = 766;
        sArray[510] = 510;
        sArray[511] = 1022;
        sArray[512] = 1;
        sArray[513] = 513;
        sArray[514] = 257;
        sArray[515] = 769;
        sArray[516] = 129;
        sArray[517] = 641;
        sArray[518] = 385;
        sArray[519] = 897;
        sArray[520] = 65;
        sArray[521] = 577;
        sArray[522] = 321;
        sArray[523] = 833;
        sArray[524] = 193;
        sArray[525] = 705;
        sArray[526] = 449;
        sArray[527] = 961;
        sArray[528] = 33;
        sArray[529] = 545;
        sArray[530] = 289;
        sArray[531] = 801;
        sArray[532] = 161;
        sArray[533] = 673;
        sArray[534] = 417;
        sArray[535] = 929;
        sArray[536] = 97;
        sArray[537] = 609;
        sArray[538] = 353;
        sArray[539] = 865;
        sArray[540] = 225;
        sArray[541] = 737;
        sArray[542] = 481;
        sArray[543] = 993;
        sArray[544] = 17;
        sArray[545] = 529;
        sArray[546] = 273;
        sArray[547] = 785;
        sArray[548] = 145;
        sArray[549] = 657;
        sArray[550] = 401;
        sArray[551] = 913;
        sArray[552] = 81;
        sArray[553] = 593;
        sArray[554] = 337;
        sArray[555] = 849;
        sArray[556] = 209;
        sArray[557] = 721;
        sArray[558] = 465;
        sArray[559] = 977;
        sArray[560] = 49;
        sArray[561] = 561;
        sArray[562] = 305;
        sArray[563] = 817;
        sArray[564] = 177;
        sArray[565] = 689;
        sArray[566] = 433;
        sArray[567] = 945;
        sArray[568] = 113;
        sArray[569] = 625;
        sArray[570] = 369;
        sArray[571] = 881;
        sArray[572] = 241;
        sArray[573] = 753;
        sArray[574] = 497;
        sArray[575] = 1009;
        sArray[576] = 9;
        sArray[577] = 521;
        sArray[578] = 265;
        sArray[579] = 777;
        sArray[580] = 137;
        sArray[581] = 649;
        sArray[582] = 393;
        sArray[583] = 905;
        sArray[584] = 73;
        sArray[585] = 585;
        sArray[586] = 329;
        sArray[587] = 841;
        sArray[588] = 201;
        sArray[589] = 713;
        sArray[590] = 457;
        sArray[591] = 969;
        sArray[592] = 41;
        sArray[593] = 553;
        sArray[594] = 297;
        sArray[595] = 809;
        sArray[596] = 169;
        sArray[597] = 681;
        sArray[598] = 425;
        sArray[599] = 937;
        sArray[600] = 105;
        sArray[601] = 617;
        sArray[602] = 361;
        sArray[603] = 873;
        sArray[604] = 233;
        sArray[605] = 745;
        sArray[606] = 489;
        sArray[607] = 1001;
        sArray[608] = 25;
        sArray[609] = 537;
        sArray[610] = 281;
        sArray[611] = 793;
        sArray[612] = 153;
        sArray[613] = 665;
        sArray[614] = 409;
        sArray[615] = 921;
        sArray[616] = 89;
        sArray[617] = 601;
        sArray[618] = 345;
        sArray[619] = 857;
        sArray[620] = 217;
        sArray[621] = 729;
        sArray[622] = 473;
        sArray[623] = 985;
        sArray[624] = 57;
        sArray[625] = 569;
        sArray[626] = 313;
        sArray[627] = 825;
        sArray[628] = 185;
        sArray[629] = 697;
        sArray[630] = 441;
        sArray[631] = 953;
        sArray[632] = 121;
        sArray[633] = 633;
        sArray[634] = 377;
        sArray[635] = 889;
        sArray[636] = 249;
        sArray[637] = 761;
        sArray[638] = 505;
        sArray[639] = 1017;
        sArray[640] = 5;
        sArray[641] = 517;
        sArray[642] = 261;
        sArray[643] = 773;
        sArray[644] = 133;
        sArray[645] = 645;
        sArray[646] = 389;
        sArray[647] = 901;
        sArray[648] = 69;
        sArray[649] = 581;
        sArray[650] = 325;
        sArray[651] = 837;
        sArray[652] = 197;
        sArray[653] = 709;
        sArray[654] = 453;
        sArray[655] = 965;
        sArray[656] = 37;
        sArray[657] = 549;
        sArray[658] = 293;
        sArray[659] = 805;
        sArray[660] = 165;
        sArray[661] = 677;
        sArray[662] = 421;
        sArray[663] = 933;
        sArray[664] = 101;
        sArray[665] = 613;
        sArray[666] = 357;
        sArray[667] = 869;
        sArray[668] = 229;
        sArray[669] = 741;
        sArray[670] = 485;
        sArray[671] = 997;
        sArray[672] = 21;
        sArray[673] = 533;
        sArray[674] = 277;
        sArray[675] = 789;
        sArray[676] = 149;
        sArray[677] = 661;
        sArray[678] = 405;
        sArray[679] = 917;
        sArray[680] = 85;
        sArray[681] = 597;
        sArray[682] = 341;
        sArray[683] = 853;
        sArray[684] = 213;
        sArray[685] = 725;
        sArray[686] = 469;
        sArray[687] = 981;
        sArray[688] = 53;
        sArray[689] = 565;
        sArray[690] = 309;
        sArray[691] = 821;
        sArray[692] = 181;
        sArray[693] = 693;
        sArray[694] = 437;
        sArray[695] = 949;
        sArray[696] = 117;
        sArray[697] = 629;
        sArray[698] = 373;
        sArray[699] = 885;
        sArray[700] = 245;
        sArray[701] = 757;
        sArray[702] = 501;
        sArray[703] = 1013;
        sArray[704] = 13;
        sArray[705] = 525;
        sArray[706] = 269;
        sArray[707] = 781;
        sArray[708] = 141;
        sArray[709] = 653;
        sArray[710] = 397;
        sArray[711] = 909;
        sArray[712] = 77;
        sArray[713] = 589;
        sArray[714] = 333;
        sArray[715] = 845;
        sArray[716] = 205;
        sArray[717] = 717;
        sArray[718] = 461;
        sArray[719] = 973;
        sArray[720] = 45;
        sArray[721] = 557;
        sArray[722] = 301;
        sArray[723] = 813;
        sArray[724] = 173;
        sArray[725] = 685;
        sArray[726] = 429;
        sArray[727] = 941;
        sArray[728] = 109;
        sArray[729] = 621;
        sArray[730] = 365;
        sArray[731] = 877;
        sArray[732] = 237;
        sArray[733] = 749;
        sArray[734] = 493;
        sArray[735] = 1005;
        sArray[736] = 29;
        sArray[737] = 541;
        sArray[738] = 285;
        sArray[739] = 797;
        sArray[740] = 157;
        sArray[741] = 669;
        sArray[742] = 413;
        sArray[743] = 925;
        sArray[744] = 93;
        sArray[745] = 605;
        sArray[746] = 349;
        sArray[747] = 861;
        sArray[748] = 221;
        sArray[749] = 733;
        sArray[750] = 477;
        sArray[751] = 989;
        sArray[752] = 61;
        sArray[753] = 573;
        sArray[754] = 317;
        sArray[755] = 829;
        sArray[756] = 189;
        sArray[757] = 701;
        sArray[758] = 445;
        sArray[759] = 957;
        sArray[760] = 125;
        sArray[761] = 637;
        sArray[762] = 381;
        sArray[763] = 893;
        sArray[764] = 253;
        sArray[765] = 765;
        sArray[766] = 509;
        sArray[767] = 1021;
        sArray[768] = 3;
        sArray[769] = 515;
        sArray[770] = 259;
        sArray[771] = 771;
        sArray[772] = 131;
        sArray[773] = 643;
        sArray[774] = 387;
        sArray[775] = 899;
        sArray[776] = 67;
        sArray[777] = 579;
        sArray[778] = 323;
        sArray[779] = 835;
        sArray[780] = 195;
        sArray[781] = 707;
        sArray[782] = 451;
        sArray[783] = 963;
        sArray[784] = 35;
        sArray[785] = 547;
        sArray[786] = 291;
        sArray[787] = 803;
        sArray[788] = 163;
        sArray[789] = 675;
        sArray[790] = 419;
        sArray[791] = 931;
        sArray[792] = 99;
        sArray[793] = 611;
        sArray[794] = 355;
        sArray[795] = 867;
        sArray[796] = 227;
        sArray[797] = 739;
        sArray[798] = 483;
        sArray[799] = 995;
        sArray[800] = 19;
        sArray[801] = 531;
        sArray[802] = 275;
        sArray[803] = 787;
        sArray[804] = 147;
        sArray[805] = 659;
        sArray[806] = 403;
        sArray[807] = 915;
        sArray[808] = 83;
        sArray[809] = 595;
        sArray[810] = 339;
        sArray[811] = 851;
        sArray[812] = 211;
        sArray[813] = 723;
        sArray[814] = 467;
        sArray[815] = 979;
        sArray[816] = 51;
        sArray[817] = 563;
        sArray[818] = 307;
        sArray[819] = 819;
        sArray[820] = 179;
        sArray[821] = 691;
        sArray[822] = 435;
        sArray[823] = 947;
        sArray[824] = 115;
        sArray[825] = 627;
        sArray[826] = 371;
        sArray[827] = 883;
        sArray[828] = 243;
        sArray[829] = 755;
        sArray[830] = 499;
        sArray[831] = 1011;
        sArray[832] = 11;
        sArray[833] = 523;
        sArray[834] = 267;
        sArray[835] = 779;
        sArray[836] = 139;
        sArray[837] = 651;
        sArray[838] = 395;
        sArray[839] = 907;
        sArray[840] = 75;
        sArray[841] = 587;
        sArray[842] = 331;
        sArray[843] = 843;
        sArray[844] = 203;
        sArray[845] = 715;
        sArray[846] = 459;
        sArray[847] = 971;
        sArray[848] = 43;
        sArray[849] = 555;
        sArray[850] = 299;
        sArray[851] = 811;
        sArray[852] = 171;
        sArray[853] = 683;
        sArray[854] = 427;
        sArray[855] = 939;
        sArray[856] = 107;
        sArray[857] = 619;
        sArray[858] = 363;
        sArray[859] = 875;
        sArray[860] = 235;
        sArray[861] = 747;
        sArray[862] = 491;
        sArray[863] = 1003;
        sArray[864] = 27;
        sArray[865] = 539;
        sArray[866] = 283;
        sArray[867] = 795;
        sArray[868] = 155;
        sArray[869] = 667;
        sArray[870] = 411;
        sArray[871] = 923;
        sArray[872] = 91;
        sArray[873] = 603;
        sArray[874] = 347;
        sArray[875] = 859;
        sArray[876] = 219;
        sArray[877] = 731;
        sArray[878] = 475;
        sArray[879] = 987;
        sArray[880] = 59;
        sArray[881] = 571;
        sArray[882] = 315;
        sArray[883] = 827;
        sArray[884] = 187;
        sArray[885] = 699;
        sArray[886] = 443;
        sArray[887] = 955;
        sArray[888] = 123;
        sArray[889] = 635;
        sArray[890] = 379;
        sArray[891] = 891;
        sArray[892] = 251;
        sArray[893] = 763;
        sArray[894] = 507;
        sArray[895] = 1019;
        sArray[896] = 7;
        sArray[897] = 519;
        sArray[898] = 263;
        sArray[899] = 775;
        sArray[900] = 135;
        sArray[901] = 647;
        sArray[902] = 391;
        sArray[903] = 903;
        sArray[904] = 71;
        sArray[905] = 583;
        sArray[906] = 327;
        sArray[907] = 839;
        sArray[908] = 199;
        sArray[909] = 711;
        sArray[910] = 455;
        sArray[911] = 967;
        sArray[912] = 39;
        sArray[913] = 551;
        sArray[914] = 295;
        sArray[915] = 807;
        sArray[916] = 167;
        sArray[917] = 679;
        sArray[918] = 423;
        sArray[919] = 935;
        sArray[920] = 103;
        sArray[921] = 615;
        sArray[922] = 359;
        sArray[923] = 871;
        sArray[924] = 231;
        sArray[925] = 743;
        sArray[926] = 487;
        sArray[927] = 999;
        sArray[928] = 23;
        sArray[929] = 535;
        sArray[930] = 279;
        sArray[931] = 791;
        sArray[932] = 151;
        sArray[933] = 663;
        sArray[934] = 407;
        sArray[935] = 919;
        sArray[936] = 87;
        sArray[937] = 599;
        sArray[938] = 343;
        sArray[939] = 855;
        sArray[940] = 215;
        sArray[941] = 727;
        sArray[942] = 471;
        sArray[943] = 983;
        sArray[944] = 55;
        sArray[945] = 567;
        sArray[946] = 311;
        sArray[947] = 823;
        sArray[948] = 183;
        sArray[949] = 695;
        sArray[950] = 439;
        sArray[951] = 951;
        sArray[952] = 119;
        sArray[953] = 631;
        sArray[954] = 375;
        sArray[955] = 887;
        sArray[956] = 247;
        sArray[957] = 759;
        sArray[958] = 503;
        sArray[959] = 1015;
        sArray[960] = 15;
        sArray[961] = 527;
        sArray[962] = 271;
        sArray[963] = 783;
        sArray[964] = 143;
        sArray[965] = 655;
        sArray[966] = 399;
        sArray[967] = 911;
        sArray[968] = 79;
        sArray[969] = 591;
        sArray[970] = 335;
        sArray[971] = 847;
        sArray[972] = 207;
        sArray[973] = 719;
        sArray[974] = 463;
        sArray[975] = 975;
        sArray[976] = 47;
        sArray[977] = 559;
        sArray[978] = 303;
        sArray[979] = 815;
        sArray[980] = 175;
        sArray[981] = 687;
        sArray[982] = 431;
        sArray[983] = 943;
        sArray[984] = 111;
        sArray[985] = 623;
        sArray[986] = 367;
        sArray[987] = 879;
        sArray[988] = 239;
        sArray[989] = 751;
        sArray[990] = 495;
        sArray[991] = 1007;
        sArray[992] = 31;
        sArray[993] = 543;
        sArray[994] = 287;
        sArray[995] = 799;
        sArray[996] = 159;
        sArray[997] = 671;
        sArray[998] = 415;
        sArray[999] = 927;
        sArray[1000] = 95;
        sArray[1001] = 607;
        sArray[1002] = 351;
        sArray[1003] = 863;
        sArray[1004] = 223;
        sArray[1005] = 735;
        sArray[1006] = 479;
        sArray[1007] = 991;
        sArray[1008] = 63;
        sArray[1009] = 575;
        sArray[1010] = 319;
        sArray[1011] = 831;
        sArray[1012] = 191;
        sArray[1013] = 703;
        sArray[1014] = 447;
        sArray[1015] = 959;
        sArray[1016] = 127;
        sArray[1017] = 639;
        sArray[1018] = 383;
        sArray[1019] = 895;
        sArray[1020] = 255;
        sArray[1021] = 767;
        sArray[1022] = 511;
        sArray[1023] = 1023;
        this.REV10 = sArray;
        long[] lArray = new long[27];
        lArray[0] = 1283868770400643928L;
        lArray[1] = 6416574995475331444L;
        lArray[2] = 4078260278032692663L;
        lArray[3] = 2353523259288686585L;
        lArray[4] = 1227179971273316331L;
        lArray[5] = 575931623374121527L;
        lArray[6] = 242543240509105209L;
        lArray[7] = 91437049221049666L;
        lArray[8] = 30799446349977173L;
        lArray[9] = 9255276791179340L;
        lArray[10] = 2478152334826140L;
        lArray[11] = 590642893610164L;
        lArray[12] = 125206034929641L;
        lArray[13] = 23590435911403L;
        lArray[14] = 3948334035941L;
        lArray[15] = 586753615614L;
        lArray[16] = 77391054539L;
        lArray[17] = 9056793210L;
        lArray[18] = 940121950L;
        lArray[19] = 86539696L;
        lArray[20] = 7062824L;
        lArray[21] = 510971L;
        lArray[22] = 32764L;
        lArray[23] = 1862L;
        lArray[24] = 94L;
        lArray[25] = 4L;
        this.gauss_1024_12289 = lArray;
        this.MAX_BL_SMALL = new int[]{1, 1, 2, 2, 4, 7, 14, 27, 53, 106, 209};
        this.MAX_BL_LARGE = new int[]{2, 2, 5, 7, 12, 21, 40, 78, 157, 308};
        this.bitlength_avg = new int[]{4, 11, 24, 50, 102, 202, 401, 794, 1577, 3138, 6308};
        int[] nArray = new int[11];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 2;
        nArray[6] = 4;
        nArray[7] = 5;
        nArray[8] = 8;
        nArray[9] = 13;
        nArray[10] = 25;
        this.bitlength_std = nArray;
        this.DEPTH_INT_FG = 4;
        this.fpr = new FPREngine();
        this.primes = new FalconSmallPrimeList();
        this.fft = new FalconFFT();
        this.codec = new FalconCodec();
        this.vrfy = new FalconVrfy();
    }

    long get_rng_u64(SHAKE256 sHAKE256) {
        byte[] byArray = new byte[8];
        sHAKE256.inner_shake256_extract(byArray, 0, byArray.length);
        return (long)byArray[0] & 0xFFL | ((long)byArray[1] & 0xFFL) << 8 | ((long)byArray[2] & 0xFFL) << 16 | ((long)byArray[3] & 0xFFL) << 24 | ((long)byArray[4] & 0xFFL) << 32 | ((long)byArray[5] & 0xFFL) << 40 | ((long)byArray[6] & 0xFFL) << 48 | ((long)byArray[7] & 0xFFL) << 56;
    }

    void keygen(SHAKE256 sHAKE256, byte[] byArray, int n, byte[] byArray2, int n2, byte[] byArray3, int n3, byte[] byArray4, int n4, short[] sArray, int n5, int n6) {
        int n7 = FalconKeyGen.mkn(n6);
        SHAKE256 sHAKE2562 = sHAKE256;
        while (true) {
            int[] nArray;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            FalconFPR[] falconFPRArray = new FalconFPR[3 * n7];
            this.poly_small_mkgauss(sHAKE2562, byArray, n, n6);
            this.poly_small_mkgauss(sHAKE2562, byArray2, n2, n6);
            int n13 = 1 << this.codec.max_fg_bits[n6] - 1;
            int n14 = 0;
            while (n14 < n7) {
                if (byArray[n + n14] >= n13 || byArray[n + n14] <= -n13 || byArray2[n2 + n14] >= n13 || byArray2[n2 + n14] <= -n13) {
                    n13 = -1;
                    break;
                }
                ++n14;
            }
            if (n13 < 0 || ((long)(n12 = (n11 = this.poly_small_sqnorm(byArray, n, n6)) + (n10 = this.poly_small_sqnorm(byArray2, n2, n6)) | -((n11 | n10) >>> 31)) & 0xFFFFFFFFL) >= 16823L) continue;
            int n15 = 0;
            int n16 = n15 + n7;
            int n17 = n16 + n7;
            this.poly_small_to_fp(falconFPRArray, n15, byArray, n, n6);
            this.poly_small_to_fp(falconFPRArray, n16, byArray2, n2, n6);
            this.fft.FFT(falconFPRArray, n15, n6);
            this.fft.FFT(falconFPRArray, n16, n6);
            this.fft.poly_invnorm2_fft(falconFPRArray, n17, falconFPRArray, n15, falconFPRArray, n16, n6);
            this.fft.poly_adj_fft(falconFPRArray, n15, n6);
            this.fft.poly_adj_fft(falconFPRArray, n16, n6);
            this.fft.poly_mulconst(falconFPRArray, n15, this.fpr.fpr_q, n6);
            this.fft.poly_mulconst(falconFPRArray, n16, this.fpr.fpr_q, n6);
            this.fft.poly_mul_autoadj_fft(falconFPRArray, n15, falconFPRArray, n17, n6);
            this.fft.poly_mul_autoadj_fft(falconFPRArray, n16, falconFPRArray, n17, n6);
            this.fft.iFFT(falconFPRArray, n15, n6);
            this.fft.iFFT(falconFPRArray, n16, n6);
            FalconFPR falconFPR = this.fpr.fpr_zero;
            n14 = 0;
            while (n14 < n7) {
                falconFPR = this.fpr.fpr_add(falconFPR, this.fpr.fpr_sqr(falconFPRArray[n15 + n14]));
                falconFPR = this.fpr.fpr_add(falconFPR, this.fpr.fpr_sqr(falconFPRArray[n16 + n14]));
                ++n14;
            }
            if (!this.fpr.fpr_lt(falconFPR, this.fpr.fpr_bnorm_max)) continue;
            short[] sArray2 = new short[2 * n7];
            if (sArray == null) {
                n9 = 0;
                sArray = sArray2;
                n8 = n9 + n7;
            } else {
                n9 = n5;
                n8 = 0;
            }
            if (this.vrfy.compute_public(sArray, n9, byArray, n, byArray2, n2, n6, sArray2, n8) != 0 && this.solve_NTRU(n6, byArray3, n3, byArray4, n4, byArray, n, byArray2, n2, n13 = (1 << this.codec.max_FG_bits[n6] - 1) - 1, nArray = n6 > 2 ? new int[28 * n7] : new int[28 * n7 * 3], 0) != 0) break;
        }
    }

    void make_fg(int[] nArray, int n, byte[] byArray, int n2, byte[] byArray2, int n3, int n4, int n5, int n6) {
        int n7 = FalconKeyGen.mkn(n4);
        int n8 = n;
        int n9 = n8 + n7;
        FalconSmallPrime[] falconSmallPrimeArray = FalconSmallPrimeList.PRIMES;
        int n10 = falconSmallPrimeArray[0].p;
        int n11 = 0;
        while (n11 < n7) {
            nArray[n8 + n11] = this.modp_set(byArray[n2 + n11], n10);
            nArray[n9 + n11] = this.modp_set(byArray2[n3 + n11], n10);
            ++n11;
        }
        if (n5 == 0 && n6 != 0) {
            int n12 = falconSmallPrimeArray[0].p;
            int n13 = this.modp_ninv31(n12);
            int n14 = n9 + n7;
            int n15 = n14 + n7;
            this.modp_mkgm2(nArray, n14, nArray, n15, n4, falconSmallPrimeArray[0].g, n12, n13);
            this.modp_NTT2(nArray, n8, nArray, n14, n4, n12, n13);
            this.modp_NTT2(nArray, n9, nArray, n14, n4, n12, n13);
            return;
        }
        int n16 = 0;
        while (n16 < n5) {
            this.make_fg_step(nArray, n, n4 - n16, n16, n16 != 0 ? 1 : 0, n16 + 1 < n5 || n6 != 0 ? 1 : 0);
            ++n16;
        }
    }

    void make_fg_step(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13 = 1 << n2;
        int n14 = n13 >> 1;
        int n15 = this.MAX_BL_SMALL[n3];
        int n16 = this.MAX_BL_SMALL[n3 + 1];
        FalconSmallPrime[] falconSmallPrimeArray = FalconSmallPrimeList.PRIMES;
        int n17 = n;
        int n18 = n17 + n14 * n16;
        int n19 = n18 + n14 * n16;
        int n20 = n19 + n13 * n15;
        int n21 = n20 + n13 * n15;
        int n22 = n21 + n13;
        int n23 = n22 + n13;
        System.arraycopy(nArray, n, nArray, n19, 2 * n13 * n15);
        int n24 = 0;
        while (n24 < n15) {
            n12 = falconSmallPrimeArray[n24].p;
            n11 = this.modp_ninv31(n12);
            n10 = this.modp_R2(n12, n11);
            this.modp_mkgm2(nArray, n21, nArray, n22, n2, falconSmallPrimeArray[n24].g, n12, n11);
            n9 = 0;
            n8 = n19 + n24;
            while (n9 < n13) {
                nArray[n23 + n9] = nArray[n8];
                ++n9;
                n8 += n15;
            }
            if (n4 == 0) {
                this.modp_NTT2(nArray, n23, nArray, n21, n2, n12, n11);
            }
            n9 = 0;
            n8 = n17 + n24;
            while (n9 < n14) {
                n7 = nArray[n23 + (n9 << 1)];
                n6 = nArray[n23 + (n9 << 1) + 1];
                nArray[n8] = this.modp_montymul(this.modp_montymul(n7, n6, n12, n11), n10, n12, n11);
                ++n9;
                n8 += n16;
            }
            if (n4 != 0) {
                this.modp_iNTT2_ext(nArray, n19 + n24, n15, nArray, n22, n2, n12, n11);
            }
            n9 = 0;
            n8 = n20 + n24;
            while (n9 < n13) {
                nArray[n23 + n9] = nArray[n8];
                ++n9;
                n8 += n15;
            }
            if (n4 == 0) {
                this.modp_NTT2(nArray, n23, nArray, n21, n2, n12, n11);
            }
            n9 = 0;
            n8 = n18 + n24;
            while (n9 < n14) {
                n7 = nArray[n23 + (n9 << 1)];
                n6 = nArray[n23 + (n9 << 1) + 1];
                nArray[n8] = this.modp_montymul(this.modp_montymul(n7, n6, n12, n11), n10, n12, n11);
                ++n9;
                n8 += n16;
            }
            if (n4 != 0) {
                this.modp_iNTT2_ext(nArray, n20 + n24, n15, nArray, n22, n2, n12, n11);
            }
            if (n5 == 0) {
                this.modp_iNTT2_ext(nArray, n17 + n24, n16, nArray, n22, n2 - 1, n12, n11);
                this.modp_iNTT2_ext(nArray, n18 + n24, n16, nArray, n22, n2 - 1, n12, n11);
            }
            ++n24;
        }
        this.zint_rebuild_CRT(nArray, n19, n15, n15, n13, falconSmallPrimeArray, 1, nArray, n21);
        this.zint_rebuild_CRT(nArray, n20, n15, n15, n13, falconSmallPrimeArray, 1, nArray, n21);
        n24 = n15;
        while (n24 < n16) {
            int n25;
            n12 = falconSmallPrimeArray[n24].p;
            n11 = this.modp_ninv31(n12);
            n10 = this.modp_R2(n12, n11);
            n9 = this.modp_Rx(n15, n12, n11, n10);
            this.modp_mkgm2(nArray, n21, nArray, n22, n2, falconSmallPrimeArray[n24].g, n12, n11);
            n8 = 0;
            n7 = n19;
            while (n8 < n13) {
                nArray[n23 + n8] = this.zint_mod_small_signed(nArray, n7, n15, n12, n11, n10, n9);
                ++n8;
                n7 += n15;
            }
            this.modp_NTT2(nArray, n23, nArray, n21, n2, n12, n11);
            n8 = 0;
            n7 = n17 + n24;
            while (n8 < n14) {
                n6 = nArray[n23 + (n8 << 1)];
                n25 = nArray[n23 + (n8 << 1) + 1];
                nArray[n7] = this.modp_montymul(this.modp_montymul(n6, n25, n12, n11), n10, n12, n11);
                ++n8;
                n7 += n16;
            }
            n8 = 0;
            n7 = n20;
            while (n8 < n13) {
                nArray[n23 + n8] = this.zint_mod_small_signed(nArray, n7, n15, n12, n11, n10, n9);
                ++n8;
                n7 += n15;
            }
            this.modp_NTT2(nArray, n23, nArray, n21, n2, n12, n11);
            n8 = 0;
            n7 = n18 + n24;
            while (n8 < n14) {
                n6 = nArray[n23 + (n8 << 1)];
                n25 = nArray[n23 + (n8 << 1) + 1];
                nArray[n7] = this.modp_montymul(this.modp_montymul(n6, n25, n12, n11), n10, n12, n11);
                ++n8;
                n7 += n16;
            }
            if (n5 == 0) {
                this.modp_iNTT2_ext(nArray, n17 + n24, n16, nArray, n22, n2 - 1, n12, n11);
                this.modp_iNTT2_ext(nArray, n18 + n24, n16, nArray, n22, n2 - 1, n12, n11);
            }
            ++n24;
        }
    }

    int mkgauss(SHAKE256 sHAKE256, int n) {
        int n2 = 1 << 10 - n;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            long l = this.get_rng_u64(sHAKE256);
            int n5 = (int)(l >>> 63);
            int n6 = (int)((l &= Long.MAX_VALUE) - this.gauss_1024_12289[0] >>> 63);
            int n7 = 0;
            l = this.get_rng_u64(sHAKE256);
            l &= Long.MAX_VALUE;
            int n8 = 1;
            while (n8 < this.gauss_1024_12289.length) {
                int n9 = (int)(l - this.gauss_1024_12289[n8] >>> 63) ^ 1;
                n7 |= n8 & -(n9 & (n6 ^ 1));
                n6 |= n9;
                ++n8;
            }
            n7 = (n7 ^ -n5) + n5;
            n3 += n7;
            ++n4;
        }
        return n3;
    }

    private static int mkn(int n) {
        return 1 << n;
    }

    void modp_NTT2(int[] nArray, int n, int[] nArray2, int n2, int n3, int n4, int n5) {
        this.modp_NTT2_ext(nArray, n, 1, nArray2, n2, n3, n4, n5);
    }

    void modp_NTT2_ext(int[] nArray, int n, int n2, int[] nArray2, int n3, int n4, int n5, int n6) {
        int n7;
        if (n4 == 0) {
            return;
        }
        int n8 = n7 = FalconKeyGen.mkn(n4);
        int n9 = 1;
        while (n9 < n7) {
            int n10 = n8 >> 1;
            int n11 = 0;
            int n12 = 0;
            while (n11 < n9) {
                int n13 = nArray2[n3 + n9 + n11];
                int n14 = n + n12 * n2;
                int n15 = n14 + n10 * n2;
                int n16 = 0;
                while (n16 < n10) {
                    int n17 = nArray[n14];
                    int n18 = this.modp_montymul(nArray[n15], n13, n5, n6);
                    nArray[n14] = this.modp_add(n17, n18, n5);
                    nArray[n15] = this.modp_sub(n17, n18, n5);
                    ++n16;
                    n14 += n2;
                    n15 += n2;
                }
                ++n11;
                n12 += n8;
            }
            n8 = n10;
            n9 <<= 1;
        }
    }

    int modp_R(int n) {
        return Integer.MIN_VALUE - n;
    }

    int modp_R2(int n, int n2) {
        int n3 = this.modp_R(n);
        n3 = this.modp_add(n3, n3, n);
        n3 = this.modp_montymul(n3, n3, n, n2);
        n3 = this.modp_montymul(n3, n3, n, n2);
        n3 = this.modp_montymul(n3, n3, n, n2);
        n3 = this.modp_montymul(n3, n3, n, n2);
        n3 = this.modp_montymul(n3, n3, n, n2);
        n3 = n3 + (n & -(n3 & 1)) >>> 1;
        return n3;
    }

    int modp_Rx(int n, int n2, int n3, int n4) {
        --n;
        int n5 = n4;
        int n6 = this.modp_R(n2);
        int n7 = 0;
        while (1 << n7 <= n) {
            if ((n & 1 << n7) != 0) {
                n6 = this.modp_montymul(n6, n5, n2, n3);
            }
            n5 = this.modp_montymul(n5, n5, n2, n3);
            ++n7;
        }
        return n6;
    }

    int modp_add(int n, int n2, int n3) {
        int n4 = n + n2 - n3;
        n4 += n3 & -(n4 >>> 31);
        return n4;
    }

    int modp_div(int n, int n2, int n3, int n4, int n5) {
        int n6 = n3 - 2;
        int n7 = n5;
        int n8 = 30;
        while (n8 >= 0) {
            n7 = this.modp_montymul(n7, n7, n3, n4);
            int n9 = this.modp_montymul(n7, n2, n3, n4);
            n7 ^= (n7 ^ n9) & -(n6 >>> n8 & 1);
            --n8;
        }
        n7 = this.modp_montymul(n7, 1, n3, n4);
        return this.modp_montymul(n, n7, n3, n4);
    }

    void modp_iNTT2(int[] nArray, int n, int[] nArray2, int n2, int n3, int n4, int n5) {
        this.modp_iNTT2_ext(nArray, n, 1, nArray2, n2, n3, n4, n5);
    }

    void modp_iNTT2_ext(int[] nArray, int n, int n2, int[] nArray2, int n3, int n4, int n5, int n6) {
        if (n4 == 0) {
            return;
        }
        int n7 = FalconKeyGen.mkn(n4);
        int n8 = 1;
        int n9 = n7;
        while (n9 > 1) {
            int n10 = n9 >> 1;
            int n11 = n8 << 1;
            int n12 = 0;
            int n13 = 0;
            while (n12 < n10) {
                int n14 = nArray2[n3 + n10 + n12];
                int n15 = n + n13 * n2;
                int n16 = n15 + n8 * n2;
                int n17 = 0;
                while (n17 < n8) {
                    int n18 = nArray[n15];
                    int n19 = nArray[n16];
                    nArray[n15] = this.modp_add(n18, n19, n5);
                    nArray[n16] = this.modp_montymul(this.modp_sub(n18, n19, n5), n14, n5, n6);
                    ++n17;
                    n15 += n2;
                    n16 += n2;
                }
                ++n12;
                n13 += n11;
            }
            n8 = n11;
            n9 >>= 1;
        }
        int n20 = 1 << 31 - n4;
        int n21 = 0;
        int n22 = n;
        while (n21 < n7) {
            nArray[n22] = this.modp_montymul(nArray[n22], n20, n5, n6);
            ++n21;
            n22 += n2;
        }
    }

    void modp_mkgm2(int[] nArray, int n, int[] nArray2, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8 = FalconKeyGen.mkn(n3);
        int n9 = this.modp_R2(n5, n6);
        n4 = this.modp_montymul(n4, n9, n5, n6);
        int n10 = n3;
        while (n10 < 10) {
            n4 = this.modp_montymul(n4, n4, n5, n6);
            ++n10;
        }
        int n11 = this.modp_div(n9, n4, n5, n6, this.modp_R(n5));
        n10 = 10 - n3;
        int n12 = n7 = this.modp_R(n5);
        int n13 = 0;
        while (n13 < n8) {
            short s = this.REV10[n13 << n10];
            nArray[n + s] = n12;
            nArray2[n2 + s] = n7;
            n12 = this.modp_montymul(n12, n4, n5, n6);
            n7 = this.modp_montymul(n7, n11, n5, n6);
            ++n13;
        }
    }

    int modp_montymul(int n, int n2, int n3, int n4) {
        long l = this.toUnsignedLong(n) * this.toUnsignedLong(n2);
        long l2 = (l * (long)n4 & this.toUnsignedLong(Integer.MAX_VALUE)) * (long)n3;
        int n5 = (int)(l + l2 >>> 31) - n3;
        n5 += n3 & -(n5 >>> 31);
        return n5;
    }

    int modp_ninv31(int n) {
        int n2 = 2 - n;
        n2 *= 2 - n * n2;
        n2 *= 2 - n * n2;
        n2 *= 2 - n * n2;
        n2 *= 2 - n * n2;
        return Integer.MAX_VALUE & -n2;
    }

    int modp_norm(int n, int n2) {
        return n - (n2 & (n - (n2 + 1 >>> 1) >>> 31) - 1);
    }

    void modp_poly_rec_res(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = 1 << n2 - 1;
        int n7 = 0;
        while (n7 < n6) {
            int n8 = nArray[n + (n7 << 1)];
            int n9 = nArray[n + (n7 << 1) + 1];
            nArray[n + n7] = this.modp_montymul(this.modp_montymul(n8, n9, n3, n4), n5, n3, n4);
            ++n7;
        }
    }

    int modp_set(int n, int n2) {
        int n3 = n;
        n3 += n2 & -(n3 >>> 31);
        return n3;
    }

    int modp_sub(int n, int n2, int n3) {
        int n4 = n - n2;
        n4 += n3 & -(n4 >>> 31);
        return n4;
    }

    void poly_big_to_fp(FalconFPR[] falconFPRArray, int n, int[] nArray, int n2, int n3, int n4, int n5) {
        int n6 = FalconKeyGen.mkn(n5);
        if (n3 == 0) {
            int n7 = 0;
            while (n7 < n6) {
                falconFPRArray[n + n7] = this.fpr.fpr_zero;
                ++n7;
            }
            return;
        }
        int n8 = 0;
        while (n8 < n6) {
            int n9 = -(nArray[n2 + n3 - 1] >>> 30);
            int n10 = n9 >>> 1;
            int n11 = n9 & 1;
            FalconFPR falconFPR = this.fpr.fpr_zero;
            FalconFPR falconFPR2 = this.fpr.fpr_one;
            int n12 = 0;
            while (n12 < n3) {
                int n13 = (nArray[n2 + n12] ^ n10) + n11;
                n11 = n13 >>> 31;
                n13 &= Integer.MAX_VALUE;
                n13 -= n13 << 1 & n9;
                falconFPR = this.fpr.fpr_add(falconFPR, this.fpr.fpr_mul(this.fpr.fpr_of(n13), falconFPR2));
                ++n12;
                falconFPR2 = this.fpr.fpr_mul(falconFPR2, this.fpr.fpr_ptwo31);
            }
            falconFPRArray[n + n8] = falconFPR;
            ++n8;
            n2 += n4;
        }
    }

    int poly_big_to_small(byte[] byArray, int n, int[] nArray, int n2, int n3, int n4) {
        int n5 = FalconKeyGen.mkn(n4);
        int n6 = 0;
        while (n6 < n5) {
            int n7 = this.zint_one_to_plain(nArray, n2 + n6);
            if (n7 < -n3 || n7 > n3) {
                return 0;
            }
            byArray[n + n6] = (byte)n7;
            ++n6;
        }
        return 1;
    }

    void poly_small_mkgauss(SHAKE256 sHAKE256, byte[] byArray, int n, int n2) {
        int n3 = FalconKeyGen.mkn(n2);
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            int n6;
            block4: {
                while (true) {
                    if ((n6 = this.mkgauss(sHAKE256, n2)) < -127 || n6 > 127) {
                        continue;
                    }
                    if (n5 != n3 - 1) break;
                    if ((n4 ^ n6 & 1) == 0) {
                        continue;
                    }
                    break block4;
                    break;
                }
                n4 ^= n6 & 1;
            }
            byArray[n + n5] = (byte)n6;
            ++n5;
        }
    }

    int poly_small_sqnorm(byte[] byArray, int n, int n2) {
        int n3 = FalconKeyGen.mkn(n2);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            byte by = byArray[n + n6];
            n5 |= (n4 += by * by);
            ++n6;
        }
        return n4 | -(n5 >>> 31);
    }

    void poly_small_to_fp(FalconFPR[] falconFPRArray, int n, byte[] byArray, int n2, int n3) {
        int n4 = FalconKeyGen.mkn(n3);
        int n5 = 0;
        while (n5 < n4) {
            falconFPRArray[n + n5] = this.fpr.fpr_of(byArray[n2 + n5]);
            ++n5;
        }
    }

    void poly_sub_scaled(int[] nArray, int n, int n2, int n3, int[] nArray2, int n4, int n5, int n6, int[] nArray3, int n7, int n8, int n9, int n10) {
        int n11 = FalconKeyGen.mkn(n10);
        int n12 = 0;
        while (n12 < n11) {
            int n13 = -nArray3[n7 + n12];
            int n14 = n + n12 * n3;
            int n15 = n4;
            int n16 = 0;
            while (n16 < n11) {
                this.zint_add_scaled_mul_small(nArray, n14, n2, nArray2, n15, n5, n13, n8, n9);
                if (n12 + n16 == n11 - 1) {
                    n14 = n;
                    n13 = -n13;
                } else {
                    n14 += n3;
                }
                n15 += n6;
                ++n16;
            }
            ++n12;
        }
    }

    void poly_sub_scaled_ntt(int[] nArray, int n, int n2, int n3, int[] nArray2, int n4, int n5, int n6, int[] nArray3, int n7, int n8, int n9, int n10, int[] nArray4, int n11) {
        int n12;
        int n13;
        int n14 = FalconKeyGen.mkn(n10);
        int n15 = n5 + 1;
        int n16 = n11;
        int n17 = n16 + FalconKeyGen.mkn(n10);
        int n18 = n17 + FalconKeyGen.mkn(n10);
        int n19 = n18 + n14 * n15;
        FalconSmallPrime[] falconSmallPrimeArray = FalconSmallPrimeList.PRIMES;
        int n20 = 0;
        while (n20 < n15) {
            int n21 = falconSmallPrimeArray[n20].p;
            int n22 = this.modp_ninv31(n21);
            int n23 = this.modp_R2(n21, n22);
            int n24 = this.modp_Rx(n5, n21, n22, n23);
            this.modp_mkgm2(nArray4, n16, nArray4, n17, n10, falconSmallPrimeArray[n20].g, n21, n22);
            int n25 = 0;
            while (n25 < n14) {
                nArray4[n19 + n25] = this.modp_set(nArray3[n7 + n25], n21);
                ++n25;
            }
            this.modp_NTT2(nArray4, n19, nArray4, n16, n10, n21, n22);
            n25 = 0;
            n13 = n4;
            n12 = n18 + n20;
            while (n25 < n14) {
                nArray4[n12] = this.zint_mod_small_signed(nArray2, n13, n5, n21, n22, n23, n24);
                ++n25;
                n13 += n6;
                n12 += n15;
            }
            this.modp_NTT2_ext(nArray4, n18 + n20, n15, nArray4, n16, n10, n21, n22);
            n25 = 0;
            n12 = n18 + n20;
            while (n25 < n14) {
                nArray4[n12] = this.modp_montymul(this.modp_montymul(nArray4[n19 + n25], nArray4[n12], n21, n22), n23, n21, n22);
                ++n25;
                n12 += n15;
            }
            this.modp_iNTT2_ext(nArray4, n18 + n20, n15, nArray4, n17, n10, n21, n22);
            ++n20;
        }
        this.zint_rebuild_CRT(nArray4, n18, n15, n15, n14, falconSmallPrimeArray, 1, nArray4, n19);
        n20 = 0;
        n12 = n;
        n13 = n18;
        while (n20 < n14) {
            this.zint_sub_scaled(nArray, n12, n2, nArray4, n13, n15, n8, n9);
            ++n20;
            n12 += n3;
            n13 += n15;
        }
    }

    int solve_NTRU(int n, byte[] byArray, int n2, byte[] byArray2, int n3, byte[] byArray3, int n4, byte[] byArray4, int n5, int n6, int[] nArray, int n7) {
        int n8;
        int n9 = FalconKeyGen.mkn(n);
        if (this.solve_NTRU_deepest(n, byArray3, n4, byArray4, n5, nArray, n7) == 0) {
            return 0;
        }
        if (n <= 2) {
            n8 = n;
            while (n8-- > 0) {
                if (this.solve_NTRU_intermediate(n, byArray3, n4, byArray4, n5, n8, nArray, n7) != 0) continue;
                return 0;
            }
        } else {
            n8 = n;
            while (n8-- > 2) {
                if (this.solve_NTRU_intermediate(n, byArray3, n4, byArray4, n5, n8, nArray, n7) != 0) continue;
                return 0;
            }
            if (this.solve_NTRU_binary_depth1(n, byArray3, n4, byArray4, n5, nArray, n7) == 0) {
                return 0;
            }
            if (this.solve_NTRU_binary_depth0(n, byArray3, n4, byArray4, n5, nArray, n7) == 0) {
                return 0;
            }
        }
        if (byArray2 == null) {
            n3 = 0;
            byArray2 = new byte[n9];
        }
        if (this.poly_big_to_small(byArray, n2, nArray, n7, n6, n) == 0 || this.poly_big_to_small(byArray2, n3, nArray, n7 + n9, n6, n) == 0) {
            return 0;
        }
        int n10 = n7;
        int n11 = n10 + n9;
        int n12 = n11 + n9;
        int n13 = n12 + n9;
        int n14 = n13 + n9;
        FalconSmallPrime[] falconSmallPrimeArray = FalconSmallPrimeList.PRIMES;
        int n15 = falconSmallPrimeArray[0].p;
        int n16 = this.modp_ninv31(n15);
        this.modp_mkgm2(nArray, n14, nArray, n7, n, falconSmallPrimeArray[0].g, n15, n16);
        int n17 = 0;
        while (n17 < n9) {
            nArray[n10 + n17] = this.modp_set(byArray2[n3 + n17], n15);
            ++n17;
        }
        n17 = 0;
        while (n17 < n9) {
            nArray[n11 + n17] = this.modp_set(byArray3[n4 + n17], n15);
            nArray[n12 + n17] = this.modp_set(byArray4[n5 + n17], n15);
            nArray[n13 + n17] = this.modp_set(byArray[n2 + n17], n15);
            ++n17;
        }
        this.modp_NTT2(nArray, n11, nArray, n14, n, n15, n16);
        this.modp_NTT2(nArray, n12, nArray, n14, n, n15, n16);
        this.modp_NTT2(nArray, n13, nArray, n14, n, n15, n16);
        this.modp_NTT2(nArray, n10, nArray, n14, n, n15, n16);
        int n18 = this.modp_montymul(12289, 1, n15, n16);
        n17 = 0;
        while (n17 < n9) {
            n8 = this.modp_sub(this.modp_montymul(nArray[n11 + n17], nArray[n10 + n17], n15, n16), this.modp_montymul(nArray[n12 + n17], nArray[n13 + n17], n15, n16), n15);
            if (n8 != n18) {
                return 0;
            }
            ++n17;
        }
        return 1;
    }

    int solve_NTRU_binary_depth0(int n, byte[] byArray, int n2, byte[] byArray2, int n3, int[] nArray, int n4) {
        int n5;
        int n6;
        int n7 = 1 << n;
        int n8 = n7 >> 1;
        int n9 = FalconSmallPrimeList.PRIMES[0].p;
        int n10 = this.modp_ninv31(n9);
        int n11 = this.modp_R2(n9, n10);
        int n12 = n4;
        int n13 = n12 + n8;
        int n14 = n13 + n8;
        int n15 = n14 + n7;
        int n16 = n15 + n7;
        int n17 = n16 + n7;
        this.modp_mkgm2(nArray, n16, nArray, n17, n, FalconSmallPrimeList.PRIMES[0].g, n9, n10);
        int n18 = 0;
        while (n18 < n8) {
            nArray[n12 + n18] = this.modp_set(this.zint_one_to_plain(nArray, n12 + n18), n9);
            nArray[n13 + n18] = this.modp_set(this.zint_one_to_plain(nArray, n13 + n18), n9);
            ++n18;
        }
        this.modp_NTT2(nArray, n12, nArray, n16, n - 1, n9, n10);
        this.modp_NTT2(nArray, n13, nArray, n16, n - 1, n9, n10);
        n18 = 0;
        while (n18 < n7) {
            nArray[n14 + n18] = this.modp_set(byArray[n2 + n18], n9);
            nArray[n15 + n18] = this.modp_set(byArray2[n3 + n18], n9);
            ++n18;
        }
        this.modp_NTT2(nArray, n14, nArray, n16, n, n9, n10);
        this.modp_NTT2(nArray, n15, nArray, n16, n, n9, n10);
        n18 = 0;
        while (n18 < n7) {
            n6 = nArray[n14 + n18];
            n5 = nArray[n14 + n18 + 1];
            int n19 = nArray[n15 + n18];
            int n20 = nArray[n15 + n18 + 1];
            int n21 = this.modp_montymul(nArray[n12 + (n18 >> 1)], n11, n9, n10);
            int n22 = this.modp_montymul(nArray[n13 + (n18 >> 1)], n11, n9, n10);
            nArray[n14 + n18] = this.modp_montymul(n20, n21, n9, n10);
            nArray[n14 + n18 + 1] = this.modp_montymul(n19, n21, n9, n10);
            nArray[n15 + n18] = this.modp_montymul(n5, n22, n9, n10);
            nArray[n15 + n18 + 1] = this.modp_montymul(n6, n22, n9, n10);
            n18 += 2;
        }
        this.modp_iNTT2(nArray, n14, nArray, n17, n, n9, n10);
        this.modp_iNTT2(nArray, n15, nArray, n17, n, n9, n10);
        n13 = n12 + n7;
        int n23 = n13 + n7;
        System.arraycopy(nArray, n14, nArray, n12, 2 * n7);
        int n24 = n23 + n7;
        int n25 = n24 + n7;
        int n26 = n25 + n7;
        int n27 = n26 + n7;
        this.modp_mkgm2(nArray, n23, nArray, n24, n, FalconSmallPrimeList.PRIMES[0].g, n9, n10);
        this.modp_NTT2(nArray, n12, nArray, n23, n, n9, n10);
        this.modp_NTT2(nArray, n13, nArray, n23, n, n9, n10);
        nArray[n26] = nArray[n27] = this.modp_set(byArray[n2], n9);
        n18 = 1;
        while (n18 < n7) {
            nArray[n26 + n18] = this.modp_set(byArray[n2 + n18], n9);
            nArray[n27 + n7 - n18] = this.modp_set(-byArray[n2 + n18], n9);
            ++n18;
        }
        this.modp_NTT2(nArray, n26, nArray, n23, n, n9, n10);
        this.modp_NTT2(nArray, n27, nArray, n23, n, n9, n10);
        n18 = 0;
        while (n18 < n7) {
            n6 = this.modp_montymul(nArray[n27 + n18], n11, n9, n10);
            nArray[n24 + n18] = this.modp_montymul(n6, nArray[n12 + n18], n9, n10);
            nArray[n25 + n18] = this.modp_montymul(n6, nArray[n26 + n18], n9, n10);
            ++n18;
        }
        nArray[n26] = nArray[n27] = this.modp_set(byArray2[n3], n9);
        n18 = 1;
        while (n18 < n7) {
            nArray[n26 + n18] = this.modp_set(byArray2[n3 + n18], n9);
            nArray[n27 + n7 - n18] = this.modp_set(-byArray2[n3 + n18], n9);
            ++n18;
        }
        this.modp_NTT2(nArray, n26, nArray, n23, n, n9, n10);
        this.modp_NTT2(nArray, n27, nArray, n23, n, n9, n10);
        n18 = 0;
        while (n18 < n7) {
            n6 = this.modp_montymul(nArray[n27 + n18], n11, n9, n10);
            nArray[n24 + n18] = this.modp_add(nArray[n24 + n18], this.modp_montymul(n6, nArray[n13 + n18], n9, n10), n9);
            nArray[n25 + n18] = this.modp_add(nArray[n25 + n18], this.modp_montymul(n6, nArray[n26 + n18], n9, n10), n9);
            ++n18;
        }
        this.modp_mkgm2(nArray, n23, nArray, n26, n, FalconSmallPrimeList.PRIMES[0].g, n9, n10);
        this.modp_iNTT2(nArray, n24, nArray, n26, n, n9, n10);
        this.modp_iNTT2(nArray, n25, nArray, n26, n, n9, n10);
        n18 = 0;
        while (n18 < n7) {
            nArray[n23 + n18] = this.modp_norm(nArray[n24 + n18], n9);
            nArray[n24 + n18] = this.modp_norm(nArray[n25 + n18], n9);
            ++n18;
        }
        FalconFPR[] falconFPRArray = new FalconFPR[3 * n7];
        int n28 = 0;
        int n29 = n28 + n7;
        int n30 = n29 + n7;
        n18 = 0;
        while (n18 < n7) {
            falconFPRArray[n30 + n18] = this.fpr.fpr_of(nArray[n24 + n18]);
            ++n18;
        }
        this.fft.FFT(falconFPRArray, n30, n);
        System.arraycopy(falconFPRArray, n30, falconFPRArray, n29, n8);
        n30 = n29 + n8;
        n18 = 0;
        while (n18 < n7) {
            falconFPRArray[n30 + n18] = this.fpr.fpr_of(nArray[n23 + n18]);
            ++n18;
        }
        this.fft.FFT(falconFPRArray, n30, n);
        this.fft.poly_div_autoadj_fft(falconFPRArray, n30, falconFPRArray, n29, n);
        this.fft.iFFT(falconFPRArray, n30, n);
        n18 = 0;
        while (n18 < n7) {
            nArray[n23 + n18] = this.modp_set((int)this.fpr.fpr_rint(falconFPRArray[n30 + n18]), n9);
            ++n18;
        }
        n24 = n23 + n7;
        n25 = n24 + n7;
        n26 = n25 + n7;
        n27 = n26 + n7;
        this.modp_mkgm2(nArray, n24, nArray, n25, n, FalconSmallPrimeList.PRIMES[0].g, n9, n10);
        n18 = 0;
        while (n18 < n7) {
            nArray[n26 + n18] = this.modp_set(byArray[n2 + n18], n9);
            nArray[n27 + n18] = this.modp_set(byArray2[n3 + n18], n9);
            ++n18;
        }
        this.modp_NTT2(nArray, n23, nArray, n24, n, n9, n10);
        this.modp_NTT2(nArray, n26, nArray, n24, n, n9, n10);
        this.modp_NTT2(nArray, n27, nArray, n24, n, n9, n10);
        n18 = 0;
        while (n18 < n7) {
            n5 = this.modp_montymul(nArray[n23 + n18], n11, n9, n10);
            nArray[n12 + n18] = this.modp_sub(nArray[n12 + n18], this.modp_montymul(n5, nArray[n26 + n18], n9, n10), n9);
            nArray[n13 + n18] = this.modp_sub(nArray[n13 + n18], this.modp_montymul(n5, nArray[n27 + n18], n9, n10), n9);
            ++n18;
        }
        this.modp_iNTT2(nArray, n12, nArray, n25, n, n9, n10);
        this.modp_iNTT2(nArray, n13, nArray, n25, n, n9, n10);
        n18 = 0;
        while (n18 < n7) {
            nArray[n12 + n18] = this.modp_norm(nArray[n12 + n18], n9);
            nArray[n13 + n18] = this.modp_norm(nArray[n13 + n18], n9);
            ++n18;
        }
        return 1;
    }

    int solve_NTRU_binary_depth1(int n, byte[] byArray, int n2, byte[] byArray2, int n3, int[] nArray, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14 = 1;
        int n15 = 1 << n;
        int n16 = n - n14;
        int n17 = 1 << n16;
        int n18 = n17 >> 1;
        int n19 = this.MAX_BL_SMALL[n14];
        int n20 = this.MAX_BL_SMALL[n14 + 1];
        int n21 = this.MAX_BL_LARGE[n14];
        int n22 = n4;
        int n23 = n22 + n20 * n18;
        int n24 = n23 + n20 * n18;
        int n25 = n24 + n21 * n17;
        int n26 = 0;
        while (n26 < n21) {
            n13 = FalconSmallPrimeList.PRIMES[n26].p;
            n12 = this.modp_ninv31(n13);
            n11 = this.modp_R2(n13, n12);
            n10 = this.modp_Rx(n20, n13, n12, n11);
            n9 = 0;
            n8 = n22;
            n7 = n23;
            n6 = n24 + n26;
            n5 = n25 + n26;
            while (n9 < n18) {
                nArray[n6] = this.zint_mod_small_signed(nArray, n8, n20, n13, n12, n11, n10);
                nArray[n5] = this.zint_mod_small_signed(nArray, n7, n20, n13, n12, n11, n10);
                ++n9;
                n8 += n20;
                n7 += n20;
                n6 += n21;
                n5 += n21;
            }
            ++n26;
        }
        System.arraycopy(nArray, n24, nArray, n4, n21 * n17);
        n24 = n4;
        System.arraycopy(nArray, n25, nArray, n24 + n21 * n17, n21 * n17);
        n25 = n24 + n21 * n17;
        int n27 = n25 + n21 * n17;
        int n28 = n27 + n19 * n17;
        int n29 = n28 + n19 * n17;
        n26 = 0;
        while (n26 < n21) {
            n13 = FalconSmallPrimeList.PRIMES[n26].p;
            n12 = this.modp_ninv31(n13);
            n11 = this.modp_R2(n13, n12);
            n10 = n29;
            n9 = n10 + n15;
            n8 = n9 + n17;
            n7 = n8 + n15;
            this.modp_mkgm2(nArray, n10, nArray, n9, n, FalconSmallPrimeList.PRIMES[n26].g, n13, n12);
            int n30 = 0;
            while (n30 < n15) {
                nArray[n8 + n30] = this.modp_set(byArray[n2 + n30], n13);
                nArray[n7 + n30] = this.modp_set(byArray2[n3 + n30], n13);
                ++n30;
            }
            this.modp_NTT2(nArray, n8, nArray, n10, n, n13, n12);
            this.modp_NTT2(nArray, n7, nArray, n10, n, n13, n12);
            int n31 = n;
            while (n31 > n16) {
                this.modp_poly_rec_res(nArray, n8, n31, n13, n12, n11);
                this.modp_poly_rec_res(nArray, n7, n31, n13, n12, n11);
                --n31;
            }
            if (n14 > 0) {
                System.arraycopy(nArray, n9, nArray, n10 + n17, n17);
                n9 = n10 + n17;
                System.arraycopy(nArray, n8, nArray, n9 + n17, n17);
                n8 = n9 + n17;
                System.arraycopy(nArray, n7, nArray, n8 + n17, n17);
                n7 = n8 + n17;
            }
            n6 = n7 + n17;
            n5 = n6 + n18;
            n30 = 0;
            int n32 = n24 + n26;
            int n33 = n25 + n26;
            while (n30 < n18) {
                nArray[n6 + n30] = nArray[n32];
                nArray[n5 + n30] = nArray[n33];
                ++n30;
                n32 += n21;
                n33 += n21;
            }
            this.modp_NTT2(nArray, n6, nArray, n10, n16 - 1, n13, n12);
            this.modp_NTT2(nArray, n5, nArray, n10, n16 - 1, n13, n12);
            n30 = 0;
            n32 = n24 + n26;
            n33 = n25 + n26;
            while (n30 < n18) {
                int n34 = nArray[n8 + (n30 << 1)];
                int n35 = nArray[n8 + (n30 << 1) + 1];
                int n36 = nArray[n7 + (n30 << 1)];
                int n37 = nArray[n7 + (n30 << 1) + 1];
                int n38 = this.modp_montymul(nArray[n6 + n30], n11, n13, n12);
                int n39 = this.modp_montymul(nArray[n5 + n30], n11, n13, n12);
                nArray[n32] = this.modp_montymul(n37, n38, n13, n12);
                nArray[n32 + n21] = this.modp_montymul(n36, n38, n13, n12);
                nArray[n33] = this.modp_montymul(n35, n39, n13, n12);
                nArray[n33 + n21] = this.modp_montymul(n34, n39, n13, n12);
                ++n30;
                n32 += n21 << 1;
                n33 += n21 << 1;
            }
            this.modp_iNTT2_ext(nArray, n24 + n26, n21, nArray, n9, n16, n13, n12);
            this.modp_iNTT2_ext(nArray, n25 + n26, n21, nArray, n9, n16, n13, n12);
            if (n26 < n19) {
                this.modp_iNTT2(nArray, n8, nArray, n9, n16, n13, n12);
                this.modp_iNTT2(nArray, n7, nArray, n9, n16, n13, n12);
                n30 = 0;
                n32 = n27 + n26;
                n33 = n28 + n26;
                while (n30 < n17) {
                    nArray[n32] = nArray[n8 + n30];
                    nArray[n33] = nArray[n7 + n30];
                    ++n30;
                    n32 += n19;
                    n33 += n19;
                }
            }
            ++n26;
        }
        this.zint_rebuild_CRT(nArray, n24, n21, n21, n17 << 1, FalconSmallPrimeList.PRIMES, 1, nArray, n29);
        this.zint_rebuild_CRT(nArray, n27, n19, n19, n17 << 1, FalconSmallPrimeList.PRIMES, 1, nArray, n29);
        FalconFPR[] falconFPRArray = new FalconFPR[n17];
        FalconFPR[] falconFPRArray2 = new FalconFPR[n17];
        this.poly_big_to_fp(falconFPRArray, 0, nArray, n24, n21, n21, n16);
        this.poly_big_to_fp(falconFPRArray2, 0, nArray, n25, n21, n21, n16);
        System.arraycopy(nArray, n27, nArray, n4, 2 * n19 * n17);
        n27 = n4;
        n28 = n27 + n19 * n17;
        FalconFPR[] falconFPRArray3 = new FalconFPR[n17];
        FalconFPR[] falconFPRArray4 = new FalconFPR[n17];
        this.poly_big_to_fp(falconFPRArray3, 0, nArray, n27, n19, n19, n16);
        this.poly_big_to_fp(falconFPRArray4, 0, nArray, n28, n19, n19, n16);
        this.fft.FFT(falconFPRArray, 0, n16);
        this.fft.FFT(falconFPRArray2, 0, n16);
        this.fft.FFT(falconFPRArray3, 0, n16);
        this.fft.FFT(falconFPRArray4, 0, n16);
        FalconFPR[] falconFPRArray5 = new FalconFPR[n17];
        FalconFPR[] falconFPRArray6 = new FalconFPR[n17 >> 1];
        this.fft.poly_add_muladj_fft(falconFPRArray5, 0, falconFPRArray, 0, falconFPRArray2, 0, falconFPRArray3, 0, falconFPRArray4, 0, n16);
        this.fft.poly_invnorm2_fft(falconFPRArray6, 0, falconFPRArray3, 0, falconFPRArray4, 0, n16);
        this.fft.poly_mul_autoadj_fft(falconFPRArray5, 0, falconFPRArray6, 0, n16);
        this.fft.iFFT(falconFPRArray5, 0, n16);
        n26 = 0;
        while (n26 < n17) {
            FalconFPR falconFPR = falconFPRArray5[n26];
            if (!this.fpr.fpr_lt(falconFPR, this.fpr.fpr_ptwo63m1) || !this.fpr.fpr_lt(this.fpr.fpr_mtwo63m1, falconFPR)) {
                return 0;
            }
            falconFPRArray5[n26] = this.fpr.fpr_of(this.fpr.fpr_rint(falconFPR));
            ++n26;
        }
        this.fft.FFT(falconFPRArray5, 0, n16);
        this.fft.poly_mul_fft(falconFPRArray3, 0, falconFPRArray5, 0, n16);
        this.fft.poly_mul_fft(falconFPRArray4, 0, falconFPRArray5, 0, n16);
        this.fft.poly_sub(falconFPRArray, 0, falconFPRArray3, 0, n16);
        this.fft.poly_sub(falconFPRArray2, 0, falconFPRArray4, 0, n16);
        this.fft.iFFT(falconFPRArray, 0, n16);
        this.fft.iFFT(falconFPRArray2, 0, n16);
        n24 = n4;
        n25 = n24 + n17;
        n26 = 0;
        while (n26 < n17) {
            nArray[n24 + n26] = (int)this.fpr.fpr_rint(falconFPRArray[n26]);
            nArray[n25 + n26] = (int)this.fpr.fpr_rint(falconFPRArray2[n26]);
            ++n26;
        }
        return 1;
    }

    int solve_NTRU_deepest(int n, byte[] byArray, int n2, byte[] byArray2, int n3, int[] nArray, int n4) {
        int n5 = this.MAX_BL_SMALL[n];
        FalconSmallPrime[] falconSmallPrimeArray = FalconSmallPrimeList.PRIMES;
        int n6 = n4;
        int n7 = n6 + n5;
        int n8 = n7 + n5;
        int n9 = n8 + n5;
        int n10 = n9 + n5;
        this.make_fg(nArray, n8, byArray, n2, byArray2, n3, n, n, 0);
        this.zint_rebuild_CRT(nArray, n8, n5, n5, 2, falconSmallPrimeArray, 0, nArray, n10);
        if (this.zint_bezout(nArray, n7, nArray, n6, nArray, n8, nArray, n9, n5, nArray, n10) == 0) {
            return 0;
        }
        int n11 = 12289;
        if (this.zint_mul_small(nArray, n6, n5, n11) != 0 || this.zint_mul_small(nArray, n7, n5, n11) != 0) {
            return 0;
        }
        return 1;
    }

    int solve_NTRU_intermediate(int n, byte[] byArray, int n2, byte[] byArray2, int n3, int n4, int[] nArray, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17 = n - n4;
        int n18 = 1 << n17;
        int n19 = n18 >> 1;
        int n20 = this.MAX_BL_SMALL[n4];
        int n21 = this.MAX_BL_SMALL[n4 + 1];
        int n22 = this.MAX_BL_LARGE[n4];
        FalconSmallPrime[] falconSmallPrimeArray = FalconSmallPrimeList.PRIMES;
        int n23 = n5;
        int n24 = n23 + n21 * n19;
        int n25 = n24 + n21 * n19;
        this.make_fg(nArray, n25, byArray, n2, byArray2, n3, n, n4, 1);
        int n26 = n5;
        int n27 = n26 + n18 * n22;
        int n28 = n27 + n18 * n22;
        System.arraycopy(nArray, n25, nArray, n28, 2 * n18 * n20);
        n25 = n28;
        int n29 = n25 + n20 * n18;
        n28 = n29 + n20 * n18;
        System.arraycopy(nArray, n23, nArray, n28, 2 * n19 * n21);
        n23 = n28;
        n24 = n23 + n19 * n21;
        int n30 = 0;
        while (n30 < n22) {
            n16 = falconSmallPrimeArray[n30].p;
            n15 = this.modp_ninv31(n16);
            n14 = this.modp_R2(n16, n15);
            n13 = this.modp_Rx(n21, n16, n15, n14);
            n12 = 0;
            n11 = n23;
            n10 = n24;
            n9 = n26 + n30;
            n8 = n27 + n30;
            while (n12 < n19) {
                nArray[n9] = this.zint_mod_small_signed(nArray, n11, n21, n16, n15, n14, n13);
                nArray[n8] = this.zint_mod_small_signed(nArray, n10, n21, n16, n15, n14, n13);
                ++n12;
                n11 += n21;
                n10 += n21;
                n9 += n22;
                n8 += n22;
            }
            ++n30;
        }
        n30 = 0;
        while (n30 < n22) {
            int n31;
            int n32;
            n16 = falconSmallPrimeArray[n30].p;
            n15 = this.modp_ninv31(n16);
            n14 = this.modp_R2(n16, n15);
            if (n30 == n20) {
                this.zint_rebuild_CRT(nArray, n25, n20, n20, n18, falconSmallPrimeArray, 1, nArray, n28);
                this.zint_rebuild_CRT(nArray, n29, n20, n20, n18, falconSmallPrimeArray, 1, nArray, n28);
            }
            n13 = n28;
            n12 = n13 + n18;
            n11 = n12 + n18;
            n10 = n11 + n18;
            this.modp_mkgm2(nArray, n13, nArray, n12, n17, falconSmallPrimeArray[n30].g, n16, n15);
            if (n30 < n20) {
                n32 = 0;
                n7 = n25 + n30;
                n6 = n29 + n30;
                while (n32 < n18) {
                    nArray[n11 + n32] = nArray[n7];
                    nArray[n10 + n32] = nArray[n6];
                    ++n32;
                    n7 += n20;
                    n6 += n20;
                }
                this.modp_iNTT2_ext(nArray, n25 + n30, n20, nArray, n12, n17, n16, n15);
                this.modp_iNTT2_ext(nArray, n29 + n30, n20, nArray, n12, n17, n16, n15);
            } else {
                n31 = this.modp_Rx(n20, n16, n15, n14);
                n32 = 0;
                n7 = n25;
                n6 = n29;
                while (n32 < n18) {
                    nArray[n11 + n32] = this.zint_mod_small_signed(nArray, n7, n20, n16, n15, n14, n31);
                    nArray[n10 + n32] = this.zint_mod_small_signed(nArray, n6, n20, n16, n15, n14, n31);
                    ++n32;
                    n7 += n20;
                    n6 += n20;
                }
                this.modp_NTT2(nArray, n11, nArray, n13, n17, n16, n15);
                this.modp_NTT2(nArray, n10, nArray, n13, n17, n16, n15);
            }
            n9 = n10 + n18;
            n8 = n9 + n19;
            n32 = 0;
            n7 = n26 + n30;
            n6 = n27 + n30;
            while (n32 < n19) {
                nArray[n9 + n32] = nArray[n7];
                nArray[n8 + n32] = nArray[n6];
                ++n32;
                n7 += n22;
                n6 += n22;
            }
            this.modp_NTT2(nArray, n9, nArray, n13, n17 - 1, n16, n15);
            this.modp_NTT2(nArray, n8, nArray, n13, n17 - 1, n16, n15);
            n32 = 0;
            n7 = n26 + n30;
            n6 = n27 + n30;
            while (n32 < n19) {
                n31 = nArray[n11 + (n32 << 1)];
                int n33 = nArray[n11 + (n32 << 1) + 1];
                int n34 = nArray[n10 + (n32 << 1)];
                int n35 = nArray[n10 + (n32 << 1) + 1];
                int n36 = this.modp_montymul(nArray[n9 + n32], n14, n16, n15);
                int n37 = this.modp_montymul(nArray[n8 + n32], n14, n16, n15);
                nArray[n7] = this.modp_montymul(n35, n36, n16, n15);
                nArray[n7 + n22] = this.modp_montymul(n34, n36, n16, n15);
                nArray[n6] = this.modp_montymul(n33, n37, n16, n15);
                nArray[n6 + n22] = this.modp_montymul(n31, n37, n16, n15);
                ++n32;
                n7 += n22 << 1;
                n6 += n22 << 1;
            }
            this.modp_iNTT2_ext(nArray, n26 + n30, n22, nArray, n12, n17, n16, n15);
            this.modp_iNTT2_ext(nArray, n27 + n30, n22, nArray, n12, n17, n16, n15);
            ++n30;
        }
        this.zint_rebuild_CRT(nArray, n26, n22, n22, n18, falconSmallPrimeArray, 1, nArray, n28);
        this.zint_rebuild_CRT(nArray, n27, n22, n22, n18, falconSmallPrimeArray, 1, nArray, n28);
        FalconFPR[] falconFPRArray = new FalconFPR[n18];
        FalconFPR[] falconFPRArray2 = new FalconFPR[n18];
        FalconFPR[] falconFPRArray3 = new FalconFPR[n18];
        FalconFPR[] falconFPRArray4 = new FalconFPR[n18];
        FalconFPR[] falconFPRArray5 = new FalconFPR[n18 >> 1];
        int[] nArray2 = new int[n18];
        int n38 = n20 > 10 ? 10 : n20;
        this.poly_big_to_fp(falconFPRArray3, 0, nArray, n25 + n20 - n38, n38, n20, n17);
        this.poly_big_to_fp(falconFPRArray4, 0, nArray, n29 + n20 - n38, n38, n20, n17);
        int n39 = 31 * (n20 - n38);
        int n40 = this.bitlength_avg[n4] - 6 * this.bitlength_std[n4];
        int n41 = this.bitlength_avg[n4] + 6 * this.bitlength_std[n4];
        this.fft.FFT(falconFPRArray3, 0, n17);
        this.fft.FFT(falconFPRArray4, 0, n17);
        this.fft.poly_invnorm2_fft(falconFPRArray5, 0, falconFPRArray3, 0, falconFPRArray4, 0, n17);
        this.fft.poly_adj_fft(falconFPRArray3, 0, n17);
        this.fft.poly_adj_fft(falconFPRArray4, 0, n17);
        int n42 = n22;
        int n43 = 31 * n22;
        int n44 = n43 - n40;
        while (true) {
            FalconFPR falconFPR;
            n38 = n42 > 10 ? 10 : n42;
            n16 = 31 * (n42 - n38);
            this.poly_big_to_fp(falconFPRArray, 0, nArray, n26 + n42 - n38, n38, n22, n17);
            this.poly_big_to_fp(falconFPRArray2, 0, nArray, n27 + n42 - n38, n38, n22, n17);
            this.fft.FFT(falconFPRArray, 0, n17);
            this.fft.FFT(falconFPRArray2, 0, n17);
            this.fft.poly_mul_fft(falconFPRArray, 0, falconFPRArray3, 0, n17);
            this.fft.poly_mul_fft(falconFPRArray2, 0, falconFPRArray4, 0, n17);
            this.fft.poly_add(falconFPRArray2, 0, falconFPRArray, 0, n17);
            this.fft.poly_mul_autoadj_fft(falconFPRArray2, 0, falconFPRArray5, 0, n17);
            this.fft.iFFT(falconFPRArray2, 0, n17);
            n15 = n44 - n16 + n39;
            if (n15 < 0) {
                n15 = -n15;
                falconFPR = this.fpr.fpr_two;
            } else {
                falconFPR = this.fpr.fpr_onehalf;
            }
            FalconFPR falconFPR2 = this.fpr.fpr_one;
            while (n15 != 0) {
                if ((n15 & 1) != 0) {
                    falconFPR2 = this.fpr.fpr_mul(falconFPR2, falconFPR);
                }
                n15 >>= 1;
                falconFPR = this.fpr.fpr_sqr(falconFPR);
            }
            n30 = 0;
            while (n30 < n18) {
                FalconFPR falconFPR3 = this.fpr.fpr_mul(falconFPRArray2[n30], falconFPR2);
                if (!this.fpr.fpr_lt(this.fpr.fpr_mtwo31m1, falconFPR3) || !this.fpr.fpr_lt(falconFPR3, this.fpr.fpr_ptwo31m1)) {
                    return 0;
                }
                nArray2[n30] = (int)this.fpr.fpr_rint(falconFPR3);
                ++n30;
            }
            n12 = n44 / 31;
            n13 = n44 % 31;
            if (n4 <= 4) {
                this.poly_sub_scaled_ntt(nArray, n26, n42, n22, nArray, n25, n20, n20, nArray2, 0, n12, n13, n17, nArray, n28);
                this.poly_sub_scaled_ntt(nArray, n27, n42, n22, nArray, n29, n20, n20, nArray2, 0, n12, n13, n17, nArray, n28);
            } else {
                this.poly_sub_scaled(nArray, n26, n42, n22, nArray, n25, n20, n20, nArray2, 0, n12, n13, n17);
                this.poly_sub_scaled(nArray, n27, n42, n22, nArray, n29, n20, n20, nArray2, 0, n12, n13, n17);
            }
            n14 = n44 + n41 + 10;
            if (n14 < n43 && n42 * 31 >= (n43 = n14) + 31) {
                --n42;
            }
            if (n44 <= 0) break;
            if ((n44 -= 25) >= 0) continue;
            n44 = 0;
        }
        if (n42 < n20) {
            n30 = 0;
            while (n30 < n18) {
                n15 = -(nArray[n26 + n42 - 1] >>> 30) >>> 1;
                n16 = n42;
                while (n16 < n20) {
                    nArray[n26 + n16] = n15;
                    ++n16;
                }
                n15 = -(nArray[n27 + n42 - 1] >>> 30) >>> 1;
                n16 = n42;
                while (n16 < n20) {
                    nArray[n27 + n16] = n15;
                    ++n16;
                }
                ++n30;
                n26 += n22;
                n27 += n22;
            }
        }
        n30 = 0;
        n7 = n5;
        n6 = n5;
        while (n30 < n18 << 1) {
            System.arraycopy(nArray, n6, nArray, n7, n20);
            ++n30;
            n7 += n20;
            n6 += n22;
        }
        return 1;
    }

    private long toUnsignedLong(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    void zint_add_mul_small(int[] nArray, int n, int[] nArray2, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            int n7 = nArray[n + n6];
            int n8 = nArray2[n2 + n6];
            long l = this.toUnsignedLong(n8) * this.toUnsignedLong(n4) + this.toUnsignedLong(n7) + this.toUnsignedLong(n5);
            nArray[n + n6] = (int)l & Integer.MAX_VALUE;
            n5 = (int)(l >>> 31);
            ++n6;
        }
        nArray[n + n3] = n5;
    }

    void zint_add_scaled_mul_small(int[] nArray, int n, int n2, int[] nArray2, int n3, int n4, int n5, int n6, int n7) {
        if (n4 == 0) {
            return;
        }
        int n8 = -(nArray2[n3 + n4 - 1] >>> 30) >>> 1;
        int n9 = 0;
        int n10 = 0;
        int n11 = n6;
        while (n11 < n2) {
            int n12;
            int n13 = n11 - n6;
            int n14 = n13 < n4 ? nArray2[n3 + n13] : n8;
            int n15 = n14 << n7 & Integer.MAX_VALUE | n9;
            n9 = n14 >>> 31 - n7;
            long l = this.toUnsignedLong(n15) * (long)n5 + this.toUnsignedLong(nArray[n + n11]) + (long)n10;
            nArray[n + n11] = (int)l & Integer.MAX_VALUE;
            n10 = n12 = (int)(l >>> 31);
            ++n11;
        }
    }

    int zint_bezout(int[] nArray, int n, int[] nArray2, int n2, int[] nArray3, int n3, int[] nArray4, int n4, int n5, int[] nArray5, int n6) {
        int n7;
        if (n5 == 0) {
            return 0;
        }
        int n8 = n;
        int n9 = n2;
        int n10 = n6;
        int n11 = n10 + n5;
        int n12 = n11 + n5;
        int n13 = n12 + n5;
        int n14 = this.modp_ninv31(nArray3[n3]);
        int n15 = this.modp_ninv31(nArray4[n4]);
        System.arraycopy(nArray3, n3, nArray5, n12, n5);
        System.arraycopy(nArray4, n4, nArray5, n13, n5);
        nArray[n8] = 1;
        nArray2[n9] = 0;
        int n16 = 1;
        while (n16 < n5) {
            nArray[n8 + n16] = 0;
            nArray2[n9 + n16] = 0;
            ++n16;
        }
        System.arraycopy(nArray4, n4, nArray5, n10, n5);
        System.arraycopy(nArray3, n3, nArray5, n11, n5);
        int n17 = n11;
        nArray5[n17] = nArray5[n17] - 1;
        int n18 = 62 * n5 + 30;
        while (n18 >= 30) {
            int n19;
            int n20;
            int n21 = -1;
            int n22 = -1;
            int n23 = 0;
            int n24 = 0;
            int n25 = 0;
            int n26 = 0;
            n7 = n5;
            while (n7-- > 0) {
                n20 = nArray5[n12 + n7];
                n19 = nArray5[n13 + n7];
                n23 ^= (n23 ^ n20) & n21;
                n24 ^= (n24 ^ n20) & n22;
                n25 ^= (n25 ^ n19) & n21;
                n26 ^= (n26 ^ n19) & n22;
                n22 = n21;
                n21 &= ((n20 | n19) + Integer.MAX_VALUE >>> 31) - 1;
            }
            n24 |= n23 & n22;
            n26 |= n25 & n22;
            long l = (this.toUnsignedLong(n23 &= ~n22) << 31) + this.toUnsignedLong(n24);
            long l2 = (this.toUnsignedLong(n25 &= ~n22) << 31) + this.toUnsignedLong(n26);
            int n27 = nArray5[n12];
            int n28 = nArray5[n13];
            long l3 = 1L;
            long l4 = 0L;
            long l5 = 0L;
            long l6 = 1L;
            int n29 = 0;
            while (n29 < 31) {
                long l7 = l2 - l;
                n20 = (int)((l7 ^ (l ^ l2) & (l ^ l7)) >>> 63);
                n19 = n27 >> n29 & 1;
                int n30 = n28 >> n29 & 1;
                int n31 = n19 & n30 & n20;
                int n32 = n19 & n30 & ~n20;
                int n33 = n31 | n19 ^ 1;
                n27 -= n28 & -n31;
                l -= l2 & -this.toUnsignedLong(n31);
                l3 -= l5 & -((long)n31);
                l4 -= l6 & -((long)n31);
                n28 -= n27 & -n32;
                l2 -= l & -this.toUnsignedLong(n32);
                l5 -= l3 & -((long)n32);
                l6 -= l4 & -((long)n32);
                n27 += n27 & n33 - 1;
                l3 += l3 & (long)n33 - 1L;
                l4 += l4 & (long)n33 - 1L;
                l ^= (l ^ l >> 1) & -this.toUnsignedLong(n33);
                n28 += n28 & -n33;
                l5 += l5 & -((long)n33);
                l6 += l6 & -((long)n33);
                l2 ^= (l2 ^ l2 >> 1) & this.toUnsignedLong(n33) - 1L;
                ++n29;
            }
            int n34 = this.zint_co_reduce(nArray5, n12, nArray5, n13, n5, l3, l4, l5, l6);
            l3 -= l3 + l3 & -((long)(n34 & 1));
            l4 -= l4 + l4 & -((long)(n34 & 1));
            l5 -= l5 + l5 & -((long)(n34 >>> 1));
            l6 -= l6 + l6 & -((long)(n34 >>> 1));
            this.zint_co_reduce_mod(nArray, n8, nArray5, n10, nArray4, n4, n5, n15, l3, l4, l5, l6);
            this.zint_co_reduce_mod(nArray2, n9, nArray5, n11, nArray3, n3, n5, n14, l3, l4, l5, l6);
            n18 -= 30;
        }
        int n35 = nArray5[n12] ^ 1;
        n7 = 1;
        while (n7 < n5) {
            n35 |= nArray5[n12 + n7];
            ++n7;
        }
        return 1 - ((n35 | -n35) >>> 31) & nArray3[n3] & nArray4[n4];
    }

    int zint_co_reduce(int[] nArray, int n, int[] nArray2, int n2, int n3, long l, long l2, long l3, long l4) {
        long l5 = 0L;
        long l6 = 0L;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = nArray[n + n4];
            int n6 = nArray2[n2 + n4];
            long l7 = (long)n5 * l + (long)n6 * l2 + l5;
            long l8 = (long)n5 * l3 + (long)n6 * l4 + l6;
            if (n4 > 0) {
                nArray[n + n4 - 1] = (int)l7 & Integer.MAX_VALUE;
                nArray2[n2 + n4 - 1] = (int)l8 & Integer.MAX_VALUE;
            }
            l5 = l7 >> 31;
            l6 = l8 >> 31;
            ++n4;
        }
        nArray[n + n3 - 1] = (int)l5;
        nArray2[n2 + n3 - 1] = (int)l6;
        int n7 = (int)(l5 >>> 63);
        int n8 = (int)(l6 >>> 63);
        this.zint_negate(nArray, n, n3, n7);
        this.zint_negate(nArray2, n2, n3, n8);
        return n7 | n8 << 1;
    }

    void zint_co_reduce_mod(int[] nArray, int n, int[] nArray2, int n2, int[] nArray3, int n3, int n4, int n5, long l, long l2, long l3, long l4) {
        long l5 = 0L;
        long l6 = 0L;
        int n6 = (nArray[n] * (int)l + nArray2[n2] * (int)l2) * n5 & Integer.MAX_VALUE;
        int n7 = (nArray[n] * (int)l3 + nArray2[n2] * (int)l4) * n5 & Integer.MAX_VALUE;
        int n8 = 0;
        while (n8 < n4) {
            int n9 = nArray[n + n8];
            int n10 = nArray2[n2 + n8];
            long l7 = (long)n9 * l + (long)n10 * l2 + (long)nArray3[n3 + n8] * this.toUnsignedLong(n6) + l5;
            long l8 = (long)n9 * l3 + (long)n10 * l4 + (long)nArray3[n3 + n8] * this.toUnsignedLong(n7) + l6;
            if (n8 > 0) {
                nArray[n + n8 - 1] = (int)l7 & Integer.MAX_VALUE;
                nArray2[n2 + n8 - 1] = (int)l8 & Integer.MAX_VALUE;
            }
            l5 = l7 >> 31;
            l6 = l8 >> 31;
            ++n8;
        }
        nArray[n + n4 - 1] = (int)l5;
        nArray2[n2 + n4 - 1] = (int)l6;
        this.zint_finish_mod(nArray, n, n4, nArray3, n3, (int)(l5 >>> 63));
        this.zint_finish_mod(nArray2, n2, n4, nArray3, n3, (int)(l6 >>> 63));
    }

    void zint_finish_mod(int[] nArray, int n, int n2, int[] nArray2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            n5 = nArray[n + n6] - nArray2[n3 + n6] - n5 >>> 31;
            ++n6;
        }
        int n7 = -n4 >>> 1;
        int n8 = -(n4 | 1 - n5);
        n5 = n4;
        n6 = 0;
        while (n6 < n2) {
            int n9 = nArray[n + n6];
            int n10 = (nArray2[n3 + n6] ^ n7) & n8;
            n9 = n9 - n10 - n5;
            nArray[n + n6] = n9 & Integer.MAX_VALUE;
            n5 = n9 >>> 31;
            ++n6;
        }
    }

    int zint_mod_small_signed(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n2 == 0) {
            return 0;
        }
        int n7 = this.zint_mod_small_unsigned(nArray, n, n2, n3, n4, n5);
        n7 = this.modp_sub(n7, n6 & -(nArray[n + n2 - 1] >>> 30), n3);
        return n7;
    }

    int zint_mod_small_unsigned(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        int n7 = n2;
        while (n7-- > 0) {
            n6 = this.modp_montymul(n6, n5, n3, n4);
            int n8 = nArray[n + n7] - n3;
            n8 += n3 & -(n8 >>> 31);
            n6 = this.modp_add(n6, n8, n3);
        }
        return n6;
    }

    int zint_mul_small(int[] nArray, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            long l = this.toUnsignedLong(nArray[n + n5]) * this.toUnsignedLong(n3) + (long)n4;
            nArray[n + n5] = (int)l & Integer.MAX_VALUE;
            n4 = (int)(l >> 31);
            ++n5;
        }
        return n4;
    }

    void zint_negate(int[] nArray, int n, int n2, int n3) {
        int n4 = n3;
        int n5 = -n3 >>> 1;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = nArray[n + n6];
            n7 = (n7 ^ n5) + n4;
            nArray[n + n6] = n7 & Integer.MAX_VALUE;
            n4 = n7 >>> 31;
            ++n6;
        }
    }

    void zint_norm_zero(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = n3;
        while (n6-- > 0) {
            int n7 = nArray[n + n6];
            int n8 = nArray2[n2 + n6] >>> 1 | n5 << 30;
            n5 = nArray2[n2 + n6] & 1;
            int n9 = n8 - n7;
            n9 = -n9 >>> 31 | -(n9 >>> 31);
            n4 |= n9 & (n4 & 1) - 1;
        }
        this.zint_sub(nArray, n, nArray2, n2, n3, n4 >>> 31);
    }

    int zint_one_to_plain(int[] nArray, int n) {
        int n2 = nArray[n];
        n2 |= (n2 & 0x40000000) << 1;
        return n2;
    }

    void zint_rebuild_CRT(int[] nArray, int n, int n2, int n3, int n4, FalconSmallPrime[] falconSmallPrimeArray, int n5, int[] nArray2, int n6) {
        int n7;
        nArray2[n6] = falconSmallPrimeArray[0].p;
        int n8 = 1;
        while (n8 < n2) {
            int n9 = falconSmallPrimeArray[n8].p;
            int n10 = falconSmallPrimeArray[n8].s;
            int n11 = this.modp_ninv31(n9);
            int n12 = this.modp_R2(n9, n11);
            int n13 = 0;
            n7 = n;
            while (n13 < n4) {
                int n14 = nArray[n7 + n8];
                int n15 = this.zint_mod_small_unsigned(nArray, n7, n8, n9, n11, n12);
                int n16 = this.modp_montymul(n10, this.modp_sub(n14, n15, n9), n9, n11);
                this.zint_add_mul_small(nArray, n7, nArray2, n6, n8, n16);
                ++n13;
                n7 += n3;
            }
            nArray2[n6 + n8] = this.zint_mul_small(nArray2, n6, n8, n9);
            ++n8;
        }
        if (n5 != 0) {
            n8 = 0;
            n7 = n;
            while (n8 < n4) {
                this.zint_norm_zero(nArray, n7, nArray2, n6, n2);
                ++n8;
                n7 += n3;
            }
        }
    }

    int zint_sub(int[] nArray, int n, int[] nArray2, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = -n4;
        int n7 = 0;
        while (n7 < n3) {
            int n8 = nArray[n + n7];
            int n9 = n8 - nArray2[n2 + n7] - n5;
            n5 = n9 >>> 31;
            n8 ^= (n9 & Integer.MAX_VALUE ^ n8) & n6;
            nArray[n + n7] = n8;
            ++n7;
        }
        return n5;
    }

    void zint_sub_scaled(int[] nArray, int n, int n2, int[] nArray2, int n3, int n4, int n5, int n6) {
        if (n4 == 0) {
            return;
        }
        int n7 = -(nArray2[n3 + n4 - 1] >>> 30) >>> 1;
        int n8 = 0;
        int n9 = 0;
        int n10 = n5;
        while (n10 < n2) {
            int n11 = n10 - n5;
            int n12 = n11 < n4 ? nArray2[n3 + n11] : n7;
            int n13 = n12 << n6 & Integer.MAX_VALUE | n8;
            n8 = n12 >>> 31 - n6;
            int n14 = nArray[n + n10] - n13 - n9;
            nArray[n + n10] = n14 & Integer.MAX_VALUE;
            n9 = n14 >>> 31;
            ++n10;
        }
    }
}

