/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.crystals.dilithium;

import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumEngine;
import org.bouncycastle.pqc.crypto.crystals.dilithium.PolyVecK;
import org.bouncycastle.pqc.crypto.crystals.dilithium.PolyVecL;
import org.bouncycastle.util.Arrays;

class Packing {
    Packing() {
    }

    static byte[] packPublicKey(PolyVecK polyVecK, DilithiumEngine dilithiumEngine) {
        byte[] byArray = new byte[dilithiumEngine.getCryptoPublicKeyBytes() - 32];
        int n = 0;
        while (n < dilithiumEngine.getDilithiumK()) {
            System.arraycopy(polyVecK.getVectorIndex(n).polyt1Pack(), 0, byArray, n * 320, 320);
            ++n;
        }
        return byArray;
    }

    static byte[][] packSecretKey(byte[] byArray, byte[] byArray2, byte[] byArray3, PolyVecK polyVecK, PolyVecL polyVecL, PolyVecK polyVecK2, DilithiumEngine dilithiumEngine) {
        byte[][] byArray4 = new byte[6][];
        byArray4[0] = byArray;
        byArray4[1] = byArray3;
        byArray4[2] = byArray2;
        byArray4[3] = new byte[dilithiumEngine.getDilithiumL() * dilithiumEngine.getDilithiumPolyEtaPackedBytes()];
        int n = 0;
        while (n < dilithiumEngine.getDilithiumL()) {
            polyVecL.getVectorIndex(n).polyEtaPack(byArray4[3], n * dilithiumEngine.getDilithiumPolyEtaPackedBytes());
            ++n;
        }
        byArray4[4] = new byte[dilithiumEngine.getDilithiumK() * dilithiumEngine.getDilithiumPolyEtaPackedBytes()];
        int n2 = 0;
        while (n2 < dilithiumEngine.getDilithiumK()) {
            polyVecK2.getVectorIndex(n2).polyEtaPack(byArray4[4], n2 * dilithiumEngine.getDilithiumPolyEtaPackedBytes());
            ++n2;
        }
        byArray4[5] = new byte[dilithiumEngine.getDilithiumK() * 416];
        int n3 = 0;
        while (n3 < dilithiumEngine.getDilithiumK()) {
            polyVecK.getVectorIndex(n3).polyt0Pack(byArray4[5], n3 * 416);
            ++n3;
        }
        return byArray4;
    }

    static byte[] packSignature(byte[] byArray, PolyVecL polyVecL, PolyVecK polyVecK, DilithiumEngine dilithiumEngine) {
        int n = 0;
        byte[] byArray2 = new byte[dilithiumEngine.getCryptoBytes()];
        System.arraycopy(byArray, 0, byArray2, 0, dilithiumEngine.getDilithiumCTilde());
        n += dilithiumEngine.getDilithiumCTilde();
        int n2 = 0;
        while (n2 < dilithiumEngine.getDilithiumL()) {
            System.arraycopy(polyVecL.getVectorIndex(n2).zPack(), 0, byArray2, n + n2 * dilithiumEngine.getDilithiumPolyZPackedBytes(), dilithiumEngine.getDilithiumPolyZPackedBytes());
            ++n2;
        }
        n += dilithiumEngine.getDilithiumL() * dilithiumEngine.getDilithiumPolyZPackedBytes();
        n2 = 0;
        while (n2 < dilithiumEngine.getDilithiumOmega() + dilithiumEngine.getDilithiumK()) {
            byArray2[n + n2] = 0;
            ++n2;
        }
        int n3 = 0;
        n2 = 0;
        while (n2 < dilithiumEngine.getDilithiumK()) {
            int n4 = 0;
            while (n4 < 256) {
                if (polyVecK.getVectorIndex(n2).getCoeffIndex(n4) != 0) {
                    byArray2[n + n3++] = (byte)n4;
                }
                ++n4;
            }
            byArray2[n + dilithiumEngine.getDilithiumOmega() + n2] = (byte)n3;
            ++n2;
        }
        return byArray2;
    }

    static PolyVecK unpackPublicKey(PolyVecK polyVecK, byte[] byArray, DilithiumEngine dilithiumEngine) {
        int n = 0;
        while (n < dilithiumEngine.getDilithiumK()) {
            polyVecK.getVectorIndex(n).polyt1Unpack(Arrays.copyOfRange(byArray, n * 320, (n + 1) * 320));
            ++n;
        }
        return polyVecK;
    }

    static void unpackSecretKey(PolyVecK polyVecK, PolyVecL polyVecL, PolyVecK polyVecK2, byte[] byArray, byte[] byArray2, byte[] byArray3, DilithiumEngine dilithiumEngine) {
        int n = 0;
        while (n < dilithiumEngine.getDilithiumL()) {
            polyVecL.getVectorIndex(n).polyEtaUnpack(byArray2, n * dilithiumEngine.getDilithiumPolyEtaPackedBytes());
            ++n;
        }
        int n2 = 0;
        while (n2 < dilithiumEngine.getDilithiumK()) {
            polyVecK2.getVectorIndex(n2).polyEtaUnpack(byArray3, n2 * dilithiumEngine.getDilithiumPolyEtaPackedBytes());
            ++n2;
        }
        int n3 = 0;
        while (n3 < dilithiumEngine.getDilithiumK()) {
            polyVecK.getVectorIndex(n3).polyt0Unpack(byArray, n3 * 416);
            ++n3;
        }
    }

    static boolean unpackSignature(PolyVecL polyVecL, PolyVecK polyVecK, byte[] byArray, DilithiumEngine dilithiumEngine) {
        int n;
        int n2 = dilithiumEngine.getDilithiumCTilde();
        int n3 = 0;
        while (n3 < dilithiumEngine.getDilithiumL()) {
            polyVecL.getVectorIndex(n3).zUnpack(Arrays.copyOfRange(byArray, n2 + n3 * dilithiumEngine.getDilithiumPolyZPackedBytes(), n2 + (n3 + 1) * dilithiumEngine.getDilithiumPolyZPackedBytes()));
            ++n3;
        }
        n2 += dilithiumEngine.getDilithiumL() * dilithiumEngine.getDilithiumPolyZPackedBytes();
        int n4 = 0;
        n3 = 0;
        while (n3 < dilithiumEngine.getDilithiumK()) {
            n = 0;
            while (n < 256) {
                polyVecK.getVectorIndex(n3).setCoeffIndex(n, 0);
                ++n;
            }
            if ((byArray[n2 + dilithiumEngine.getDilithiumOmega() + n3] & 0xFF) < n4 || (byArray[n2 + dilithiumEngine.getDilithiumOmega() + n3] & 0xFF) > dilithiumEngine.getDilithiumOmega()) {
                return false;
            }
            n = n4;
            while (n < (byArray[n2 + dilithiumEngine.getDilithiumOmega() + n3] & 0xFF)) {
                if (n > n4 && (byArray[n2 + n] & 0xFF) <= (byArray[n2 + n - 1] & 0xFF)) {
                    return false;
                }
                polyVecK.getVectorIndex(n3).setCoeffIndex(byArray[n2 + n] & 0xFF, 1);
                ++n;
            }
            n4 = byArray[n2 + dilithiumEngine.getDilithiumOmega() + n3];
            ++n3;
        }
        n = n4;
        while (n < dilithiumEngine.getDilithiumOmega()) {
            if ((byArray[n2 + n] & 0xFF) != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

