/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.cmce;

import org.bouncycastle.math.raw.Interleave;
import org.bouncycastle.pqc.crypto.cmce.GF;

final class GF12
extends GF {
    GF12() {
    }

    protected short gf_frac(short s, short s2) {
        return this.gf_mul(this.gf_inv(s), s2);
    }

    protected short gf_inv(short s) {
        short s2 = s;
        s2 = this.gf_sq(s2);
        short s3 = this.gf_mul(s2, s);
        s2 = this.gf_sq(s3);
        s2 = this.gf_sq(s2);
        short s4 = this.gf_mul(s2, s3);
        s2 = this.gf_sq(s4);
        s2 = this.gf_sq(s2);
        s2 = this.gf_sq(s2);
        s2 = this.gf_sq(s2);
        s2 = this.gf_mul(s2, s4);
        s2 = this.gf_sq(s2);
        s2 = this.gf_sq(s2);
        s2 = this.gf_mul(s2, s3);
        s2 = this.gf_sq(s2);
        s2 = this.gf_mul(s2, s);
        return this.gf_sq(s2);
    }

    protected short gf_mul(short s, short s2) {
        short s3 = s;
        short s4 = s2;
        int n = s3 * (s4 & 1);
        int n2 = 1;
        while (n2 < 12) {
            n ^= s3 * (s4 & 1 << n2);
            ++n2;
        }
        return this.gf_reduce(n);
    }

    protected int gf_mul_ext(short s, short s2) {
        short s3 = s;
        short s4 = s2;
        int n = s3 * (s4 & 1);
        int n2 = 1;
        while (n2 < 12) {
            n ^= s3 * (s4 & 1 << n2);
            ++n2;
        }
        return n;
    }

    private int gf_mul_ext_par(short s, short s2, short s3, short s4) {
        short s5 = s;
        short s6 = s2;
        short s7 = s3;
        short s8 = s4;
        int n = s5 * (s6 & 1);
        int n2 = s7 * (s8 & 1);
        int n3 = 1;
        while (n3 < 12) {
            n ^= s5 * (s6 & 1 << n3);
            n2 ^= s7 * (s8 & 1 << n3);
            ++n3;
        }
        return n ^ n2;
    }

    protected void gf_mul_poly(int n, int[] nArray, short[] sArray, short[] sArray2, short[] sArray3, int[] nArray2) {
        int n2;
        short s;
        short s2;
        nArray2[0] = this.gf_mul_ext(sArray2[0], sArray3[0]);
        int n3 = 1;
        while (n3 < n) {
            nArray2[n3 + n3 - 1] = 0;
            s2 = sArray2[n3];
            s = sArray3[n3];
            n2 = 0;
            while (n2 < n3) {
                int n4 = n3 + n2;
                nArray2[n4] = nArray2[n4] ^ this.gf_mul_ext_par(s2, sArray3[n2], sArray2[n2], s);
                ++n2;
            }
            nArray2[n3 + n3] = this.gf_mul_ext(s2, s);
            ++n3;
        }
        s2 = (n - 1) * 2;
        while (s2 >= n) {
            s = nArray2[s2];
            n2 = 0;
            while (n2 < nArray.length - 1) {
                int n5 = s2 - n + nArray[n2];
                nArray2[n5] = nArray2[n5] ^ s;
                ++n2;
            }
            int n6 = s2 - n;
            nArray2[n6] = nArray2[n6] ^ s << 1;
            --s2;
        }
        s = 0;
        while (s < n) {
            sArray[s] = this.gf_reduce(nArray2[s]);
            ++s;
        }
    }

    protected short gf_reduce(int n) {
        int n2 = n & 0xFFF;
        int n3 = n >>> 12;
        int n4 = (n & 0x1FF000) >>> 9;
        int n5 = (n & 0xE00000) >>> 18;
        int n6 = n >>> 21;
        return (short)(n2 ^ n3 ^ n4 ^ n5 ^ n6);
    }

    protected short gf_sq(short s) {
        int n = Interleave.expand16to32(s);
        return this.gf_reduce(n);
    }

    protected int gf_sq_ext(short s) {
        return Interleave.expand16to32(s);
    }

    protected void gf_sqr_poly(int n, int[] nArray, short[] sArray, short[] sArray2, int[] nArray2) {
        int n2;
        nArray2[0] = this.gf_sq_ext(sArray2[0]);
        int n3 = 1;
        while (n3 < n) {
            nArray2[n3 + n3 - 1] = 0;
            nArray2[n3 + n3] = this.gf_sq_ext(sArray2[n3]);
            ++n3;
        }
        int n4 = (n - 1) * 2;
        while (n4 >= n) {
            n2 = nArray2[n4];
            int n5 = 0;
            while (n5 < nArray.length - 1) {
                int n6 = n4 - n + nArray[n5];
                nArray2[n6] = nArray2[n6] ^ n2;
                ++n5;
            }
            int n7 = n4 - n;
            nArray2[n7] = nArray2[n7] ^ n2 << 1;
            --n4;
        }
        n2 = 0;
        while (n2 < n) {
            sArray[n2] = this.gf_reduce(nArray2[n2]);
            ++n2;
        }
    }
}

