/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.cmce;

import java.security.SecureRandom;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.pqc.crypto.cmce.BENES;
import org.bouncycastle.pqc.crypto.cmce.BENES12;
import org.bouncycastle.pqc.crypto.cmce.BENES13;
import org.bouncycastle.pqc.crypto.cmce.GF;
import org.bouncycastle.pqc.crypto.cmce.GF12;
import org.bouncycastle.pqc.crypto.cmce.GF13;
import org.bouncycastle.pqc.crypto.cmce.Utils;
import org.bouncycastle.util.Arrays;

class CMCEEngine {
    private int SYS_N;
    private int SYS_T;
    private int GFBITS;
    private int IRR_BYTES;
    private int COND_BYTES;
    private int PK_NROWS;
    private int PK_NCOLS;
    private int PK_ROW_BYTES;
    private int SYND_BYTES;
    private int GFMASK;
    private int[] poly;
    private final int defaultKeySize;
    private GF gf;
    private BENES benes;
    private boolean usePadding;
    private boolean countErrorIndices;
    private boolean usePivots;

    public CMCEEngine(int n, int n2, int n3, int[] nArray, boolean bl, int n4) {
        this.usePivots = bl;
        this.SYS_N = n2;
        this.SYS_T = n3;
        this.GFBITS = n;
        this.poly = nArray;
        this.defaultKeySize = n4;
        this.IRR_BYTES = this.SYS_T * 2;
        this.COND_BYTES = (1 << this.GFBITS - 4) * (2 * this.GFBITS - 1);
        this.PK_NROWS = this.SYS_T * this.GFBITS;
        this.PK_NCOLS = this.SYS_N - this.PK_NROWS;
        this.PK_ROW_BYTES = (this.PK_NCOLS + 7) / 8;
        this.SYND_BYTES = (this.PK_NROWS + 7) / 8;
        this.GFMASK = (1 << this.GFBITS) - 1;
        if (this.GFBITS == 12) {
            this.gf = new GF12();
            this.benes = new BENES12(this.SYS_N, this.SYS_T, this.GFBITS);
        } else {
            this.gf = new GF13();
            this.benes = new BENES13(this.SYS_N, this.SYS_T, this.GFBITS);
        }
        this.usePadding = this.SYS_T % 8 != 0;
        this.countErrorIndices = 1 << this.GFBITS > this.SYS_N;
    }

    private void bm(short[] sArray, short[] sArray2) {
        int n;
        short s = 0;
        int n2 = 0;
        short[] sArray3 = new short[this.SYS_T + 1];
        short[] sArray4 = new short[this.SYS_T + 1];
        short[] sArray5 = new short[this.SYS_T + 1];
        short s2 = 1;
        int n3 = 0;
        while (n3 < this.SYS_T + 1) {
            sArray5[n3] = 0;
            sArray4[n3] = 0;
            ++n3;
        }
        sArray4[0] = 1;
        sArray5[1] = 1;
        s = 0;
        while (s < 2 * this.SYS_T) {
            short s3;
            n = 0;
            int n4 = 0;
            while (n4 <= CMCEEngine.min(s, this.SYS_T)) {
                n ^= this.gf.gf_mul_ext(sArray4[n4], sArray2[s - n4]);
                ++n4;
            }
            short s4 = s3 = this.gf.gf_reduce(n);
            s4 = (short)(s4 - 1);
            s4 = (short)(s4 >> 15);
            s4 = (short)(s4 & 1);
            s4 = (short)(s4 - 1);
            short s5 = s;
            s5 = (short)(s5 - 2 * n2);
            s5 = (short)(s5 >> 15);
            s5 = (short)(s5 & 1);
            s5 = (short)(s5 - 1);
            s5 = (short)(s5 & s4);
            int n5 = 0;
            while (n5 <= this.SYS_T) {
                sArray3[n5] = sArray4[n5];
                ++n5;
            }
            short s6 = this.gf.gf_frac(s2, s3);
            int n6 = 0;
            while (n6 <= this.SYS_T) {
                int n7 = n6;
                sArray4[n7] = (short)(sArray4[n7] ^ this.gf.gf_mul(s6, sArray5[n6]) & s4);
                ++n6;
            }
            n2 = (short)(n2 & ~s5 | s + 1 - n2 & s5);
            int n8 = this.SYS_T - 1;
            while (n8 >= 0) {
                sArray5[n8 + 1] = (short)(sArray5[n8] & ~s5 | sArray3[n8] & s5);
                --n8;
            }
            sArray5[0] = 0;
            s2 = (short)(s2 & ~s5 | s3 & s5);
            s = (short)(s + 1);
        }
        n = 0;
        while (n <= this.SYS_T) {
            sArray[n] = sArray4[this.SYS_T - n];
            ++n;
        }
    }

    static void cbrecursion(byte[] byArray, long l, long l2, short[] sArray, int n, long l3, long l4, int[] nArray) {
        int n2;
        int n3;
        long l5;
        int n4;
        int n5;
        int n6;
        long l6;
        if (l3 == 1L) {
            int n7 = (int)(l >> 3);
            byArray[n7] = (byte)(byArray[n7] ^ CMCEEngine.get_q_short(nArray, n) << (int)(l & 7L));
            return;
        }
        if (sArray != null) {
            l6 = 0L;
            while (l6 < l4) {
                nArray[(int)l6] = (sArray[(int)l6] ^ 1) << 16 | sArray[(int)(l6 ^ 1L)];
                ++l6;
            }
        } else {
            l6 = 0L;
            while (l6 < l4) {
                nArray[(int)l6] = (CMCEEngine.get_q_short(nArray, (int)((long)n + l6)) ^ 1) << 16 | CMCEEngine.get_q_short(nArray, (int)((long)n + (l6 ^ 1L)));
                ++l6;
            }
        }
        CMCEEngine.sort32(nArray, 0, (int)l4);
        l6 = 0L;
        while (l6 < l4) {
            n6 = nArray[(int)l6];
            n5 = n6 & 0xFFFF;
            n4 = n5;
            if (l6 < (long)n4) {
                n4 = (int)l6;
            }
            nArray[(int)(l4 + l6)] = n5 << 16 | n4;
            ++l6;
        }
        l6 = 0L;
        while (l6 < l4) {
            nArray[(int)l6] = (int)((long)(nArray[(int)l6] << 16) | l6);
            ++l6;
        }
        CMCEEngine.sort32(nArray, 0, (int)l4);
        l6 = 0L;
        while (l6 < l4) {
            nArray[(int)l6] = (nArray[(int)l6] << 16) + (nArray[(int)(l4 + l6)] >> 16);
            ++l6;
        }
        CMCEEngine.sort32(nArray, 0, (int)l4);
        if (l3 <= 10L) {
            l6 = 0L;
            while (l6 < l4) {
                nArray[(int)(l4 + l6)] = (nArray[(int)l6] & 0xFFFF) << 10 | nArray[(int)(l4 + l6)] & 0x3FF;
                ++l6;
            }
            l5 = 1L;
            while (l5 < l3 - 1L) {
                l6 = 0L;
                while (l6 < l4) {
                    nArray[(int)l6] = (int)((long)((nArray[(int)(l4 + l6)] & 0xFFFFFC00) << 6) | l6);
                    ++l6;
                }
                CMCEEngine.sort32(nArray, 0, (int)l4);
                l6 = 0L;
                while (l6 < l4) {
                    nArray[(int)l6] = nArray[(int)l6] << 20 | nArray[(int)(l4 + l6)];
                    ++l6;
                }
                CMCEEngine.sort32(nArray, 0, (int)l4);
                l6 = 0L;
                while (l6 < l4) {
                    n6 = nArray[(int)l6] & 0xFFFFF;
                    n5 = nArray[(int)l6] & 0xFFC00 | nArray[(int)(l4 + l6)] & 0x3FF;
                    if (n6 < n5) {
                        n5 = n6;
                    }
                    nArray[(int)(l4 + l6)] = n5;
                    ++l6;
                }
                ++l5;
            }
            l6 = 0L;
            while (l6 < l4) {
                int n8 = (int)(l4 + l6);
                nArray[n8] = nArray[n8] & 0x3FF;
                ++l6;
            }
        } else {
            l6 = 0L;
            while (l6 < l4) {
                nArray[(int)(l4 + l6)] = nArray[(int)l6] << 16 | nArray[(int)(l4 + l6)] & 0xFFFF;
                ++l6;
            }
            l5 = 1L;
            while (l5 < l3 - 1L) {
                l6 = 0L;
                while (l6 < l4) {
                    nArray[(int)l6] = (int)((long)(nArray[(int)(l4 + l6)] & 0xFFFF0000) | l6);
                    ++l6;
                }
                CMCEEngine.sort32(nArray, 0, (int)l4);
                l6 = 0L;
                while (l6 < l4) {
                    nArray[(int)l6] = nArray[(int)l6] << 16 | nArray[(int)(l4 + l6)] & 0xFFFF;
                    ++l6;
                }
                if (l5 < l3 - 2L) {
                    l6 = 0L;
                    while (l6 < l4) {
                        nArray[(int)(l4 + l6)] = nArray[(int)l6] & 0xFFFF0000 | nArray[(int)(l4 + l6)] >> 16;
                        ++l6;
                    }
                    CMCEEngine.sort32(nArray, (int)l4, (int)(l4 * 2L));
                    l6 = 0L;
                    while (l6 < l4) {
                        nArray[(int)(l4 + l6)] = nArray[(int)(l4 + l6)] << 16 | nArray[(int)l6] & 0xFFFF;
                        ++l6;
                    }
                }
                CMCEEngine.sort32(nArray, 0, (int)l4);
                l6 = 0L;
                while (l6 < l4) {
                    n6 = nArray[(int)(l4 + l6)] & 0xFFFF0000 | nArray[(int)l6] & 0xFFFF;
                    if (n6 < nArray[(int)(l4 + l6)]) {
                        nArray[(int)(l4 + l6)] = n6;
                    }
                    ++l6;
                }
                ++l5;
            }
            l6 = 0L;
            while (l6 < l4) {
                int n9 = (int)(l4 + l6);
                nArray[n9] = nArray[n9] & 0xFFFF;
                ++l6;
            }
        }
        if (sArray != null) {
            l6 = 0L;
            while (l6 < l4) {
                nArray[(int)l6] = (int)((long)(sArray[(int)l6] << 16) + l6);
                ++l6;
            }
        } else {
            l6 = 0L;
            while (l6 < l4) {
                nArray[(int)l6] = (int)((long)(CMCEEngine.get_q_short(nArray, (int)((long)n + l6)) << 16) + l6);
                ++l6;
            }
        }
        CMCEEngine.sort32(nArray, 0, (int)l4);
        long l7 = 0L;
        while (l7 < l4 / 2L) {
            long l8 = 2L * l7;
            n4 = nArray[(int)(l4 + l8)] & 1;
            n3 = (int)(l8 + (long)n4);
            n2 = n3 ^ 1;
            int n10 = (int)(l >> 3);
            byArray[n10] = (byte)(byArray[n10] ^ n4 << (int)(l & 7L));
            l += l2;
            nArray[(int)(l4 + l8)] = nArray[(int)l8] << 16 | n3;
            nArray[(int)(l4 + l8 + 1L)] = nArray[(int)(l8 + 1L)] << 16 | n2;
            ++l7;
        }
        CMCEEngine.sort32(nArray, (int)l4, (int)(l4 * 2L));
        l += (2L * l3 - 3L) * l2 * (l4 / 2L);
        long l9 = 0L;
        while (l9 < l4 / 2L) {
            long l10 = 2L * l9;
            n4 = nArray[(int)(l4 + l10)] & 1;
            n3 = (int)(l10 + (long)n4);
            n2 = n3 ^ 1;
            int n11 = (int)(l >> 3);
            byArray[n11] = (byte)(byArray[n11] ^ n4 << (int)(l & 7L));
            l += l2;
            nArray[(int)l10] = n3 << 16 | nArray[(int)(l4 + l10)] & 0xFFFF;
            nArray[(int)(l10 + 1L)] = n2 << 16 | nArray[(int)(l4 + l10 + 1L)] & 0xFFFF;
            ++l9;
        }
        CMCEEngine.sort32(nArray, 0, (int)l4);
        l -= (2L * l3 - 2L) * l2 * (l4 / 2L);
        short[] sArray2 = new short[(int)l4 * 4];
        l5 = 0L;
        while (l5 < l4 * 2L) {
            sArray2[(int)(l5 * 2L)] = (short)nArray[(int)l5];
            sArray2[(int)(l5 * 2L + 1L)] = (short)((nArray[(int)l5] & 0xFFFF0000) >> 16);
            ++l5;
        }
        l7 = 0L;
        while (l7 < l4 / 2L) {
            sArray2[(int)l7] = (short)((nArray[(int)(2L * l7)] & 0xFFFF) >>> 1);
            sArray2[(int)(l7 + l4 / 2L)] = (short)((nArray[(int)(2L * l7 + 1L)] & 0xFFFF) >>> 1);
            ++l7;
        }
        l5 = 0L;
        while (l5 < l4 / 2L) {
            nArray[(int)(l4 + l4 / 4L + l5)] = sArray2[(int)(l5 * 2L + 1L)] << 16 | sArray2[(int)(l5 * 2L)];
            ++l5;
        }
        CMCEEngine.cbrecursion(byArray, l, l2 * 2L, null, (int)(l4 + l4 / 4L) * 2, l3 - 1L, l4 / 2L, nArray);
        CMCEEngine.cbrecursion(byArray, l + l2, l2 * 2L, null, (int)((l4 + l4 / 4L) * 2L + l4 / 2L), l3 - 1L, l4 / 2L, nArray);
    }

    int check_c_padding(byte[] byArray) {
        byte by = (byte)((byArray[this.SYND_BYTES - 1] & 0xFF) >>> this.PK_NROWS % 8);
        by = (byte)(by - 1);
        byte by2 = by = (byte)((by & 0xFF) >>> 7);
        return by2 - 1;
    }

    int check_pk_padding(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.PK_NROWS) {
            n = (byte)(n | byArray[n2 * this.PK_ROW_BYTES + this.PK_ROW_BYTES - 1]);
            ++n2;
        }
        n = (byte)((n & 0xFF) >>> this.PK_NCOLS % 8);
        n = (byte)(n - 1);
        int n3 = n = (int)((byte)((n & 0xFF) >>> 7));
        return n3 - 1;
    }

    private static void controlbitsfrompermutation(byte[] byArray, short[] sArray, long l, long l2) {
        int n;
        int[] nArray = new int[(int)(2L * l2)];
        short[] sArray2 = new short[(int)l2];
        do {
            int n2 = 0;
            while ((long)n2 < ((2L * l - 1L) * l2 / 2L + 7L) / 8L) {
                byArray[n2] = 0;
                ++n2;
            }
            CMCEEngine.cbrecursion(byArray, 0L, 1L, sArray, 0, l, l2, nArray);
            n2 = 0;
            while ((long)n2 < l2) {
                sArray2[n2] = (short)n2;
                ++n2;
            }
            int n3 = 0;
            n2 = 0;
            while ((long)n2 < l) {
                CMCEEngine.layer(sArray2, byArray, n3, n2, (int)l2);
                n3 = (int)((long)n3 + (l2 >> 4));
                ++n2;
            }
            n2 = (int)(l - 2L);
            while (n2 >= 0) {
                CMCEEngine.layer(sArray2, byArray, n3, n2, (int)l2);
                n3 = (int)((long)n3 + (l2 >> 4));
                --n2;
            }
            n = 0;
            n2 = 0;
            while ((long)n2 < l2) {
                n = (short)(n | sArray[n2] ^ sArray2[n2]);
                ++n2;
            }
        } while (n != 0);
    }

    private static int ctz(long l) {
        long l2 = 0x101010101010101L;
        long l3 = 0L;
        long l4 = l ^ 0xFFFFFFFFFFFFFFFFL;
        int n = 0;
        while (n < 8) {
            l3 += (l2 &= l4 >>> n);
            ++n;
        }
        long l5 = l3 & 0x808080808080808L;
        l5 |= l5 >>> 1;
        l5 |= l5 >>> 2;
        long l6 = l3;
        l6 += (l3 >>>= 8) & l5;
        int n2 = 2;
        while (n2 < 8) {
            l5 &= l5 >>> 8;
            l6 += (l3 >>>= 8) & l5;
            ++n2;
        }
        return (int)l6 & 0xFF;
    }

    public byte[] decompress_private_key(byte[] byArray) {
        int n;
        Object[] objectArray;
        Object[] objectArray2;
        byte[] byArray2 = new byte[this.getPrivateKeySize()];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byte[] byArray3 = new byte[this.SYS_N / 8 + (1 << this.GFBITS) * 4 + this.IRR_BYTES + 32];
        int n2 = 0;
        SHAKEDigest sHAKEDigest = new SHAKEDigest(256);
        sHAKEDigest.update((byte)64);
        sHAKEDigest.update(byArray, 0, 32);
        sHAKEDigest.doFinal(byArray3, 0, byArray3.length);
        if (byArray.length <= 40) {
            objectArray2 = new short[this.SYS_T];
            objectArray = new byte[this.IRR_BYTES];
            n2 = byArray3.length - 32 - this.IRR_BYTES;
            n = 0;
            while (n < this.SYS_T) {
                objectArray2[n] = Utils.load_gf(byArray3, n2 + n * 2, this.GFMASK);
                ++n;
            }
            this.generate_irr_poly((short[])objectArray2);
            int n3 = 0;
            while (n3 < this.SYS_T) {
                Utils.store_gf(objectArray, n3 * 2, objectArray2[n3]);
                ++n3;
            }
            System.arraycopy(objectArray, 0, byArray2, 40, this.IRR_BYTES);
        }
        if (byArray.length <= 40 + this.IRR_BYTES) {
            Object[] objectArray3;
            objectArray2 = new int[1 << this.GFBITS];
            objectArray = new short[1 << this.GFBITS];
            n2 = byArray3.length - 32 - this.IRR_BYTES - (1 << this.GFBITS) * 4;
            n = 0;
            while (n < 1 << this.GFBITS) {
                objectArray2[n] = Utils.load4(byArray3, n2 + n * 4);
                ++n;
            }
            if (this.usePivots) {
                objectArray3 = new long[1];
                this.pk_gen(null, byArray2, (int[])objectArray2, (short[])objectArray, (long[])objectArray3);
            } else {
                objectArray3 = new long[1 << this.GFBITS];
                int n4 = 0;
                while (n4 < 1 << this.GFBITS) {
                    objectArray3[n4] = objectArray2[n4];
                    int n5 = n4;
                    objectArray3[n5] = objectArray3[n5] << 31;
                    int n6 = n4;
                    objectArray3[n6] = objectArray3[n6] | (long)n4;
                    int n7 = n4++;
                    objectArray3[n7] = objectArray3[n7] & Long.MAX_VALUE;
                }
                CMCEEngine.sort64(objectArray3, 0, objectArray3.length);
                int n8 = 0;
                while (n8 < 1 << this.GFBITS) {
                    objectArray[n8] = (short)(objectArray3[n8] & (long)this.GFMASK);
                    ++n8;
                }
            }
            objectArray3 = new byte[this.COND_BYTES];
            CMCEEngine.controlbitsfrompermutation((byte[])objectArray3, objectArray, this.GFBITS, 1 << this.GFBITS);
            System.arraycopy(objectArray3, 0, byArray2, this.IRR_BYTES + 40, objectArray3.length);
        }
        System.arraycopy(byArray3, 0, byArray2, this.getPrivateKeySize() - this.SYS_N / 8, this.SYS_N / 8);
        return byArray2;
    }

    private int decrypt(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        short[] sArray = new short[this.SYS_T + 1];
        short[] sArray2 = new short[this.SYS_N];
        short[] sArray3 = new short[this.SYS_T * 2];
        short[] sArray4 = new short[this.SYS_T * 2];
        short[] sArray5 = new short[this.SYS_T + 1];
        short[] sArray6 = new short[this.SYS_N];
        byte[] byArray4 = new byte[this.SYS_N / 8];
        int n = 0;
        while (n < this.SYND_BYTES) {
            byArray4[n] = byArray3[n];
            ++n;
        }
        int n2 = this.SYND_BYTES;
        while (n2 < this.SYS_N / 8) {
            byArray4[n2] = 0;
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.SYS_T) {
            sArray[n3] = Utils.load_gf(byArray2, 40 + n3 * 2, this.GFMASK);
            ++n3;
        }
        sArray[this.SYS_T] = 1;
        this.benes.support_gen(sArray2, byArray2);
        this.synd(sArray3, sArray, sArray2, byArray4);
        this.bm(sArray5, sArray3);
        this.root(sArray6, sArray5, sArray2);
        int n4 = 0;
        while (n4 < this.SYS_N / 8) {
            byArray[n4] = 0;
            ++n4;
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.SYS_N) {
            short s = (short)(this.gf.gf_iszero(sArray6[n6]) & 1);
            int n7 = n6 / 8;
            byArray[n7] = (byte)(byArray[n7] | s << n6 % 8);
            n5 += s;
            ++n6;
        }
        this.synd(sArray4, sArray, sArray2, byArray);
        int n8 = n5;
        n8 ^= this.SYS_T;
        int n9 = 0;
        while (n9 < this.SYS_T * 2) {
            n8 |= sArray3[n9] ^ sArray4[n9];
            ++n9;
        }
        --n8;
        n8 >>= 15;
        return (n8 &= 1) ^ 1;
    }

    private void encrypt(byte[] byArray, byte[] byArray2, byte[] byArray3, SecureRandom secureRandom) {
        this.generate_error_vector(byArray3, secureRandom);
        this.syndrome(byArray, byArray2, byArray3);
    }

    private short eval(short[] sArray, short s) {
        short s2 = sArray[this.SYS_T];
        int n = this.SYS_T - 1;
        while (n >= 0) {
            s2 = (short)(this.gf.gf_mul(s2, s) ^ sArray[n]);
            --n;
        }
        return s2;
    }

    private void generate_error_vector(byte[] byArray, SecureRandom secureRandom) {
        int n;
        short s;
        int n2;
        short[] sArray = new short[this.SYS_T * 2];
        short[] sArray2 = new short[this.SYS_T];
        byte[] byArray2 = new byte[this.SYS_T];
        while (true) {
            byte[] byArray3;
            if (this.countErrorIndices) {
                byArray3 = new byte[this.SYS_T * 4];
                secureRandom.nextBytes(byArray3);
                n2 = 0;
                while (n2 < this.SYS_T * 2) {
                    sArray[n2] = Utils.load_gf(byArray3, n2 * 2, this.GFMASK);
                    ++n2;
                }
                s = 0;
                n = 0;
                while (n < this.SYS_T * 2 && s < this.SYS_T) {
                    if (sArray[n] < this.SYS_N) {
                        sArray2[s++] = sArray[n];
                    }
                    ++n;
                }
                if (s < this.SYS_T) {
                    continue;
                }
            } else {
                byArray3 = new byte[this.SYS_T * 2];
                secureRandom.nextBytes(byArray3);
                n2 = 0;
                while (n2 < this.SYS_T) {
                    sArray2[n2] = Utils.load_gf(byArray3, n2 * 2, this.GFMASK);
                    ++n2;
                }
            }
            n2 = 0;
            s = 1;
            while (s < this.SYS_T && n2 != 1) {
                n = 0;
                while (n < s) {
                    if (sArray2[s] == sArray2[n]) {
                        n2 = 1;
                        break;
                    }
                    ++n;
                }
                ++s;
            }
            if (n2 == 0) break;
        }
        n2 = 0;
        while (n2 < this.SYS_T) {
            byArray2[n2] = (byte)(1 << (sArray2[n2] & 7));
            ++n2;
        }
        s = 0;
        while (s < this.SYS_N / 8) {
            byArray[s] = 0;
            n = 0;
            while (n < this.SYS_T) {
                short s2 = CMCEEngine.same_mask32(s, (short)(sArray2[n] >> 3));
                s2 = (short)(s2 & 0xFF);
                short s3 = s;
                byArray[s3] = (byte)(byArray[s3] | byArray2[n] & s2);
                ++n;
            }
            s = (short)(s + 1);
        }
    }

    private int generate_irr_poly(short[] sArray) {
        short[][] sArray2 = new short[this.SYS_T + 1][this.SYS_T];
        sArray2[0][0] = 1;
        System.arraycopy(sArray, 0, sArray2[1], 0, this.SYS_T);
        int[] nArray = new int[this.SYS_T * 2 - 1];
        int n = 2;
        while (n < this.SYS_T) {
            this.gf.gf_sqr_poly(this.SYS_T, this.poly, sArray2[n], sArray2[n >>> 1], nArray);
            this.gf.gf_mul_poly(this.SYS_T, this.poly, sArray2[n + 1], sArray2[n], sArray, nArray);
            n += 2;
        }
        if (n == this.SYS_T) {
            this.gf.gf_sqr_poly(this.SYS_T, this.poly, sArray2[n], sArray2[n >>> 1], nArray);
        }
        int n2 = 0;
        while (n2 < this.SYS_T) {
            int n3;
            short s;
            int n4 = n2 + 1;
            while (n4 < this.SYS_T) {
                s = this.gf.gf_iszero(sArray2[n2][n2]);
                n3 = n2;
                while (n3 < this.SYS_T + 1) {
                    short[] sArray3 = sArray2[n3];
                    int n5 = n2;
                    sArray3[n5] = (short)(sArray3[n5] ^ (short)(sArray2[n3][n4] & s));
                    ++n3;
                }
                ++n4;
            }
            if (sArray2[n2][n2] == 0) {
                return -1;
            }
            s = this.gf.gf_inv(sArray2[n2][n2]);
            n3 = n2;
            while (n3 < this.SYS_T + 1) {
                sArray2[n3][n2] = this.gf.gf_mul(sArray2[n3][n2], s);
                ++n3;
            }
            int n6 = 0;
            while (n6 < this.SYS_T) {
                if (n6 != n2) {
                    short s2 = sArray2[n2][n6];
                    int n7 = n2;
                    while (n7 <= this.SYS_T) {
                        short[] sArray4 = sArray2[n7];
                        int n8 = n6;
                        sArray4[n8] = (short)(sArray4[n8] ^ this.gf.gf_mul(sArray2[n7][n2], s2));
                        ++n7;
                    }
                }
                ++n6;
            }
            ++n2;
        }
        System.arraycopy(sArray2[this.SYS_T], 0, sArray, 0, this.SYS_T);
        return 0;
    }

    public byte[] generate_public_key_from_private_key(byte[] byArray) {
        byte[] byArray2 = new byte[this.getPublicKeySize()];
        short[] sArray = new short[1 << this.GFBITS];
        long[] lArray = new long[1];
        int[] nArray = new int[1 << this.GFBITS];
        byte[] byArray3 = new byte[this.SYS_N / 8 + (1 << this.GFBITS) * 4];
        int n = byArray3.length - 32 - this.IRR_BYTES - (1 << this.GFBITS) * 4;
        SHAKEDigest sHAKEDigest = new SHAKEDigest(256);
        sHAKEDigest.update((byte)64);
        sHAKEDigest.update(byArray, 0, 32);
        sHAKEDigest.doFinal(byArray3, 0, byArray3.length);
        int n2 = 0;
        while (n2 < 1 << this.GFBITS) {
            nArray[n2] = Utils.load4(byArray3, n + n2 * 4);
            ++n2;
        }
        this.pk_gen(byArray2, byArray, nArray, sArray, lArray);
        return byArray2;
    }

    public int getCipherTextSize() {
        return this.SYND_BYTES;
    }

    public int getCondBytes() {
        return this.COND_BYTES;
    }

    public int getDefaultSessionKeySize() {
        return this.defaultKeySize;
    }

    public int getIrrBytes() {
        return this.IRR_BYTES;
    }

    public int getPrivateKeySize() {
        return this.COND_BYTES + this.IRR_BYTES + this.SYS_N / 8 + 40;
    }

    public int getPublicKeySize() {
        if (this.usePadding) {
            return this.PK_NROWS * (this.SYS_N / 8 - (this.PK_NROWS - 1) / 8);
        }
        return this.PK_NROWS * this.PK_NCOLS / 8;
    }

    static short get_q_short(int[] nArray, int n) {
        int n2 = n / 2;
        if (n % 2 == 0) {
            return (short)nArray[n2];
        }
        return (short)((nArray[n2] & 0xFFFF0000) >> 16);
    }

    public int kem_dec(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[this.SYS_N / 8];
        byte[] byArray5 = new byte[1 + this.SYS_N / 8 + this.SYND_BYTES];
        int n = 0;
        if (this.usePadding) {
            n = this.check_c_padding(byArray2);
        }
        byte by = (byte)this.decrypt(byArray4, byArray3, byArray2);
        short s = by;
        s = (short)(s - 1);
        s = (short)(s >> 8);
        s = (short)(s & 0xFF);
        byArray5[0] = (byte)(s & 1);
        int n2 = 0;
        while (n2 < this.SYS_N / 8) {
            byArray5[1 + n2] = (byte)(~s & byArray3[n2 + 40 + this.IRR_BYTES + this.COND_BYTES] | s & byArray4[n2]);
            ++n2;
        }
        n2 = 0;
        while (n2 < this.SYND_BYTES) {
            byArray5[1 + this.SYS_N / 8 + n2] = byArray2[n2];
            ++n2;
        }
        SHAKEDigest sHAKEDigest = new SHAKEDigest(256);
        sHAKEDigest.update(byArray5, 0, byArray5.length);
        sHAKEDigest.doFinal(byArray, 0, byArray.length);
        if (this.usePadding) {
            byte by2 = (byte)n;
            n2 = 0;
            while (n2 < byArray.length) {
                int n3 = n2++;
                byArray[n3] = (byte)(byArray[n3] | by2);
            }
            return n;
        }
        return 0;
    }

    public int kem_enc(byte[] byArray, byte[] byArray2, byte[] byArray3, SecureRandom secureRandom) {
        byte[] byArray4 = new byte[this.SYS_N / 8];
        int n = 0;
        if (this.usePadding) {
            n = this.check_pk_padding(byArray3);
        }
        this.encrypt(byArray, byArray3, byArray4, secureRandom);
        SHAKEDigest sHAKEDigest = new SHAKEDigest(256);
        sHAKEDigest.update((byte)1);
        sHAKEDigest.update(byArray4, 0, byArray4.length);
        sHAKEDigest.update(byArray, 0, byArray.length);
        sHAKEDigest.doFinal(byArray2, 0, byArray2.length);
        if (this.usePadding) {
            byte by = (byte)n;
            by = (byte)(by ^ 0xFF);
            int n2 = 0;
            while (n2 < this.SYND_BYTES) {
                int n3 = n2++;
                byArray[n3] = (byte)(byArray[n3] & by);
            }
            n2 = 0;
            while (n2 < 32) {
                int n4 = n2++;
                byArray2[n4] = (byte)(byArray2[n4] & by);
            }
            return n;
        }
        return 0;
    }

    public void kem_keypair(byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
        short[] sArray;
        byte[] byArray3 = new byte[1];
        byte[] byArray4 = new byte[32];
        byArray3[0] = 64;
        secureRandom.nextBytes(byArray4);
        byte[] byArray5 = new byte[this.SYS_N / 8 + (1 << this.GFBITS) * 4 + this.SYS_T * 2 + 32];
        int n = 0;
        byte[] byArray6 = byArray4;
        long[] lArray = new long[1];
        SHAKEDigest sHAKEDigest = new SHAKEDigest(256);
        while (true) {
            int n2;
            sHAKEDigest.update(byArray3, 0, byArray3.length);
            sHAKEDigest.update(byArray4, 0, byArray4.length);
            sHAKEDigest.doFinal(byArray5, 0, byArray5.length);
            int n3 = byArray5.length - 32;
            byArray4 = Arrays.copyOfRange(byArray5, n3, n3 + 32);
            System.arraycopy(byArray6, 0, byArray2, 0, 32);
            byArray6 = Arrays.copyOfRange(byArray4, 0, 32);
            short[] sArray2 = new short[this.SYS_T];
            n3 = n2 = byArray5.length - 32 - 2 * this.SYS_T;
            int n4 = 0;
            while (n4 < this.SYS_T) {
                sArray2[n4] = Utils.load_gf(byArray5, n2 + n4 * 2, this.GFMASK);
                ++n4;
            }
            if (this.generate_irr_poly(sArray2) == -1) continue;
            n = 40;
            int n5 = 0;
            while (n5 < this.SYS_T) {
                Utils.store_gf(byArray2, n + n5 * 2, sArray2[n5]);
                ++n5;
            }
            int[] nArray = new int[1 << this.GFBITS];
            n3 -= (1 << this.GFBITS) * 4;
            int n6 = 0;
            while (n6 < 1 << this.GFBITS) {
                nArray[n6] = Utils.load4(byArray5, n3 + n6 * 4);
                ++n6;
            }
            sArray = new short[1 << this.GFBITS];
            if (this.pk_gen(byArray, byArray2, nArray, sArray, lArray) != -1) break;
        }
        byte[] byArray7 = new byte[this.COND_BYTES];
        CMCEEngine.controlbitsfrompermutation(byArray7, sArray, this.GFBITS, 1 << this.GFBITS);
        System.arraycopy(byArray7, 0, byArray2, this.IRR_BYTES + 40, byArray7.length);
        System.arraycopy(byArray5, n3 -= this.SYS_N / 8, byArray2, byArray2.length - this.SYS_N / 8, this.SYS_N / 8);
        if (!this.usePivots) {
            Utils.store8(byArray2, 32, 0xFFFFFFFFL);
        } else {
            Utils.store8(byArray2, 32, lArray[0]);
        }
    }

    private static void layer(short[] sArray, byte[] byArray, int n, int n2, int n3) {
        int n4 = 1 << n2;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            int n7 = 0;
            while (n7 < n4) {
                int n8 = sArray[n6 + n7] ^ sArray[n6 + n7 + n4];
                int n9 = byArray[n + (n5 >> 3)] >> (n5 & 7) & 1;
                n9 = -n9;
                int n10 = n6 + n7;
                sArray[n10] = (short)(sArray[n10] ^ (n8 &= n9));
                int n11 = n6 + n7 + n4;
                sArray[n11] = (short)(sArray[n11] ^ n8);
                ++n5;
                ++n7;
            }
            n6 += n4 * 2;
        }
    }

    private static int min(short s, int n) {
        if (s < n) {
            return s;
        }
        return n;
    }

    private int mov_columns(byte[][] byArray, short[] sArray, long[] lArray) {
        long l;
        int n;
        long l2;
        int n2;
        int n3;
        long[] lArray2 = new long[64];
        long[] lArray3 = new long[32];
        long l3 = 1L;
        byte[] byArray2 = new byte[9];
        int n4 = this.PK_NROWS - 32;
        int n5 = n4 / 8;
        int n6 = n4 % 8;
        if (this.usePadding) {
            n3 = 0;
            while (n3 < 32) {
                n2 = 0;
                while (n2 < 9) {
                    byArray2[n2] = byArray[n4 + n3][n5 + n2];
                    ++n2;
                }
                n2 = 0;
                while (n2 < 8) {
                    byArray2[n2] = (byte)((byArray2[n2] & 0xFF) >> n6 | byArray2[n2 + 1] << 8 - n6);
                    ++n2;
                }
                lArray2[n3] = Utils.load8(byArray2, 0);
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < 32) {
                lArray2[n3] = Utils.load8(byArray[n4 + n3], n5);
                ++n3;
            }
        }
        lArray[0] = 0L;
        n3 = 0;
        while (n3 < 32) {
            long l4;
            l2 = lArray2[n3];
            n2 = n3 + 1;
            while (n2 < 32) {
                l2 |= lArray2[n2];
                ++n2;
            }
            if (l2 == 0L) {
                return -1;
            }
            int n7 = CMCEEngine.ctz(l2);
            lArray3[n3] = n7;
            lArray[0] = lArray[0] | l3 << (int)lArray3[n3];
            n2 = n3 + 1;
            while (n2 < 32) {
                l4 = lArray2[n3] >> n7 & 1L;
                int n8 = n3;
                lArray2[n8] = lArray2[n8] ^ lArray2[n2] & --l4;
                ++n2;
            }
            n2 = n3 + 1;
            while (n2 < 32) {
                l4 = lArray2[n2] >> n7 & 1L;
                l4 = -l4;
                int n9 = n2++;
                lArray2[n9] = lArray2[n9] ^ lArray2[n3] & l4;
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < 32) {
            n = n2 + 1;
            while (n < 64) {
                l = sArray[n4 + n2] ^ sArray[n4 + n];
                int n10 = n4 + n2;
                sArray[n10] = (short)((long)sArray[n10] ^ (l &= CMCEEngine.same_mask64((short)n, (short)lArray3[n2])));
                int n11 = n4 + n;
                sArray[n11] = (short)((long)sArray[n11] ^ l);
                ++n;
            }
            ++n2;
        }
        n3 = 0;
        while (n3 < this.PK_NROWS) {
            if (this.usePadding) {
                n = 0;
                while (n < 9) {
                    byArray2[n] = byArray[n3][n5 + n];
                    ++n;
                }
                n = 0;
                while (n < 8) {
                    byArray2[n] = (byte)((byArray2[n] & 0xFF) >> n6 | byArray2[n + 1] << 8 - n6);
                    ++n;
                }
                l2 = Utils.load8(byArray2, 0);
            } else {
                l2 = Utils.load8(byArray[n3], n5);
            }
            n2 = 0;
            while (n2 < 32) {
                l = l2 >> n2;
                l ^= l2 >> (int)lArray3[n2];
                l2 ^= (l &= 1L) << (int)lArray3[n2];
                l2 ^= l << n2;
                ++n2;
            }
            if (this.usePadding) {
                Utils.store8(byArray2, 0, l2);
                byArray[n3][n5 + 8] = (byte)((byArray[n3][n5 + 8] & 0xFF) >>> n6 << n6 | (byArray2[7] & 0xFF) >>> 8 - n6);
                byArray[n3][n5] = (byte)((byArray2[0] & 0xFF) << n6 | (byArray[n3][n5] & 0xFF) << 8 - n6 >>> 8 - n6);
                n = 7;
                while (n >= 1) {
                    byArray[n3][n5 + n] = (byte)((byArray2[n] & 0xFF) << n6 | (byArray2[n - 1] & 0xFF) >>> 8 - n6);
                    --n;
                }
            } else {
                Utils.store8(byArray[n3], n5, l2);
            }
            ++n3;
        }
        return 0;
    }

    private int pk_gen(byte[] byArray, byte[] byArray2, int[] nArray, short[] sArray, long[] lArray) {
        block28: {
            int n;
            int n2;
            short[] sArray2 = new short[this.SYS_T + 1];
            sArray2[this.SYS_T] = 1;
            int n3 = 0;
            while (n3 < this.SYS_T) {
                sArray2[n3] = Utils.load_gf(byArray2, 40 + n3 * 2, this.GFMASK);
                ++n3;
            }
            long[] lArray2 = new long[1 << this.GFBITS];
            n3 = 0;
            while (n3 < 1 << this.GFBITS) {
                lArray2[n3] = nArray[n3];
                int n4 = n3;
                lArray2[n4] = lArray2[n4] << 31;
                int n5 = n3;
                lArray2[n5] = lArray2[n5] | (long)n3;
                int n6 = n3++;
                lArray2[n6] = lArray2[n6] & Long.MAX_VALUE;
            }
            CMCEEngine.sort64(lArray2, 0, lArray2.length);
            n3 = 1;
            while (n3 < 1 << this.GFBITS) {
                if (lArray2[n3 - 1] >> 31 == lArray2[n3] >> 31) {
                    return -1;
                }
                ++n3;
            }
            short[] sArray3 = new short[this.SYS_N];
            n3 = 0;
            while (n3 < 1 << this.GFBITS) {
                sArray[n3] = (short)(lArray2[n3] & (long)this.GFMASK);
                ++n3;
            }
            n3 = 0;
            while (n3 < this.SYS_N) {
                sArray3[n3] = Utils.bitrev(sArray[n3], this.GFBITS);
                ++n3;
            }
            short[] sArray4 = new short[this.SYS_N];
            this.root(sArray4, sArray2, sArray3);
            n3 = 0;
            while (n3 < this.SYS_N) {
                sArray4[n3] = this.gf.gf_inv(sArray4[n3]);
                ++n3;
            }
            byte[][] byArray3 = new byte[this.PK_NROWS][this.SYS_N / 8];
            n3 = 0;
            while (n3 < this.PK_NROWS) {
                n2 = 0;
                while (n2 < this.SYS_N / 8) {
                    byArray3[n3][n2] = 0;
                    ++n2;
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < this.SYS_T) {
                n2 = 0;
                while (n2 < this.SYS_N) {
                    n = 0;
                    while (n < this.GFBITS) {
                        byte by = (byte)(sArray4[n2 + 7] >>> n & 1);
                        by = (byte)(by << 1);
                        by = (byte)(by | sArray4[n2 + 6] >>> n & 1);
                        by = (byte)(by << 1);
                        by = (byte)(by | sArray4[n2 + 5] >>> n & 1);
                        by = (byte)(by << 1);
                        by = (byte)(by | sArray4[n2 + 4] >>> n & 1);
                        by = (byte)(by << 1);
                        by = (byte)(by | sArray4[n2 + 3] >>> n & 1);
                        by = (byte)(by << 1);
                        by = (byte)(by | sArray4[n2 + 2] >>> n & 1);
                        by = (byte)(by << 1);
                        by = (byte)(by | sArray4[n2 + 1] >>> n & 1);
                        by = (byte)(by << 1);
                        byArray3[n3 * this.GFBITS + n][n2 / 8] = by = (byte)(by | sArray4[n2] >>> n & 1);
                        ++n;
                    }
                    n2 += 8;
                }
                n2 = 0;
                while (n2 < this.SYS_N) {
                    sArray4[n2] = this.gf.gf_mul(sArray4[n2], sArray3[n2]);
                    ++n2;
                }
                ++n3;
            }
            int n7 = 0;
            while (n7 < this.PK_NROWS) {
                int n8;
                byte by;
                n3 = n7 >>> 3;
                n2 = n7 & 7;
                if (this.usePivots && n7 == this.PK_NROWS - 32 && this.mov_columns(byArray3, sArray, lArray) != 0) {
                    return -1;
                }
                n = n7 + 1;
                while (n < this.PK_NROWS) {
                    by = (byte)(byArray3[n7][n3] ^ byArray3[n][n3]);
                    by = (byte)(by >> n2);
                    by = (byte)(by & 1);
                    by = -by;
                    n8 = 0;
                    while (n8 < this.SYS_N / 8) {
                        byte[] byArray4 = byArray3[n7];
                        int n9 = n8;
                        byArray4[n9] = (byte)(byArray4[n9] ^ byArray3[n][n8] & by);
                        ++n8;
                    }
                    ++n;
                }
                if ((byArray3[n7][n3] >> n2 & 1) == 0) {
                    return -1;
                }
                n = 0;
                while (n < this.PK_NROWS) {
                    if (n != n7) {
                        by = (byte)(byArray3[n][n3] >> n2);
                        by = (byte)(by & 1);
                        by = -by;
                        n8 = 0;
                        while (n8 < this.SYS_N / 8) {
                            byte[] byArray5 = byArray3[n];
                            int n10 = n8;
                            byArray5[n10] = (byte)(byArray5[n10] ^ byArray3[n7][n8] & by);
                            ++n8;
                        }
                    }
                    ++n;
                }
                ++n7;
            }
            if (byArray == null) break block28;
            if (this.usePadding) {
                int n11 = 0;
                int n12 = this.PK_NROWS % 8;
                if (n12 == 0) {
                    System.arraycopy(byArray3[n3], (this.PK_NROWS - 1) / 8, byArray, n11, this.SYS_N / 8);
                    n11 += this.SYS_N / 8;
                } else {
                    n3 = 0;
                    while (n3 < this.PK_NROWS) {
                        n2 = (this.PK_NROWS - 1) / 8;
                        while (n2 < this.SYS_N / 8 - 1) {
                            byArray[n11++] = (byte)((byArray3[n3][n2] & 0xFF) >>> n12 | byArray3[n3][n2 + 1] << 8 - n12);
                            ++n2;
                        }
                        byArray[n11++] = (byte)((byArray3[n3][n2] & 0xFF) >>> n12);
                        ++n3;
                    }
                }
            } else {
                int n13 = (this.SYS_N - this.PK_NROWS + 7) / 8;
                n3 = 0;
                while (n3 < this.PK_NROWS) {
                    System.arraycopy(byArray3[n3], this.PK_NROWS / 8, byArray, n13 * n3, n13);
                    ++n3;
                }
            }
        }
        return 0;
    }

    private void root(short[] sArray, short[] sArray2, short[] sArray3) {
        int n = 0;
        while (n < this.SYS_N) {
            sArray[n] = this.eval(sArray2, sArray3[n]);
            ++n;
        }
    }

    private static byte same_mask32(short s, short s2) {
        int n = s ^ s2;
        --n;
        n >>>= 31;
        n = -n;
        return (byte)(n & 0xFF);
    }

    private static long same_mask64(short s, short s2) {
        long l = s ^ s2;
        --l;
        l >>>= 63;
        l = -l;
        return l;
    }

    /*
     * Unable to fully structure code
     */
    private static void sort32(int[] var0, int var1_1, int var2_2) {
        var8_3 = var2_2 - var1_1;
        if (var8_3 < 2) {
            return;
        }
        var3_4 = 1;
        while (var3_4 < var8_3 - var3_4) {
            var3_4 += var3_4;
        }
        var4_5 = var3_4;
        while (var4_5 > 0) {
            var7_8 = 0;
            while (var7_8 < var8_3 - var4_5) {
                if ((var7_8 & var4_5) == 0) {
                    var9_9 = var0[var1_1 + var7_8 + var4_5] ^ var0[var1_1 + var7_8];
                    var10_10 = var0[var1_1 + var7_8 + var4_5] - var0[var1_1 + var7_8];
                    var10_10 ^= var9_9 & (var10_10 ^ var0[var1_1 + var7_8 + var4_5]);
                    var10_10 >>= 31;
                    v0 = var1_1 + var7_8;
                    var0[v0] = var0[v0] ^ (var10_10 &= var9_9);
                    v1 = var1_1 + var7_8 + var4_5;
                    var0[v1] = var0[v1] ^ var10_10;
                }
                ++var7_8;
            }
            var7_8 = 0;
            var5_6 = var3_4;
            ** GOTO lbl44
            {
                if ((var7_8 & var4_5) == 0) {
                    var9_9 = var0[var1_1 + var7_8 + var4_5];
                    var6_7 = var5_6;
                    while (var6_7 > var4_5) {
                        var10_10 = var0[var1_1 + var7_8 + var6_7] ^ var9_9;
                        var11_11 = var0[var1_1 + var7_8 + var6_7] - var9_9;
                        var11_11 ^= var10_10 & (var11_11 ^ var0[var1_1 + var7_8 + var6_7]);
                        var11_11 >>= 31;
                        var9_9 ^= (var11_11 &= var10_10);
                        v2 = var1_1 + var7_8 + var6_7;
                        var0[v2] = var0[v2] ^ var11_11;
                        var6_7 >>>= 1;
                    }
                    var0[var1_1 + var7_8 + var4_5] = var9_9;
                }
                ++var7_8;
                do {
                    if (var7_8 < var8_3 - var5_6) continue block3;
                    var5_6 >>>= 1;
lbl44:
                    // 2 sources

                } while (var5_6 > var4_5);
            }
            var4_5 >>>= 1;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void sort64(long[] var0, int var1_1, int var2_2) {
        var8_3 = var2_2 - var1_1;
        if (var8_3 < 2) {
            return;
        }
        var3_4 = 1;
        while (var3_4 < var8_3 - var3_4) {
            var3_4 += var3_4;
        }
        var4_5 = var3_4;
        while (var4_5 > 0) {
            var7_8 = 0;
            while (var7_8 < var8_3 - var4_5) {
                if ((var7_8 & var4_5) == 0) {
                    var9_9 = var0[var1_1 + var7_8 + var4_5] - var0[var1_1 + var7_8];
                    var9_9 >>>= 63;
                    var9_9 = -var9_9;
                    v0 = var1_1 + var7_8;
                    var0[v0] = var0[v0] ^ (var9_9 &= var0[var1_1 + var7_8] ^ var0[var1_1 + var7_8 + var4_5]);
                    v1 = var1_1 + var7_8 + var4_5;
                    var0[v1] = var0[v1] ^ var9_9;
                }
                ++var7_8;
            }
            var7_8 = 0;
            var5_6 = var3_4;
            ** GOTO lbl42
            {
                if ((var7_8 & var4_5) == 0) {
                    var9_9 = var0[var1_1 + var7_8 + var4_5];
                    var6_7 = var5_6;
                    while (var6_7 > var4_5) {
                        var11_10 = var0[var1_1 + var7_8 + var6_7] - var9_9;
                        var11_10 >>>= 63;
                        var11_10 = -var11_10;
                        var9_9 ^= (var11_10 &= var9_9 ^ var0[var1_1 + var7_8 + var6_7]);
                        v2 = var1_1 + var7_8 + var6_7;
                        var0[v2] = var0[v2] ^ var11_10;
                        var6_7 >>>= 1;
                    }
                    var0[var1_1 + var7_8 + var4_5] = var9_9;
                }
                ++var7_8;
                do {
                    if (var7_8 < var8_3 - var5_6) continue block3;
                    var5_6 >>>= 1;
lbl42:
                    // 2 sources

                } while (var5_6 > var4_5);
            }
            var4_5 >>>= 1;
        }
    }

    private void synd(short[] sArray, short[] sArray2, short[] sArray3, byte[] byArray) {
        short s;
        short s2 = (short)(byArray[0] & 1);
        short s3 = sArray3[0];
        short s4 = this.eval(sArray2, s3);
        short s5 = this.gf.gf_inv(this.gf.gf_sq(s4));
        sArray[0] = s = (short)(s5 & -s2);
        int n = 1;
        while (n < 2 * this.SYS_T) {
            sArray[n] = s = this.gf.gf_mul(s, s3);
            ++n;
        }
        int n2 = 1;
        while (n2 < this.SYS_N) {
            short s6 = (short)(byArray[n2 / 8] >> n2 % 8 & 1);
            short s7 = sArray3[n2];
            short s8 = this.eval(sArray2, s7);
            short s9 = this.gf.gf_inv(this.gf.gf_sq(s8));
            short s10 = this.gf.gf_mul(s9, s6);
            sArray[0] = (short)(sArray[0] ^ s10);
            int n3 = 1;
            while (n3 < 2 * this.SYS_T) {
                s10 = this.gf.gf_mul(s10, s7);
                int n4 = n3++;
                sArray[n4] = (short)(sArray[n4] ^ s10);
            }
            ++n2;
        }
    }

    private void syndrome(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        short[] sArray = new short[this.SYS_N / 8];
        int n = 0;
        int n2 = this.PK_NROWS % 8;
        int n3 = 0;
        while (n3 < this.SYND_BYTES) {
            byArray[n3] = 0;
            ++n3;
        }
        n3 = 0;
        while (n3 < this.PK_NROWS) {
            int n4 = 0;
            while (n4 < this.SYS_N / 8) {
                sArray[n4] = 0;
                ++n4;
            }
            n4 = 0;
            while (n4 < this.PK_ROW_BYTES) {
                sArray[this.SYS_N / 8 - this.PK_ROW_BYTES + n4] = byArray2[n + n4];
                ++n4;
            }
            if (this.usePadding) {
                n4 = this.SYS_N / 8 - 1;
                while (n4 >= this.SYS_N / 8 - this.PK_ROW_BYTES) {
                    sArray[n4] = (short)(((sArray[n4] & 0xFF) << n2 | (sArray[n4 - 1] & 0xFF) >>> 8 - n2) & 0xFF);
                    --n4;
                }
            }
            int n5 = n3 / 8;
            sArray[n5] = (short)(sArray[n5] | 1 << n3 % 8);
            int n6 = 0;
            n4 = 0;
            while (n4 < this.SYS_N / 8) {
                n6 = (byte)(n6 ^ sArray[n4] & byArray3[n4]);
                ++n4;
            }
            n6 = (byte)(n6 ^ n6 >>> 4);
            n6 = (byte)(n6 ^ n6 >>> 2);
            n6 = (byte)(n6 ^ n6 >>> 1);
            n6 = (byte)(n6 & 1);
            int n7 = n3 / 8;
            byArray[n7] = (byte)(byArray[n7] | n6 << n3 % 8);
            n += this.PK_ROW_BYTES;
            ++n3;
        }
    }
}

