/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.bike;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.math.raw.Interleave;
import org.bouncycastle.math.raw.Mod;
import org.bouncycastle.math.raw.Nat;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Pack;

class BIKERing {
    private static final int PERMUTATION_CUTOFF = 64;
    private final int bits;
    private final int size;
    private final int sizeExt;
    private final Map halfPowers = new HashMap();

    BIKERing(int n) {
        if ((n & 0xFFFF0001) != 1) {
            throw new IllegalArgumentException();
        }
        this.bits = n;
        this.size = n + 63 >>> 6;
        this.sizeExt = this.size * 2;
        BIKERing.generateHalfPowersInv(this.halfPowers, n);
    }

    void add(long[] lArray, long[] lArray2, long[] lArray3) {
        int n = 0;
        while (n < this.size) {
            lArray3[n] = lArray[n] ^ lArray2[n];
            ++n;
        }
    }

    void addTo(long[] lArray, long[] lArray2) {
        int n = 0;
        while (n < this.size) {
            int n2 = n;
            lArray2[n2] = lArray2[n2] ^ lArray[n];
            ++n;
        }
    }

    void copy(long[] lArray, long[] lArray2) {
        int n = 0;
        while (n < this.size) {
            lArray2[n] = lArray[n];
            ++n;
        }
    }

    long[] create() {
        return new long[this.size];
    }

    long[] createExt() {
        return new long[this.sizeExt];
    }

    void decodeBytes(byte[] byArray, long[] lArray) {
        int n = this.bits & 0x3F;
        Pack.littleEndianToLong(byArray, 0, lArray, 0, this.size - 1);
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, this.size - 1 << 3, byArray2, 0, n + 7 >>> 3);
        lArray[this.size - 1] = Pack.littleEndianToLong(byArray2, 0);
    }

    byte[] encodeBitsTransposed(long[] lArray) {
        byte[] byArray = new byte[this.bits];
        byArray[0] = (byte)(lArray[0] & 1L);
        int n = 1;
        while (n < this.bits) {
            byArray[this.bits - n] = (byte)(lArray[n >>> 6] >>> (n & 0x3F) & 1L);
            ++n;
        }
        return byArray;
    }

    void encodeBytes(long[] lArray, byte[] byArray) {
        int n = this.bits & 0x3F;
        Pack.longToLittleEndian(lArray, 0, this.size - 1, byArray, 0);
        byte[] byArray2 = new byte[8];
        Pack.longToLittleEndian(lArray[this.size - 1], byArray2, 0);
        System.arraycopy(byArray2, 0, byArray, this.size - 1 << 3, n + 7 >>> 3);
    }

    private static int generateHalfPower(int n, int n2, int n3) {
        int n4;
        int n5 = 1;
        int n6 = n3;
        while (n6 >= 32) {
            n4 = n2 * n5;
            long l = ((long)n4 & 0xFFFFFFFFL) * (long)n;
            long l2 = l + (long)n5;
            n5 = (int)(l2 >>> 32);
            n6 -= 32;
        }
        if (n6 > 0) {
            n4 = -1 >>> -n6;
            int n7 = n2 * n5 & n4;
            long l = ((long)n7 & 0xFFFFFFFFL) * (long)n;
            long l3 = l + (long)n5;
            n5 = (int)(l3 >>> n6);
        }
        return n5;
    }

    private static void generateHalfPowersInv(Map map, int n) {
        int n2 = n - 2;
        int n3 = 32 - Integers.numberOfLeadingZeros(n2);
        int n4 = Mod.inverse32(-n);
        int n5 = 1;
        while (n5 < n3) {
            int n6;
            int n7 = 1 << n5 - 1;
            if (n7 >= 64 && !map.containsKey(Integers.valueOf(n7))) {
                map.put(Integers.valueOf(n7), Integers.valueOf(BIKERing.generateHalfPower(n, n4, n7)));
            }
            if ((n2 & 1 << n5) != 0 && (n6 = n2 & (1 << n5) - 1) >= 64 && !map.containsKey(Integers.valueOf(n6))) {
                map.put(Integers.valueOf(n6), Integers.valueOf(BIKERing.generateHalfPower(n, n4, n6)));
            }
            ++n5;
        }
    }

    int getSize() {
        return this.size;
    }

    int getSizeExt() {
        return this.sizeExt;
    }

    private static int implModAdd(int n, int n2, int n3) {
        int n4 = n2 + n3 - n;
        return n4 + (n4 >> 31 & n);
    }

    protected void implMultiplyAcc(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = new long[16];
        int n = 0;
        while (n < this.size) {
            BIKERing.implMulwAcc(lArray4, lArray[n], lArray2[n], lArray3, n << 1);
            ++n;
        }
        long l = lArray3[0];
        long l2 = lArray3[1];
        int n2 = 1;
        while (n2 < this.size) {
            lArray3[n2] = (l ^= lArray3[n2 << 1]) ^ l2;
            l2 ^= lArray3[(n2 << 1) + 1];
            ++n2;
        }
        long l3 = l ^ l2;
        int n3 = 0;
        while (n3 < this.size) {
            lArray3[this.size + n3] = lArray3[n3] ^ l3;
            ++n3;
        }
        int n4 = this.size - 1;
        int n5 = 1;
        while (n5 < n4 * 2) {
            int n6 = Math.min(n4, n5);
            int n7 = n5 - n6;
            while (n7 < n6) {
                BIKERing.implMulwAcc(lArray4, lArray[n7] ^ lArray[n6], lArray2[n7] ^ lArray2[n6], lArray3, n5);
                ++n7;
                --n6;
            }
            ++n5;
        }
    }

    private static void implMulwAcc(long[] lArray, long l, long l2, long[] lArray2, int n) {
        lArray[1] = l2;
        int n2 = 2;
        while (n2 < 16) {
            lArray[n2] = lArray[n2 >>> 1] << 1;
            lArray[n2 + 1] = lArray[n2] ^ l2;
            n2 += 2;
        }
        int n3 = (int)l;
        long l3 = 0L;
        long l4 = lArray[n3 & 0xF] ^ lArray[n3 >>> 4 & 0xF] << 4;
        int n4 = 56;
        do {
            n3 = (int)(l >>> n4);
            long l5 = lArray[n3 & 0xF] ^ lArray[n3 >>> 4 & 0xF] << 4;
            l4 ^= l5 << n4;
            l3 ^= l5 >>> -n4;
        } while ((n4 -= 8) > 0);
        int n5 = 0;
        while (n5 < 7) {
            l = (l & 0xFEFEFEFEFEFEFEFEL) >>> 1;
            l3 ^= l & l2 << n5 >> 63;
            ++n5;
        }
        int n6 = n;
        lArray2[n6] = lArray2[n6] ^ l4;
        int n7 = n + 1;
        lArray2[n7] = lArray2[n7] ^ l3;
    }

    private void implPermute(long[] lArray, int n, long[] lArray2) {
        int n2 = this.bits;
        int n3 = (Integer)this.halfPowers.get(Integers.valueOf(n));
        int n4 = BIKERing.implModAdd(n2, n3, n3);
        int n5 = BIKERing.implModAdd(n2, n4, n4);
        int n6 = BIKERing.implModAdd(n2, n5, n5);
        int n7 = n2 - n6;
        int n8 = BIKERing.implModAdd(n2, n7, n3);
        int n9 = BIKERing.implModAdd(n2, n7, n4);
        int n10 = BIKERing.implModAdd(n2, n8, n4);
        int n11 = BIKERing.implModAdd(n2, n7, n5);
        int n12 = BIKERing.implModAdd(n2, n8, n5);
        int n13 = BIKERing.implModAdd(n2, n9, n5);
        int n14 = BIKERing.implModAdd(n2, n10, n5);
        int n15 = 0;
        while (n15 < this.size) {
            long l = 0L;
            int n16 = 0;
            while (n16 < 64) {
                n7 = BIKERing.implModAdd(n2, n7, n6);
                n8 = BIKERing.implModAdd(n2, n8, n6);
                n9 = BIKERing.implModAdd(n2, n9, n6);
                n10 = BIKERing.implModAdd(n2, n10, n6);
                n11 = BIKERing.implModAdd(n2, n11, n6);
                n12 = BIKERing.implModAdd(n2, n12, n6);
                n13 = BIKERing.implModAdd(n2, n13, n6);
                n14 = BIKERing.implModAdd(n2, n14, n6);
                l |= (lArray[n7 >>> 6] >>> n7 & 1L) << n16;
                l |= (lArray[n8 >>> 6] >>> n8 & 1L) << n16 + 1;
                l |= (lArray[n9 >>> 6] >>> n9 & 1L) << n16 + 2;
                l |= (lArray[n10 >>> 6] >>> n10 & 1L) << n16 + 3;
                l |= (lArray[n11 >>> 6] >>> n11 & 1L) << n16 + 4;
                l |= (lArray[n12 >>> 6] >>> n12 & 1L) << n16 + 5;
                l |= (lArray[n13 >>> 6] >>> n13 & 1L) << n16 + 6;
                l |= (lArray[n14 >>> 6] >>> n14 & 1L) << n16 + 7;
                n16 += 8;
            }
            lArray2[n15] = l;
            ++n15;
        }
        int n17 = this.size - 1;
        lArray2[n17] = lArray2[n17] & -1L >>> -n2;
    }

    private void implSquare(long[] lArray, long[] lArray2) {
        Interleave.expand64To128(lArray, 0, this.size, lArray2, 0);
    }

    void inv(long[] lArray, long[] lArray2) {
        long[] lArray3 = this.create();
        long[] lArray4 = this.create();
        long[] lArray5 = this.create();
        this.copy(lArray, lArray3);
        this.copy(lArray, lArray5);
        int n = this.bits - 2;
        int n2 = 32 - Integers.numberOfLeadingZeros(n);
        int n3 = 1;
        while (n3 < n2) {
            this.squareN(lArray3, 1 << n3 - 1, lArray4);
            this.multiply(lArray3, lArray4, lArray3);
            if ((n & 1 << n3) != 0) {
                int n4 = n & (1 << n3) - 1;
                this.squareN(lArray3, n4, lArray4);
                this.multiply(lArray5, lArray4, lArray5);
            }
            ++n3;
        }
        this.square(lArray5, lArray2);
    }

    void multiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = this.createExt();
        this.implMultiplyAcc(lArray, lArray2, lArray4);
        this.reduce(lArray4, lArray3);
    }

    void reduce(long[] lArray, long[] lArray2) {
        int n = this.bits & 0x3F;
        int n2 = 64 - n;
        long l = -1L >>> n2;
        Nat.shiftUpBits64(this.size, lArray, this.size, n2, lArray[this.size - 1], lArray2, 0);
        this.addTo(lArray, lArray2);
        int n3 = this.size - 1;
        lArray2[n3] = lArray2[n3] & l;
    }

    void square(long[] lArray, long[] lArray2) {
        long[] lArray3 = this.createExt();
        this.implSquare(lArray, lArray3);
        this.reduce(lArray3, lArray2);
    }

    void squareN(long[] lArray, int n, long[] lArray2) {
        if (n >= 64) {
            this.implPermute(lArray, n, lArray2);
            return;
        }
        long[] lArray3 = this.createExt();
        this.implSquare(lArray, lArray3);
        this.reduce(lArray3, lArray2);
        while (--n > 0) {
            this.implSquare(lArray2, lArray3);
            this.reduce(lArray3, lArray2);
        }
    }
}

