/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.bike;

import java.security.SecureRandom;
import org.bouncycastle.crypto.digests.SHA3Digest;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.pqc.crypto.bike.BIKERing;
import org.bouncycastle.pqc.crypto.bike.BIKEUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Bytes;

class BIKEEngine {
    private int r;
    private int w;
    private int hw;
    private int t;
    private int nbIter;
    private int tau;
    private final BIKERing bikeRing;
    private int L_BYTE;
    private int R_BYTE;
    private int R2_BYTE;

    public BIKEEngine(int n, int n2, int n3, int n4, int n5, int n6) {
        this.r = n;
        this.w = n2;
        this.t = n3;
        this.nbIter = n5;
        this.tau = n6;
        this.hw = this.w / 2;
        this.L_BYTE = n4 / 8;
        this.R_BYTE = n + 7 >>> 3;
        this.R2_BYTE = 2 * n + 7 >>> 3;
        this.bikeRing = new BIKERing(n);
    }

    private void BFIter(byte[] byArray, byte[] byArray2, int n, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        int n2;
        int n3;
        int n4;
        int n5;
        this.ctrAll(nArray3, byArray, byArray5);
        int n6 = byArray5[0] & 0xFF;
        int n7 = (n6 - n >> 31) + 1;
        int n8 = (n6 - (n - this.tau) >> 31) + 1;
        byArray2[0] = (byte)(byArray2[0] ^ (byte)n7);
        byArray3[0] = (byte)n7;
        byArray4[0] = (byte)n8;
        int n9 = 1;
        while (n9 < this.r) {
            n5 = byArray5[n9] & 0xFF;
            n4 = (n5 - n >> 31) + 1;
            n3 = (n5 - (n - this.tau) >> 31) + 1;
            int n10 = this.r - n9;
            byArray2[n10] = (byte)(byArray2[n10] ^ (byte)n4);
            byArray3[n9] = (byte)n4;
            byArray4[n9] = (byte)n3;
            ++n9;
        }
        this.ctrAll(nArray4, byArray, byArray5);
        n5 = byArray5[0] & 0xFF;
        n4 = (n5 - n >> 31) + 1;
        n3 = (n5 - (n - this.tau) >> 31) + 1;
        int n11 = this.r;
        byArray2[n11] = (byte)(byArray2[n11] ^ (byte)n4);
        byArray3[this.r] = (byte)n4;
        byArray4[this.r] = (byte)n3;
        int n12 = 1;
        while (n12 < this.r) {
            n2 = byArray5[n12] & 0xFF;
            int n13 = (n2 - n >> 31) + 1;
            int n14 = (n2 - (n - this.tau) >> 31) + 1;
            int n15 = this.r + this.r - n12;
            byArray2[n15] = (byte)(byArray2[n15] ^ (byte)n13);
            byArray3[this.r + n12] = (byte)n13;
            byArray4[this.r + n12] = (byte)n14;
            ++n12;
        }
        n2 = 0;
        while (n2 < 2 * this.r) {
            this.recomputeSyndrome(byArray, n2, nArray, nArray2, byArray3[n2] != 0);
            ++n2;
        }
    }

    private void BFIter2(byte[] byArray, byte[] byArray2, int n, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, byte[] byArray3) {
        int n2;
        int n3;
        int n4;
        int[] nArray5 = new int[2 * this.r];
        this.ctrAll(nArray3, byArray, byArray3);
        int n5 = byArray3[0] & 0xFF;
        int n6 = (n5 - n >> 31) + 1;
        byArray2[0] = (byte)(byArray2[0] ^ (byte)n6);
        nArray5[0] = n6;
        int n7 = 1;
        while (n7 < this.r) {
            n4 = byArray3[n7] & 0xFF;
            n3 = (n4 - n >> 31) + 1;
            int n8 = this.r - n7;
            byArray2[n8] = (byte)(byArray2[n8] ^ (byte)n3);
            nArray5[n7] = n3;
            ++n7;
        }
        this.ctrAll(nArray4, byArray, byArray3);
        n4 = byArray3[0] & 0xFF;
        n3 = (n4 - n >> 31) + 1;
        int n9 = this.r;
        byArray2[n9] = (byte)(byArray2[n9] ^ (byte)n3);
        nArray5[this.r] = n3;
        int n10 = 1;
        while (n10 < this.r) {
            n2 = byArray3[n10] & 0xFF;
            int n11 = (n2 - n >> 31) + 1;
            int n12 = this.r + this.r - n10;
            byArray2[n12] = (byte)(byArray2[n12] ^ (byte)n11);
            nArray5[this.r + n10] = n11;
            ++n10;
        }
        n2 = 0;
        while (n2 < 2 * this.r) {
            this.recomputeSyndrome(byArray, n2, nArray, nArray2, nArray5[n2] == 1);
            ++n2;
        }
    }

    private void BFMaskedIter(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        boolean bl;
        int n2;
        int[] nArray5 = new int[2 * this.r];
        int n3 = 0;
        while (n3 < this.r) {
            if (byArray3[n3] == 1) {
                n2 = this.ctr(nArray3, byArray, n3) < n ? 0 : 1;
                this.updateNewErrorIndex(byArray2, n3, n2 != 0);
                nArray5[n3] = n2 != 0 ? 1 : 0;
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < this.r) {
            if (byArray3[this.r + n2] == 1) {
                bl = this.ctr(nArray4, byArray, n2) >= n;
                this.updateNewErrorIndex(byArray2, this.r + n2, bl);
                nArray5[this.r + n2] = bl ? 1 : 0;
            }
            ++n2;
        }
        bl = false;
        while (bl < 2 * this.r) {
            this.recomputeSyndrome(byArray, bl ? 1 : 0, nArray, nArray2, nArray5[bl] == 1);
            bl += 1;
        }
    }

    private byte[] BGFDecoder(byte[] byArray, int[] nArray, int[] nArray2) {
        byte[] byArray2 = new byte[2 * this.r];
        int[] nArray3 = this.getColumnFromCompactVersion(nArray);
        int[] nArray4 = this.getColumnFromCompactVersion(nArray2);
        byte[] byArray3 = new byte[2 * this.r];
        byte[] byArray4 = new byte[this.r];
        byte[] byArray5 = new byte[2 * this.r];
        int n = this.threshold(BIKEUtils.getHammingWeight(byArray), this.r);
        this.BFIter(byArray, byArray2, n, nArray, nArray2, nArray3, nArray4, byArray3, byArray5, byArray4);
        this.BFMaskedIter(byArray, byArray2, byArray3, (this.hw + 1) / 2 + 1, nArray, nArray2, nArray3, nArray4);
        this.BFMaskedIter(byArray, byArray2, byArray5, (this.hw + 1) / 2 + 1, nArray, nArray2, nArray3, nArray4);
        int n2 = 1;
        while (n2 < this.nbIter) {
            Arrays.fill(byArray3, (byte)0);
            int n3 = this.threshold(BIKEUtils.getHammingWeight(byArray), this.r);
            this.BFIter2(byArray, byArray2, n3, nArray, nArray2, nArray3, nArray4, byArray4);
            ++n2;
        }
        if (BIKEUtils.getHammingWeight(byArray) == 0) {
            return byArray2;
        }
        return null;
    }

    private byte[] computeSyndrome(byte[] byArray, byte[] byArray2) {
        long[] lArray = this.bikeRing.create();
        long[] lArray2 = this.bikeRing.create();
        this.bikeRing.decodeBytes(byArray, lArray);
        this.bikeRing.decodeBytes(byArray2, lArray2);
        this.bikeRing.multiply(lArray, lArray2, lArray);
        return this.bikeRing.encodeBitsTransposed(lArray);
    }

    private void convertToCompact(int[] nArray, byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.R_BYTE) {
            int n3 = 0;
            while (n3 < 8) {
                if (n2 * 8 + n3 == this.r) break;
                int n4 = byArray[n2] >> n3 & 1;
                nArray[n] = n2 * 8 + n3 & -n4 | nArray[n] & ~(-n4);
                n = (n + n4) % this.hw;
                ++n3;
            }
            ++n2;
        }
    }

    private int ctr(int[] nArray, byte[] byArray, int n) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.hw - 4;
        while (n4 <= n5) {
            n2 = nArray[n4] + n - this.r;
            int n6 = nArray[n4 + 1] + n - this.r;
            int n7 = nArray[n4 + 2] + n - this.r;
            int n8 = nArray[n4 + 3] + n - this.r;
            n2 += n2 >> 31 & this.r;
            n6 += n6 >> 31 & this.r;
            n7 += n7 >> 31 & this.r;
            n8 += n8 >> 31 & this.r;
            n3 += byArray[n2] & 0xFF;
            n3 += byArray[n6] & 0xFF;
            n3 += byArray[n7] & 0xFF;
            n3 += byArray[n8] & 0xFF;
            n4 += 4;
        }
        while (n4 < this.hw) {
            n2 = nArray[n4] + n - this.r;
            n2 += n2 >> 31 & this.r;
            n3 += byArray[n2] & 0xFF;
            ++n4;
        }
        return n3;
    }

    private void ctrAll(int[] nArray, byte[] byArray, byte[] byArray2) {
        int n = nArray[0];
        int n2 = this.r - n;
        System.arraycopy(byArray, n, byArray2, 0, n2);
        System.arraycopy(byArray, 0, byArray2, n2, n);
        int n3 = 1;
        while (n3 < this.hw) {
            int n4 = nArray[n3];
            int n5 = this.r - n4;
            int n6 = 0;
            int n7 = n5 - 4;
            while (n6 <= n7) {
                int n8 = n6;
                byArray2[n8] = (byte)(byArray2[n8] + (byArray[n4 + n6] & 0xFF));
                int n9 = n6 + 1;
                byArray2[n9] = (byte)(byArray2[n9] + (byArray[n4 + n6 + 1] & 0xFF));
                int n10 = n6 + 2;
                byArray2[n10] = (byte)(byArray2[n10] + (byArray[n4 + n6 + 2] & 0xFF));
                int n11 = n6 + 3;
                byArray2[n11] = (byte)(byArray2[n11] + (byArray[n4 + n6 + 3] & 0xFF));
                n6 += 4;
            }
            while (n6 < n5) {
                int n12 = n6;
                byArray2[n12] = (byte)(byArray2[n12] + (byArray[n4 + n6] & 0xFF));
                ++n6;
            }
            int n13 = n5;
            int n14 = this.r - 4;
            while (n13 <= n14) {
                int n15 = n13;
                byArray2[n15] = (byte)(byArray2[n15] + (byArray[n13 - n5] & 0xFF));
                int n16 = n13 + 1;
                byArray2[n16] = (byte)(byArray2[n16] + (byArray[n13 + 1 - n5] & 0xFF));
                int n17 = n13 + 2;
                byArray2[n17] = (byte)(byArray2[n17] + (byArray[n13 + 2 - n5] & 0xFF));
                int n18 = n13 + 3;
                byArray2[n18] = (byte)(byArray2[n18] + (byArray[n13 + 3 - n5] & 0xFF));
                n13 += 4;
            }
            while (n13 < this.r) {
                int n19 = n13;
                byArray2[n19] = (byte)(byArray2[n19] + (byArray[n13 - n5] & 0xFF));
                ++n13;
            }
            ++n3;
        }
    }

    public void decaps(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) {
        int[] nArray = new int[this.hw];
        int[] nArray2 = new int[this.hw];
        this.convertToCompact(nArray, byArray2);
        this.convertToCompact(nArray2, byArray3);
        byte[] byArray7 = this.computeSyndrome(byArray5, byArray2);
        byte[] byArray8 = this.BGFDecoder(byArray7, nArray, nArray2);
        byte[] byArray9 = new byte[2 * this.R_BYTE];
        BIKEUtils.fromBitArrayToByteArray(byArray9, byArray8, 0, 2 * this.r);
        byte[] byArray10 = new byte[this.R_BYTE];
        byte[] byArray11 = new byte[this.R_BYTE];
        this.splitEBytes(byArray9, byArray10, byArray11);
        byte[] byArray12 = new byte[this.L_BYTE];
        this.functionL(byArray10, byArray11, byArray12);
        Bytes.xorTo(this.L_BYTE, byArray6, byArray12);
        byte[] byArray13 = this.functionH(byArray12);
        if (Arrays.areEqual(byArray9, 0, this.R2_BYTE, byArray13, 0, this.R2_BYTE)) {
            this.functionK(byArray12, byArray5, byArray6, byArray);
        } else {
            this.functionK(byArray4, byArray5, byArray6, byArray);
        }
    }

    public void encaps(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, SecureRandom secureRandom) {
        byte[] byArray5 = new byte[this.L_BYTE];
        secureRandom.nextBytes(byArray5);
        byte[] byArray6 = this.functionH(byArray5);
        byte[] byArray7 = new byte[this.R_BYTE];
        byte[] byArray8 = new byte[this.R_BYTE];
        this.splitEBytes(byArray6, byArray7, byArray8);
        long[] lArray = this.bikeRing.create();
        long[] lArray2 = this.bikeRing.create();
        this.bikeRing.decodeBytes(byArray7, lArray);
        this.bikeRing.decodeBytes(byArray8, lArray2);
        long[] lArray3 = this.bikeRing.create();
        this.bikeRing.decodeBytes(byArray4, lArray3);
        this.bikeRing.multiply(lArray3, lArray2, lArray3);
        this.bikeRing.add(lArray3, lArray, lArray3);
        this.bikeRing.encodeBytes(lArray3, byArray);
        this.functionL(byArray7, byArray8, byArray2);
        Bytes.xorTo(this.L_BYTE, byArray5, byArray2);
        this.functionK(byArray5, byArray, byArray2, byArray3);
    }

    private byte[] functionH(byte[] byArray) {
        byte[] byArray2 = new byte[2 * this.R_BYTE];
        SHAKEDigest sHAKEDigest = new SHAKEDigest(256);
        sHAKEDigest.update(byArray, 0, byArray.length);
        BIKEUtils.generateRandomByteArray(byArray2, 2 * this.r, this.t, sHAKEDigest);
        return byArray2;
    }

    private void functionK(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        byte[] byArray5 = new byte[48];
        SHA3Digest sHA3Digest = new SHA3Digest(384);
        sHA3Digest.update(byArray, 0, byArray.length);
        sHA3Digest.update(byArray2, 0, byArray2.length);
        sHA3Digest.update(byArray3, 0, byArray3.length);
        sHA3Digest.doFinal(byArray5, 0);
        System.arraycopy(byArray5, 0, byArray4, 0, this.L_BYTE);
    }

    private void functionL(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[48];
        SHA3Digest sHA3Digest = new SHA3Digest(384);
        sHA3Digest.update(byArray, 0, byArray.length);
        sHA3Digest.update(byArray2, 0, byArray2.length);
        sHA3Digest.doFinal(byArray4, 0);
        System.arraycopy(byArray4, 0, byArray3, 0, this.L_BYTE);
    }

    public void genKeyPair(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, SecureRandom secureRandom) {
        byte[] byArray5 = new byte[64];
        secureRandom.nextBytes(byArray5);
        SHAKEDigest sHAKEDigest = new SHAKEDigest(256);
        sHAKEDigest.update(byArray5, 0, this.L_BYTE);
        BIKEUtils.generateRandomByteArray(byArray, this.r, this.hw, sHAKEDigest);
        BIKEUtils.generateRandomByteArray(byArray2, this.r, this.hw, sHAKEDigest);
        long[] lArray = this.bikeRing.create();
        long[] lArray2 = this.bikeRing.create();
        this.bikeRing.decodeBytes(byArray, lArray);
        this.bikeRing.decodeBytes(byArray2, lArray2);
        long[] lArray3 = this.bikeRing.create();
        this.bikeRing.inv(lArray, lArray3);
        this.bikeRing.multiply(lArray3, lArray2, lArray3);
        this.bikeRing.encodeBytes(lArray3, byArray4);
        System.arraycopy(byArray5, this.L_BYTE, byArray3, 0, byArray3.length);
    }

    private int[] getColumnFromCompactVersion(int[] nArray) {
        int[] nArray2 = new int[this.hw];
        if (nArray[0] == 0) {
            nArray2[0] = 0;
            int n = 1;
            while (n < this.hw) {
                nArray2[n] = this.r - nArray[this.hw - n];
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.hw) {
                nArray2[n] = this.r - nArray[this.hw - 1 - n];
                ++n;
            }
        }
        return nArray2;
    }

    public int getSessionKeySize() {
        return this.L_BYTE;
    }

    private void recomputeSyndrome(byte[] byArray, int n, int[] nArray, int[] nArray2, boolean bl) {
        byte by;
        byte by2 = by = bl ? (byte)1 : 0;
        if (n < this.r) {
            int n2 = 0;
            while (n2 < this.hw) {
                if (nArray[n2] <= n) {
                    int n3 = n - nArray[n2];
                    byArray[n3] = (byte)(byArray[n3] ^ by);
                } else {
                    int n4 = this.r + n - nArray[n2];
                    byArray[n4] = (byte)(byArray[n4] ^ by);
                }
                ++n2;
            }
        } else {
            int n5 = 0;
            while (n5 < this.hw) {
                if (nArray2[n5] <= n - this.r) {
                    int n6 = n - this.r - nArray2[n5];
                    byArray[n6] = (byte)(byArray[n6] ^ by);
                } else {
                    int n7 = this.r - nArray2[n5] + (n - this.r);
                    byArray[n7] = (byte)(byArray[n7] ^ by);
                }
                ++n5;
            }
        }
    }

    private void splitEBytes(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n = this.r & 7;
        System.arraycopy(byArray, 0, byArray2, 0, this.R_BYTE - 1);
        byte by = byArray[this.R_BYTE - 1];
        byte by2 = (byte)(-1 << n);
        byArray2[this.R_BYTE - 1] = (byte)(by & ~by2);
        byte by3 = (byte)(by & by2);
        int n2 = 0;
        while (n2 < this.R_BYTE) {
            byte by4 = byArray[this.R_BYTE + n2];
            byArray3[n2] = (byte)(by4 << 8 - n | (by3 & 0xFF) >>> n);
            by3 = by4;
            ++n2;
        }
    }

    private int threshold(int n, int n2) {
        switch (n2) {
            case 12323: {
                return BIKEEngine.thresholdFromParameters(n, 0.0069722, 13.53, 36);
            }
            case 24659: {
                return BIKEEngine.thresholdFromParameters(n, 0.005265, 15.2588, 52);
            }
            case 40973: {
                return BIKEEngine.thresholdFromParameters(n, 0.00402312, 17.8785, 69);
            }
        }
        throw new IllegalArgumentException();
    }

    private static int thresholdFromParameters(int n, double d, double d2, int n2) {
        return Math.max(n2, (int)Math.floor(d * (double)n + d2));
    }

    private void updateNewErrorIndex(byte[] byArray, int n, boolean bl) {
        int n2 = n;
        if (n != 0 && n != this.r) {
            n2 = n > this.r ? 2 * this.r - n + this.r : this.r - n;
        }
        int n3 = n2;
        byArray[n3] = (byte)(byArray[n3] ^ (bl ? (byte)1 : 0));
    }
}

