/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.asn1;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.pqc.legacy.crypto.rainbow.Layer;
import org.bouncycastle.pqc.legacy.crypto.rainbow.util.RainbowUtil;

public class RainbowPrivateKey
extends ASN1Object {
    private ASN1Integer version;
    private ASN1ObjectIdentifier oid;
    private byte[][] invA1;
    private byte[] b1;
    private byte[][] invA2;
    private byte[] b2;
    private byte[] vi;
    private Layer[] layers;

    private RainbowPrivateKey(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.getObjectAt(0) instanceof ASN1Integer) {
            this.version = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0));
        } else {
            this.oid = ASN1ObjectIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
        }
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(1);
        this.invA1 = new byte[aSN1Sequence2.size()][];
        int n = 0;
        while (n < aSN1Sequence2.size()) {
            this.invA1[n] = ((ASN1OctetString)aSN1Sequence2.getObjectAt(n)).getOctets();
            ++n;
        }
        ASN1Sequence aSN1Sequence3 = (ASN1Sequence)aSN1Sequence.getObjectAt(2);
        this.b1 = ((ASN1OctetString)aSN1Sequence3.getObjectAt(0)).getOctets();
        ASN1Sequence aSN1Sequence4 = (ASN1Sequence)aSN1Sequence.getObjectAt(3);
        this.invA2 = new byte[aSN1Sequence4.size()][];
        int n2 = 0;
        while (n2 < aSN1Sequence4.size()) {
            this.invA2[n2] = ((ASN1OctetString)aSN1Sequence4.getObjectAt(n2)).getOctets();
            ++n2;
        }
        ASN1Sequence aSN1Sequence5 = (ASN1Sequence)aSN1Sequence.getObjectAt(4);
        this.b2 = ((ASN1OctetString)aSN1Sequence5.getObjectAt(0)).getOctets();
        ASN1Sequence aSN1Sequence6 = (ASN1Sequence)aSN1Sequence.getObjectAt(5);
        this.vi = ((ASN1OctetString)aSN1Sequence6.getObjectAt(0)).getOctets();
        ASN1Sequence aSN1Sequence7 = (ASN1Sequence)aSN1Sequence.getObjectAt(6);
        byte[][][][] byArray = new byte[aSN1Sequence7.size()][][][];
        byte[][][][] byArray2 = new byte[aSN1Sequence7.size()][][][];
        byte[][][] byArray3 = new byte[aSN1Sequence7.size()][][];
        byte[][] byArray4 = new byte[aSN1Sequence7.size()][];
        int n3 = 0;
        while (n3 < aSN1Sequence7.size()) {
            int n4;
            ASN1Sequence aSN1Sequence8;
            int n5;
            ASN1Sequence aSN1Sequence9;
            ASN1Sequence aSN1Sequence10 = (ASN1Sequence)aSN1Sequence7.getObjectAt(n3);
            ASN1Sequence aSN1Sequence11 = (ASN1Sequence)aSN1Sequence10.getObjectAt(0);
            byArray[n3] = new byte[aSN1Sequence11.size()][][];
            int n6 = 0;
            while (n6 < aSN1Sequence11.size()) {
                aSN1Sequence9 = (ASN1Sequence)aSN1Sequence11.getObjectAt(n6);
                byArray[n3][n6] = new byte[aSN1Sequence9.size()][];
                n5 = 0;
                while (n5 < aSN1Sequence9.size()) {
                    byArray[n3][n6][n5] = ((ASN1OctetString)aSN1Sequence9.getObjectAt(n5)).getOctets();
                    ++n5;
                }
                ++n6;
            }
            aSN1Sequence9 = (ASN1Sequence)aSN1Sequence10.getObjectAt(1);
            byArray2[n3] = new byte[aSN1Sequence9.size()][][];
            n5 = 0;
            while (n5 < aSN1Sequence9.size()) {
                aSN1Sequence8 = (ASN1Sequence)aSN1Sequence9.getObjectAt(n5);
                byArray2[n3][n5] = new byte[aSN1Sequence8.size()][];
                n4 = 0;
                while (n4 < aSN1Sequence8.size()) {
                    byArray2[n3][n5][n4] = ((ASN1OctetString)aSN1Sequence8.getObjectAt(n4)).getOctets();
                    ++n4;
                }
                ++n5;
            }
            aSN1Sequence8 = (ASN1Sequence)aSN1Sequence10.getObjectAt(2);
            byArray3[n3] = new byte[aSN1Sequence8.size()][];
            n4 = 0;
            while (n4 < aSN1Sequence8.size()) {
                byArray3[n3][n4] = ((ASN1OctetString)aSN1Sequence8.getObjectAt(n4)).getOctets();
                ++n4;
            }
            byArray4[n3] = ((ASN1OctetString)aSN1Sequence10.getObjectAt(3)).getOctets();
            ++n3;
        }
        int n7 = this.vi.length - 1;
        this.layers = new Layer[n7];
        int n8 = 0;
        while (n8 < n7) {
            Layer layer;
            this.layers[n8] = layer = new Layer(this.vi[n8], this.vi[n8 + 1], RainbowUtil.convertArray(byArray[n8]), RainbowUtil.convertArray(byArray2[n8]), RainbowUtil.convertArray(byArray3[n8]), RainbowUtil.convertArray(byArray4[n8]));
            ++n8;
        }
    }

    public RainbowPrivateKey(short[][] sArray, short[] sArray2, short[][] sArray3, short[] sArray4, int[] nArray, Layer[] layerArray) {
        this.version = new ASN1Integer(1L);
        this.invA1 = RainbowUtil.convertArray(sArray);
        this.b1 = RainbowUtil.convertArray(sArray2);
        this.invA2 = RainbowUtil.convertArray(sArray3);
        this.b2 = RainbowUtil.convertArray(sArray4);
        this.vi = RainbowUtil.convertIntArray(nArray);
        this.layers = layerArray;
    }

    public short[] getB1() {
        return RainbowUtil.convertArray(this.b1);
    }

    public short[] getB2() {
        return RainbowUtil.convertArray(this.b2);
    }

    public static RainbowPrivateKey getInstance(Object object) {
        if (object instanceof RainbowPrivateKey) {
            return (RainbowPrivateKey)object;
        }
        if (object != null) {
            return new RainbowPrivateKey(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public short[][] getInvA1() {
        return RainbowUtil.convertArray(this.invA1);
    }

    public short[][] getInvA2() {
        return RainbowUtil.convertArray(this.invA2);
    }

    public Layer[] getLayers() {
        return this.layers;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public int[] getVi() {
        return RainbowUtil.convertArraytoInt(this.vi);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.version != null) {
            aSN1EncodableVector.add(this.version);
        } else {
            aSN1EncodableVector.add(this.oid);
        }
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        int n = 0;
        while (n < this.invA1.length) {
            aSN1EncodableVector2.add(new DEROctetString(this.invA1[n]));
            ++n;
        }
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        ASN1EncodableVector aSN1EncodableVector3 = new ASN1EncodableVector();
        aSN1EncodableVector3.add(new DEROctetString(this.b1));
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector3));
        ASN1EncodableVector aSN1EncodableVector4 = new ASN1EncodableVector();
        int n2 = 0;
        while (n2 < this.invA2.length) {
            aSN1EncodableVector4.add(new DEROctetString(this.invA2[n2]));
            ++n2;
        }
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector4));
        ASN1EncodableVector aSN1EncodableVector5 = new ASN1EncodableVector();
        aSN1EncodableVector5.add(new DEROctetString(this.b2));
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector5));
        ASN1EncodableVector aSN1EncodableVector6 = new ASN1EncodableVector();
        aSN1EncodableVector6.add(new DEROctetString(this.vi));
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector6));
        ASN1EncodableVector aSN1EncodableVector7 = new ASN1EncodableVector();
        int n3 = 0;
        while (n3 < this.layers.length) {
            Object object;
            Object object2;
            ASN1EncodableVector aSN1EncodableVector8 = new ASN1EncodableVector();
            byte[][][] byArray = RainbowUtil.convertArray(this.layers[n3].getCoeffAlpha());
            ASN1EncodableVector aSN1EncodableVector9 = new ASN1EncodableVector();
            int n4 = 0;
            while (n4 < byArray.length) {
                object2 = new ASN1EncodableVector();
                int n5 = 0;
                while (n5 < byArray[n4].length) {
                    ((ASN1EncodableVector)object2).add(new DEROctetString(byArray[n4][n5]));
                    ++n5;
                }
                aSN1EncodableVector9.add(new DERSequence((ASN1EncodableVector)object2));
                ++n4;
            }
            aSN1EncodableVector8.add(new DERSequence(aSN1EncodableVector9));
            object2 = RainbowUtil.convertArray(this.layers[n3].getCoeffBeta());
            ASN1EncodableVector aSN1EncodableVector10 = new ASN1EncodableVector();
            int n6 = 0;
            while (n6 < ((Object)object2).length) {
                object = new ASN1EncodableVector();
                int n7 = 0;
                while (n7 < ((Object)object2[n6]).length) {
                    ((ASN1EncodableVector)object).add(new DEROctetString((byte[])object2[n6][n7]));
                    ++n7;
                }
                aSN1EncodableVector10.add(new DERSequence((ASN1EncodableVector)object));
                ++n6;
            }
            aSN1EncodableVector8.add(new DERSequence(aSN1EncodableVector10));
            object = RainbowUtil.convertArray(this.layers[n3].getCoeffGamma());
            ASN1EncodableVector aSN1EncodableVector11 = new ASN1EncodableVector();
            int n8 = 0;
            while (n8 < ((Object)object).length) {
                aSN1EncodableVector11.add(new DEROctetString((byte[])object[n8]));
                ++n8;
            }
            aSN1EncodableVector8.add(new DERSequence(aSN1EncodableVector11));
            aSN1EncodableVector8.add(new DEROctetString(RainbowUtil.convertArray(this.layers[n3].getCoeffEta())));
            aSN1EncodableVector7.add(new DERSequence(aSN1EncodableVector8));
            ++n3;
        }
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector7));
        return new DERSequence(aSN1EncodableVector);
    }
}

