/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.tools;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParametersHolder;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.util.Integers;

public class TraceOptimizer {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final SecureRandom R = new SecureRandom();

    private static int calculateTrace(ECFieldElement eCFieldElement) {
        int n = eCFieldElement.getFieldSize();
        int n2 = 31 - Integers.numberOfLeadingZeros(n);
        int n3 = 1;
        ECFieldElement eCFieldElement2 = eCFieldElement;
        while (n2 > 0) {
            eCFieldElement2 = eCFieldElement2.squarePow(n3).add(eCFieldElement2);
            if (((n3 = n >>> --n2) & 1) == 0) continue;
            eCFieldElement2 = eCFieldElement2.square().add(eCFieldElement);
        }
        if (eCFieldElement2.isZero()) {
            return 0;
        }
        if (eCFieldElement2.isOne()) {
            return 1;
        }
        throw new IllegalStateException("Internal error in trace calculation");
    }

    private static List enumToList(Enumeration enumeration) {
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }

    public static void implPrintNonZeroTraceBits(ECCurve eCCurve) {
        Object object;
        int n = eCCurve.getFieldSize();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = 0;
        while (n2 < n) {
            if ((n2 & 1) == 0 && n2 != 0) {
                if (arrayList.contains(Integers.valueOf(n2 >>> 1))) {
                    arrayList.add(Integers.valueOf(n2));
                    System.out.print(" " + n2);
                }
            } else {
                BigInteger bigInteger = ONE.shiftLeft(n2);
                object = eCCurve.fromBigInteger(bigInteger);
                int n3 = TraceOptimizer.calculateTrace((ECFieldElement)object);
                if (n3 != 0) {
                    arrayList.add(Integers.valueOf(n2));
                    System.out.print(" " + n2);
                }
            }
            ++n2;
        }
        System.out.println();
        int n4 = 0;
        while (n4 < 1000) {
            object = new BigInteger(n, R);
            ECFieldElement eCFieldElement = eCCurve.fromBigInteger((BigInteger)object);
            int n5 = TraceOptimizer.calculateTrace(eCFieldElement);
            int n6 = 0;
            int n7 = 0;
            while (n7 < arrayList.size()) {
                int n8 = (Integer)arrayList.get(n7);
                if (((BigInteger)object).testBit(n8)) {
                    n6 ^= 1;
                }
                ++n7;
            }
            if (n5 != n6) {
                throw new IllegalStateException("Optimized-trace sanity check failed");
            }
            ++n4;
        }
    }

    public static void main(String[] stringArray) {
        TreeSet treeSet = new TreeSet(TraceOptimizer.enumToList(ECNamedCurveTable.getNames()));
        treeSet.addAll(TraceOptimizer.enumToList(CustomNamedCurves.getNames()));
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            ECCurve eCCurve;
            String string = (String)iterator.next();
            X9ECParametersHolder x9ECParametersHolder = CustomNamedCurves.getByNameLazy(string);
            if (x9ECParametersHolder == null) {
                x9ECParametersHolder = ECNamedCurveTable.getByNameLazy(string);
            }
            if (x9ECParametersHolder == null || !ECAlgorithms.isF2mCurve(eCCurve = x9ECParametersHolder.getCurve())) continue;
            System.out.print(String.valueOf(string) + ":");
            TraceOptimizer.implPrintNonZeroTraceBits(eCCurve);
        }
    }

    public static void printNonZeroTraceBits(ECCurve eCCurve) {
        if (!ECAlgorithms.isF2mCurve(eCCurve)) {
            throw new IllegalArgumentException("Trace only defined over characteristic-2 fields");
        }
        TraceOptimizer.implPrintNonZeroTraceBits(eCCurve);
    }
}

