/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.rfc8032;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.math.ec.rfc7748.X25519;
import org.bouncycastle.math.ec.rfc7748.X25519Field;
import org.bouncycastle.math.ec.rfc8032.Codec;
import org.bouncycastle.math.ec.rfc8032.Scalar25519;
import org.bouncycastle.math.ec.rfc8032.Wnaf;
import org.bouncycastle.math.raw.Interleave;
import org.bouncycastle.math.raw.Nat256;

public abstract class Ed25519 {
    private static final int COORD_INTS = 8;
    private static final int POINT_BYTES = 32;
    private static final int SCALAR_INTS = 8;
    private static final int SCALAR_BYTES = 32;
    public static final int PREHASH_SIZE = 64;
    public static final int PUBLIC_KEY_SIZE = 32;
    public static final int SECRET_KEY_SIZE = 32;
    public static final int SIGNATURE_SIZE = 64;
    private static final byte[] DOM2_PREFIX = new byte[]{83, 105, 103, 69, 100, 50, 53, 53, 49, 57, 32, 110, 111, 32, 69, 100, 50, 53, 53, 49, 57, 32, 99, 111, 108, 108, 105, 115, 105, 111, 110, 115};
    private static final int[] P = new int[]{-19, -1, -1, -1, -1, -1, -1, Integer.MAX_VALUE};
    private static final int[] ORDER8_y1 = new int[]{1886001095, 1339575613, 1980447930, 258412557, -95215574, -959694548, 2013120334, 2047061138};
    private static final int[] ORDER8_y2 = new int[]{-1886001114, -1339575614, -1980447931, -258412558, 95215573, 959694547, -2013120335, 100422509};
    private static final int[] B_x = new int[]{52811034, 25909283, 8072341, 50637101, 13785486, 30858332, 20483199, 20966410, 43936626, 4379245};
    private static final int[] B_y = new int[]{40265304, 0x1999999, 0x666666, 0x3333333, 0xCCCCCC, 0x2666666, 0x1999999, 0x666666, 0x3333333, 0xCCCCCC};
    private static final int[] B128_x = new int[]{12052516, 1174424, 4087752, 38672185, 20040971, 21899680, 55468344, 20105554, 66708015, 9981791};
    private static final int[] B128_y = new int[]{66430571, 45040722, 4842939, 15895846, 18981244, 46308410, 4697481, 8903007, 53646190, 12474675};
    private static final int[] C_d = new int[]{56195235, 47411844, 25868126, 40503822, 57364, 58321048, 30416477, 31930572, 57760639, 10749657};
    private static final int[] C_d2 = new int[]{45281625, 27714825, 18181821, 0xD4141D, 114729, 49533232, 60832955, 30306712, 48412415, 4722099};
    private static final int[] C_d4 = new int[]{23454386, 55429651, 2809210, 27797563, 229458, 31957600, 54557047, 27058993, 29715967, 9444199};
    private static final int WNAF_WIDTH_128 = 4;
    private static final int WNAF_WIDTH_BASE = 6;
    private static final int PRECOMP_BLOCKS = 8;
    private static final int PRECOMP_TEETH = 4;
    private static final int PRECOMP_SPACING = 8;
    private static final int PRECOMP_RANGE = 256;
    private static final int PRECOMP_POINTS = 8;
    private static final int PRECOMP_MASK = 7;
    private static final Object PRECOMP_LOCK = new Object();
    private static PointPrecomp[] PRECOMP_BASE_WNAF = null;
    private static PointPrecomp[] PRECOMP_BASE128_WNAF = null;
    private static int[] PRECOMP_BASE_COMB = null;

    private static byte[] calculateS(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int[] nArray = new int[16];
        Scalar25519.decode(byArray, nArray);
        int[] nArray2 = new int[8];
        Scalar25519.decode(byArray2, nArray2);
        int[] nArray3 = new int[8];
        Scalar25519.decode(byArray3, nArray3);
        Nat256.mulAddTo(nArray2, nArray3, nArray);
        byte[] byArray4 = new byte[64];
        Codec.encode32(nArray, 0, nArray.length, byArray4, 0);
        return Scalar25519.reduce512(byArray4);
    }

    private static boolean checkContextVar(byte[] byArray, byte by) {
        return byArray == null && by == 0 || byArray != null && byArray.length < 256;
    }

    private static int checkPoint(PointAccum pointAccum) {
        int[] nArray = X25519Field.create();
        int[] nArray2 = X25519Field.create();
        int[] nArray3 = X25519Field.create();
        int[] nArray4 = X25519Field.create();
        X25519Field.sqr(pointAccum.x, nArray2);
        X25519Field.sqr(pointAccum.y, nArray3);
        X25519Field.sqr(pointAccum.z, nArray4);
        X25519Field.mul(nArray2, nArray3, nArray);
        X25519Field.sub(nArray2, nArray3, nArray2);
        X25519Field.mul(nArray2, nArray4, nArray2);
        X25519Field.sqr(nArray4, nArray4);
        X25519Field.mul(nArray, C_d, nArray);
        X25519Field.add(nArray, nArray4, nArray);
        X25519Field.add(nArray, nArray2, nArray);
        X25519Field.normalize(nArray);
        X25519Field.normalize(nArray3);
        X25519Field.normalize(nArray4);
        return X25519Field.isZero(nArray) & ~X25519Field.isZero(nArray3) & ~X25519Field.isZero(nArray4);
    }

    private static int checkPoint(PointAffine pointAffine) {
        int[] nArray = X25519Field.create();
        int[] nArray2 = X25519Field.create();
        int[] nArray3 = X25519Field.create();
        X25519Field.sqr(pointAffine.x, nArray2);
        X25519Field.sqr(pointAffine.y, nArray3);
        X25519Field.mul(nArray2, nArray3, nArray);
        X25519Field.sub(nArray2, nArray3, nArray2);
        X25519Field.mul(nArray, C_d, nArray);
        X25519Field.addOne(nArray);
        X25519Field.add(nArray, nArray2, nArray);
        X25519Field.normalize(nArray);
        X25519Field.normalize(nArray3);
        return X25519Field.isZero(nArray) & ~X25519Field.isZero(nArray3);
    }

    private static boolean checkPointFullVar(byte[] byArray) {
        int n;
        int n2;
        int n3 = n2 = Codec.decode32(byArray, 28) & Integer.MAX_VALUE;
        int n4 = n2 ^ P[7];
        int n5 = n2 ^ ORDER8_y1[7];
        int n6 = n2 ^ ORDER8_y2[7];
        int n7 = 6;
        while (n7 > 0) {
            n = Codec.decode32(byArray, n7 * 4);
            n3 |= n;
            n4 |= n ^ P[n7];
            n5 |= n ^ ORDER8_y1[n7];
            n6 |= n ^ ORDER8_y2[n7];
            --n7;
        }
        n = Codec.decode32(byArray, 0);
        if (n3 == 0 && n + Integer.MIN_VALUE <= -2147483647) {
            return false;
        }
        if (n4 == 0 && n + Integer.MIN_VALUE >= P[0] - 1 + Integer.MIN_VALUE) {
            return false;
        }
        return (n5 |= n ^ ORDER8_y1[0]) != 0 & (n6 |= n ^ ORDER8_y2[0]) != 0;
    }

    private static boolean checkPointOrderVar(PointAffine pointAffine) {
        PointAccum pointAccum = new PointAccum();
        Ed25519.scalarMultOrderVar(pointAffine, pointAccum);
        return Ed25519.normalizeToNeutralElementVar(pointAccum);
    }

    private static boolean checkPointVar(byte[] byArray) {
        if ((Codec.decode32(byArray, 28) & Integer.MAX_VALUE) < P[7]) {
            return true;
        }
        int[] nArray = new int[8];
        Codec.decode32(byArray, 0, nArray, 0, 8);
        nArray[7] = nArray[7] & Integer.MAX_VALUE;
        return Nat256.gte(nArray, P) ^ true;
    }

    private static byte[] copy(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    private static Digest createDigest() {
        SHA512Digest sHA512Digest = new SHA512Digest();
        if (sHA512Digest.getDigestSize() != 64) {
            throw new IllegalStateException();
        }
        return sHA512Digest;
    }

    public static Digest createPrehash() {
        return Ed25519.createDigest();
    }

    private static boolean decodePointVar(byte[] byArray, boolean bl, PointAffine pointAffine) {
        int n = (byArray[31] & 0x80) >>> 7;
        X25519Field.decode(byArray, pointAffine.y);
        int[] nArray = X25519Field.create();
        int[] nArray2 = X25519Field.create();
        X25519Field.sqr(pointAffine.y, nArray);
        X25519Field.mul(C_d, nArray, nArray2);
        X25519Field.subOne(nArray);
        X25519Field.addOne(nArray2);
        if (!X25519Field.sqrtRatioVar(nArray, nArray2, pointAffine.x)) {
            return false;
        }
        X25519Field.normalize(pointAffine.x);
        if (n == 1 && X25519Field.isZeroVar(pointAffine.x)) {
            return false;
        }
        if (bl ^ n != (pointAffine.x[0] & 1)) {
            X25519Field.negate(pointAffine.x, pointAffine.x);
            X25519Field.normalize(pointAffine.x);
        }
        return true;
    }

    private static void dom2(Digest digest, byte by, byte[] byArray) {
        int n = DOM2_PREFIX.length;
        byte[] byArray2 = new byte[n + 2 + byArray.length];
        System.arraycopy(DOM2_PREFIX, 0, byArray2, 0, n);
        byArray2[n] = by;
        byArray2[n + 1] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray2, n + 2, byArray.length);
        digest.update(byArray2, 0, byArray2.length);
    }

    private static void encodePoint(PointAffine pointAffine, byte[] byArray, int n) {
        X25519Field.encode(pointAffine.y, byArray, n);
        int n2 = n + 32 - 1;
        byArray[n2] = (byte)(byArray[n2] | (pointAffine.x[0] & 1) << 7);
    }

    public static void encodePublicPoint(PublicPoint publicPoint, byte[] byArray, int n) {
        X25519Field.encode(publicPoint.data, 10, byArray, n);
        int n2 = n + 32 - 1;
        byArray[n2] = (byte)(byArray[n2] | (publicPoint.data[0] & 1) << 7);
    }

    private static int encodeResult(PointAccum pointAccum, byte[] byArray, int n) {
        PointAffine pointAffine = new PointAffine();
        Ed25519.normalizeToAffine(pointAccum, pointAffine);
        int n2 = Ed25519.checkPoint(pointAffine);
        Ed25519.encodePoint(pointAffine, byArray, n);
        return n2;
    }

    private static PublicPoint exportPoint(PointAffine pointAffine) {
        int[] nArray = new int[20];
        X25519Field.copy(pointAffine.x, 0, nArray, 0);
        X25519Field.copy(pointAffine.y, 0, nArray, 10);
        return new PublicPoint(nArray);
    }

    public static void generatePrivateKey(SecureRandom secureRandom, byte[] byArray) {
        if (byArray.length != 32) {
            throw new IllegalArgumentException("k");
        }
        secureRandom.nextBytes(byArray);
    }

    public static PublicPoint generatePublicKey(byte[] byArray, int n) {
        Digest digest = Ed25519.createDigest();
        byte[] byArray2 = new byte[64];
        digest.update(byArray, n, 32);
        digest.doFinal(byArray2, 0);
        byte[] byArray3 = new byte[32];
        Ed25519.pruneScalar(byArray2, 0, byArray3);
        PointAccum pointAccum = new PointAccum();
        Ed25519.scalarMultBase(byArray3, pointAccum);
        PointAffine pointAffine = new PointAffine();
        Ed25519.normalizeToAffine(pointAccum, pointAffine);
        if (Ed25519.checkPoint(pointAffine) == 0) {
            throw new IllegalStateException();
        }
        return Ed25519.exportPoint(pointAffine);
    }

    public static void generatePublicKey(byte[] byArray, int n, byte[] byArray2, int n2) {
        Digest digest = Ed25519.createDigest();
        byte[] byArray3 = new byte[64];
        digest.update(byArray, n, 32);
        digest.doFinal(byArray3, 0);
        byte[] byArray4 = new byte[32];
        Ed25519.pruneScalar(byArray3, 0, byArray4);
        Ed25519.scalarMultBaseEncoded(byArray4, byArray2, n2);
    }

    private static int getWindow4(int[] nArray, int n) {
        int n2 = n >>> 3;
        int n3 = (n & 7) << 2;
        return nArray[n2] >>> n3 & 0xF;
    }

    private static void groupCombBits(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = Interleave.shuffle2(nArray[n]);
            ++n;
        }
    }

    private static void implSign(Digest digest, byte[] byArray, byte[] byArray2, byte[] byArray3, int n, byte[] byArray4, byte by, byte[] byArray5, int n2, int n3, byte[] byArray6, int n4) {
        if (byArray4 != null) {
            Ed25519.dom2(digest, by, byArray4);
        }
        digest.update(byArray, 32, 32);
        digest.update(byArray5, n2, n3);
        digest.doFinal(byArray, 0);
        byte[] byArray7 = Scalar25519.reduce512(byArray);
        byte[] byArray8 = new byte[32];
        Ed25519.scalarMultBaseEncoded(byArray7, byArray8, 0);
        if (byArray4 != null) {
            Ed25519.dom2(digest, by, byArray4);
        }
        digest.update(byArray8, 0, 32);
        digest.update(byArray3, n, 32);
        digest.update(byArray5, n2, n3);
        digest.doFinal(byArray, 0);
        byte[] byArray9 = Scalar25519.reduce512(byArray);
        byte[] byArray10 = Ed25519.calculateS(byArray7, byArray9, byArray2);
        System.arraycopy(byArray8, 0, byArray6, n4, 32);
        System.arraycopy(byArray10, 0, byArray6, n4 + 32, 32);
    }

    private static void implSign(byte[] byArray, int n, byte[] byArray2, byte by, byte[] byArray3, int n2, int n3, byte[] byArray4, int n4) {
        if (!Ed25519.checkContextVar(byArray2, by)) {
            throw new IllegalArgumentException("ctx");
        }
        Digest digest = Ed25519.createDigest();
        byte[] byArray5 = new byte[64];
        digest.update(byArray, n, 32);
        digest.doFinal(byArray5, 0);
        byte[] byArray6 = new byte[32];
        Ed25519.pruneScalar(byArray5, 0, byArray6);
        byte[] byArray7 = new byte[32];
        Ed25519.scalarMultBaseEncoded(byArray6, byArray7, 0);
        Ed25519.implSign(digest, byArray5, byArray6, byArray7, 0, byArray2, by, byArray3, n2, n3, byArray4, n4);
    }

    private static void implSign(byte[] byArray, int n, byte[] byArray2, int n2, byte[] byArray3, byte by, byte[] byArray4, int n3, int n4, byte[] byArray5, int n5) {
        if (!Ed25519.checkContextVar(byArray3, by)) {
            throw new IllegalArgumentException("ctx");
        }
        Digest digest = Ed25519.createDigest();
        byte[] byArray6 = new byte[64];
        digest.update(byArray, n, 32);
        digest.doFinal(byArray6, 0);
        byte[] byArray7 = new byte[32];
        Ed25519.pruneScalar(byArray6, 0, byArray7);
        Ed25519.implSign(digest, byArray6, byArray7, byArray2, n2, byArray3, by, byArray4, n3, n4, byArray5, n5);
    }

    private static boolean implVerify(byte[] byArray, int n, PublicPoint publicPoint, byte[] byArray2, byte by, byte[] byArray3, int n2, int n3) {
        if (!Ed25519.checkContextVar(byArray2, by)) {
            throw new IllegalArgumentException("ctx");
        }
        byte[] byArray4 = Ed25519.copy(byArray, n, 32);
        byte[] byArray5 = Ed25519.copy(byArray, n + 32, 32);
        if (!Ed25519.checkPointVar(byArray4)) {
            return false;
        }
        int[] nArray = new int[8];
        if (!Scalar25519.checkVar(byArray5, nArray)) {
            return false;
        }
        PointAffine pointAffine = new PointAffine();
        if (!Ed25519.decodePointVar(byArray4, true, pointAffine)) {
            return false;
        }
        PointAffine pointAffine2 = new PointAffine();
        X25519Field.negate(publicPoint.data, pointAffine2.x);
        X25519Field.copy(publicPoint.data, 10, pointAffine2.y, 0);
        byte[] byArray6 = new byte[32];
        Ed25519.encodePublicPoint(publicPoint, byArray6, 0);
        Digest digest = Ed25519.createDigest();
        byte[] byArray7 = new byte[64];
        if (byArray2 != null) {
            Ed25519.dom2(digest, by, byArray2);
        }
        digest.update(byArray4, 0, 32);
        digest.update(byArray6, 0, 32);
        digest.update(byArray3, n2, n3);
        digest.doFinal(byArray7, 0);
        byte[] byArray8 = Scalar25519.reduce512(byArray7);
        int[] nArray2 = new int[8];
        Scalar25519.decode(byArray8, nArray2);
        int[] nArray3 = new int[4];
        int[] nArray4 = new int[4];
        if (!Scalar25519.reduceBasisVar(nArray2, nArray3, nArray4)) {
            throw new IllegalStateException();
        }
        Scalar25519.multiply128Var(nArray, nArray4, nArray);
        PointAccum pointAccum = new PointAccum();
        Ed25519.scalarMultStraus128Var(nArray, nArray3, pointAffine2, nArray4, pointAffine, pointAccum);
        return Ed25519.normalizeToNeutralElementVar(pointAccum);
    }

    private static boolean implVerify(byte[] byArray, int n, byte[] byArray2, int n2, byte[] byArray3, byte by, byte[] byArray4, int n3, int n4) {
        if (!Ed25519.checkContextVar(byArray3, by)) {
            throw new IllegalArgumentException("ctx");
        }
        byte[] byArray5 = Ed25519.copy(byArray, n, 32);
        byte[] byArray6 = Ed25519.copy(byArray, n + 32, 32);
        byte[] byArray7 = Ed25519.copy(byArray2, n2, 32);
        if (!Ed25519.checkPointVar(byArray5)) {
            return false;
        }
        int[] nArray = new int[8];
        if (!Scalar25519.checkVar(byArray6, nArray)) {
            return false;
        }
        if (!Ed25519.checkPointFullVar(byArray7)) {
            return false;
        }
        PointAffine pointAffine = new PointAffine();
        if (!Ed25519.decodePointVar(byArray5, true, pointAffine)) {
            return false;
        }
        PointAffine pointAffine2 = new PointAffine();
        if (!Ed25519.decodePointVar(byArray7, true, pointAffine2)) {
            return false;
        }
        Digest digest = Ed25519.createDigest();
        byte[] byArray8 = new byte[64];
        if (byArray3 != null) {
            Ed25519.dom2(digest, by, byArray3);
        }
        digest.update(byArray5, 0, 32);
        digest.update(byArray7, 0, 32);
        digest.update(byArray4, n3, n4);
        digest.doFinal(byArray8, 0);
        byte[] byArray9 = Scalar25519.reduce512(byArray8);
        int[] nArray2 = new int[8];
        Scalar25519.decode(byArray9, nArray2);
        int[] nArray3 = new int[4];
        int[] nArray4 = new int[4];
        if (!Scalar25519.reduceBasisVar(nArray2, nArray3, nArray4)) {
            throw new IllegalStateException();
        }
        Scalar25519.multiply128Var(nArray, nArray4, nArray);
        PointAccum pointAccum = new PointAccum();
        Ed25519.scalarMultStraus128Var(nArray, nArray3, pointAffine2, nArray4, pointAffine, pointAccum);
        return Ed25519.normalizeToNeutralElementVar(pointAccum);
    }

    private static void invertDoubleZs(PointExtended[] pointExtendedArray) {
        int n = pointExtendedArray.length;
        int[] nArray = X25519Field.createTable(n);
        int[] nArray2 = X25519Field.create();
        X25519Field.copy(pointExtendedArray[0].z, 0, nArray2, 0);
        X25519Field.copy(nArray2, 0, nArray, 0);
        int n2 = 0;
        while (++n2 < n) {
            X25519Field.mul(nArray2, pointExtendedArray[n2].z, nArray2);
            X25519Field.copy(nArray2, 0, nArray, n2 * 10);
        }
        X25519Field.add(nArray2, nArray2, nArray2);
        X25519Field.invVar(nArray2, nArray2);
        --n2;
        int[] nArray3 = X25519Field.create();
        while (n2 > 0) {
            int n3 = n2--;
            X25519Field.copy(nArray, n2 * 10, nArray3, 0);
            X25519Field.mul(nArray3, nArray2, nArray3);
            X25519Field.mul(nArray2, pointExtendedArray[n3].z, nArray2);
            X25519Field.copy(nArray3, 0, pointExtendedArray[n3].z, 0);
        }
        X25519Field.copy(nArray2, 0, pointExtendedArray[0].z, 0);
    }

    private static void normalizeToAffine(PointAccum pointAccum, PointAffine pointAffine) {
        X25519Field.inv(pointAccum.z, pointAffine.y);
        X25519Field.mul(pointAffine.y, pointAccum.x, pointAffine.x);
        X25519Field.mul(pointAffine.y, pointAccum.y, pointAffine.y);
        X25519Field.normalize(pointAffine.x);
        X25519Field.normalize(pointAffine.y);
    }

    private static boolean normalizeToNeutralElementVar(PointAccum pointAccum) {
        X25519Field.normalize(pointAccum.x);
        X25519Field.normalize(pointAccum.y);
        X25519Field.normalize(pointAccum.z);
        return X25519Field.isZeroVar(pointAccum.x) && !X25519Field.isZeroVar(pointAccum.y) && X25519Field.areEqualVar(pointAccum.y, pointAccum.z);
    }

    private static void pointAdd(PointExtended pointExtended, PointExtended pointExtended2, PointExtended pointExtended3, PointTemp pointTemp) {
        int[] nArray = pointExtended3.x;
        int[] nArray2 = pointExtended3.y;
        int[] nArray3 = pointTemp.r0;
        int[] nArray4 = pointTemp.r1;
        int[] nArray5 = nArray;
        int[] nArray6 = nArray3;
        int[] nArray7 = nArray4;
        int[] nArray8 = nArray2;
        X25519Field.apm(pointExtended.y, pointExtended.x, nArray2, nArray);
        X25519Field.apm(pointExtended2.y, pointExtended2.x, nArray4, nArray3);
        X25519Field.mul(nArray, nArray3, nArray);
        X25519Field.mul(nArray2, nArray4, nArray2);
        X25519Field.mul(pointExtended.t, pointExtended2.t, nArray3);
        X25519Field.mul(nArray3, C_d2, nArray3);
        X25519Field.add(pointExtended.z, pointExtended.z, nArray4);
        X25519Field.mul(nArray4, pointExtended2.z, nArray4);
        X25519Field.apm(nArray2, nArray, nArray8, nArray5);
        X25519Field.apm(nArray4, nArray3, nArray7, nArray6);
        X25519Field.mul(nArray5, nArray8, pointExtended3.t);
        X25519Field.mul(nArray6, nArray7, pointExtended3.z);
        X25519Field.mul(nArray5, nArray6, pointExtended3.x);
        X25519Field.mul(nArray8, nArray7, pointExtended3.y);
    }

    private static void pointAdd(PointPrecomp pointPrecomp, PointAccum pointAccum, PointTemp pointTemp) {
        int[] nArray = pointAccum.x;
        int[] nArray2 = pointAccum.y;
        int[] nArray3 = pointTemp.r0;
        int[] nArray4 = pointAccum.u;
        int[] nArray5 = nArray;
        int[] nArray6 = nArray2;
        int[] nArray7 = pointAccum.v;
        X25519Field.apm(pointAccum.y, pointAccum.x, nArray2, nArray);
        X25519Field.mul(nArray, pointPrecomp.ymx_h, nArray);
        X25519Field.mul(nArray2, pointPrecomp.ypx_h, nArray2);
        X25519Field.mul(pointAccum.u, pointAccum.v, nArray3);
        X25519Field.mul(nArray3, pointPrecomp.xyd, nArray3);
        X25519Field.apm(nArray2, nArray, nArray7, nArray4);
        X25519Field.apm(pointAccum.z, nArray3, nArray6, nArray5);
        X25519Field.mul(nArray5, nArray6, pointAccum.z);
        X25519Field.mul(nArray5, nArray4, pointAccum.x);
        X25519Field.mul(nArray6, nArray7, pointAccum.y);
    }

    private static void pointAdd(PointPrecompZ pointPrecompZ, PointAccum pointAccum, PointTemp pointTemp) {
        int[] nArray = pointAccum.x;
        int[] nArray2 = pointAccum.y;
        int[] nArray3 = pointTemp.r0;
        int[] nArray4 = pointAccum.z;
        int[] nArray5 = pointAccum.u;
        int[] nArray6 = nArray;
        int[] nArray7 = nArray2;
        int[] nArray8 = pointAccum.v;
        X25519Field.apm(pointAccum.y, pointAccum.x, nArray2, nArray);
        X25519Field.mul(nArray, pointPrecompZ.ymx_h, nArray);
        X25519Field.mul(nArray2, pointPrecompZ.ypx_h, nArray2);
        X25519Field.mul(pointAccum.u, pointAccum.v, nArray3);
        X25519Field.mul(nArray3, pointPrecompZ.xyd, nArray3);
        X25519Field.mul(pointAccum.z, pointPrecompZ.z, nArray4);
        X25519Field.apm(nArray2, nArray, nArray8, nArray5);
        X25519Field.apm(nArray4, nArray3, nArray7, nArray6);
        X25519Field.mul(nArray6, nArray7, pointAccum.z);
        X25519Field.mul(nArray6, nArray5, pointAccum.x);
        X25519Field.mul(nArray7, nArray8, pointAccum.y);
    }

    private static void pointAddVar(boolean bl, PointPrecomp pointPrecomp, PointAccum pointAccum, PointTemp pointTemp) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3 = pointAccum.x;
        int[] nArray4 = pointAccum.y;
        int[] nArray5 = pointTemp.r0;
        int[] nArray6 = pointAccum.u;
        int[] nArray7 = nArray3;
        int[] nArray8 = nArray4;
        int[] nArray9 = pointAccum.v;
        if (bl) {
            nArray2 = nArray4;
            nArray = nArray3;
        } else {
            nArray2 = nArray3;
            nArray = nArray4;
        }
        int[] nArray10 = nArray2;
        int[] nArray11 = nArray;
        X25519Field.apm(pointAccum.y, pointAccum.x, nArray4, nArray3);
        X25519Field.mul(nArray2, pointPrecomp.ymx_h, nArray2);
        X25519Field.mul(nArray, pointPrecomp.ypx_h, nArray);
        X25519Field.mul(pointAccum.u, pointAccum.v, nArray5);
        X25519Field.mul(nArray5, pointPrecomp.xyd, nArray5);
        X25519Field.apm(nArray4, nArray3, nArray9, nArray6);
        X25519Field.apm(pointAccum.z, nArray5, nArray11, nArray10);
        X25519Field.mul(nArray7, nArray8, pointAccum.z);
        X25519Field.mul(nArray7, nArray6, pointAccum.x);
        X25519Field.mul(nArray8, nArray9, pointAccum.y);
    }

    private static void pointAddVar(boolean bl, PointPrecompZ pointPrecompZ, PointAccum pointAccum, PointTemp pointTemp) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3 = pointAccum.x;
        int[] nArray4 = pointAccum.y;
        int[] nArray5 = pointTemp.r0;
        int[] nArray6 = pointAccum.z;
        int[] nArray7 = pointAccum.u;
        int[] nArray8 = nArray3;
        int[] nArray9 = nArray4;
        int[] nArray10 = pointAccum.v;
        if (bl) {
            nArray2 = nArray4;
            nArray = nArray3;
        } else {
            nArray2 = nArray3;
            nArray = nArray4;
        }
        int[] nArray11 = nArray2;
        int[] nArray12 = nArray;
        X25519Field.apm(pointAccum.y, pointAccum.x, nArray4, nArray3);
        X25519Field.mul(nArray2, pointPrecompZ.ymx_h, nArray2);
        X25519Field.mul(nArray, pointPrecompZ.ypx_h, nArray);
        X25519Field.mul(pointAccum.u, pointAccum.v, nArray5);
        X25519Field.mul(nArray5, pointPrecompZ.xyd, nArray5);
        X25519Field.mul(pointAccum.z, pointPrecompZ.z, nArray6);
        X25519Field.apm(nArray4, nArray3, nArray10, nArray7);
        X25519Field.apm(nArray6, nArray5, nArray12, nArray11);
        X25519Field.mul(nArray8, nArray9, pointAccum.z);
        X25519Field.mul(nArray8, nArray7, pointAccum.x);
        X25519Field.mul(nArray9, nArray10, pointAccum.y);
    }

    private static void pointCopy(PointAccum pointAccum, PointExtended pointExtended) {
        X25519Field.copy(pointAccum.x, 0, pointExtended.x, 0);
        X25519Field.copy(pointAccum.y, 0, pointExtended.y, 0);
        X25519Field.copy(pointAccum.z, 0, pointExtended.z, 0);
        X25519Field.mul(pointAccum.u, pointAccum.v, pointExtended.t);
    }

    private static void pointCopy(PointAffine pointAffine, PointExtended pointExtended) {
        X25519Field.copy(pointAffine.x, 0, pointExtended.x, 0);
        X25519Field.copy(pointAffine.y, 0, pointExtended.y, 0);
        X25519Field.one(pointExtended.z);
        X25519Field.mul(pointAffine.x, pointAffine.y, pointExtended.t);
    }

    private static void pointCopy(PointExtended pointExtended, PointPrecompZ pointPrecompZ) {
        X25519Field.apm(pointExtended.y, pointExtended.x, pointPrecompZ.ypx_h, pointPrecompZ.ymx_h);
        X25519Field.mul(pointExtended.t, C_d2, pointPrecompZ.xyd);
        X25519Field.add(pointExtended.z, pointExtended.z, pointPrecompZ.z);
    }

    private static void pointDouble(PointAccum pointAccum) {
        int[] nArray = pointAccum.x;
        int[] nArray2 = pointAccum.y;
        int[] nArray3 = pointAccum.z;
        int[] nArray4 = pointAccum.u;
        int[] nArray5 = nArray;
        int[] nArray6 = nArray2;
        int[] nArray7 = pointAccum.v;
        X25519Field.add(pointAccum.x, pointAccum.y, nArray4);
        X25519Field.sqr(pointAccum.x, nArray);
        X25519Field.sqr(pointAccum.y, nArray2);
        X25519Field.sqr(pointAccum.z, nArray3);
        X25519Field.add(nArray3, nArray3, nArray3);
        X25519Field.apm(nArray, nArray2, nArray7, nArray6);
        X25519Field.sqr(nArray4, nArray4);
        X25519Field.sub(nArray7, nArray4, nArray4);
        X25519Field.add(nArray3, nArray6, nArray5);
        X25519Field.carry(nArray5);
        X25519Field.mul(nArray5, nArray6, pointAccum.z);
        X25519Field.mul(nArray5, nArray4, pointAccum.x);
        X25519Field.mul(nArray6, nArray7, pointAccum.y);
    }

    private static void pointLookup(int n, int n2, PointPrecomp pointPrecomp) {
        int n3 = n * 8 * 3 * 10;
        int n4 = 0;
        while (n4 < 8) {
            int n5 = (n4 ^ n2) - 1 >> 31;
            X25519Field.cmov(n5, PRECOMP_BASE_COMB, n3, pointPrecomp.ymx_h, 0);
            X25519Field.cmov(n5, PRECOMP_BASE_COMB, n3 += 10, pointPrecomp.ypx_h, 0);
            X25519Field.cmov(n5, PRECOMP_BASE_COMB, n3 += 10, pointPrecomp.xyd, 0);
            n3 += 10;
            ++n4;
        }
    }

    private static void pointLookupZ(int[] nArray, int n, int[] nArray2, PointPrecompZ pointPrecompZ) {
        int n2 = Ed25519.getWindow4(nArray, n);
        int n3 = n2 >>> 3 ^ 1;
        int n4 = (n2 ^ -n3) & 7;
        int n5 = 0;
        int n6 = 0;
        while (n5 < 8) {
            int n7 = (n5 ^ n4) - 1 >> 31;
            X25519Field.cmov(n7, nArray2, n6, pointPrecompZ.ymx_h, 0);
            X25519Field.cmov(n7, nArray2, n6 += 10, pointPrecompZ.ypx_h, 0);
            X25519Field.cmov(n7, nArray2, n6 += 10, pointPrecompZ.xyd, 0);
            X25519Field.cmov(n7, nArray2, n6 += 10, pointPrecompZ.z, 0);
            n6 += 10;
            ++n5;
        }
        X25519Field.cswap(n3, pointPrecompZ.ymx_h, pointPrecompZ.ypx_h);
        X25519Field.cnegate(n3, pointPrecompZ.xyd);
    }

    private static void pointPrecompute(PointAffine pointAffine, PointExtended[] pointExtendedArray, int n, int n2, PointTemp pointTemp) {
        pointExtendedArray[n] = new PointExtended();
        Ed25519.pointCopy(pointAffine, pointExtendedArray[n]);
        PointExtended pointExtended = new PointExtended();
        Ed25519.pointAdd(pointExtendedArray[n], pointExtendedArray[n], pointExtended, pointTemp);
        int n3 = 1;
        while (n3 < n2) {
            PointExtended pointExtended2 = new PointExtended();
            pointExtendedArray[n + n3] = pointExtended2;
            Ed25519.pointAdd(pointExtendedArray[n + n3 - 1], pointExtended, pointExtended2, pointTemp);
            ++n3;
        }
    }

    private static int[] pointPrecomputeZ(PointAffine pointAffine, int n, PointTemp pointTemp) {
        PointExtended pointExtended = new PointExtended();
        Ed25519.pointCopy(pointAffine, pointExtended);
        PointExtended pointExtended2 = new PointExtended();
        Ed25519.pointAdd(pointExtended, pointExtended, pointExtended2, pointTemp);
        PointPrecompZ pointPrecompZ = new PointPrecompZ();
        int[] nArray = X25519Field.createTable(n * 4);
        int n2 = 0;
        int n3 = 0;
        while (true) {
            Ed25519.pointCopy(pointExtended, pointPrecompZ);
            X25519Field.copy(pointPrecompZ.ymx_h, 0, nArray, n2);
            X25519Field.copy(pointPrecompZ.ypx_h, 0, nArray, n2 += 10);
            X25519Field.copy(pointPrecompZ.xyd, 0, nArray, n2 += 10);
            X25519Field.copy(pointPrecompZ.z, 0, nArray, n2 += 10);
            n2 += 10;
            if (++n3 == n) break;
            Ed25519.pointAdd(pointExtended, pointExtended2, pointExtended, pointTemp);
        }
        return nArray;
    }

    private static void pointPrecomputeZ(PointAffine pointAffine, PointPrecompZ[] pointPrecompZArray, int n, PointTemp pointTemp) {
        PointExtended pointExtended = new PointExtended();
        Ed25519.pointCopy(pointAffine, pointExtended);
        PointExtended pointExtended2 = new PointExtended();
        Ed25519.pointAdd(pointExtended, pointExtended, pointExtended2, pointTemp);
        int n2 = 0;
        while (true) {
            PointPrecompZ pointPrecompZ = pointPrecompZArray[n2] = new PointPrecompZ();
            Ed25519.pointCopy(pointExtended, pointPrecompZ);
            if (++n2 == n) break;
            Ed25519.pointAdd(pointExtended, pointExtended2, pointExtended, pointTemp);
        }
    }

    private static void pointSetNeutral(PointAccum pointAccum) {
        X25519Field.zero(pointAccum.x);
        X25519Field.one(pointAccum.y);
        X25519Field.one(pointAccum.z);
        X25519Field.zero(pointAccum.u);
        X25519Field.one(pointAccum.v);
    }

    public static void precompute() {
        Object object = PRECOMP_LOCK;
        synchronized (object) {
            int n;
            int n2;
            if (PRECOMP_BASE_COMB != null) {
                Object var1_1 = null;
                return;
            }
            int n3 = 16;
            int n4 = 64;
            int n5 = n3 * 2 + n4;
            PointExtended[] pointExtendedArray = new PointExtended[n5];
            PointTemp pointTemp = new PointTemp();
            PointAffine pointAffine = new PointAffine();
            X25519Field.copy(B_x, 0, pointAffine.x, 0);
            X25519Field.copy(B_y, 0, pointAffine.y, 0);
            Ed25519.pointPrecompute(pointAffine, pointExtendedArray, 0, n3, pointTemp);
            PointAffine pointAffine2 = new PointAffine();
            X25519Field.copy(B128_x, 0, pointAffine2.x, 0);
            X25519Field.copy(B128_y, 0, pointAffine2.y, 0);
            Ed25519.pointPrecompute(pointAffine2, pointExtendedArray, n3, n3, pointTemp);
            PointAccum pointAccum = new PointAccum();
            X25519Field.copy(B_x, 0, pointAccum.x, 0);
            X25519Field.copy(B_y, 0, pointAccum.y, 0);
            X25519Field.one(pointAccum.z);
            X25519Field.copy(pointAccum.x, 0, pointAccum.u, 0);
            X25519Field.copy(pointAccum.y, 0, pointAccum.v, 0);
            int n6 = n3 * 2;
            PointExtended[] pointExtendedArray2 = new PointExtended[4];
            int n7 = 0;
            while (n7 < 4) {
                pointExtendedArray2[n7] = new PointExtended();
                ++n7;
            }
            PointExtended pointExtended = new PointExtended();
            int n8 = 0;
            while (n8 < 8) {
                int n9;
                int n10 = n6++;
                PointExtended pointExtended2 = new PointExtended();
                pointExtendedArray[n10] = pointExtended2;
                PointExtended pointExtended3 = pointExtended2;
                int n11 = 0;
                while (n11 < 4) {
                    if (n11 == 0) {
                        Ed25519.pointCopy(pointAccum, pointExtended3);
                    } else {
                        Ed25519.pointCopy(pointAccum, pointExtended);
                        Ed25519.pointAdd(pointExtended3, pointExtended, pointExtended3, pointTemp);
                    }
                    Ed25519.pointDouble(pointAccum);
                    Ed25519.pointCopy(pointAccum, pointExtendedArray2[n11]);
                    if (n8 + n11 != 10) {
                        n9 = 1;
                        while (n9 < 8) {
                            Ed25519.pointDouble(pointAccum);
                            ++n9;
                        }
                    }
                    ++n11;
                }
                X25519Field.negate(pointExtended3.x, pointExtended3.x);
                X25519Field.negate(pointExtended3.t, pointExtended3.t);
                n9 = 0;
                while (n9 < 3) {
                    n2 = 1 << n9;
                    n = 0;
                    while (n < n2) {
                        pointExtendedArray[n6] = new PointExtended();
                        Ed25519.pointAdd(pointExtendedArray[n6 - n2], pointExtendedArray2[n9], pointExtendedArray[n6], pointTemp);
                        ++n;
                        ++n6;
                    }
                    ++n9;
                }
                ++n8;
            }
            Ed25519.invertDoubleZs(pointExtendedArray);
            PRECOMP_BASE_WNAF = new PointPrecomp[n3];
            int n12 = 0;
            while (n12 < n3) {
                PointExtended pointExtended4 = pointExtendedArray[n12];
                PointPrecomp pointPrecomp = Ed25519.PRECOMP_BASE_WNAF[n12] = new PointPrecomp();
                X25519Field.mul(pointExtended4.x, pointExtended4.z, pointExtended4.x);
                X25519Field.mul(pointExtended4.y, pointExtended4.z, pointExtended4.y);
                X25519Field.apm(pointExtended4.y, pointExtended4.x, pointPrecomp.ypx_h, pointPrecomp.ymx_h);
                X25519Field.mul(pointExtended4.x, pointExtended4.y, pointPrecomp.xyd);
                X25519Field.mul(pointPrecomp.xyd, C_d4, pointPrecomp.xyd);
                X25519Field.normalize(pointPrecomp.ymx_h);
                X25519Field.normalize(pointPrecomp.ypx_h);
                X25519Field.normalize(pointPrecomp.xyd);
                ++n12;
            }
            PRECOMP_BASE128_WNAF = new PointPrecomp[n3];
            int n13 = 0;
            while (n13 < n3) {
                PointExtended pointExtended5 = pointExtendedArray[n3 + n13];
                PointPrecomp pointPrecomp = Ed25519.PRECOMP_BASE128_WNAF[n13] = new PointPrecomp();
                X25519Field.mul(pointExtended5.x, pointExtended5.z, pointExtended5.x);
                X25519Field.mul(pointExtended5.y, pointExtended5.z, pointExtended5.y);
                X25519Field.apm(pointExtended5.y, pointExtended5.x, pointPrecomp.ypx_h, pointPrecomp.ymx_h);
                X25519Field.mul(pointExtended5.x, pointExtended5.y, pointPrecomp.xyd);
                X25519Field.mul(pointPrecomp.xyd, C_d4, pointPrecomp.xyd);
                X25519Field.normalize(pointPrecomp.ymx_h);
                X25519Field.normalize(pointPrecomp.ypx_h);
                X25519Field.normalize(pointPrecomp.xyd);
                ++n13;
            }
            PRECOMP_BASE_COMB = X25519Field.createTable(n4 * 3);
            PointPrecomp pointPrecomp = new PointPrecomp();
            n2 = 0;
            n = n3 * 2;
            while (n < n5) {
                PointExtended pointExtended6 = pointExtendedArray[n];
                X25519Field.mul(pointExtended6.x, pointExtended6.z, pointExtended6.x);
                X25519Field.mul(pointExtended6.y, pointExtended6.z, pointExtended6.y);
                X25519Field.apm(pointExtended6.y, pointExtended6.x, pointPrecomp.ypx_h, pointPrecomp.ymx_h);
                X25519Field.mul(pointExtended6.x, pointExtended6.y, pointPrecomp.xyd);
                X25519Field.mul(pointPrecomp.xyd, C_d4, pointPrecomp.xyd);
                X25519Field.normalize(pointPrecomp.ymx_h);
                X25519Field.normalize(pointPrecomp.ypx_h);
                X25519Field.normalize(pointPrecomp.xyd);
                X25519Field.copy(pointPrecomp.ymx_h, 0, PRECOMP_BASE_COMB, n2);
                X25519Field.copy(pointPrecomp.ypx_h, 0, PRECOMP_BASE_COMB, n2 += 10);
                X25519Field.copy(pointPrecomp.xyd, 0, PRECOMP_BASE_COMB, n2 += 10);
                n2 += 10;
                ++n;
            }
        }
    }

    private static void pruneScalar(byte[] byArray, int n, byte[] byArray2) {
        System.arraycopy(byArray, n, byArray2, 0, 32);
        byArray2[0] = (byte)(byArray2[0] & 0xF8);
        byArray2[31] = (byte)(byArray2[31] & 0x7F);
        byArray2[31] = (byte)(byArray2[31] | 0x40);
    }

    private static void scalarMult(byte[] byArray, PointAffine pointAffine, PointAccum pointAccum) {
        int[] nArray = new int[8];
        Scalar25519.decode(byArray, nArray);
        Scalar25519.toSignedDigits(256, nArray);
        PointPrecompZ pointPrecompZ = new PointPrecompZ();
        PointTemp pointTemp = new PointTemp();
        int[] nArray2 = Ed25519.pointPrecomputeZ(pointAffine, 8, pointTemp);
        Ed25519.pointSetNeutral(pointAccum);
        int n = 63;
        block0: while (true) {
            Ed25519.pointLookupZ(nArray, n, nArray2, pointPrecompZ);
            Ed25519.pointAdd(pointPrecompZ, pointAccum, pointTemp);
            if (--n < 0) break;
            int n2 = 0;
            while (true) {
                if (n2 >= 4) continue block0;
                Ed25519.pointDouble(pointAccum);
                ++n2;
            }
            break;
        }
    }

    private static void scalarMultBase(byte[] byArray, PointAccum pointAccum) {
        Ed25519.precompute();
        int[] nArray = new int[8];
        Scalar25519.decode(byArray, nArray);
        Scalar25519.toSignedDigits(256, nArray);
        Ed25519.groupCombBits(nArray);
        PointPrecomp pointPrecomp = new PointPrecomp();
        PointTemp pointTemp = new PointTemp();
        Ed25519.pointSetNeutral(pointAccum);
        int n = 0;
        int n2 = 28;
        while (true) {
            int n3 = 0;
            while (n3 < 8) {
                int n4 = nArray[n3] >>> n2;
                int n5 = n4 >>> 3 & 1;
                int n6 = (n4 ^ -n5) & 7;
                Ed25519.pointLookup(n3, n6, pointPrecomp);
                X25519Field.cnegate(n ^ n5, pointAccum.x);
                X25519Field.cnegate(n ^ n5, pointAccum.u);
                n = n5;
                Ed25519.pointAdd(pointPrecomp, pointAccum, pointTemp);
                ++n3;
            }
            if ((n2 -= 4) < 0) break;
            Ed25519.pointDouble(pointAccum);
        }
        X25519Field.cnegate(n, pointAccum.x);
        X25519Field.cnegate(n, pointAccum.u);
    }

    private static void scalarMultBaseEncoded(byte[] byArray, byte[] byArray2, int n) {
        PointAccum pointAccum = new PointAccum();
        Ed25519.scalarMultBase(byArray, pointAccum);
        if (Ed25519.encodeResult(pointAccum, byArray2, n) == 0) {
            throw new IllegalStateException();
        }
    }

    public static void scalarMultBaseYZ(X25519.Friend friend, byte[] byArray, int n, int[] nArray, int[] nArray2) {
        if (friend == null) {
            throw new NullPointerException("This method is only for use by X25519");
        }
        byte[] byArray2 = new byte[32];
        Ed25519.pruneScalar(byArray, n, byArray2);
        PointAccum pointAccum = new PointAccum();
        Ed25519.scalarMultBase(byArray2, pointAccum);
        if (Ed25519.checkPoint(pointAccum) == 0) {
            throw new IllegalStateException();
        }
        X25519Field.copy(pointAccum.y, 0, nArray, 0);
        X25519Field.copy(pointAccum.z, 0, nArray2, 0);
    }

    private static void scalarMultOrderVar(PointAffine pointAffine, PointAccum pointAccum) {
        byte[] byArray = new byte[253];
        Scalar25519.getOrderWnafVar(4, byArray);
        int n = 4;
        PointPrecompZ[] pointPrecompZArray = new PointPrecompZ[n];
        PointTemp pointTemp = new PointTemp();
        Ed25519.pointPrecomputeZ(pointAffine, pointPrecompZArray, n, pointTemp);
        Ed25519.pointSetNeutral(pointAccum);
        int n2 = 252;
        while (true) {
            byte by;
            if ((by = byArray[n2]) != 0) {
                int n3 = by >> 1 ^ by >> 31;
                Ed25519.pointAddVar(by < 0, pointPrecompZArray[n3], pointAccum, pointTemp);
            }
            if (--n2 < 0) break;
            Ed25519.pointDouble(pointAccum);
        }
    }

    private static void scalarMultStraus128Var(int[] nArray, int[] nArray2, PointAffine pointAffine, int[] nArray3, PointAffine pointAffine2, PointAccum pointAccum) {
        Ed25519.precompute();
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[128];
        byte[] byArray3 = new byte[128];
        Wnaf.getSignedVar(nArray, 6, byArray);
        Wnaf.getSignedVar(nArray2, 4, byArray2);
        Wnaf.getSignedVar(nArray3, 4, byArray3);
        int n = 4;
        PointPrecompZ[] pointPrecompZArray = new PointPrecompZ[n];
        PointPrecompZ[] pointPrecompZArray2 = new PointPrecompZ[n];
        PointTemp pointTemp = new PointTemp();
        Ed25519.pointPrecomputeZ(pointAffine, pointPrecompZArray, n, pointTemp);
        Ed25519.pointPrecomputeZ(pointAffine2, pointPrecompZArray2, n, pointTemp);
        Ed25519.pointSetNeutral(pointAccum);
        int n2 = 128;
        while (--n2 >= 0) {
            if ((byArray[n2] | byArray[128 + n2] | byArray2[n2] | byArray3[n2]) != 0) break;
        }
        while (n2 >= 0) {
            int n3;
            int n4;
            int n5;
            byte by = byArray[n2];
            if (by != 0) {
                n5 = by >> 1 ^ by >> 31;
                Ed25519.pointAddVar(by < 0, PRECOMP_BASE_WNAF[n5], pointAccum, pointTemp);
            }
            if ((n5 = byArray[128 + n2]) != 0) {
                n4 = n5 >> 1 ^ n5 >> 31;
                Ed25519.pointAddVar(n5 < 0, PRECOMP_BASE128_WNAF[n4], pointAccum, pointTemp);
            }
            if ((n4 = byArray2[n2]) != 0) {
                n3 = n4 >> 1 ^ n4 >> 31;
                Ed25519.pointAddVar(n4 < 0, pointPrecompZArray[n3], pointAccum, pointTemp);
            }
            if ((n3 = byArray3[n2]) != 0) {
                int n6 = n3 >> 1 ^ n3 >> 31;
                Ed25519.pointAddVar(n3 < 0, pointPrecompZArray2[n6], pointAccum, pointTemp);
            }
            Ed25519.pointDouble(pointAccum);
            --n2;
        }
        Ed25519.pointDouble(pointAccum);
        Ed25519.pointDouble(pointAccum);
    }

    public static void sign(byte[] byArray, int n, byte[] byArray2, int n2, int n3, byte[] byArray3, int n4) {
        byte[] byArray4 = null;
        byte by = 0;
        Ed25519.implSign(byArray, n, byArray4, by, byArray2, n2, n3, byArray3, n4);
    }

    public static void sign(byte[] byArray, int n, byte[] byArray2, int n2, byte[] byArray3, int n3, int n4, byte[] byArray4, int n5) {
        byte[] byArray5 = null;
        byte by = 0;
        Ed25519.implSign(byArray, n, byArray2, n2, byArray5, by, byArray3, n3, n4, byArray4, n5);
    }

    public static void sign(byte[] byArray, int n, byte[] byArray2, int n2, byte[] byArray3, byte[] byArray4, int n3, int n4, byte[] byArray5, int n5) {
        byte by = 0;
        Ed25519.implSign(byArray, n, byArray2, n2, byArray3, by, byArray4, n3, n4, byArray5, n5);
    }

    public static void sign(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2, int n3, byte[] byArray4, int n4) {
        byte by = 0;
        Ed25519.implSign(byArray, n, byArray2, by, byArray3, n2, n3, byArray4, n4);
    }

    public static void signPrehash(byte[] byArray, int n, byte[] byArray2, int n2, byte[] byArray3, Digest digest, byte[] byArray4, int n3) {
        byte[] byArray5 = new byte[64];
        if (digest.doFinal(byArray5, 0) != 64) {
            throw new IllegalArgumentException("ph");
        }
        byte by = 1;
        Ed25519.implSign(byArray, n, byArray2, n2, byArray3, by, byArray5, 0, byArray5.length, byArray4, n3);
    }

    public static void signPrehash(byte[] byArray, int n, byte[] byArray2, int n2, byte[] byArray3, byte[] byArray4, int n3, byte[] byArray5, int n4) {
        byte by = 1;
        Ed25519.implSign(byArray, n, byArray2, n2, byArray3, by, byArray4, n3, 64, byArray5, n4);
    }

    public static void signPrehash(byte[] byArray, int n, byte[] byArray2, Digest digest, byte[] byArray3, int n2) {
        byte[] byArray4 = new byte[64];
        if (digest.doFinal(byArray4, 0) != 64) {
            throw new IllegalArgumentException("ph");
        }
        byte by = 1;
        Ed25519.implSign(byArray, n, byArray2, by, byArray4, 0, byArray4.length, byArray3, n2);
    }

    public static void signPrehash(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2, byte[] byArray4, int n3) {
        byte by = 1;
        Ed25519.implSign(byArray, n, byArray2, by, byArray3, n2, 64, byArray4, n3);
    }

    public static boolean validatePublicKeyFull(byte[] byArray, int n) {
        byte[] byArray2 = Ed25519.copy(byArray, n, 32);
        if (!Ed25519.checkPointFullVar(byArray2)) {
            return false;
        }
        PointAffine pointAffine = new PointAffine();
        if (!Ed25519.decodePointVar(byArray2, false, pointAffine)) {
            return false;
        }
        return Ed25519.checkPointOrderVar(pointAffine);
    }

    public static PublicPoint validatePublicKeyFullExport(byte[] byArray, int n) {
        byte[] byArray2 = Ed25519.copy(byArray, n, 32);
        if (!Ed25519.checkPointFullVar(byArray2)) {
            return null;
        }
        PointAffine pointAffine = new PointAffine();
        if (!Ed25519.decodePointVar(byArray2, false, pointAffine)) {
            return null;
        }
        if (!Ed25519.checkPointOrderVar(pointAffine)) {
            return null;
        }
        return Ed25519.exportPoint(pointAffine);
    }

    public static boolean validatePublicKeyPartial(byte[] byArray, int n) {
        byte[] byArray2 = Ed25519.copy(byArray, n, 32);
        if (!Ed25519.checkPointFullVar(byArray2)) {
            return false;
        }
        PointAffine pointAffine = new PointAffine();
        return Ed25519.decodePointVar(byArray2, false, pointAffine);
    }

    public static PublicPoint validatePublicKeyPartialExport(byte[] byArray, int n) {
        byte[] byArray2 = Ed25519.copy(byArray, n, 32);
        if (!Ed25519.checkPointFullVar(byArray2)) {
            return null;
        }
        PointAffine pointAffine = new PointAffine();
        if (!Ed25519.decodePointVar(byArray2, false, pointAffine)) {
            return null;
        }
        return Ed25519.exportPoint(pointAffine);
    }

    public static boolean verify(byte[] byArray, int n, PublicPoint publicPoint, byte[] byArray2, int n2, int n3) {
        byte[] byArray3 = null;
        byte by = 0;
        return Ed25519.implVerify(byArray, n, publicPoint, byArray3, by, byArray2, n2, n3);
    }

    public static boolean verify(byte[] byArray, int n, PublicPoint publicPoint, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        byte by = 0;
        return Ed25519.implVerify(byArray, n, publicPoint, byArray2, by, byArray3, n2, n3);
    }

    public static boolean verify(byte[] byArray, int n, byte[] byArray2, int n2, byte[] byArray3, int n3, int n4) {
        byte[] byArray4 = null;
        byte by = 0;
        return Ed25519.implVerify(byArray, n, byArray2, n2, byArray4, by, byArray3, n3, n4);
    }

    public static boolean verify(byte[] byArray, int n, byte[] byArray2, int n2, byte[] byArray3, byte[] byArray4, int n3, int n4) {
        byte by = 0;
        return Ed25519.implVerify(byArray, n, byArray2, n2, byArray3, by, byArray4, n3, n4);
    }

    public static boolean verifyPrehash(byte[] byArray, int n, PublicPoint publicPoint, byte[] byArray2, Digest digest) {
        byte[] byArray3 = new byte[64];
        if (digest.doFinal(byArray3, 0) != 64) {
            throw new IllegalArgumentException("ph");
        }
        byte by = 1;
        return Ed25519.implVerify(byArray, n, publicPoint, byArray2, by, byArray3, 0, byArray3.length);
    }

    public static boolean verifyPrehash(byte[] byArray, int n, PublicPoint publicPoint, byte[] byArray2, byte[] byArray3, int n2) {
        byte by = 1;
        return Ed25519.implVerify(byArray, n, publicPoint, byArray2, by, byArray3, n2, 64);
    }

    public static boolean verifyPrehash(byte[] byArray, int n, byte[] byArray2, int n2, byte[] byArray3, Digest digest) {
        byte[] byArray4 = new byte[64];
        if (digest.doFinal(byArray4, 0) != 64) {
            throw new IllegalArgumentException("ph");
        }
        byte by = 1;
        return Ed25519.implVerify(byArray, n, byArray2, n2, byArray3, by, byArray4, 0, byArray4.length);
    }

    public static boolean verifyPrehash(byte[] byArray, int n, byte[] byArray2, int n2, byte[] byArray3, byte[] byArray4, int n3) {
        byte by = 1;
        return Ed25519.implVerify(byArray, n, byArray2, n2, byArray3, by, byArray4, n3, 64);
    }

    public static final class Algorithm {
        public static final int Ed25519 = 0;
        public static final int Ed25519ctx = 1;
        public static final int Ed25519ph = 2;
    }

    public static final class PublicPoint {
        final int[] data;

        PublicPoint(int[] nArray) {
            this.data = nArray;
        }
    }

    private static class F
    extends X25519Field {
        F() {
        }
    }

    private static class PointAccum {
        int[] x = X25519Field.create();
        int[] y = X25519Field.create();
        int[] z = X25519Field.create();
        int[] u = X25519Field.create();
        int[] v = X25519Field.create();

        PointAccum() {
        }
    }

    private static class PointAffine {
        int[] x = X25519Field.create();
        int[] y = X25519Field.create();

        PointAffine() {
        }
    }

    private static class PointExtended {
        int[] x = X25519Field.create();
        int[] y = X25519Field.create();
        int[] z = X25519Field.create();
        int[] t = X25519Field.create();

        PointExtended() {
        }
    }

    private static class PointPrecomp {
        int[] ymx_h = X25519Field.create();
        int[] ypx_h = X25519Field.create();
        int[] xyd = X25519Field.create();

        PointPrecomp() {
        }
    }

    private static class PointPrecompZ {
        int[] ymx_h = X25519Field.create();
        int[] ypx_h = X25519Field.create();
        int[] xyd = X25519Field.create();
        int[] z = X25519Field.create();

        PointPrecompZ() {
        }
    }

    private static class PointTemp {
        int[] r0 = X25519Field.create();
        int[] r1 = X25519Field.create();

        PointTemp() {
        }
    }
}

