/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.AbstractECLookupTable;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECLookupTable;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.sec.SecT193FieldElement;
import org.bouncycastle.math.ec.custom.sec.SecT193R2Point;
import org.bouncycastle.math.raw.Nat256;
import org.bouncycastle.util.encoders.Hex;

public class SecT193R2Curve
extends ECCurve.AbstractF2m {
    private static final int SECT193R2_DEFAULT_COORDS = 6;
    private static final ECFieldElement[] SECT193R2_AFFINE_ZS = new ECFieldElement[]{new SecT193FieldElement(ECConstants.ONE)};
    protected SecT193R2Point infinity = new SecT193R2Point(this, null, null);

    public SecT193R2Curve() {
        super(193, 15, 0, 0);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("0163F35A5137C2CE3EA6ED8667190B0BC43ECD69977702709B")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("00C9BB9E8927D4D64C377E2AB2856A5B16E3EFB7F61D4316AE")));
        this.order = new BigInteger(1, Hex.decodeStrict("010000000000000000000000015AAB561B005413CCD4EE99D5"));
        this.cofactor = BigInteger.valueOf(2L);
        this.coord = 6;
    }

    protected ECCurve cloneCurve() {
        return new SecT193R2Curve();
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, final int n2) {
        final int n3 = 4;
        final long[] lArray = new long[n2 * 4 * 2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            ECPoint eCPoint = eCPointArray[n + n5];
            Nat256.copy64(((SecT193FieldElement)eCPoint.getRawXCoord()).x, 0, lArray, n4);
            Nat256.copy64(((SecT193FieldElement)eCPoint.getRawYCoord()).x, 0, lArray, n4 += 4);
            n4 += 4;
            ++n5;
        }
        return new AbstractECLookupTable(){

            private ECPoint createPoint(long[] lArray3, long[] lArray2) {
                return this.createRawPoint(new SecT193FieldElement(lArray3), new SecT193FieldElement(lArray2), SECT193R2_AFFINE_ZS);
            }

            public int getSize() {
                return n2;
            }

            public ECPoint lookup(int n) {
                long[] lArray3 = Nat256.create64();
                long[] lArray2 = Nat256.create64();
                int n22 = 0;
                int n32 = 0;
                while (n32 < n2) {
                    long l = (n32 ^ n) - 1 >> 31;
                    int n4 = 0;
                    while (n4 < n3) {
                        int n5 = n4;
                        lArray3[n5] = lArray3[n5] ^ lArray[n22 + n4] & l;
                        int n6 = n4;
                        lArray2[n6] = lArray2[n6] ^ lArray[n22 + n3 + n4] & l;
                        ++n4;
                    }
                    n22 += n3 * 2;
                    ++n32;
                }
                return this.createPoint(lArray3, lArray2);
            }

            public ECPoint lookupVar(int n) {
                long[] lArray3 = Nat256.create64();
                long[] lArray2 = Nat256.create64();
                int n22 = n * n3 * 2;
                int n32 = 0;
                while (n32 < n3) {
                    int n4 = n32;
                    lArray3[n4] = lArray3[n4] ^ lArray[n22 + n32];
                    int n5 = n32;
                    lArray2[n5] = lArray2[n5] ^ lArray[n22 + n3 + n32];
                    ++n32;
                }
                return this.createPoint(lArray3, lArray2);
            }
        };
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecT193R2Point(this, eCFieldElement, eCFieldElement2);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecT193R2Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT193FieldElement(bigInteger);
    }

    public int getFieldSize() {
        return 193;
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public int getK1() {
        return 15;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    public int getM() {
        return 193;
    }

    public boolean isKoblitz() {
        return false;
    }

    public boolean isTrinomial() {
        return true;
    }

    public boolean supportsCoordinateSystem(int n) {
        switch (n) {
            case 6: {
                return true;
            }
        }
        return false;
    }
}

