/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.AbstractECLookupTable;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECLookupTable;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.sec.SecT113FieldElement;
import org.bouncycastle.math.ec.custom.sec.SecT113R1Point;
import org.bouncycastle.math.raw.Nat128;
import org.bouncycastle.util.encoders.Hex;

public class SecT113R1Curve
extends ECCurve.AbstractF2m {
    private static final int SECT113R1_DEFAULT_COORDS = 6;
    private static final ECFieldElement[] SECT113R1_AFFINE_ZS = new ECFieldElement[]{new SecT113FieldElement(ECConstants.ONE)};
    protected SecT113R1Point infinity = new SecT113R1Point(this, null, null);

    public SecT113R1Curve() {
        super(113, 9, 0, 0);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("003088250CA6E7C7FE649CE85820F7")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("00E8BEE4D3E2260744188BE0E9C723")));
        this.order = new BigInteger(1, Hex.decodeStrict("0100000000000000D9CCEC8A39E56F"));
        this.cofactor = BigInteger.valueOf(2L);
        this.coord = 6;
    }

    protected ECCurve cloneCurve() {
        return new SecT113R1Curve();
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, final int n2) {
        final int n3 = 2;
        final long[] lArray = new long[n2 * 2 * 2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            ECPoint eCPoint = eCPointArray[n + n5];
            Nat128.copy64(((SecT113FieldElement)eCPoint.getRawXCoord()).x, 0, lArray, n4);
            Nat128.copy64(((SecT113FieldElement)eCPoint.getRawYCoord()).x, 0, lArray, n4 += 2);
            n4 += 2;
            ++n5;
        }
        return new AbstractECLookupTable(){

            private ECPoint createPoint(long[] lArray3, long[] lArray2) {
                return this.createRawPoint(new SecT113FieldElement(lArray3), new SecT113FieldElement(lArray2), SECT113R1_AFFINE_ZS);
            }

            public int getSize() {
                return n2;
            }

            public ECPoint lookup(int n) {
                long[] lArray3 = Nat128.create64();
                long[] lArray2 = Nat128.create64();
                int n22 = 0;
                int n32 = 0;
                while (n32 < n2) {
                    long l = (n32 ^ n) - 1 >> 31;
                    int n4 = 0;
                    while (n4 < n3) {
                        int n5 = n4;
                        lArray3[n5] = lArray3[n5] ^ lArray[n22 + n4] & l;
                        int n6 = n4;
                        lArray2[n6] = lArray2[n6] ^ lArray[n22 + n3 + n4] & l;
                        ++n4;
                    }
                    n22 += n3 * 2;
                    ++n32;
                }
                return this.createPoint(lArray3, lArray2);
            }

            public ECPoint lookupVar(int n) {
                long[] lArray3 = Nat128.create64();
                long[] lArray2 = Nat128.create64();
                int n22 = n * n3 * 2;
                int n32 = 0;
                while (n32 < n3) {
                    lArray3[n32] = lArray[n22 + n32];
                    lArray2[n32] = lArray[n22 + n3 + n32];
                    ++n32;
                }
                return this.createPoint(lArray3, lArray2);
            }
        };
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecT113R1Point(this, eCFieldElement, eCFieldElement2);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecT113R1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT113FieldElement(bigInteger);
    }

    public int getFieldSize() {
        return 113;
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public int getK1() {
        return 9;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    public int getM() {
        return 113;
    }

    public boolean isKoblitz() {
        return false;
    }

    public boolean isTrinomial() {
        return true;
    }

    public boolean supportsCoordinateSystem(int n) {
        switch (n) {
            case 6: {
                return true;
            }
        }
        return false;
    }
}

