/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import org.bouncycastle.jcajce.PKIXCRLStore;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Iterable;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

class CrlCache {
    private static final int DEFAULT_TIMEOUT = 15000;
    private static Hashtable cache = new Hashtable();

    CrlCache() {
    }

    static synchronized PKIXCRLStore getCrl(CertificateFactory certificateFactory, Date date, URL uRL) throws IOException, CRLException {
        Object object;
        PKIXCRLStore pKIXCRLStore = null;
        WeakReference weakReference = (WeakReference)cache.get(uRL);
        if (weakReference != null) {
            pKIXCRLStore = (PKIXCRLStore)weakReference.get();
        }
        if (pKIXCRLStore != null) {
            boolean bl = false;
            object = pKIXCRLStore.getMatches(null).iterator();
            while (object.hasNext()) {
                X509CRL x509CRL = (X509CRL)object.next();
                Date date2 = x509CRL.getNextUpdate();
                if (date2 == null || !date2.before(date)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return pKIXCRLStore;
            }
        }
        Collection collection = CrlCache.getCrls(certificateFactory, uRL);
        object = new LocalCRLStore(new CollectionStore(collection));
        cache.put(uRL, new WeakReference(object));
        return object;
    }

    private static Collection getCrls(CertificateFactory certificateFactory, URL uRL) throws IOException, CRLException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        InputStream inputStream = httpURLConnection.getInputStream();
        Collection<? extends CRL> collection = certificateFactory.generateCRLs(inputStream);
        inputStream.close();
        return collection;
    }

    private static class LocalCRLStore
    implements PKIXCRLStore,
    Iterable {
        private Collection _local;

        public LocalCRLStore(Store store) {
            this._local = new ArrayList(store.getMatches(null));
        }

        public Collection getMatches(Selector selector) {
            if (selector == null) {
                return new ArrayList(this._local);
            }
            ArrayList<CRL> arrayList = new ArrayList<CRL>();
            Iterator iterator = this._local.iterator();
            while (iterator.hasNext()) {
                CRL cRL = (CRL)iterator.next();
                if (!selector.match(cRL)) continue;
                arrayList.add(cRL);
            }
            return arrayList;
        }

        public Iterator iterator() {
            return this.getMatches(null).iterator();
        }
    }

    private static class WeakReference {
        private Object o;

        WeakReference(Object object) {
            this.o = object;
        }

        public Object get() {
            return this.o;
        }
    }
}

