/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.cert;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.util.ASN1Dump;

public final class PolicyQualifierInfo {
    private String id;
    private byte[] encoded;
    private byte[] qualifier;

    public PolicyQualifierInfo(byte[] byArray) throws IOException {
        this.encoded = (byte[])byArray.clone();
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.encoded);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
            this.id = ((ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0)).getId();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = ASN1OutputStream.create(byteArrayOutputStream, "DER");
            aSN1OutputStream.writeObject(aSN1Sequence.getObjectAt(1));
            aSN1OutputStream.close();
            this.qualifier = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new IOException("parsing exception : " + exception.toString());
        }
    }

    public byte[] getEncoded() {
        return (byte[])this.encoded.clone();
    }

    public byte[] getPolicyQualifier() {
        if (this.qualifier == null) {
            return null;
        }
        return (byte[])this.qualifier.clone();
    }

    public String getPolicyQualifierId() {
        return this.id;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PolicyQualifierInfo: [\n");
        stringBuffer.append("qualifierID: ").append(this.id).append('\n');
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.qualifier);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
            stringBuffer.append("  qualifier:\n").append(ASN1Dump.dumpAsString(aSN1Primitive)).append('\n');
        }
        catch (IOException iOException) {
            stringBuffer.append(iOException.getMessage());
        }
        stringBuffer.append("qualifier: ").append(this.id).append('\n');
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

