/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.util;

import java.security.PrivateKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AnnotatedPrivateKey
implements PrivateKey {
    public static final String LABEL = "label";
    private final PrivateKey key;
    private final Map annotations;

    AnnotatedPrivateKey(PrivateKey privateKey, String string) {
        this.key = privateKey;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(LABEL, string);
        this.annotations = Collections.unmodifiableMap(hashMap);
    }

    AnnotatedPrivateKey(PrivateKey privateKey, Map map) {
        this.key = privateKey;
        this.annotations = map;
    }

    public AnnotatedPrivateKey addAnnotation(String string, Object object) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(this.annotations);
        hashMap.put(string, object);
        return new AnnotatedPrivateKey(this.key, Collections.unmodifiableMap(hashMap));
    }

    public boolean equals(Object object) {
        if (object instanceof AnnotatedPrivateKey) {
            return this.key.equals(((AnnotatedPrivateKey)object).key);
        }
        return this.key.equals(object);
    }

    public String getAlgorithm() {
        return this.key.getAlgorithm();
    }

    public Object getAnnotation(String string) {
        return this.annotations.get(string);
    }

    public Map getAnnotations() {
        return this.annotations;
    }

    public byte[] getEncoded() {
        return this.key.getEncoded();
    }

    public String getFormat() {
        return this.key.getFormat();
    }

    public PrivateKey getKey() {
        return this.key;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public AnnotatedPrivateKey removeAnnotation(String string) {
        HashMap hashMap = new HashMap(this.annotations);
        hashMap.remove(string);
        return new AnnotatedPrivateKey(this.key, Collections.unmodifiableMap(hashMap));
    }

    public String toString() {
        if (this.annotations.containsKey(LABEL)) {
            return this.annotations.get(LABEL).toString();
        }
        return this.key.toString();
    }
}

