/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.drbg;

import java.security.SecureRandom;
import org.bouncycastle.crypto.prng.EntropySource;
import org.bouncycastle.crypto.prng.EntropySourceProvider;
import org.bouncycastle.jcajce.provider.drbg.IncrementalEntropySource;

class IncrementalEntropySourceProvider
implements EntropySourceProvider {
    private final SecureRandom random;
    private final boolean predictionResistant;

    public IncrementalEntropySourceProvider(SecureRandom secureRandom, boolean bl) {
        this.random = secureRandom;
        this.predictionResistant = bl;
    }

    public EntropySource get(final int n) {
        return new IncrementalEntropySource(){
            final int numBytes;
            {
                this.numBytes = (n2 + 7) / 8;
            }

            public int entropySize() {
                return n;
            }

            public byte[] getEntropy() {
                try {
                    return this.getEntropy(0L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException("initial entropy fetch interrupted");
                }
            }

            public byte[] getEntropy(long l) throws InterruptedException {
                byte[] byArray = new byte[this.numBytes];
                int n3 = 0;
                while (n3 < this.numBytes / 8) {
                    IncrementalEntropySourceProvider.sleep(l);
                    byte[] byArray2 = random.generateSeed(8);
                    System.arraycopy(byArray2, 0, byArray, n3 * 8, byArray2.length);
                    ++n3;
                }
                int n2 = this.numBytes - this.numBytes / 8 * 8;
                if (n2 != 0) {
                    IncrementalEntropySourceProvider.sleep(l);
                    byte[] byArray3 = random.generateSeed(n2);
                    System.arraycopy(byArray3, 0, byArray, byArray.length - byArray3.length, byArray3.length);
                }
                return byArray;
            }

            public boolean isPredictionResistant() {
                return predictionResistant;
            }
        };
    }

    private static void sleep(long l) throws InterruptedException {
        if (l != 0L) {
            Thread.sleep(l);
        }
    }
}

