/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.x509;

import java.security.cert.CRLException;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.jcajce.provider.asymmetric.x509.ExtCRLException;
import org.bouncycastle.jcajce.provider.asymmetric.x509.X509CRLImpl;
import org.bouncycastle.jcajce.provider.asymmetric.x509.X509CRLInternal;
import org.bouncycastle.jcajce.provider.asymmetric.x509.X509SignatureUtil;
import org.bouncycastle.jcajce.util.JcaJceHelper;

class X509CRLObject
extends X509CRLImpl {
    private final Object cacheLock = new Object();
    private X509CRLInternal internalCRLValue;
    private volatile boolean hashValueSet;
    private volatile int hashValue;

    X509CRLObject(JcaJceHelper jcaJceHelper, CertificateList certificateList) throws CRLException {
        super(jcaJceHelper, certificateList, X509CRLObject.createSigAlgName(certificateList), X509CRLObject.createSigAlgParams(certificateList), X509CRLObject.isIndirectCRL(certificateList));
    }

    private static String createSigAlgName(CertificateList certificateList) throws CRLException {
        try {
            return X509SignatureUtil.getSignatureName(certificateList.getSignatureAlgorithm());
        }
        catch (Exception exception) {
            throw new CRLException("CRL contents invalid: " + exception);
        }
    }

    private static byte[] createSigAlgParams(CertificateList certificateList) throws CRLException {
        try {
            ASN1Encodable aSN1Encodable = certificateList.getSignatureAlgorithm().getParameters();
            if (aSN1Encodable == null) {
                return null;
            }
            return aSN1Encodable.toASN1Primitive().getEncoded("DER");
        }
        catch (Exception exception) {
            throw new CRLException("CRL contents invalid: " + exception);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof X509CRLObject) {
            ASN1BitString aSN1BitString;
            X509CRLObject x509CRLObject = (X509CRLObject)object;
            if (this.hashValueSet && x509CRLObject.hashValueSet ? this.hashValue != x509CRLObject.hashValue : (this.internalCRLValue == null || x509CRLObject.internalCRLValue == null) && (aSN1BitString = this.c.getSignature()) != null && !aSN1BitString.equals(x509CRLObject.c.getSignature())) {
                return false;
            }
        }
        return this.getInternalCRL().equals(object);
    }

    private X509CRLInternal getInternalCRL() {
        byte[] byArray;
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.internalCRLValue != null) {
                X509CRLInternal x509CRLInternal = this.internalCRLValue;
                Object var3_4 = null;
                return x509CRLInternal;
            }
        }
        object = null;
        try {
            byArray = this.getEncoded();
        }
        catch (CRLException cRLException) {
            object = cRLException;
            byArray = null;
        }
        X509CRLInternal x509CRLInternal = new X509CRLInternal(this.bcHelper, this.c, this.sigAlgName, this.sigAlgParams, this.isIndirect, byArray, (CRLException)object);
        Object object2 = this.cacheLock;
        synchronized (object2) {
            if (this.internalCRLValue == null) {
                this.internalCRLValue = x509CRLInternal;
            }
            X509CRLInternal x509CRLInternal2 = this.internalCRLValue;
            Object var6_9 = null;
            return x509CRLInternal2;
        }
    }

    public int hashCode() {
        if (!this.hashValueSet) {
            this.hashValue = this.getInternalCRL().hashCode();
            this.hashValueSet = true;
        }
        return this.hashValue;
    }

    private static boolean isIndirectCRL(CertificateList certificateList) throws CRLException {
        try {
            byte[] byArray = X509CRLImpl.getExtensionOctets(certificateList, Extension.issuingDistributionPoint.getId());
            if (byArray == null) {
                return false;
            }
            return IssuingDistributionPoint.getInstance(byArray).isIndirectCRL();
        }
        catch (Exception exception) {
            throw new ExtCRLException("Exception reading IssuingDistributionPoint", exception);
        }
    }
}

