/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.util;

import java.io.IOException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;

public abstract class BaseKeyFactorySpi
extends KeyFactorySpi
implements AsymmetricKeyInfoConverter {
    static /* synthetic */ Class class$java$security$spec$PKCS8EncodedKeySpec;
    static /* synthetic */ Class class$java$security$spec$X509EncodedKeySpec;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                return this.generatePrivate(PrivateKeyInfo.getInstance(((PKCS8EncodedKeySpec)keySpec).getEncoded()));
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException("encoded key spec not recognized: " + exception.getMessage());
            }
        }
        throw new InvalidKeySpecException("key spec not recognized");
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                return this.generatePublic(SubjectPublicKeyInfo.getInstance(((X509EncodedKeySpec)keySpec).getEncoded()));
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException("encoded key spec not recognized: " + exception.getMessage());
            }
        }
        throw new InvalidKeySpecException("key spec not recognized");
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (clazz.isAssignableFrom(class$java$security$spec$PKCS8EncodedKeySpec != null ? class$java$security$spec$PKCS8EncodedKeySpec : (class$java$security$spec$PKCS8EncodedKeySpec = BaseKeyFactorySpi.class$("java.security.spec.PKCS8EncodedKeySpec"))) && key.getFormat().equals("PKCS#8")) {
            return new PKCS8EncodedKeySpec(key.getEncoded());
        }
        if (clazz.isAssignableFrom(class$java$security$spec$X509EncodedKeySpec != null ? class$java$security$spec$X509EncodedKeySpec : (class$java$security$spec$X509EncodedKeySpec = BaseKeyFactorySpi.class$("java.security.spec.X509EncodedKeySpec"))) && key.getFormat().equals("X.509")) {
            return new X509EncodedKeySpec(key.getEncoded());
        }
        throw new InvalidKeySpecException("not implemented yet " + key + " " + clazz);
    }

    public abstract PrivateKey generatePrivate(PrivateKeyInfo var1) throws IOException;

    public abstract PublicKey generatePublic(SubjectPublicKeyInfo var1) throws IOException;
}

