/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.slhdsa;

import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.jcajce.provider.asymmetric.slhdsa.BCSLHDSAPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.slhdsa.BCSLHDSAPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.BaseDeterministicOrRandomSignature;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAPublicKeyParameters;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSASigner;

public class SignatureSpi
extends BaseDeterministicOrRandomSignature {
    private final ByteArrayOutputStream bOut = new ByteArrayOutputStream();
    private final SLHDSASigner signer;

    protected SignatureSpi(SLHDSASigner sLHDSASigner) {
        super("SLH-DSA");
        this.signer = sLHDSASigner;
    }

    protected byte[] engineSign() throws SignatureException {
        AsymmetricKeyParameter asymmetricKeyParameter = this.keyParams;
        if (!(asymmetricKeyParameter instanceof SLHDSAPrivateKeyParameters)) {
            throw new SignatureException("engine initialized for verification");
        }
        try {
            try {
                byte[] byArray;
                byte[] byArray2 = byArray = this.signer.generateSignature(this.bOut.toByteArray());
                Object var4_5 = null;
                this.isInitState = true;
                this.bOut.reset();
                return byArray2;
            }
            catch (Exception exception) {
                throw new SignatureException(exception.toString());
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.isInitState = true;
            this.bOut.reset();
            throw throwable;
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        AsymmetricKeyParameter asymmetricKeyParameter = this.keyParams;
        if (!(asymmetricKeyParameter instanceof SLHDSAPublicKeyParameters)) {
            throw new SignatureException("engine initialized for signing");
        }
        try {
            boolean bl = this.signer.verifySignature(this.bOut.toByteArray(), byArray);
            Object var5_4 = null;
            this.isInitState = true;
            this.bOut.reset();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.isInitState = true;
            this.bOut.reset();
            throw throwable;
        }
    }

    protected void reInitialize(boolean bl, CipherParameters cipherParameters) {
        this.signer.init(bl, cipherParameters);
        this.bOut.reset();
    }

    protected void signInit(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.appRandom = secureRandom;
        if (!(privateKey instanceof BCSLHDSAPrivateKey)) {
            throw new InvalidKeyException("unknown private key passed to SLH-DSA");
        }
        BCSLHDSAPrivateKey bCSLHDSAPrivateKey = (BCSLHDSAPrivateKey)privateKey;
        this.keyParams = bCSLHDSAPrivateKey.getKeyParams();
    }

    protected void updateEngine(byte by) throws SignatureException {
        this.bOut.write(by);
    }

    protected void updateEngine(byte[] byArray, int n, int n2) throws SignatureException {
        this.bOut.write(byArray, n, n2);
    }

    protected void verifyInit(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof BCSLHDSAPublicKey)) {
            throw new InvalidKeyException("unknown public key passed to SLH-DSA");
        }
        BCSLHDSAPublicKey bCSLHDSAPublicKey = (BCSLHDSAPublicKey)publicKey;
        this.keyParams = bCSLHDSAPublicKey.getKeyParams();
    }

    public static class Direct
    extends SignatureSpi {
        public Direct() {
            super(new SLHDSASigner());
        }
    }
}

