/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.rsa;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Properties;

class CustomPKCS1Encoding
implements AsymmetricBlockCipher {
    private static final int HEADER_LENGTH = 10;
    private SecureRandom random;
    private AsymmetricBlockCipher engine;
    private boolean forEncryption;
    private boolean forPrivateKey;
    private boolean useStrictLength;
    private byte[] blockBuffer;

    CustomPKCS1Encoding(AsymmetricBlockCipher asymmetricBlockCipher) {
        this.engine = asymmetricBlockCipher;
        this.useStrictLength = this.useStrict();
    }

    private static int checkPkcs1Encoding1(byte[] byArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = -(byArray[0] & 0xFF ^ 1);
        int n5 = 1;
        while (n5 < byArray.length) {
            n = byArray[n5] & 0xFF;
            int n6 = n - 1 >> 31;
            int n7 = (n ^ 0xFF) - 1 >> 31;
            n3 ^= n5 & ~n2 & n6;
            n4 |= ~((n2 |= n6) | n7);
            ++n5;
        }
        n = byArray.length - 1 - n3;
        return n | (n4 |= n3 - 9) >> 31;
    }

    private static int checkPkcs1Encoding2(byte[] byArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = -(byArray[0] & 0xFF ^ 2);
        int n5 = 1;
        while (n5 < byArray.length) {
            n = byArray[n5] & 0xFF;
            int n6 = n - 1 >> 31;
            n3 ^= n5 & ~n2 & n6;
            n2 |= n6;
            ++n5;
        }
        n = byArray.length - 1 - n3;
        return n | (n4 |= n3 - 9) >> 31;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] decodeBlock(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        byte[] byArray2;
        byte[] byArray3;
        block5: {
            byte[] byArray4;
            block4: {
                int n3 = this.engine.getOutputBlockSize();
                byArray3 = this.engine.processBlock(byArray, n, n2);
                boolean bl = this.useStrictLength & byArray3.length != n3;
                byte[] byArray5 = byArray3;
                if (byArray3.length < n3) {
                    byArray5 = this.blockBuffer;
                }
                int n4 = this.forPrivateKey ? CustomPKCS1Encoding.checkPkcs1Encoding2(byArray5) : CustomPKCS1Encoding.checkPkcs1Encoding1(byArray5);
                try {
                    if (n4 < 0 | bl) {
                        byArray4 = null;
                        Object var11_11 = null;
                        break block4;
                    }
                    byte[] byArray6 = new byte[n4];
                    System.arraycopy(byArray5, byArray5.length - n4, byArray6, 0, n4);
                    byArray2 = byArray6;
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    Arrays.fill(byArray3, (byte)0);
                    Arrays.fill(this.blockBuffer, 0, Math.max(0, this.blockBuffer.length - byArray3.length), (byte)0);
                    throw throwable;
                }
            }
            Arrays.fill(byArray3, (byte)0);
            Arrays.fill(this.blockBuffer, 0, Math.max(0, this.blockBuffer.length - byArray3.length), (byte)0);
            return byArray4;
        }
        Object var11_12 = null;
        Arrays.fill(byArray3, (byte)0);
        Arrays.fill(this.blockBuffer, 0, Math.max(0, this.blockBuffer.length - byArray3.length), (byte)0);
        return byArray2;
    }

    /*
     * Unable to fully structure code
     */
    private byte[] encodeBlock(byte[] var1_1, int var2_2, int var3_3) throws InvalidCipherTextException {
        block5: {
            block4: {
                if (var3_3 > this.getInputBlockSize()) {
                    throw new IllegalArgumentException("input data too large");
                }
                var4_4 = new byte[this.engine.getInputBlockSize()];
                if (!this.forPrivateKey) break block4;
                var4_4[0] = 1;
                var5_5 = 1;
                while (var5_5 != var4_4.length - var3_3 - 1) {
                    var4_4[var5_5] = -1;
                    ++var5_5;
                }
                break block5;
            }
            this.random.nextBytes(var4_4);
            var4_4[0] = 2;
            var5_6 = 1;
            ** GOTO lbl21
            {
                var4_4[var5_6] = (byte)this.random.nextInt();
                do {
                    if (var4_4[var5_6] == 0) continue block1;
                    ++var5_6;
lbl21:
                    // 2 sources

                } while (var5_6 != var4_4.length - var3_3 - 1);
            }
        }
        var4_4[var4_4.length - var3_3 - 1] = 0;
        System.arraycopy(var1_1, var2_2, var4_4, var4_4.length - var3_3, var3_3);
        return this.engine.processBlock(var4_4, 0, var4_4.length);
    }

    public int getInputBlockSize() {
        int n = this.engine.getInputBlockSize();
        if (this.forEncryption) {
            return n - 10;
        }
        return n;
    }

    public int getOutputBlockSize() {
        int n = this.engine.getOutputBlockSize();
        if (this.forEncryption) {
            return n;
        }
        return n - 10;
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        AsymmetricKeyParameter asymmetricKeyParameter;
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.random = parametersWithRandom.getRandom();
            asymmetricKeyParameter = (AsymmetricKeyParameter)parametersWithRandom.getParameters();
        } else {
            asymmetricKeyParameter = (AsymmetricKeyParameter)cipherParameters;
            if (!asymmetricKeyParameter.isPrivate() && bl) {
                this.random = CryptoServicesRegistrar.getSecureRandom();
            }
        }
        this.engine.init(bl, cipherParameters);
        this.forPrivateKey = asymmetricKeyParameter.isPrivate();
        this.forEncryption = bl;
        this.blockBuffer = new byte[this.engine.getOutputBlockSize()];
    }

    public byte[] processBlock(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encodeBlock(byArray, n, n2);
        }
        return this.decodeBlock(byArray, n, n2);
    }

    private boolean useStrict() {
        if (Properties.isOverrideSetTo("org.bouncycastle.pkcs1.not_strict", true)) {
            return false;
        }
        return Properties.isOverrideSetTo("org.bouncycastle.pkcs1.strict", false) ^ true;
    }
}

