/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.elgamal;

import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHParameterSpec;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.internal.asn1.oiw.ElGamalParameter;
import org.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameters;
import org.bouncycastle.jce.spec.ElGamalParameterSpec;

public class AlgorithmParametersSpi
extends BaseAlgorithmParameters {
    ElGamalParameterSpec currentSpec;
    static /* synthetic */ Class class$org$bouncycastle$jce$spec$ElGamalParameterSpec;
    static /* synthetic */ Class class$java$security$spec$AlgorithmParameterSpec;
    static /* synthetic */ Class class$javax$crypto$spec$DHParameterSpec;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected byte[] engineGetEncoded() {
        ElGamalParameter elGamalParameter = new ElGamalParameter(this.currentSpec.getP(), this.currentSpec.getG());
        try {
            return elGamalParameter.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error encoding ElGamalParameters");
        }
    }

    protected byte[] engineGetEncoded(String string) {
        if (this.isASN1FormatString(string) || string.equalsIgnoreCase("X.509")) {
            return this.engineGetEncoded();
        }
        return null;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof ElGamalParameterSpec) && !(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidParameterSpecException("DHParameterSpec required to initialise a ElGamal algorithm parameters object");
        }
        if (algorithmParameterSpec instanceof ElGamalParameterSpec) {
            this.currentSpec = (ElGamalParameterSpec)algorithmParameterSpec;
        } else {
            DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
            this.currentSpec = new ElGamalParameterSpec(dHParameterSpec.getP(), dHParameterSpec.getG());
        }
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            ElGamalParameter elGamalParameter = ElGamalParameter.getInstance(ASN1Primitive.fromByteArray(byArray));
            this.currentSpec = new ElGamalParameterSpec(elGamalParameter.getP(), elGamalParameter.getG());
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Not a valid ElGamal Parameter encoding.");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException("Not a valid ElGamal Parameter encoding.");
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        if (!this.isASN1FormatString(string) && !string.equalsIgnoreCase("X.509")) {
            throw new IOException("Unknown parameter format " + string);
        }
        this.engineInit(byArray);
    }

    protected String engineToString() {
        return "ElGamal Parameters";
    }

    protected AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (clazz == (class$org$bouncycastle$jce$spec$ElGamalParameterSpec != null ? class$org$bouncycastle$jce$spec$ElGamalParameterSpec : (class$org$bouncycastle$jce$spec$ElGamalParameterSpec = AlgorithmParametersSpi.class$("org.bouncycastle.jce.spec.ElGamalParameterSpec"))) || clazz == (class$java$security$spec$AlgorithmParameterSpec != null ? class$java$security$spec$AlgorithmParameterSpec : (class$java$security$spec$AlgorithmParameterSpec = AlgorithmParametersSpi.class$("java.security.spec.AlgorithmParameterSpec")))) {
            return this.currentSpec;
        }
        if (clazz == (class$javax$crypto$spec$DHParameterSpec != null ? class$javax$crypto$spec$DHParameterSpec : (class$javax$crypto$spec$DHParameterSpec = AlgorithmParametersSpi.class$("javax.crypto.spec.DHParameterSpec")))) {
            return new DHParameterSpec(this.currentSpec.getP(), this.currentSpec.getG());
        }
        throw new InvalidParameterSpecException("unknown parameter spec passed to ElGamal parameters object.");
    }
}

