/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce;

import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.jcajce.PKIXExtendedParameters;
import org.bouncycastle.jce.cert.CertPathParameters;
import org.bouncycastle.jce.cert.PKIXBuilderParameters;

public class PKIXExtendedBuilderParameters
implements CertPathParameters {
    private PKIXExtendedParameters baseParameters;
    private Set excludedCerts;
    private int maxPathLength;

    /* synthetic */ PKIXExtendedBuilderParameters(1 var1_1, Builder builder) {
        this(builder);
    }

    private PKIXExtendedBuilderParameters(Builder builder) {
        this.baseParameters = builder.baseParameters;
        this.excludedCerts = Collections.unmodifiableSet(builder.excludedCerts);
        this.maxPathLength = builder.maxPathLength;
    }

    public Object clone() {
        return this;
    }

    public PKIXExtendedParameters getBaseParameters() {
        return this.baseParameters;
    }

    public Set getExcludedCerts() {
        return this.excludedCerts;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public static class Builder {
        private PKIXExtendedParameters baseParameters;
        private int maxPathLength = 5;
        private Set excludedCerts = new HashSet();

        public Builder(PKIXExtendedParameters pKIXExtendedParameters) {
            this.baseParameters = pKIXExtendedParameters;
        }

        public Builder(PKIXBuilderParameters pKIXBuilderParameters) {
            this.baseParameters = new PKIXExtendedParameters.Builder(pKIXBuilderParameters).build();
            this.maxPathLength = pKIXBuilderParameters.getMaxPathLength();
        }

        public Builder addExcludedCerts(Set set) {
            this.excludedCerts.addAll(set);
            return this;
        }

        public PKIXExtendedBuilderParameters build() {
            class Org_bouncycastle_jcajce_PKIXExtendedBuilderParameters$1 {
                /* synthetic */ Org_bouncycastle_jcajce_PKIXExtendedBuilderParameters$1() {
                }
            }
            return new PKIXExtendedBuilderParameters(null, this);
        }

        public Builder setMaxPathLength(int n) {
            if (n < -1) {
                throw new InvalidParameterException("The maximum path length parameter can not be less than -1.");
            }
            this.maxPathLength = n;
            return this;
        }
    }
}

