/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce;

import java.math.BigInteger;
import java.security.cert.CRL;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.jce.cert.CRLSelector;
import org.bouncycastle.jce.cert.CertStore;
import org.bouncycastle.jce.cert.CertStoreException;
import org.bouncycastle.jce.cert.X509CRLSelector;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Selector;

public class PKIXCRLStoreSelector
implements Selector {
    private CRLSelector baseSelector;
    private boolean deltaCRLIndicator;
    private boolean completeCRLEnabled;
    private BigInteger maxBaseCRLNumber;
    private byte[] issuingDistributionPoint;
    private boolean issuingDistributionPointEnabled;

    /* synthetic */ PKIXCRLStoreSelector(2 var1_1, Builder builder) {
        this(builder);
    }

    private PKIXCRLStoreSelector(Builder builder) {
        this.baseSelector = builder.baseSelector;
        this.deltaCRLIndicator = builder.deltaCRLIndicator;
        this.completeCRLEnabled = builder.completeCRLEnabled;
        this.maxBaseCRLNumber = builder.maxBaseCRLNumber;
        this.issuingDistributionPoint = builder.issuingDistributionPoint;
        this.issuingDistributionPointEnabled = builder.issuingDistributionPointEnabled;
    }

    public Object clone() {
        return this;
    }

    public static Collection getCRLs(PKIXCRLStoreSelector pKIXCRLStoreSelector, CertStore certStore) throws CertStoreException {
        return certStore.getCRLs(new CRLSelector(){

            public Object clone() {
                return this;
            }

            public boolean match(CRL cRL) {
                return PKIXCRLStoreSelector.this.match(cRL);
            }
        });
    }

    public X509Certificate getCertificateChecking() {
        return ((X509CRLSelector)this.baseSelector).getCertificateChecking();
    }

    public byte[] getIssuingDistributionPoint() {
        return Arrays.clone(this.issuingDistributionPoint);
    }

    public BigInteger getMaxBaseCRLNumber() {
        return this.maxBaseCRLNumber;
    }

    public boolean isCompleteCRLEnabled() {
        return this.completeCRLEnabled;
    }

    public boolean isDeltaCRLIndicatorEnabled() {
        return this.deltaCRLIndicator;
    }

    public boolean isIssuingDistributionPointEnabled() {
        return this.issuingDistributionPointEnabled;
    }

    public boolean match(Object object) {
        byte[] byArray;
        if (!(object instanceof X509CRL)) {
            return this.baseSelector.match((X509CRL)object);
        }
        X509CRL x509CRL = (X509CRL)object;
        ASN1Integer aSN1Integer = null;
        try {
            byArray = x509CRL.getExtensionValue(Extension.deltaCRLIndicator.getId());
            if (byArray != null) {
                aSN1Integer = ASN1Integer.getInstance(ASN1OctetString.getInstance(byArray).getOctets());
            }
        }
        catch (Exception exception) {
            return false;
        }
        if (this.isDeltaCRLIndicatorEnabled() && aSN1Integer == null) {
            return false;
        }
        if (this.isCompleteCRLEnabled() && aSN1Integer != null) {
            return false;
        }
        if (aSN1Integer != null && this.maxBaseCRLNumber != null && aSN1Integer.getPositiveValue().compareTo(this.maxBaseCRLNumber) == 1) {
            return false;
        }
        if (this.issuingDistributionPointEnabled) {
            byArray = x509CRL.getExtensionValue(Extension.issuingDistributionPoint.getId());
            if (this.issuingDistributionPoint == null ? byArray != null : !Arrays.areEqual(byArray, this.issuingDistributionPoint)) {
                return false;
            }
        }
        return this.baseSelector.match((CRL)object);
    }

    public static class Builder {
        private CRLSelector baseSelector;
        private boolean deltaCRLIndicator = false;
        private boolean completeCRLEnabled = false;
        private BigInteger maxBaseCRLNumber = null;
        private byte[] issuingDistributionPoint = null;
        private boolean issuingDistributionPointEnabled = false;

        public Builder(CRLSelector cRLSelector) {
            this.baseSelector = (CRLSelector)cRLSelector.clone();
        }

        public PKIXCRLStoreSelector build() {
            class Org_bouncycastle_jcajce_PKIXCRLStoreSelector$2 {
                /* synthetic */ Org_bouncycastle_jcajce_PKIXCRLStoreSelector$2() {
                }
            }
            return new PKIXCRLStoreSelector(null, this);
        }

        public Builder setCompleteCRLEnabled(boolean bl) {
            this.completeCRLEnabled = bl;
            return this;
        }

        public Builder setDeltaCRLIndicatorEnabled(boolean bl) {
            this.deltaCRLIndicator = bl;
            return this;
        }

        public void setIssuingDistributionPoint(byte[] byArray) {
            this.issuingDistributionPoint = Arrays.clone(byArray);
        }

        public void setIssuingDistributionPointEnabled(boolean bl) {
            this.issuingDistributionPointEnabled = bl;
        }

        public void setMaxBaseCRLNumber(BigInteger bigInteger) {
            this.maxBaseCRLNumber = bigInteger;
        }
    }
}

