/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.util;

import org.bouncycastle.crypto.util.PBKDFConfig;
import org.bouncycastle.internal.asn1.misc.MiscObjectIdentifiers;

public class ScryptConfig
extends PBKDFConfig {
    private int costParameter;
    private int blockSize;
    private int parallelizationParameter;
    private int saltLength;

    /* synthetic */ ScryptConfig(1 var1_1, Builder builder) {
        this(builder);
    }

    private ScryptConfig(Builder builder) {
        super(MiscObjectIdentifiers.id_scrypt);
        this.costParameter = builder.costParameter;
        this.blockSize = builder.blockSize;
        this.parallelizationParameter = builder.parallelizationParameter;
        this.saltLength = builder.saltLength;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getCostParameter() {
        return this.costParameter;
    }

    public int getParallelizationParameter() {
        return this.parallelizationParameter;
    }

    public int getSaltLength() {
        return this.saltLength;
    }

    public static class Builder {
        private int costParameter;
        private int blockSize;
        private int parallelizationParameter;
        private int saltLength = 16;

        public Builder(int n, int n2, int n3) {
            if (n <= 1 || !Builder.isPowerOf2(n)) {
                throw new IllegalArgumentException("Cost parameter N must be > 1 and a power of 2");
            }
            this.costParameter = n;
            this.blockSize = n2;
            this.parallelizationParameter = n3;
        }

        public ScryptConfig build() {
            class Org_bouncycastle_crypto_util_ScryptConfig$1 {
                /* synthetic */ Org_bouncycastle_crypto_util_ScryptConfig$1() {
                }
            }
            return new ScryptConfig(null, this);
        }

        private static boolean isPowerOf2(int n) {
            return (n & n - 1) == 0;
        }

        public Builder withSaltLength(int n) {
            this.saltLength = n;
            return this;
        }
    }
}

