/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.util.Strings;

class SSHBuilder {
    private final ByteArrayOutputStream bos = new ByteArrayOutputStream();

    SSHBuilder() {
    }

    public byte[] getBytes() {
        return this.bos.toByteArray();
    }

    public byte[] getPaddedBytes() {
        return this.getPaddedBytes(8);
    }

    public byte[] getPaddedBytes(int n) {
        int n2 = this.bos.size() % n;
        if (n2 != 0) {
            int n3 = n - n2;
            int n4 = 1;
            while (n4 <= n3) {
                this.bos.write(n4);
                ++n4;
            }
        }
        return this.bos.toByteArray();
    }

    public void u32(long l) {
        this.bos.write((int)(l >>> 24 & 0xFFL));
        this.bos.write((int)(l >>> 16 & 0xFFL));
        this.bos.write((int)(l >>> 8 & 0xFFL));
        this.bos.write((int)(l & 0xFFL));
    }

    public void writeBigNum(BigInteger bigInteger) {
        this.writeBlock(bigInteger.toByteArray());
    }

    public void writeBlock(byte[] byArray) {
        this.u32(byArray.length);
        try {
            this.bos.write(byArray);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage());
        }
    }

    public void writeBytes(byte[] byArray) {
        try {
            this.bos.write(byArray);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage());
        }
    }

    public void writeString(String string) {
        this.writeBlock(Strings.toByteArray(string));
    }
}

