/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.util;

import java.math.BigInteger;
import org.bouncycastle.util.BigIntegers;

public class RadixConverter {
    private static final double LOG_LONG_MAX_VALUE = Math.log(9.223372036854776E18);
    private static final int DEFAULT_POWERS_TO_CACHE = 10;
    private final int digitsGroupLength;
    private final BigInteger digitsGroupSpaceSize;
    private final int radix;
    private final BigInteger[] digitsGroupSpacePowers;

    public RadixConverter(int n) {
        this(n, 10);
    }

    public RadixConverter(int n, int n2) {
        this.radix = n;
        this.digitsGroupLength = (int)Math.floor(LOG_LONG_MAX_VALUE / Math.log(n));
        this.digitsGroupSpaceSize = BigInteger.valueOf(n).pow(this.digitsGroupLength);
        this.digitsGroupSpacePowers = this.precomputeDigitsGroupPowers(n2, this.digitsGroupSpaceSize);
    }

    private long fromEncoding(int n, int n2, short[] sArray) {
        long l = 0L;
        int n3 = n;
        while (n3 < n2) {
            l = l * (long)this.radix + (long)(sArray[n3] & 0xFFFF);
            ++n3;
        }
        return l;
    }

    public BigInteger fromEncoding(short[] sArray) {
        BigInteger bigInteger = BigIntegers.ONE;
        BigInteger bigInteger2 = null;
        int n = 0;
        int n2 = sArray.length;
        int n3 = n2 - this.digitsGroupLength;
        while (n3 > -this.digitsGroupLength) {
            int n4 = this.digitsGroupLength;
            if (n3 < 0) {
                n4 = this.digitsGroupLength + n3;
                n3 = 0;
            }
            int n5 = Math.min(n3 + n4, n2);
            long l = this.fromEncoding(n3, n5, sArray);
            BigInteger bigInteger3 = BigInteger.valueOf(l);
            if (n == 0) {
                bigInteger2 = bigInteger3;
            } else {
                bigInteger = n <= this.digitsGroupSpacePowers.length ? this.digitsGroupSpacePowers[n - 1] : bigInteger.multiply(this.digitsGroupSpaceSize);
                bigInteger2 = bigInteger2.add(bigInteger3.multiply(bigInteger));
            }
            ++n;
            n3 -= this.digitsGroupLength;
        }
        return bigInteger2;
    }

    public int getDigitsGroupLength() {
        return this.digitsGroupLength;
    }

    public int getRadix() {
        return this.radix;
    }

    private BigInteger[] precomputeDigitsGroupPowers(int n, BigInteger bigInteger) {
        BigInteger[] bigIntegerArray = new BigInteger[n];
        BigInteger bigInteger2 = bigInteger;
        int n2 = 0;
        while (n2 < n) {
            bigIntegerArray[n2] = bigInteger2;
            bigInteger2 = bigInteger2.multiply(bigInteger);
            ++n2;
        }
        return bigIntegerArray;
    }

    private int toEncoding(long l, int n, short[] sArray) {
        int n2 = 0;
        while (n2 < this.digitsGroupLength && n >= 0) {
            if (l == 0L) {
                sArray[n--] = 0;
            } else {
                sArray[n--] = (short)(l % (long)this.radix);
                l /= (long)this.radix;
            }
            ++n2;
        }
        if (l != 0L) {
            throw new IllegalStateException("Failed to convert decimal number");
        }
        return n;
    }

    public void toEncoding(BigInteger bigInteger, int n, short[] sArray) {
        if (bigInteger.signum() < 0) {
            throw new IllegalArgumentException();
        }
        int n2 = n - 1;
        do {
            if (bigInteger.equals(BigInteger.ZERO)) {
                sArray[n2--] = 0;
                continue;
            }
            BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(this.digitsGroupSpaceSize);
            bigInteger = bigIntegerArray[0];
            n2 = this.toEncoding(bigIntegerArray[1].longValue(), n2, sArray);
        } while (n2 >= 0);
        if (bigInteger.signum() != 0) {
            throw new IllegalArgumentException();
        }
    }
}

