/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.util;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.crypto.util.DerUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public final class DERMacData {
    private byte[] macData;

    /* synthetic */ DERMacData(1 var1_1, byte[] byArray) {
        this(byArray);
    }

    private DERMacData(byte[] byArray) {
        this.macData = byArray;
    }

    public byte[] getMacData() {
        return Arrays.clone(this.macData);
    }

    public static class Type {
        public static final Type UNILATERALU = new Type("KC_1_U", 0);
        public static final Type UNILATERALV = new Type("KC_1_V", 1);
        public static final Type BILATERALU = new Type("KC_2_U", 2);
        public static final Type BILATERALV = new Type("KC_2_V", 3);
        private String enc;
        private int ordinal;

        Type(String string, int n) {
            this.enc = string;
            this.ordinal = n;
        }

        public byte[] getHeader() {
            return Strings.toByteArray(this.enc);
        }
    }

    public static final class Builder {
        private final Type type;
        private ASN1OctetString idU;
        private ASN1OctetString idV;
        private ASN1OctetString ephemDataU;
        private ASN1OctetString ephemDataV;
        private byte[] text;

        public Builder(Type type, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
            this.type = type;
            this.idU = DerUtil.getOctetString(byArray);
            this.idV = DerUtil.getOctetString(byArray2);
            this.ephemDataU = DerUtil.getOctetString(byArray3);
            this.ephemDataV = DerUtil.getOctetString(byArray4);
        }

        public DERMacData build() {
            switch (this.type.ordinal) {
                class Org_bouncycastle_crypto_util_DERMacData$1 {
                    /* synthetic */ Org_bouncycastle_crypto_util_DERMacData$1() {
                    }
                }
                case 0: 
                case 2: {
                    return new DERMacData(null, this.concatenate(this.type.getHeader(), DerUtil.toByteArray(this.idU), DerUtil.toByteArray(this.idV), DerUtil.toByteArray(this.ephemDataU), DerUtil.toByteArray(this.ephemDataV), this.text));
                }
                case 1: 
                case 3: {
                    return new DERMacData(null, this.concatenate(this.type.getHeader(), DerUtil.toByteArray(this.idV), DerUtil.toByteArray(this.idU), DerUtil.toByteArray(this.ephemDataV), DerUtil.toByteArray(this.ephemDataU), this.text));
                }
            }
            throw new IllegalStateException("Unknown type encountered in build");
        }

        private byte[] concatenate(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) {
            return Arrays.concatenate(Arrays.concatenate(byArray, byArray2, byArray3), Arrays.concatenate(byArray4, byArray5, byArray6));
        }

        public Builder withText(byte[] byArray) {
            this.text = DerUtil.toByteArray(new DERTaggedObject(false, 0, (ASN1Encodable)DerUtil.getOctetString(byArray)));
            return this;
        }
    }
}

