/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.engines.Zuc128Engine;
import org.bouncycastle.crypto.engines.Zuc256Engine;
import org.bouncycastle.crypto.macs.Zuc128Mac;
import org.bouncycastle.crypto.macs.Zuc256Mac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class ZucTest
extends SimpleTest {
    private static final int INT_SIZE = 32;
    private static final int BYTE_SIZE = 8;
    private static final String KEY128_1 = "00000000000000000000000000000000";
    private static final String KEY128_2 = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
    private static final String KEY256_1 = "0000000000000000000000000000000000000000000000000000000000000000";
    private static final String KEY256_2 = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
    private static final String IV128_1 = "00000000000000000000000000000000";
    private static final String IV128_2 = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
    private static final String IV200_1 = "00000000000000000000000000000000000000000000000000";
    private static final String IV200_2 = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF3F3F3F3F3F3F3F3F";
    private static final int ZUC256LIMIT = 20000;
    private static final int ZUC128LIMIT = 65504;

    public String getName() {
        return "Zuc";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new ZucTest());
    }

    public void performTest() throws Exception {
        new Zuc128Test().testTheCipher();
        new Zuc256Test().testTheCipher();
        new Zuc128MacTest().testTheMac();
        new Zuc256Mac32Test().testTheMac();
        new Zuc256Mac64Test().testTheMac();
        new Zuc256Mac128Test().testTheMac();
    }

    void testCipher(StreamCipher streamCipher, TestCase testCase) {
        byte[] byArray = Hex.decode(testCase.theExpected);
        byte[] byArray2 = new byte[byArray.length];
        byte[] byArray3 = testCase.thePlainText != null ? Hex.decode(testCase.thePlainText) : new byte[byArray.length];
        KeyParameter keyParameter = new KeyParameter(Hex.decode(testCase.theKey));
        byte[] byArray4 = Hex.decode(testCase.theIV);
        ParametersWithIV parametersWithIV = new ParametersWithIV(keyParameter, byArray4);
        streamCipher.init(true, parametersWithIV);
        streamCipher.processBytes(byArray3, 0, byArray3.length, byArray2, 0);
        this.isTrue("Encryption mismatch", Arrays.areEqual(byArray, byArray2));
    }

    void testMac(Mac mac, boolean bl, TestCase testCase) {
        byte[] byArray = Hex.decode(testCase.theExpected);
        byte[] byArray2 = new byte[mac.getMacSize()];
        byte[] byArray3 = new byte[(bl ? 4000 : 400) / 8];
        Arrays.fill(byArray3, (byte)(bl ? 17 : 0));
        KeyParameter keyParameter = new KeyParameter(Hex.decode(testCase.theKey));
        byte[] byArray4 = Hex.decode(testCase.theIV);
        ParametersWithIV parametersWithIV = new ParametersWithIV(keyParameter, byArray4);
        mac.init(parametersWithIV);
        mac.update(byArray3, 0, byArray3.length);
        mac.doFinal(byArray2, 0);
        this.isTrue("Mac mismatch", Arrays.areEqual(byArray, byArray2));
        mac.update(byArray3, 0, byArray3.length);
        mac.doFinal(byArray2, 0);
        this.isTrue("DoFinal Mac mismatch", Arrays.areEqual(byArray, byArray2));
        mac.update(byArray3, 0, byArray3.length);
        mac.reset();
        mac.update(byArray3, 0, byArray3.length);
        mac.doFinal(byArray2, 0);
        this.isTrue("Reset Mac mismatch", Arrays.areEqual(byArray, byArray2));
    }

    void testMacLimit(Mac mac, TestCase testCase, int n) {
        this.isTrue("Invalid limit", n % 32 == 0);
        int n2 = n / 8;
        byte[] byArray = new byte[n2];
        byte[] byArray2 = new byte[n2];
        KeyParameter keyParameter = new KeyParameter(Hex.decode(testCase.theKey));
        byte[] byArray3 = Hex.decode(testCase.theIV);
        ParametersWithIV parametersWithIV = new ParametersWithIV(keyParameter, byArray3);
        mac.init(parametersWithIV);
        mac.update(byArray, 0, byArray.length);
        mac.doFinal(byArray2, 0);
        mac.init(parametersWithIV);
        mac.update(byArray, 0, byArray.length);
        try {
            mac.update(byArray, 0, 1);
            mac.doFinal(byArray2, 0);
            this.fail("Limit Failure");
        }
        catch (IllegalStateException illegalStateException) {}
    }

    void testStreamLimit(StreamCipher streamCipher, TestCase testCase, int n) {
        this.isTrue("Invalid limit", n % 32 == 0);
        int n2 = n / 8;
        byte[] byArray = new byte[n2];
        byte[] byArray2 = new byte[n2];
        KeyParameter keyParameter = new KeyParameter(Hex.decode(testCase.theKey));
        byte[] byArray3 = Hex.decode(testCase.theIV);
        ParametersWithIV parametersWithIV = new ParametersWithIV(keyParameter, byArray3);
        streamCipher.init(true, parametersWithIV);
        streamCipher.processBytes(byArray, 0, byArray.length, byArray2, 0);
        try {
            streamCipher.processBytes(byArray, 0, 1, byArray2, 0);
            this.fail("Limit Failure");
        }
        catch (IllegalStateException illegalStateException) {}
    }

    private static class TestCase {
        private final String theKey;
        private final String theIV;
        private final String thePlainText;
        private final String theExpected;

        TestCase(String string, String string2, String string3) {
            this(string, string2, null, string3);
        }

        TestCase(String string, String string2, String string3, String string4) {
            this.theKey = string;
            this.theIV = string2;
            this.thePlainText = string3;
            this.theExpected = string4;
        }
    }

    class Zuc128Test {
        private final TestCase TEST4 = new TestCase("00000000000000000000000000000000", "00000000000000000000000000000000", "27bede74018082da87d4e5b69f18bf6632070e0f39b7b692b4673edc3184a48e27636f4414510d62cc15cfe194ec4f6d4b8c8fcc630648badf41b6f9d16a36ca");
        private final TestCase TEST5 = new TestCase("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "0657cfa07096398b734b6cb4883eedf4257a76eb97595208d884adcdb1cbffb8e0f9d15846a0eed015328503351138f740d079af17296c232c4f022d6e4acac6");

        Zuc128Test() {
        }

        void testTheCipher() {
            Zuc128Engine zuc128Engine = new Zuc128Engine();
            ZucTest.this.testCipher(zuc128Engine, this.TEST4);
            ZucTest.this.testCipher(zuc128Engine, this.TEST5);
            ZucTest.this.testStreamLimit(zuc128Engine, this.TEST5, 65504);
        }
    }

    class Zuc256Test {
        private final TestCase TEST4 = new TestCase("0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000000000000000000000", "58d03ad62e032ce2dafc683a39bdcb0352a2bc67f1b7de74163ce3a101ef55589639d75b95fa681b7f090df756391ccc903b7612744d544c17bc3fad8b163b08");
        private final TestCase TEST5 = new TestCase("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF3F3F3F3F3F3F3F3F", "3356cbaed1a1c18b6baa4ffe343f777c9e15128f251ab65b949f7b26ef7157f296dd2fa9df95e3ee7a5be02ec32ba585505af316c2f9ded27cdbd935e441ce11");

        Zuc256Test() {
        }

        void testTheCipher() {
            Zuc256Engine zuc256Engine = new Zuc256Engine();
            ZucTest.this.testCipher(zuc256Engine, this.TEST4);
            ZucTest.this.testCipher(zuc256Engine, this.TEST5);
            ZucTest.this.testStreamLimit(zuc256Engine, this.TEST5, 20000);
        }
    }

    class Zuc128MacTest {
        private final TestCase TEST1 = new TestCase("00000000000000000000000000000000", "00000000000000000000000000000000", "508dd5ff");
        private final TestCase TEST2 = new TestCase("00000000000000000000000000000000", "00000000000000000000000000000000", "fbed4c12");
        private final TestCase TEST3 = new TestCase("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "55e01504");
        private final TestCase TEST4 = new TestCase("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "9ce9a0c4");

        Zuc128MacTest() {
        }

        void testTheMac() {
            Zuc128Mac zuc128Mac = new Zuc128Mac();
            ZucTest.this.testMac(zuc128Mac, false, this.TEST1);
            ZucTest.this.testMac(zuc128Mac, true, this.TEST2);
            ZucTest.this.testMac(zuc128Mac, false, this.TEST3);
            ZucTest.this.testMac(zuc128Mac, true, this.TEST4);
            ZucTest.this.testMacLimit(zuc128Mac, this.TEST4, 65440);
            Zuc128Mac zuc128Mac2 = new Zuc128Mac();
            zuc128Mac2.reset();
        }
    }

    class Zuc256Mac32Test {
        private final TestCase TEST1 = new TestCase("0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000000000000000000000", "9b972a74");
        private final TestCase TEST2 = new TestCase("0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000000000000000000000", "8754f5cf");
        private final TestCase TEST3 = new TestCase("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF3F3F3F3F3F3F3F3F", "1f3079b4");
        private final TestCase TEST4 = new TestCase("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF3F3F3F3F3F3F3F3F", "5c7c8b88");

        Zuc256Mac32Test() {
        }

        void testTheMac() {
            Zuc256Mac zuc256Mac = new Zuc256Mac(32);
            ZucTest.this.testMac(zuc256Mac, false, this.TEST1);
            ZucTest.this.testMac(zuc256Mac, true, this.TEST2);
            ZucTest.this.testMac(zuc256Mac, false, this.TEST3);
            ZucTest.this.testMac(zuc256Mac, true, this.TEST4);
            ZucTest.this.testMacLimit(zuc256Mac, this.TEST4, 20000 - 2 * zuc256Mac.getMacSize() * 8);
            Zuc256Mac zuc256Mac2 = new Zuc256Mac(32);
            zuc256Mac2.reset();
        }
    }

    class Zuc256Mac64Test {
        private final TestCase TEST1 = new TestCase("0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000000000000000000000", "673e54990034d38c");
        private final TestCase TEST2 = new TestCase("0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000000000000000000000", "130dc225e72240cc");
        private final TestCase TEST3 = new TestCase("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF3F3F3F3F3F3F3F3F", "8c71394d39957725");
        private final TestCase TEST4 = new TestCase("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF3F3F3F3F3F3F3F3F", "ea1dee544bb6223b");

        Zuc256Mac64Test() {
        }

        void testTheMac() {
            Zuc256Mac zuc256Mac = new Zuc256Mac(64);
            ZucTest.this.testMac(zuc256Mac, false, this.TEST1);
            ZucTest.this.testMac(zuc256Mac, true, this.TEST2);
            ZucTest.this.testMac(zuc256Mac, false, this.TEST3);
            ZucTest.this.testMac(zuc256Mac, true, this.TEST4);
            ZucTest.this.testMacLimit(zuc256Mac, this.TEST4, 20000 - 2 * zuc256Mac.getMacSize() * 8);
        }
    }

    class Zuc256Mac128Test {
        private final TestCase TEST1 = new TestCase("0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000000000000000000000", "d85e54bbcb9600967084c952a1654b26");
        private final TestCase TEST2 = new TestCase("0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000000000000000000000", "df1e8307b31cc62beca1ac6f8190c22f");
        private final TestCase TEST3 = new TestCase("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF3F3F3F3F3F3F3F3F", "a35bb274b567c48b28319f111af34fbd");
        private final TestCase TEST4 = new TestCase("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF3F3F3F3F3F3F3F3F", "3a83b554be408ca5494124ed9d473205");

        Zuc256Mac128Test() {
        }

        void testTheMac() {
            Zuc256Mac zuc256Mac = new Zuc256Mac(128);
            ZucTest.this.testMac(zuc256Mac, false, this.TEST1);
            ZucTest.this.testMac(zuc256Mac, true, this.TEST2);
            ZucTest.this.testMac(zuc256Mac, false, this.TEST3);
            ZucTest.this.testMac(zuc256Mac, true, this.TEST4);
            ZucTest.this.testMacLimit(zuc256Mac, this.TEST4, 20000 - 2 * zuc256Mac.getMacSize() * 8);
        }
    }
}

