/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.agreement.X448Agreement;
import org.bouncycastle.crypto.generators.X448KeyPairGenerator;
import org.bouncycastle.crypto.params.X448KeyGenerationParameters;
import org.bouncycastle.util.test.SimpleTest;

public class X448Test
extends SimpleTest {
    private static final SecureRandom RANDOM = new SecureRandom();

    public String getName() {
        return "X448";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new X448Test());
    }

    public void performTest() {
        int n = 0;
        while (n < 10) {
            this.testAgreement();
            ++n;
        }
    }

    private void testAgreement() {
        X448KeyPairGenerator x448KeyPairGenerator = new X448KeyPairGenerator();
        x448KeyPairGenerator.init(new X448KeyGenerationParameters(RANDOM));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = x448KeyPairGenerator.generateKeyPair();
        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = x448KeyPairGenerator.generateKeyPair();
        X448Agreement x448Agreement = new X448Agreement();
        x448Agreement.init(asymmetricCipherKeyPair.getPrivate());
        byte[] byArray = new byte[x448Agreement.getAgreementSize()];
        x448Agreement.calculateAgreement(asymmetricCipherKeyPair2.getPublic(), byArray, 0);
        X448Agreement x448Agreement2 = new X448Agreement();
        x448Agreement2.init(asymmetricCipherKeyPair2.getPrivate());
        byte[] byArray2 = new byte[x448Agreement2.getAgreementSize()];
        x448Agreement2.calculateAgreement(asymmetricCipherKeyPair.getPublic(), byArray2, 0);
        if (!this.areEqual(byArray, byArray2)) {
            this.fail("X448 agreement failed");
        }
    }
}

