/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.agreement.X25519Agreement;
import org.bouncycastle.crypto.generators.X25519KeyPairGenerator;
import org.bouncycastle.crypto.params.X25519KeyGenerationParameters;
import org.bouncycastle.util.test.SimpleTest;

public class X25519Test
extends SimpleTest {
    private static final SecureRandom RANDOM = new SecureRandom();

    public String getName() {
        return "X25519";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new X25519Test());
    }

    public void performTest() {
        int n = 0;
        while (n < 10) {
            this.testAgreement();
            ++n;
        }
    }

    private void testAgreement() {
        X25519KeyPairGenerator x25519KeyPairGenerator = new X25519KeyPairGenerator();
        x25519KeyPairGenerator.init(new X25519KeyGenerationParameters(RANDOM));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = x25519KeyPairGenerator.generateKeyPair();
        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = x25519KeyPairGenerator.generateKeyPair();
        X25519Agreement x25519Agreement = new X25519Agreement();
        x25519Agreement.init(asymmetricCipherKeyPair.getPrivate());
        byte[] byArray = new byte[x25519Agreement.getAgreementSize()];
        x25519Agreement.calculateAgreement(asymmetricCipherKeyPair2.getPublic(), byArray, 0);
        X25519Agreement x25519Agreement2 = new X25519Agreement();
        x25519Agreement2.init(asymmetricCipherKeyPair2.getPrivate());
        byte[] byArray2 = new byte[x25519Agreement2.getAgreementSize()];
        x25519Agreement2.calculateAgreement(asymmetricCipherKeyPair.getPublic(), byArray2, 0);
        if (!this.areEqual(byArray, byArray2)) {
            this.fail("X25519 agreement failed");
        }
    }
}

