/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.engines.VMPCEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class VMPCTest
extends SimpleTest {
    private static final byte[] input = new byte[1000000];

    private void checkByte(byte[] byArray, int n, byte by) {
        if (byArray[n] != by) {
            this.fail("Fail on position " + n, new String(Hex.encode(new byte[]{by})), new String(Hex.encode(new byte[]{byArray[n]})));
        }
    }

    private byte[] checkEngine(VMPCEngine vMPCEngine) {
        byte[] byArray = new byte[input.length];
        vMPCEngine.processBytes(input, 0, byArray.length, byArray, 0);
        this.checkByte(byArray, 0, (byte)-88);
        this.checkByte(byArray, 1, (byte)36);
        this.checkByte(byArray, 2, (byte)121);
        this.checkByte(byArray, 3, (byte)-11);
        this.checkByte(byArray, 252, (byte)-72);
        this.checkByte(byArray, 253, (byte)-4);
        this.checkByte(byArray, 254, (byte)102);
        this.checkByte(byArray, 255, (byte)-92);
        this.checkByte(byArray, 1020, (byte)-32);
        this.checkByte(byArray, 1021, (byte)86);
        this.checkByte(byArray, 1022, (byte)64);
        this.checkByte(byArray, 1023, (byte)-91);
        this.checkByte(byArray, 102396, (byte)-127);
        this.checkByte(byArray, 102397, (byte)-54);
        this.checkByte(byArray, 102398, (byte)73);
        this.checkByte(byArray, 102399, (byte)-102);
        return byArray;
    }

    public String getName() {
        return "VMPC";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new VMPCTest());
    }

    public void performTest() {
        byte[] byArray = Hex.decode("9661410AB797D8A9EB767C21172DF6C7");
        byte[] byArray2 = Hex.decode("4B5C2F003E67F39557A8D26F3DA2B155");
        KeyParameter keyParameter = new KeyParameter(byArray);
        ParametersWithIV parametersWithIV = new ParametersWithIV(keyParameter, byArray2);
        VMPCEngine vMPCEngine = new VMPCEngine();
        try {
            vMPCEngine.init(true, keyParameter);
            this.fail("init failed to throw expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        vMPCEngine.init(true, parametersWithIV);
        this.checkEngine(vMPCEngine);
        vMPCEngine.reset();
        byte[] byArray3 = this.checkEngine(vMPCEngine);
        vMPCEngine.init(false, parametersWithIV);
        byte[] byArray4 = new byte[byArray3.length];
        vMPCEngine.processBytes(byArray3, 0, byArray3.length, byArray4, 0);
        if (!Arrays.areEqual(input, byArray4)) {
            this.fail("decrypted bytes differ from original bytes");
        }
    }
}

