/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CryptoServiceConstraintsException;
import org.bouncycastle.crypto.CryptoServicePurpose;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.constraints.LegacyBitsOfSecurityConstraint;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.engines.AESLightEngine;
import org.bouncycastle.crypto.engines.ARIAEngine;
import org.bouncycastle.crypto.engines.BlowfishEngine;
import org.bouncycastle.crypto.engines.CAST5Engine;
import org.bouncycastle.crypto.engines.CAST6Engine;
import org.bouncycastle.crypto.engines.CamelliaEngine;
import org.bouncycastle.crypto.engines.CamelliaLightEngine;
import org.bouncycastle.crypto.engines.ChaCha7539Engine;
import org.bouncycastle.crypto.engines.ChaChaEngine;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.DSTU7624Engine;
import org.bouncycastle.crypto.engines.GOST28147Engine;
import org.bouncycastle.crypto.engines.Grain128AEADEngine;
import org.bouncycastle.crypto.engines.Grain128Engine;
import org.bouncycastle.crypto.engines.Grainv1Engine;
import org.bouncycastle.crypto.engines.HC128Engine;
import org.bouncycastle.crypto.engines.HC256Engine;
import org.bouncycastle.crypto.engines.IDEAEngine;
import org.bouncycastle.crypto.engines.ISAACEngine;
import org.bouncycastle.crypto.engines.LEAEngine;
import org.bouncycastle.crypto.engines.NoekeonEngine;
import org.bouncycastle.crypto.engines.RC2Engine;
import org.bouncycastle.crypto.engines.RC532Engine;
import org.bouncycastle.crypto.engines.RC564Engine;
import org.bouncycastle.crypto.engines.RC6Engine;
import org.bouncycastle.crypto.engines.RijndaelEngine;
import org.bouncycastle.crypto.engines.SEEDEngine;
import org.bouncycastle.crypto.engines.SM4Engine;
import org.bouncycastle.crypto.engines.Salsa20Engine;
import org.bouncycastle.crypto.engines.SerpentEngine;
import org.bouncycastle.crypto.engines.Shacal2Engine;
import org.bouncycastle.crypto.engines.SkipjackEngine;
import org.bouncycastle.crypto.engines.TEAEngine;
import org.bouncycastle.crypto.engines.ThreefishEngine;
import org.bouncycastle.crypto.engines.TnepresEngine;
import org.bouncycastle.crypto.engines.TwofishEngine;
import org.bouncycastle.crypto.engines.VMPCEngine;
import org.bouncycastle.crypto.engines.VMPCKSA3Engine;
import org.bouncycastle.crypto.engines.XSalsa20Engine;
import org.bouncycastle.crypto.engines.Zuc128Engine;
import org.bouncycastle.crypto.engines.Zuc256Engine;
import org.bouncycastle.crypto.generators.DESKeyGenerator;
import org.bouncycastle.crypto.generators.DESedeKeyGenerator;
import org.bouncycastle.crypto.macs.GOST28147Mac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.RC2Parameters;
import org.bouncycastle.crypto.params.RC5Parameters;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class SymmetricConstraintsTest
extends SimpleTest {
    public String getName() {
        return "SymmetricConstraintsTest";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new SymmetricConstraintsTest());
    }

    public void performTest() throws Exception {
        this.testDES();
        this.testSerpent();
        this.testTwofish();
        this.testSkipjack();
        this.testAES();
        this.testAESFast();
        this.testAESLight();
        this.testARIA();
        this.testIDEA();
        this.testCAST5();
        this.testCAST6();
        this.testCamelliaLight();
        this.testCamellia();
        this.testBlowfish();
        this.testSM4();
        this.testTEA();
        this.testXTEA();
        this.testThreefish();
        this.testSalsa20AndXSalsa20AndChaCha();
        this.testZuc128AndZuc256();
        this.testVMPCAndVMPCKSA();
        this.testRC532AndRC564();
        this.testRijndael();
        this.testHC128AndHC256();
        this.testSEED();
        this.testISAAC();
        this.testShacal2();
        this.testGost28147();
        this.testGost28147Mac();
        this.testGrain128();
        this.testGrain128AEAD();
        this.testGrainv1();
        this.testDSTU7624();
        this.testLEA();
        this.testNoekeon();
        this.testRC2();
        this.testRC6();
    }

    private void testAES() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(192));
        AESEngine aESEngine = new AESEngine();
        try {
            aESEngine.init(true, new KeyParameter(new byte[16]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 192 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        aESEngine.init(false, new KeyParameter(new byte[16]));
        aESEngine.init(true, new KeyParameter(new byte[24]));
        aESEngine.init(false, new KeyParameter(new byte[24]));
        aESEngine.init(true, new KeyParameter(new byte[32]));
        aESEngine.init(false, new KeyParameter(new byte[32]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testAESFast() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(192));
        AESFastEngine aESFastEngine = new AESFastEngine();
        try {
            aESFastEngine.init(true, new KeyParameter(new byte[16]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 192 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        aESFastEngine.init(false, new KeyParameter(new byte[16]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testAESLight() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(192));
        AESLightEngine aESLightEngine = new AESLightEngine();
        try {
            aESLightEngine.init(true, new KeyParameter(new byte[16]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 192 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        aESLightEngine.init(false, new KeyParameter(new byte[16]));
        aESLightEngine.init(true, new KeyParameter(new byte[24]));
        aESLightEngine.init(false, new KeyParameter(new byte[24]));
        aESLightEngine.init(true, new KeyParameter(new byte[32]));
        aESLightEngine.init(false, new KeyParameter(new byte[32]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testARIA() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(192));
        ARIAEngine aRIAEngine = new ARIAEngine();
        try {
            aRIAEngine.init(true, new KeyParameter(new byte[16]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 192 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        aRIAEngine.init(false, new KeyParameter(new byte[16]));
        aRIAEngine.init(true, new KeyParameter(new byte[24]));
        aRIAEngine.init(false, new KeyParameter(new byte[24]));
        aRIAEngine.init(true, new KeyParameter(new byte[32]));
        aRIAEngine.init(false, new KeyParameter(new byte[32]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testBlowfish() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(192));
        BlowfishEngine blowfishEngine = new BlowfishEngine();
        try {
            blowfishEngine.init(true, new KeyParameter(new byte[16]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 192 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        blowfishEngine.init(false, new KeyParameter(new byte[16]));
        blowfishEngine.init(true, new KeyParameter(new byte[24]));
        blowfishEngine.init(false, new KeyParameter(new byte[24]));
        blowfishEngine.init(true, new KeyParameter(new byte[32]));
        blowfishEngine.init(false, new KeyParameter(new byte[32]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testCAST5() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(256));
        CAST5Engine cAST5Engine = new CAST5Engine();
        try {
            cAST5Engine.init(true, new KeyParameter(new byte[16]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 256 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        cAST5Engine.init(false, new KeyParameter(new byte[16]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testCAST6() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(256, 128));
        CAST6Engine cAST6Engine = new CAST6Engine();
        try {
            cAST6Engine.init(true, new KeyParameter(new byte[16]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 256 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        cAST6Engine.init(false, new KeyParameter(new byte[16]));
        cAST6Engine.init(true, new KeyParameter(new byte[32]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testCamellia() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(256));
        CamelliaEngine camelliaEngine = new CamelliaEngine();
        try {
            camelliaEngine.init(true, new KeyParameter(new byte[16]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 256 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        camelliaEngine.init(false, new KeyParameter(new byte[16]));
        camelliaEngine.init(true, new KeyParameter(new byte[32]));
        camelliaEngine.init(false, new KeyParameter(new byte[32]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testCamelliaLight() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(256));
        CamelliaLightEngine camelliaLightEngine = new CamelliaLightEngine();
        try {
            camelliaLightEngine.init(true, new KeyParameter(new byte[16]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 256 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        camelliaLightEngine.init(false, new KeyParameter(new byte[16]));
        camelliaLightEngine.init(true, new KeyParameter(new byte[32]));
        camelliaLightEngine.init(false, new KeyParameter(new byte[32]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testDES() {
        DESKeyGenerator dESKeyGenerator;
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(128));
        DESedeEngine dESedeEngine = new DESedeEngine();
        KeyParameter keyParameter = new KeyParameter(Hex.decode("01020304050607080102030405060708"));
        try {
            dESedeEngine.init(true, keyParameter);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 128 bits of security only 80", cryptoServiceConstraintsException.getMessage());
        }
        dESedeEngine.init(false, keyParameter);
        try {
            dESKeyGenerator = new DESKeyGenerator();
            dESKeyGenerator.init(new KeyGenerationParameters(new SecureRandom(), 56));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 128 bits of security only 56", cryptoServiceConstraintsException.getMessage());
        }
        try {
            dESKeyGenerator = new DESedeKeyGenerator();
            ((DESedeKeyGenerator)dESKeyGenerator).init(new KeyGenerationParameters(new SecureRandom(), 192));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 128 bits of security only 112", cryptoServiceConstraintsException.getMessage());
        }
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testDSTU7624() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(192));
        DSTU7624Engine dSTU7624Engine = new DSTU7624Engine(128);
        try {
            dSTU7624Engine.init(true, new KeyParameter(new byte[16]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 192 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        dSTU7624Engine.init(false, new KeyParameter(new byte[16]));
        dSTU7624Engine.init(true, new KeyParameter(new byte[32]));
        dSTU7624Engine.init(false, new KeyParameter(new byte[32]));
        dSTU7624Engine = new DSTU7624Engine(256);
        dSTU7624Engine.init(true, new KeyParameter(new byte[64]));
        dSTU7624Engine.init(false, new KeyParameter(new byte[64]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testGost28147() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(256, 128));
        GOST28147Engine gOST28147Engine = new GOST28147Engine();
        try {
            gOST28147Engine.init(true, new KeyParameter(new byte[32]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 256 bits of security only 178", cryptoServiceConstraintsException.getMessage());
        }
        gOST28147Engine.init(false, new KeyParameter(new byte[32]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testGost28147Mac() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(256, 128));
        GOST28147Mac gOST28147Mac = new GOST28147Mac();
        try {
            gOST28147Mac.init(new KeyParameter(new byte[32]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 256 bits of security only 178", cryptoServiceConstraintsException.getMessage());
        }
        gOST28147Mac = new GOST28147Mac(CryptoServicePurpose.VERIFICATION);
        gOST28147Mac.init(new KeyParameter(new byte[32]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testGrain128() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(256, 128));
        Grain128Engine grain128Engine = new Grain128Engine();
        try {
            grain128Engine.init(true, new ParametersWithIV(new KeyParameter(new byte[16]), new byte[12]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 256 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        grain128Engine.init(false, new ParametersWithIV(new KeyParameter(new byte[16]), new byte[12]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testGrain128AEAD() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(256, 128));
        Grain128AEADEngine grain128AEADEngine = new Grain128AEADEngine();
        try {
            grain128AEADEngine.init(true, new ParametersWithIV(new KeyParameter(new byte[16]), new byte[12]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 256 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        grain128AEADEngine.init(false, new ParametersWithIV(new KeyParameter(new byte[16]), new byte[12]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testGrainv1() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(256, 80));
        Grainv1Engine grainv1Engine = new Grainv1Engine();
        try {
            grainv1Engine.init(true, new ParametersWithIV(new KeyParameter(new byte[10]), new byte[8]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 256 bits of security only 80", cryptoServiceConstraintsException.getMessage());
        }
        grainv1Engine.init(false, new ParametersWithIV(new KeyParameter(new byte[10]), new byte[8]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testHC128AndHC256() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(256, 128));
        HC256Engine hC256Engine = new HC256Engine();
        HC128Engine hC128Engine = new HC128Engine();
        try {
            hC128Engine.init(true, new ParametersWithIV(new KeyParameter(new byte[16]), new byte[16]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 256 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        hC128Engine.init(false, new ParametersWithIV(new KeyParameter(new byte[16]), new byte[16]));
        hC256Engine.init(true, new ParametersWithIV(new KeyParameter(new byte[16]), new byte[16]));
        hC256Engine.init(false, new ParametersWithIV(new KeyParameter(new byte[16]), new byte[16]));
        hC256Engine.init(true, new ParametersWithIV(new KeyParameter(new byte[32]), new byte[32]));
        hC256Engine.init(false, new ParametersWithIV(new KeyParameter(new byte[32]), new byte[32]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testIDEA() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(256));
        IDEAEngine iDEAEngine = new IDEAEngine();
        try {
            iDEAEngine.init(true, new KeyParameter(new byte[16]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 256 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        iDEAEngine.init(false, new KeyParameter(new byte[16]));
        iDEAEngine.init(true, new KeyParameter(new byte[32]));
        iDEAEngine.init(false, new KeyParameter(new byte[32]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testISAAC() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(256, 128));
        ISAACEngine iSAACEngine = new ISAACEngine();
        try {
            iSAACEngine.init(true, new KeyParameter(new byte[16]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 256 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        iSAACEngine.init(false, new KeyParameter(new byte[16]));
        iSAACEngine.init(true, new KeyParameter(new byte[32]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testLEA() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(192));
        LEAEngine lEAEngine = new LEAEngine();
        try {
            lEAEngine.init(true, new KeyParameter(new byte[16]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 192 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        lEAEngine.init(false, new KeyParameter(new byte[16]));
        lEAEngine.init(true, new KeyParameter(new byte[24]));
        lEAEngine.init(false, new KeyParameter(new byte[24]));
        lEAEngine.init(true, new KeyParameter(new byte[32]));
        lEAEngine.init(false, new KeyParameter(new byte[32]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testNoekeon() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(256, 128));
        NoekeonEngine noekeonEngine = new NoekeonEngine();
        try {
            noekeonEngine.init(true, new KeyParameter(new byte[16]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 256 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        noekeonEngine.init(false, new KeyParameter(new byte[16]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testRC2() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(256, 128));
        RC2Engine rC2Engine = new RC2Engine();
        try {
            rC2Engine.init(true, new RC2Parameters(new byte[16], 16));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 256 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        try {
            rC2Engine.init(true, new KeyParameter(new byte[16]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 256 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        rC2Engine.init(false, new RC2Parameters(new byte[16], 16));
        rC2Engine.init(false, new KeyParameter(new byte[16]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testRC532AndRC564() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(256, 128));
        RC532Engine rC532Engine = new RC532Engine();
        RC564Engine rC564Engine = new RC564Engine();
        try {
            rC532Engine.init(true, new RC5Parameters(new byte[16], 16));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 256 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        try {
            rC532Engine.init(true, new KeyParameter(new byte[16]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 256 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        rC564Engine.init(true, new RC5Parameters(new byte[32], 12));
        rC532Engine.init(false, new RC5Parameters(new byte[16], 16));
        rC532Engine.init(false, new KeyParameter(new byte[16]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testRC6() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(256, 128));
        RC6Engine rC6Engine = new RC6Engine();
        try {
            rC6Engine.init(true, new KeyParameter(new byte[16]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 256 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        rC6Engine.init(false, new KeyParameter(new byte[16]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testRijndael() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(256, 128));
        RijndaelEngine rijndaelEngine = new RijndaelEngine(256);
        try {
            rijndaelEngine.init(true, new KeyParameter(new byte[16]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 256 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        rijndaelEngine.init(false, new KeyParameter(new byte[16]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testSEED() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(256));
        SEEDEngine sEEDEngine = new SEEDEngine();
        try {
            sEEDEngine.init(true, new KeyParameter(new byte[16]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 256 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        sEEDEngine.init(false, new KeyParameter(new byte[16]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testSM4() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(256, 128));
        SM4Engine sM4Engine = new SM4Engine();
        try {
            sM4Engine.init(true, new KeyParameter(new byte[16]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 256 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        sM4Engine.init(false, new KeyParameter(new byte[16]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testSalsa20AndXSalsa20AndChaCha() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(256, 128));
        Salsa20Engine salsa20Engine = new Salsa20Engine();
        XSalsa20Engine xSalsa20Engine = new XSalsa20Engine();
        ChaChaEngine chaChaEngine = new ChaChaEngine();
        ChaCha7539Engine chaCha7539Engine = new ChaCha7539Engine();
        try {
            salsa20Engine.init(true, new ParametersWithIV(new KeyParameter(new byte[16]), new byte[8]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 256 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        try {
            chaChaEngine.init(true, new ParametersWithIV(new KeyParameter(new byte[16]), new byte[8]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 256 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        xSalsa20Engine.init(true, new ParametersWithIV(new KeyParameter(new byte[32]), new byte[24]));
        chaCha7539Engine.init(true, new ParametersWithIV(new KeyParameter(new byte[32]), new byte[12]));
        salsa20Engine.init(false, new ParametersWithIV(new KeyParameter(new byte[16]), new byte[8]));
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(384, 256));
        try {
            xSalsa20Engine.init(true, new ParametersWithIV(new KeyParameter(new byte[32]), new byte[24]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 384 bits of security only 256", cryptoServiceConstraintsException.getMessage());
        }
        try {
            chaCha7539Engine.init(true, new ParametersWithIV(new KeyParameter(new byte[32]), new byte[12]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 384 bits of security only 256", cryptoServiceConstraintsException.getMessage());
        }
        xSalsa20Engine.init(false, new ParametersWithIV(new KeyParameter(new byte[32]), new byte[24]));
        chaCha7539Engine.init(false, new ParametersWithIV(new KeyParameter(new byte[32]), new byte[12]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testSerpent() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(128, 80));
        SerpentEngine serpentEngine = new SerpentEngine();
        try {
            serpentEngine.init(true, new KeyParameter(new byte[12]));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 128 bits of security only 96", cryptoServiceConstraintsException.getMessage());
        }
        serpentEngine.init(false, new KeyParameter(new byte[12]));
        serpentEngine.init(true, new KeyParameter(new byte[16]));
        TnepresEngine tnepresEngine = new TnepresEngine();
        try {
            tnepresEngine.init(true, new KeyParameter(new byte[12]));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 128 bits of security only 96", cryptoServiceConstraintsException.getMessage());
        }
        tnepresEngine.init(false, new KeyParameter(new byte[12]));
        tnepresEngine.init(true, new KeyParameter(new byte[16]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testShacal2() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(256, 128));
        Shacal2Engine shacal2Engine = new Shacal2Engine();
        try {
            shacal2Engine.init(true, new KeyParameter(new byte[16]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 256 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        shacal2Engine.init(false, new KeyParameter(new byte[16]));
        shacal2Engine.init(true, new KeyParameter(new byte[32]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testSkipjack() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(128, 80));
        SkipjackEngine skipjackEngine = new SkipjackEngine();
        try {
            skipjackEngine.init(true, new KeyParameter(new byte[10]));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 128 bits of security only 80", cryptoServiceConstraintsException.getMessage());
        }
        skipjackEngine.init(false, new KeyParameter(new byte[10]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testTEA() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(256, 128));
        TEAEngine tEAEngine = new TEAEngine();
        try {
            tEAEngine.init(true, new KeyParameter(new byte[16]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 256 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        tEAEngine.init(false, new KeyParameter(new byte[16]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testThreefish() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(384, 256));
        ThreefishEngine threefishEngine = new ThreefishEngine(256);
        try {
            threefishEngine.init(true, new KeyParameter(new byte[32]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 384 bits of security only 256", cryptoServiceConstraintsException.getMessage());
        }
        threefishEngine.init(false, new KeyParameter(new byte[32]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testTwofish() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(192, 80));
        TwofishEngine twofishEngine = new TwofishEngine();
        try {
            twofishEngine.init(true, new KeyParameter(new byte[16]));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 192 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        twofishEngine.init(false, new KeyParameter(new byte[16]));
        twofishEngine.init(true, new KeyParameter(new byte[24]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testVMPCAndVMPCKSA() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(256, 128));
        VMPCEngine vMPCEngine = new VMPCEngine();
        VMPCKSA3Engine vMPCKSA3Engine = new VMPCKSA3Engine();
        try {
            vMPCEngine.init(true, new ParametersWithIV(new KeyParameter(new byte[16]), new byte[16]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 256 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        vMPCKSA3Engine.init(true, new ParametersWithIV(new KeyParameter(new byte[32]), new byte[25]));
        vMPCEngine.init(false, new ParametersWithIV(new KeyParameter(new byte[16]), new byte[16]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testXTEA() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(256, 128));
        TEAEngine tEAEngine = new TEAEngine();
        try {
            tEAEngine.init(true, new KeyParameter(new byte[16]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 256 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        tEAEngine.init(false, new KeyParameter(new byte[16]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testZuc128AndZuc256() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(256, 128));
        Zuc128Engine zuc128Engine = new Zuc128Engine();
        Zuc256Engine zuc256Engine = new Zuc256Engine();
        try {
            zuc128Engine.init(true, new ParametersWithIV(new KeyParameter(new byte[16]), new byte[16]));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 256 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        zuc256Engine.init(true, new ParametersWithIV(new KeyParameter(new byte[32]), new byte[25]));
        zuc128Engine.init(false, new ParametersWithIV(new KeyParameter(new byte[16]), new byte[16]));
        CryptoServicesRegistrar.setServicesConstraints(null);
    }
}

