/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.engines.ChaChaEngine;
import org.bouncycastle.crypto.engines.Grain128Engine;
import org.bouncycastle.crypto.engines.Grainv1Engine;
import org.bouncycastle.crypto.engines.HC128Engine;
import org.bouncycastle.crypto.engines.HC256Engine;
import org.bouncycastle.crypto.engines.ISAACEngine;
import org.bouncycastle.crypto.engines.RC4Engine;
import org.bouncycastle.crypto.engines.Salsa20Engine;
import org.bouncycastle.crypto.engines.XSalsa20Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class StreamCipherResetTest
extends SimpleTest {
    private static final SecureRandom RAND = new SecureRandom();

    private void checkReset(StreamCipher streamCipher, CipherParameters cipherParameters, boolean bl, byte[] byArray, byte[] byArray2) throws InvalidCipherTextException {
        byte[] byArray3 = new byte[byArray2.length];
        streamCipher.processBytes(byArray, 0, byArray.length, byArray3, 0);
        streamCipher.init(bl, cipherParameters);
        try {
            streamCipher.processBytes(byArray, 0, byArray.length, byArray3, 0);
        }
        catch (Exception exception) {
            this.fail(String.valueOf(streamCipher.getAlgorithmName()) + " init did not reset: " + exception.getMessage());
        }
        if (!Arrays.areEqual(byArray3, byArray2)) {
            this.fail(String.valueOf(streamCipher.getAlgorithmName()) + " init did not reset.", new String(Hex.encode(byArray2)), new String(Hex.encode(byArray3)));
        }
        streamCipher.reset();
        try {
            streamCipher.processBytes(byArray, 0, byArray.length, byArray3, 0);
        }
        catch (Exception exception) {
            this.fail(String.valueOf(streamCipher.getAlgorithmName()) + " reset did not reset: " + exception.getMessage());
        }
        if (!Arrays.areEqual(byArray3, byArray2)) {
            this.fail(String.valueOf(streamCipher.getAlgorithmName()) + " reset did not reset.");
        }
    }

    public String getName() {
        return "Stream Cipher Reset";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new StreamCipherResetTest());
    }

    public void performTest() throws Exception {
        this.testReset(new Salsa20Engine(), new Salsa20Engine(), new ParametersWithIV(new KeyParameter(this.random(32)), this.random(8)));
        this.testReset(new Salsa20Engine(), new Salsa20Engine(), new ParametersWithIV(new KeyParameter(this.random(16)), this.random(8)));
        this.testReset(new XSalsa20Engine(), new XSalsa20Engine(), new ParametersWithIV(new KeyParameter(this.random(32)), this.random(24)));
        this.testReset(new ChaChaEngine(), new ChaChaEngine(), new ParametersWithIV(new KeyParameter(this.random(32)), this.random(8)));
        this.testReset(new ChaChaEngine(), new ChaChaEngine(), new ParametersWithIV(new KeyParameter(this.random(16)), this.random(8)));
        this.testReset(new RC4Engine(), new RC4Engine(), new KeyParameter(this.random(16)));
        this.testReset(new ISAACEngine(), new ISAACEngine(), new KeyParameter(this.random(16)));
        this.testReset(new HC128Engine(), new HC128Engine(), new ParametersWithIV(new KeyParameter(this.random(16)), this.random(16)));
        this.testReset(new HC256Engine(), new HC256Engine(), new ParametersWithIV(new KeyParameter(this.random(16)), this.random(16)));
        this.testReset(new Grainv1Engine(), new Grainv1Engine(), new ParametersWithIV(new KeyParameter(this.random(10)), this.random(8)));
        this.testReset(new Grain128Engine(), new Grain128Engine(), new ParametersWithIV(new KeyParameter(this.random(16)), this.random(12)));
    }

    private byte[] random(int n) {
        byte[] byArray = new byte[n];
        RAND.nextBytes(byArray);
        return byArray;
    }

    private void testReset(StreamCipher streamCipher, StreamCipher streamCipher2, CipherParameters cipherParameters) throws InvalidCipherTextException {
        streamCipher.init(true, cipherParameters);
        byte[] byArray = new byte[1023];
        byte[] byArray2 = new byte[byArray.length];
        streamCipher.processBytes(byArray, 0, byArray.length, byArray2, 0);
        this.checkReset(streamCipher, cipherParameters, true, byArray, byArray2);
        streamCipher2.init(false, cipherParameters);
        this.checkReset(streamCipher2, cipherParameters, false, byArray2, byArray);
    }
}

