/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.io.IOException;
import org.bouncycastle.crypto.AlphabetMapper;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.fpe.FPEEngine;
import org.bouncycastle.crypto.fpe.FPEFF1Engine;
import org.bouncycastle.crypto.fpe.FPEFF3_1Engine;
import org.bouncycastle.crypto.params.FPEParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.util.BasicAlphabetMapper;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class SP80038GTest
extends SimpleTest {
    private static FFSample[] ff1Samples = new FFSample[]{FFSample.from(10, "2B7E151628AED2A6ABF7158809CF4F3C", "0123456789", "2433477484", ""), FFSample.from(10, "2B7E151628AED2A6ABF7158809CF4F3C", "0123456789", "6124200773", "39383736353433323130"), FFSample.from(36, "2B7E151628AED2A6ABF7158809CF4F3C", "0123456789abcdefghi", "a9tv40mll9kdu509eum", "3737373770717273373737"), FFSample.from(10, "2B7E151628AED2A6ABF7158809CF4F3CEF4359D8D580AA4F", "0123456789", "2830668132", ""), FFSample.from(10, "2B7E151628AED2A6ABF7158809CF4F3CEF4359D8D580AA4F", "0123456789", "2496655549", "39383736353433323130"), FFSample.from(36, "2B7E151628AED2A6ABF7158809CF4F3CEF4359D8D580AA4F", "0123456789abcdefghi", "xbj3kv35jrawxv32ysr", "3737373770717273373737"), FFSample.from(10, "2B7E151628AED2A6ABF7158809CF4F3CEF4359D8D580AA4F7F036D6F04FC6A94", "0123456789", "6657667009", ""), FFSample.from(10, "2B7E151628AED2A6ABF7158809CF4F3CEF4359D8D580AA4F7F036D6F04FC6A94", "0123456789", "1001623463", "39383736353433323130"), FFSample.from(36, "2B7E151628AED2A6ABF7158809CF4F3CEF4359D8D580AA4F7F036D6F04FC6A94", "0123456789abcdefghi", "xs8a0azh2avyalyzuwd", "3737373770717273373737")};
    private static FFSample[] ff3_1Samples = new FFSample[]{FFSample.from(62, "7793833CE891B496381BD5B882F77EA1", "YbpT3hDo0J9xwCQ5qUWt93iv", "dDEYxViK56lGbV1WdZTPTe4w", "C58797C2580174")};

    private void ff3_1Test(AlphabetMapper alphabetMapper, String string, String string2, String string3, String string4) throws IOException {
        FPEFF3_1Engine fPEFF3_1Engine = new FPEFF3_1Engine();
        FPEFF3_1Engine fPEFF3_1Engine2 = new FPEFF3_1Engine();
        byte[] byArray = Hex.decode(string);
        byte[] byArray2 = Hex.decode(string2);
        int n = alphabetMapper.getRadix();
        ((FPEEngine)fPEFF3_1Engine).init(true, new FPEParameters(new KeyParameter(byArray), n, byArray2));
        ((FPEEngine)fPEFF3_1Engine2).init(false, new FPEParameters(new KeyParameter(byArray), n, byArray2));
        byte[] byArray3 = alphabetMapper.convertToIndexes(string3.toCharArray());
        byte[] byArray4 = this.process(fPEFF3_1Engine, byArray3);
        this.isEquals(string4, new String(alphabetMapper.convertToChars(byArray4)));
        byte[] byArray5 = this.process(fPEFF3_1Engine2, byArray4);
        this.isTrue(Arrays.areEqual(byArray3, byArray5));
        char[] cArray = alphabetMapper.convertToChars(byArray5);
        this.isEquals(string3, String.valueOf(cArray));
    }

    public String getName() {
        return "SP80038GTest";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new SP80038GTest());
    }

    public void performTest() throws Exception {
        this.testFF1();
        this.testFF1w();
        this.testFF1Bounds();
        this.testFF1Rounding();
        this.testFF3_1();
        this.testFF3_1w();
        this.testFF3_1_255();
        this.testFF3_1Bounds();
        this.testDisable();
        this.testUtility();
        this.testExceptions();
    }

    private byte[] process(FPEEngine fPEEngine, byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[byArray.length];
        fPEEngine.processBlock(byArray, 0, byArray.length, byArray2, 0);
        return byArray2;
    }

    private void testDisable() throws Exception {
        System.setProperty("org.bouncycastle.fpe.disable", "true");
        try {
            this.testFF1();
            this.fail("no exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.isEquals("FF1 encryption disabled", unsupportedOperationException.getMessage());
        }
        try {
            this.testFF3_1();
            this.fail("no exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.isEquals("FPE disabled", unsupportedOperationException.getMessage());
        }
        System.setProperty("org.bouncycastle.fpe.disable", "false");
        System.setProperty("org.bouncycastle.fpe.disable_ff1", "true");
        try {
            this.testFF1();
            this.fail("no exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.isEquals("FF1 encryption disabled", unsupportedOperationException.getMessage());
        }
        this.testFF3_1();
        System.setProperty("org.bouncycastle.fpe.disable_ff1", "false");
    }

    private void testExceptions() {
        byte[] byArray = Hex.decode("339BB5B1F2D44BAABF87CA1B7380CDC8");
        byte[] byArray2 = Hex.decode("3F096DE35BFA31");
        int n = 256;
        FPEFF3_1Engine fPEFF3_1Engine = new FPEFF3_1Engine();
        try {
            fPEFF3_1Engine.processBlock(null, 0, 0, null, 0);
            this.fail("no exception");
        }
        catch (IllegalStateException illegalStateException) {
            this.isEquals("FPE engine not initialized", illegalStateException.getMessage());
        }
        ((FPEEngine)fPEFF3_1Engine).init(true, new FPEParameters(new KeyParameter(byArray), n, byArray2));
        try {
            fPEFF3_1Engine.processBlock(null, 0, 0, null, 0);
            this.fail("no exception");
        }
        catch (NullPointerException nullPointerException) {
            this.isEquals("buffer value is null", ((Throwable)nullPointerException).getMessage());
        }
        try {
            fPEFF3_1Engine.processBlock(new byte[2], 0, 2, null, 0);
            this.fail("no exception");
        }
        catch (NullPointerException nullPointerException) {
            this.isEquals("buffer value is null", ((Throwable)nullPointerException).getMessage());
        }
        try {
            fPEFF3_1Engine.processBlock(new byte[2], 0, -1, new byte[2], 0);
            this.fail("no exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("input length cannot be negative", illegalArgumentException.getMessage());
        }
        try {
            fPEFF3_1Engine.processBlock(new byte[4], 0, 6, new byte[6], 0);
            this.fail("no exception");
        }
        catch (DataLengthException dataLengthException) {
            this.isEquals("input buffer too short", dataLengthException.getMessage());
        }
        try {
            fPEFF3_1Engine.processBlock(new byte[4], 0, 4, new byte[2], 0);
            this.fail("no exception");
        }
        catch (OutputLengthException outputLengthException) {
            this.isEquals("output buffer too short", outputLengthException.getMessage());
        }
    }

    private void testFF1() throws Exception {
        int n = 0;
        while (n < ff1Samples.length) {
            this.testFF1Sample(ff1Samples[n]);
            ++n;
        }
        byte[] byArray = Hex.decode("EF4359D8D580AA4F7F036D6F04FC6A942B7E151628AED2A6");
        byte[] byArray2 = Hex.decode("0327035100210215");
        byte[] byArray3 = Hex.decode("39383736353433323130");
        FPEFF1Engine fPEFF1Engine = new FPEFF1Engine();
        ((FPEEngine)fPEFF1Engine).init(true, new FPEParameters(new KeyParameter(byArray), 24, byArray3));
        try {
            fPEFF1Engine.processBlock(byArray2, 0, byArray2.length, byArray2, 0);
            this.fail("no exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("input data outside of radix", illegalArgumentException.getMessage());
        }
        try {
            fPEFF1Engine.processBlock(new byte[]{1}, 0, 1, byArray2, 0);
            this.fail("no exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("input too short", illegalArgumentException.getMessage());
        }
    }

    public void testFF1Bounds() throws IOException {
        BasicAlphabetMapper basicAlphabetMapper;
        byte[] byArray = Hex.decode("339BB5B1F2D44BAABF87CA1B7380CDC8");
        byte[] byArray2 = Hex.decode("3F096DE35BFA31");
        FPEFF1Engine fPEFF1Engine = new FPEFF1Engine();
        try {
            basicAlphabetMapper = new BasicAlphabetMapper("ABCDEFGHI");
            ((FPEEngine)fPEFF1Engine).init(true, new FPEParameters(new KeyParameter(byArray), basicAlphabetMapper.getRadix(), byArray2));
            this.process(fPEFF1Engine, new byte[]{1, 2, 3});
            this.fail("no exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("input too short", illegalArgumentException.getMessage());
        }
        try {
            basicAlphabetMapper = new BasicAlphabetMapper("ABCD");
            ((FPEEngine)fPEFF1Engine).init(true, new FPEParameters(new KeyParameter(byArray), basicAlphabetMapper.getRadix(), byArray2));
            this.process(fPEFF1Engine, new byte[]{1, 2, 3});
            this.fail("no exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("input too short", illegalArgumentException.getMessage());
        }
    }

    public void testFF1Rounding() {
        int n = 256;
        byte[] byArray = Hex.decodeStrict("000102030405060708090a0b0c0d0e0f");
        byte[] byArray2 = Hex.decodeStrict("0001020304050607");
        byte[] byArray3 = Hex.decodeStrict("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232425262728292a2b2c2d2e2f303132333435363738");
        byte[] byArray4 = Hex.decodeStrict("dc18bef8b7d23aa77d1daf7a50c2253c4bacb772129f70805ecd413775bc3bdf7927ce70f455dacf4fdf61b61ac73a5c90fd3d1759dca0bf27");
        byte[] byArray5 = new byte[byArray3.length];
        FPEFF1Engine fPEFF1Engine = new FPEFF1Engine();
        FPEParameters fPEParameters = new FPEParameters(new KeyParameter(byArray), n, byArray2);
        ((FPEEngine)fPEFF1Engine).init(true, fPEParameters);
        fPEFF1Engine.processBlock(byArray3, 0, byArray3.length, byArray5, 0);
        this.isTrue("Failed FF1 rounding test (encryption)", this.areEqual(byArray4, byArray5));
        ((FPEEngine)fPEFF1Engine).init(false, fPEParameters);
        fPEFF1Engine.processBlock(byArray4, 0, byArray4.length, byArray5, 0);
        this.isTrue("Failed FF1 rounding test (decryption)", this.areEqual(byArray3, byArray5));
    }

    private void testFF1Sample(FFSample fFSample) {
        FPEFF1Engine fPEFF1Engine = new FPEFF1Engine();
        ((FPEEngine)fPEFF1Engine).init(true, new FPEParameters(new KeyParameter(fFSample.getKey()), fFSample.getRadix(), fFSample.getTweak()));
        byte[] byArray = fFSample.getPlaintext();
        byte[] byArray2 = new byte[byArray.length];
        fPEFF1Engine.processBlock(byArray, 0, byArray.length, byArray2, 0);
        this.isTrue(this.areEqual(fFSample.getCiphertext(), byArray2));
        ((FPEEngine)fPEFF1Engine).init(false, new FPEParameters(new KeyParameter(fFSample.getKey()), fFSample.getRadix(), fFSample.getTweak()));
        fPEFF1Engine.processBlock(fFSample.ciphertext, 0, fFSample.ciphertext.length, byArray2, 0);
        this.isTrue(this.areEqual(fFSample.getPlaintext(), byArray2));
    }

    public void testFF1w() throws Exception {
        byte[] byArray = Hex.decode("EF4359D8D580AA4F7F036D6F04FC6A942B7E151628AED2A6");
        byte[] byArray2 = Hex.decode("0327035100210215");
        byte[] byArray3 = Hex.decode("022701f80217020a");
        byte[] byArray4 = Hex.decode("39383736353433323130");
        FPEFF1Engine fPEFF1Engine = new FPEFF1Engine();
        ((FPEEngine)fPEFF1Engine).init(true, new FPEParameters(new KeyParameter(byArray), 1024, byArray4));
        byte[] byArray5 = new byte[byArray2.length];
        fPEFF1Engine.processBlock(byArray2, 0, byArray2.length, byArray5, 0);
        this.isTrue(this.areEqual(byArray3, byArray5));
        ((FPEEngine)fPEFF1Engine).init(false, new FPEParameters(new KeyParameter(byArray), 1024, byArray4));
        fPEFF1Engine.processBlock(byArray3, 0, byArray3.length, byArray5, 0);
        this.isTrue(this.areEqual(byArray2, byArray5));
        byte[] byArray6 = Hex.decode("03270F5100210215");
        try {
            fPEFF1Engine.processBlock(byArray6, 0, byArray6.length, byArray5, 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("input data outside of radix", illegalArgumentException.getMessage());
        }
    }

    public void testFF3_1() throws Exception {
        int n = 0;
        while (n < ff3_1Samples.length) {
            this.testFF3_1Sample(ff3_1Samples[n]);
            ++n;
        }
        byte[] byArray = Hex.decode("EF4359D8D580AA4F7F036D6F04FC6A942B7E151628AED2A6");
        byte[] byArray2 = Hex.decode("0327035100210215");
        byte[] byArray3 = Hex.decode("39383736353433");
        FPEFF3_1Engine fPEFF3_1Engine = new FPEFF3_1Engine();
        ((FPEEngine)fPEFF3_1Engine).init(true, new FPEParameters(new KeyParameter(byArray), 24, byArray3));
        try {
            fPEFF3_1Engine.processBlock(byArray2, 0, byArray2.length, byArray2, 0);
            this.fail("no exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("input data outside of radix", illegalArgumentException.getMessage());
        }
        try {
            ((FPEEngine)fPEFF3_1Engine).init(true, new FPEParameters(new KeyParameter(byArray), 24, Hex.decode("beef")));
            this.fail("no exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("tweak should be 56 bits", illegalArgumentException.getMessage());
        }
    }

    private void testFF3_1Bounds() throws IOException {
        String string = "+-ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz";
        BasicAlphabetMapper basicAlphabetMapper = new BasicAlphabetMapper(string);
        this.ff3_1Test(basicAlphabetMapper, "467094C27E47978FE616F475215BF4F1", "ECC8AA7B87B41C", "9RwG+t8cKfa9JweBYgHAA6fHUShNZ5tc", "-DXMBhb3AFPq5Xf4oUva4WbB8eagGK2u");
        this.ff3_1Test(basicAlphabetMapper, "4DB04B58E97819015A08BA7A39A79C303968A34DB0936FAD", "26B3A632FAADFE", "k5Kop6xYpT0skr1zHHPEt5rPWQ4s4O-3", "JyWzuPL6SNsciOXdEgwnKZJxHiKaTu4Z");
        this.ff3_1Test(basicAlphabetMapper, "15567AA6CD8CCA401ADB6A10730655AEEC10E9101FD3969A", "379B9572B687A6", "ZpztPp90Oo5ekoNRzqArsAqAbnmM--W6", "NPxEDufvnYzVX3jxupv+iJOuPVpWRPjD");
        try {
            this.ff3_1Test(basicAlphabetMapper, "15567AA6CD8CCA401ADB6A10730655AEEC10E9101FD3969A", "379B9572B687A6", "ZpztPp90Oo5ekoNRzqArsAqAbnmM+-W6ZZ", "L1yx-4YLQG9W1P5yTI7Wp2h0IDcRoBq1kk");
            this.fail("no exception 1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("maximum input length is 32", illegalArgumentException.getMessage());
        }
        try {
            this.ff3_1Test(basicAlphabetMapper, "15567AA6CD8CCA401ADB6A10730655AEEC10E9101FD3969A", "379B9572B687A6", "Z", "L");
            this.fail("no exception 2");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("input too short", illegalArgumentException.getMessage());
        }
        try {
            basicAlphabetMapper = new BasicAlphabetMapper("ABCDEFGHI");
            this.ff3_1Test(basicAlphabetMapper, "15567AA6CD8CCA401ADB6A10730655AEEC10E9101FD3969A", "379B9572B687A6", "AB", "ZZ");
            this.fail("no exception 3");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("input too short", illegalArgumentException.getMessage());
        }
    }

    private void testFF3_1Sample(FFSample fFSample) throws Exception {
        FPEFF3_1Engine fPEFF3_1Engine = new FPEFF3_1Engine();
        ((FPEEngine)fPEFF3_1Engine).init(true, new FPEParameters(new KeyParameter(fFSample.getKey()), fFSample.getRadix(), fFSample.getTweak()));
        byte[] byArray = fFSample.getPlaintext();
        byte[] byArray2 = new byte[byArray.length];
        fPEFF3_1Engine.processBlock(byArray, 0, byArray.length, byArray2, 0);
        this.isTrue(Arrays.areEqual(fFSample.getCiphertext(), byArray2));
        ((FPEEngine)fPEFF3_1Engine).init(false, new FPEParameters(new KeyParameter(fFSample.getKey()), fFSample.getRadix(), fFSample.getTweak()));
        fPEFF3_1Engine.processBlock(fFSample.getCiphertext(), 0, byArray.length, byArray2, 0);
        this.isTrue(Arrays.areEqual(fFSample.getPlaintext(), byArray2));
    }

    private void testFF3_1_255() {
        byte[] byArray = Hex.decode("339BB5B1F2D44BAABF87CA1B7380CDC8");
        byte[] byArray2 = Hex.decode("3F096DE35BFA31");
        int n = 256;
        FPEFF3_1Engine fPEFF3_1Engine = new FPEFF3_1Engine();
        ((FPEEngine)fPEFF3_1Engine).init(true, new FPEParameters(new KeyParameter(byArray), n, byArray2));
        long l = 210462922239L;
        byte[] byArray3 = Pack.longToBigEndian(l);
        byte[] byArray4 = new byte[byArray3.length];
        fPEFF3_1Engine.processBlock(byArray3, 0, byArray3.length, byArray4, 0);
        this.isTrue(Arrays.areEqual(Hex.decode("18fa139dc978a681"), byArray4));
        ((FPEEngine)fPEFF3_1Engine).init(false, new FPEParameters(new KeyParameter(byArray), n, byArray2));
        fPEFF3_1Engine.processBlock(byArray4, 0, byArray4.length, byArray4, 0);
        this.isTrue(Arrays.areEqual(byArray3, byArray4));
    }

    private void testFF3_1w() throws Exception {
        byte[] byArray = Hex.decode("EF4359D8D580AA4F7F036D6F04FC6A942B7E151628AED2A6");
        byte[] byArray2 = Hex.decode("0327035100210215");
        byte[] byArray3 = Hex.decode("02fb024900310220");
        byte[] byArray4 = Hex.decode("39383736353433");
        FPEFF3_1Engine fPEFF3_1Engine = new FPEFF3_1Engine();
        ((FPEEngine)fPEFF3_1Engine).init(true, new FPEParameters(new KeyParameter(byArray), 1024, byArray4));
        byte[] byArray5 = new byte[byArray2.length];
        fPEFF3_1Engine.processBlock(byArray2, 0, byArray2.length, byArray5, 0);
        this.isTrue("enc failed: " + Hex.toHexString(byArray5), this.areEqual(byArray3, byArray5));
        ((FPEEngine)fPEFF3_1Engine).init(false, new FPEParameters(new KeyParameter(byArray), 1024, byArray4));
        fPEFF3_1Engine.processBlock(byArray3, 0, byArray3.length, byArray5, 0);
        this.isTrue(this.areEqual(byArray2, byArray5));
        byte[] byArray6 = Hex.decode("03270F5100210215");
        try {
            fPEFF3_1Engine.processBlock(byArray6, 0, byArray6.length, byArray5, 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("input data outside of radix", illegalArgumentException.getMessage());
        }
    }

    public void testUtility() throws Exception {
        FPECharEncryptor fPECharEncryptor = new FPECharEncryptor(new FPEFF1Engine(), Hex.decode("2B7E151628AED2A6ABF7158809CF4F3C"), "0123456789".toCharArray());
        char[] cArray = "01234567890123456".toCharArray();
        char[] cArray2 = fPECharEncryptor.process(cArray);
        FPECharDecryptor fPECharDecryptor = new FPECharDecryptor(new FPEFF1Engine(), Hex.decode("2B7E151628AED2A6ABF7158809CF4F3C"), "0123456789".toCharArray());
        char[] cArray3 = fPECharDecryptor.process(cArray2);
        this.isTrue("no match", Arrays.areEqual(cArray, cArray3));
    }

    private static class FFSample {
        private final int radix;
        private final byte[] key;
        private final byte[] plaintext;
        private final byte[] ciphertext;
        private final byte[] tweak;

        private FFSample(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
            this.radix = n;
            this.key = byArray;
            this.plaintext = byArray2;
            this.ciphertext = byArray3;
            this.tweak = byArray4;
        }

        public static FFSample from(int n, String string, String string2, String string3, String string4) {
            return new FFSample(n, FFSample.fromHex(string), FFSample.fromAscii(n, string2), FFSample.fromAscii(n, string3), FFSample.fromHex(string4));
        }

        private static byte fromAlphaNumeric(char c) {
            if (c >= '0' && c <= '9') {
                return (byte)(c - 48);
            }
            if (c >= 'a' && c <= 'z') {
                return (byte)(10 + (c - 97));
            }
            if (c >= 'A' && c <= 'Z') {
                return (byte)(36 + (c - 65));
            }
            throw new IllegalArgumentException();
        }

        private static byte[] fromAscii(int n, String string) {
            byte[] byArray = new byte[string.length()];
            int n2 = 0;
            while (n2 < byArray.length) {
                byArray[n2] = FFSample.fromAlphaNumeric(string.charAt(n2));
                if (byArray[n2] < 0 || byArray[n2] >= n) {
                    throw new IllegalArgumentException();
                }
                ++n2;
            }
            return byArray;
        }

        private static byte[] fromHex(String string) {
            return Hex.decode(string);
        }

        public byte[] getCiphertext() {
            return this.ciphertext;
        }

        public byte[] getKey() {
            return this.key;
        }

        public byte[] getPlaintext() {
            return this.plaintext;
        }

        public int getRadix() {
            return this.radix;
        }

        public byte[] getTweak() {
            return this.tweak;
        }
    }

    public static class FPECharEncryptor {
        private final FPEEngine fpeEngine;
        private AlphabetMapper alphabetMapper;

        public FPECharEncryptor(FPEEngine fPEEngine, byte[] byArray, byte[] byArray2, char[] cArray) {
            this.fpeEngine = fPEEngine;
            this.alphabetMapper = new BasicAlphabetMapper(cArray);
            fPEEngine.init(true, new FPEParameters(new KeyParameter(byArray), this.alphabetMapper.getRadix(), byArray2));
        }

        public FPECharEncryptor(FPEEngine fPEEngine, byte[] byArray, char[] cArray) {
            this(fPEEngine, byArray, new byte[0], cArray);
        }

        public char[] process(char[] cArray) throws IOException {
            byte[] byArray = this.alphabetMapper.convertToIndexes(cArray);
            this.fpeEngine.processBlock(byArray, 0, byArray.length, byArray, 0);
            return this.alphabetMapper.convertToChars(byArray);
        }
    }

    public static class FPECharDecryptor {
        private final FPEEngine fpeEngine;
        private AlphabetMapper alphabetMapper;

        public FPECharDecryptor(FPEEngine fPEEngine, byte[] byArray, byte[] byArray2, char[] cArray) {
            this.fpeEngine = fPEEngine;
            this.alphabetMapper = new BasicAlphabetMapper(cArray);
            fPEEngine.init(false, new FPEParameters(new KeyParameter(byArray), this.alphabetMapper.getRadix(), byArray2));
        }

        public FPECharDecryptor(FPEEngine fPEEngine, byte[] byArray, char[] cArray) {
            this(fPEEngine, byArray, new byte[0], cArray);
        }

        public char[] process(char[] cArray) throws IOException {
            byte[] byArray = this.alphabetMapper.convertToIndexes(cArray);
            this.fpeEngine.processBlock(byArray, 0, byArray.length, byArray, 0);
            return this.alphabetMapper.convertToChars(byArray);
        }
    }
}

