/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.generators.SM2KeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.test.FixedSecureRandom;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.TestRandomBigInteger;

public class SM2SignerTest
extends SimpleTest {
    private static final ECDomainParameters PARAMS_FP_DRAFT = SM2SignerTest.createParamsFpDraft();
    private static final ECDomainParameters PARAMS_F2M = SM2SignerTest.createParamsF2m();

    private static ECDomainParameters createParamsF2m() {
        BigInteger bigInteger = new BigInteger("00", 16);
        BigInteger bigInteger2 = new BigInteger("E78BCD09746C202378A7E72B12BCE00266B9627ECB0B5A25367AD1AD4CC6242B", 16);
        BigInteger bigInteger3 = new BigInteger("7FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFBC972CF7E6B6F900945B3C6A0CF6161D", 16);
        BigInteger bigInteger4 = BigInteger.valueOf(4L);
        BigInteger bigInteger5 = new BigInteger("00CDB9CA7F1E6B0441F658343F4B10297C0EF9B6491082400A62E7A7485735FADD", 16);
        BigInteger bigInteger6 = new BigInteger("013DE74DA65951C4D76DC89220D5F7777A611B1C38BAE260B175951DC8060C2B3E", 16);
        ECCurve.F2m f2m = new ECCurve.F2m(257, 12, bigInteger, bigInteger2, bigInteger3, bigInteger4);
        ECPoint eCPoint = ((ECCurve)f2m).createPoint(bigInteger5, bigInteger6);
        return new ECDomainParameters(f2m, eCPoint, bigInteger3, bigInteger4);
    }

    private static ECDomainParameters createParamsFpDraft() {
        BigInteger bigInteger = new BigInteger("8542D69E4C044F18E8B92435BF6FF7DE457283915C45517D722EDB8B08F1DFC3", 16);
        BigInteger bigInteger2 = new BigInteger("787968B4FA32C3FD2417842E73BBFEFF2F3C848B6831D7E0EC65228B3937E498", 16);
        BigInteger bigInteger3 = new BigInteger("63E4C6D3B23B0C849CF84241484BFE48F61D59A5B16BA06E6E12D1DA27C5249A", 16);
        BigInteger bigInteger4 = new BigInteger("8542D69E4C044F18E8B92435BF6FF7DD297720630485628D5AE74EE7C32E79B7", 16);
        BigInteger bigInteger5 = ECConstants.ONE;
        BigInteger bigInteger6 = new BigInteger("421DEBD61B62EAB6746434EBC3CC315E32220B3BADD50BDC4C4E6C147FEDD43D", 16);
        BigInteger bigInteger7 = new BigInteger("0680512BCBB42C07D47349D2153B70C4E5D7FDFCBFA36EA1A85841B9E46E09A2", 16);
        ECCurve.Fp fp = new ECCurve.Fp(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5);
        ECPoint eCPoint = fp.createPoint(bigInteger6, bigInteger7);
        return new ECDomainParameters(fp, eCPoint, bigInteger4, bigInteger5);
    }

    private static BigInteger[] decode(byte[] byArray) {
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(byArray);
        return new BigInteger[]{SM2SignerTest.decodeValue(aSN1Sequence.getObjectAt(0)), SM2SignerTest.decodeValue(aSN1Sequence.getObjectAt(1))};
    }

    private static BigInteger decodeValue(ASN1Encodable aSN1Encodable) {
        return ASN1Integer.getInstance(aSN1Encodable).getValue();
    }

    private void doKeyGenAndSignBoundsCheck() throws Exception {
        SM2KeyPairGenerator sM2KeyPairGenerator = new SM2KeyPairGenerator();
        ECDomainParameters eCDomainParameters = SM2SignerTest.createParamsFpDraft();
        try {
            sM2KeyPairGenerator.init(new ECKeyGenerationParameters(eCDomainParameters, new FixedSecureRandom(BigIntegers.asUnsignedByteArray(eCDomainParameters.getN().subtract(BigIntegers.ONE)))));
            sM2KeyPairGenerator.generateKeyPair();
            this.fail("no exception");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
        eCKeyPairGenerator.init(new ECKeyGenerationParameters(eCDomainParameters, new FixedSecureRandom(BigIntegers.asUnsignedByteArray(eCDomainParameters.getN().subtract(BigIntegers.ONE)))));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
        SM2Signer sM2Signer = new SM2Signer();
        try {
            sM2Signer.init(true, asymmetricCipherKeyPair.getPrivate());
            this.fail("no exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("SM2 private key out of range", illegalArgumentException.getMessage());
        }
    }

    private void doSignerTest(String string, Digest digest, String string2, String string3, String string4, String string5, String string6, String string7) throws Exception {
        X9ECParameters x9ECParameters = ECNamedCurveTable.getByName(string);
        ECDomainParameters eCDomainParameters = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
        this.doSignerTest(eCDomainParameters, digest, string2, string3, string4, string5, string6, string7);
    }

    private void doSignerTest(ECDomainParameters eCDomainParameters, Digest digest, String string, String string2, String string3, String string4, String string5, String string6) throws Exception {
        this.implSignerTest(eCDomainParameters, digest, string, string2, string3, string4, string5, string6);
        this.implSignerTestReuse(eCDomainParameters, digest, string, string2, string3);
    }

    private void doSignerTestF2m() throws Exception {
        this.doSignerTest(PARAMS_F2M, (Digest)new SM3Digest(), "ALICE123@YAHOO.COM", "message digest", "771EF3DBFF5F1CDC32B9C572930476191998B2BF7CB981D7F5B39202645F0931", "36CD79FC8E24B7357A8A7B4A46D454C397703D6498158C605399B341ADA186D6", "6D3FBA26EAB2A1054F5D198332E335817C8AC453ED26D3391CD4439D825BF25B", "3124C5688D95F0A10252A9BED033BEC84439DA384621B6D6FAD77F94B74A9556");
    }

    private void doSignerTestFpDraftSM3() throws Exception {
        this.doSignerTest(PARAMS_FP_DRAFT, (Digest)new SM3Digest(), "ALICE123@YAHOO.COM", "message digest", "128B2FA8BD433C6C068C8D803DFF79792A519A55171B1B650C23661D15897263", "6CB28D99385C175C94F94E934817663FC176D925DD72B727260DBAAE1FB2F96F", "40F1EC59F793D9F49E09DCEF49130D4194F79FB1EED2CAA55BACDB49C4E755D1", "6FC6DAC32C5D5CF10C77DFB20F7C2EB667A457872FB09EC56327A67EC7DEEBE7");
    }

    private void doSignerTestFpDraftSha256() throws Exception {
        this.doSignerTest(PARAMS_FP_DRAFT, (Digest)new SHA256Digest(), "ALICE123@YAHOO.COM", "message digest", "128B2FA8BD433C6C068C8D803DFF79792A519A55171B1B650C23661D15897263", "6CB28D99385C175C94F94E934817663FC176D925DD72B727260DBAAE1FB2F96F", "7D62A5EDBDDC8AF4D69C9E37A60D31F5CEFE8727709117E0869648D0A9AE4F57", "1E5E89718B716AAFC6253443168E4F7CF7E1B7B3934307686CE5947C1BD55EDA");
    }

    private void doSignerTestFpP256SM3() throws Exception {
        this.doSignerTest("P-256", (Digest)new SM3Digest(), "sm2_p256_test@example.com", "no backdoors here", "110E7973206F68C19EE5F7328C036F26911C8C73B4E4F36AE3291097F8984FFC", "3174C6FFC3C279D2422F3FC0A9F3E574674A4490FE45A5325CAF7D3EC4C8F96C", "96AA39A0C4A5C454653F394E86386F2E38BE14C57D0E555F3A27A5CEF30E51BD", "62372BE4AC97DBE725AC0B279BB8FD15883858D814FD792DDB0A401DCC988E70");
    }

    private void doSignerTestFpP256Sha256() throws Exception {
        this.doSignerTest("P-256", (Digest)new SHA256Digest(), "sm2_p256_test@example.com", "no backdoors here", "110E7973206F68C19EE5F7328C036F26911C8C73B4E4F36AE3291097F8984FFC", "3174C6FFC3C279D2422F3FC0A9F3E574674A4490FE45A5325CAF7D3EC4C8F96C", "503D234A22123D7029271EB9E0D763619A69868DE8296C13EDD4CA32D280CFDE", "0BDE97699B77268584DDD238DA120095F01130AD2DB37184270F37C02FB2E86B");
    }

    private void doSignerTestFpStandardSM3() throws Exception {
        this.doSignerTest("sm2p256v1", (Digest)new SM3Digest(), "sm2test@example.com", "hi chappy", "110E7973206F68C19EE5F7328C036F26911C8C73B4E4F36AE3291097F8984FFC", "3174C6FFC3C279D2422F3FC0A9F3E574674A4490FE45A5325CAF7D3EC4C8F96C", "05890B9077B92E47B17A1FF42A814280E556AFD92B4A98B9670BF8B1A274C2FA", "E3ABBB8DB2B6ECD9B24ECCEA7F679FB9A4B1DB52F4AA985E443AD73237FA1993");
    }

    private void doSignerTestFpStandardSha256() throws Exception {
        this.doSignerTest("sm2p256v1", (Digest)new SHA256Digest(), "sm2test@example.com", "hi chappy", "110E7973206F68C19EE5F7328C036F26911C8C73B4E4F36AE3291097F8984FFC", "3174C6FFC3C279D2422F3FC0A9F3E574674A4490FE45A5325CAF7D3EC4C8F96C", "94DA20EA69E4FC70692158BF3D30F87682A4B2F84DF4A4829A1EFC5D9C979D3F", "EE15AF8D455B728AB80E592FCB654BF5B05620B2F4D25749D263D5C01FAD365F");
    }

    private void doVerifyBoundsCheck() throws IOException {
        ECDomainParameters eCDomainParameters = PARAMS_F2M;
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = SM2SignerTest.generateKeyPair(eCDomainParameters, "771EF3DBFF5F1CDC32B9C572930476191998B2BF7CB981D7F5B39202645F0931");
        SM2Signer sM2Signer = new SM2Signer();
        sM2Signer.init(false, asymmetricCipherKeyPair.getPublic());
        sM2Signer.update(new byte[20], 0, 20);
        this.isTrue(sM2Signer.verifySignature(SM2SignerTest.encode(ECConstants.ZERO, ECConstants.EIGHT)) ^ true);
        sM2Signer.update(new byte[20], 0, 20);
        this.isTrue(sM2Signer.verifySignature(SM2SignerTest.encode(ECConstants.EIGHT, ECConstants.ZERO)) ^ true);
        sM2Signer.update(new byte[20], 0, 20);
        this.isTrue(sM2Signer.verifySignature(SM2SignerTest.encode(eCDomainParameters.getN(), ECConstants.EIGHT)) ^ true);
        sM2Signer.update(new byte[20], 0, 20);
        this.isTrue(sM2Signer.verifySignature(SM2SignerTest.encode(ECConstants.EIGHT, eCDomainParameters.getN())) ^ true);
    }

    private static byte[] encode(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
        return new DERSequence(new ASN1Encodable[]{new ASN1Integer(bigInteger), new ASN1Integer(bigInteger2)}).getEncoded();
    }

    private static AsymmetricCipherKeyPair generateKeyPair(ECDomainParameters eCDomainParameters, String string) {
        ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
        eCKeyPairGenerator.init(new ECKeyGenerationParameters(eCDomainParameters, new TestRandomBigInteger(string, 16)));
        return eCKeyPairGenerator.generateKeyPair();
    }

    public String getName() {
        return "SM2Signer";
    }

    private void implSignerTest(ECDomainParameters eCDomainParameters, Digest digest, String string, String string2, String string3, String string4, String string5, String string6) throws Exception {
        byte[] byArray = Strings.toByteArray(string);
        byte[] byArray2 = Strings.toByteArray(string2);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = SM2SignerTest.generateKeyPair(eCDomainParameters, string3);
        SM2Signer sM2Signer = new SM2Signer(digest);
        sM2Signer.init(true, new ParametersWithID(new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), new TestRandomBigInteger(string4, 16)), byArray));
        sM2Signer.update(byArray2, 0, byArray2.length);
        byte[] byArray3 = sM2Signer.generateSignature();
        BigInteger[] bigIntegerArray = SM2SignerTest.decode(byArray3);
        this.isTrue("r wrong", bigIntegerArray[0].equals(new BigInteger(string5, 16)));
        this.isTrue("s wrong", bigIntegerArray[1].equals(new BigInteger(string6, 16)));
        sM2Signer.init(false, new ParametersWithID(asymmetricCipherKeyPair.getPublic(), byArray));
        sM2Signer.update(byArray2, 0, byArray2.length);
        this.isTrue("verification failed", sM2Signer.verifySignature(byArray3));
    }

    private void implSignerTestReuse(ECDomainParameters eCDomainParameters, Digest digest, String string, String string2, String string3) throws Exception {
        byte[] byArray = Strings.toByteArray(string);
        byte[] byArray2 = Strings.toByteArray(string2);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = SM2SignerTest.generateKeyPair(eCDomainParameters, string3);
        SM2Signer sM2Signer = new SM2Signer(digest);
        sM2Signer.init(true, new ParametersWithID(asymmetricCipherKeyPair.getPrivate(), byArray));
        sM2Signer.update(byArray2, 0, byArray2.length);
        byte[] byArray3 = sM2Signer.generateSignature();
        sM2Signer.update(byArray2, 0, byArray2.length);
        byte[] byArray4 = sM2Signer.generateSignature();
        sM2Signer.update((byte)0);
        sM2Signer.reset();
        sM2Signer.update(byArray2, 0, byArray2.length);
        byte[] byArray5 = sM2Signer.generateSignature();
        sM2Signer.init(false, new ParametersWithID(asymmetricCipherKeyPair.getPublic(), byArray));
        sM2Signer.update(byArray2, 0, byArray2.length);
        this.isTrue("verification failed", sM2Signer.verifySignature(byArray3));
        sM2Signer.update(byArray2, 0, byArray2.length);
        this.isTrue("verification failed", sM2Signer.verifySignature(byArray4));
        sM2Signer.update((byte)0);
        sM2Signer.reset();
        sM2Signer.update(byArray2, 0, byArray2.length);
        this.isTrue("verification failed", sM2Signer.verifySignature(byArray5));
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new SM2SignerTest());
    }

    public void performTest() throws Exception {
        this.doSignerTestFpDraftSM3();
        this.doSignerTestFpDraftSha256();
        this.doSignerTestFpStandardSM3();
        this.doSignerTestFpStandardSha256();
        this.doSignerTestFpP256SM3();
        this.doSignerTestFpP256Sha256();
        this.doSignerTestF2m();
        this.doVerifyBoundsCheck();
        this.doKeyGenAndSignBoundsCheck();
    }
}

