/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class SHA1HMacTest
implements Test {
    static final String[] keys = new String[]{"0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b", "4a656665", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "0102030405060708090a0b0c0d0e0f10111213141516171819", "0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F202122232425262728292A2B2C2D2E2F303132333435363738393A3B3C3D3E3F"};
    static final String[] digests = new String[]{"b617318655057264e28bc0b6fb378c8ef146be00", "effcdf6ae5eb2fa2d27416d5f184df9c259a7c79", "125d7342b9ac11cd91a39af48aa17b4f63f175d3", "4c9007f4026250c6bc8414f9bf50c86c2d7235da", "4c1a03424b55e07fe7f27be1d58bb9324a9a5a04", "aa4ae5e15272d00e95705637ce8a3b55ed402112", "e8e99d0f45237d786d6bbaa7965c7808bbff1a91", "5FD596EE78D5553C8FF4E72D266DFD192366DA29"};
    static final String[] messages = new String[]{"Hi There", "what do ya want for nothing?", "0xdddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd", "0xcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcd", "Test With Truncation", "Test Using Larger Than Block-Size Key - Hash Key First", "Test Using Larger Than Block-Size Key and Larger Than One Block-Size Data", "Sample message for keylen=blocklen"};

    public String getName() {
        return "SHA1HMac";
    }

    public static void main(String[] stringArray) {
        SHA1HMacTest sHA1HMacTest = new SHA1HMacTest();
        TestResult testResult = sHA1HMacTest.perform();
        System.out.println(testResult);
    }

    public TestResult perform() {
        HMac hMac = new HMac(new SHA1Digest());
        byte[] byArray = new byte[hMac.getMacSize()];
        int n = 0;
        while (n < messages.length) {
            byte[] byArray2 = messages[n].getBytes();
            if (messages[n].startsWith("0x")) {
                byArray2 = Hex.decode(messages[n].substring(2));
            }
            hMac.init(new KeyParameter(Hex.decode(keys[n])));
            hMac.update(byArray2, 0, byArray2.length);
            hMac.doFinal(byArray, 0);
            if (!Arrays.areEqual(byArray, Hex.decode(digests[n]))) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Vector " + n + " failed");
            }
            ++n;
        }
        int n2 = 0;
        byte[] byArray3 = messages[n2].getBytes();
        if (messages[n2].startsWith("0x")) {
            byArray3 = Hex.decode(messages[n2].substring(2));
        }
        hMac.init(new KeyParameter(Hex.decode(keys[n2])));
        hMac.update(byArray3, 0, byArray3.length);
        hMac.doFinal(byArray, 0);
        hMac.reset();
        hMac.update(byArray3, 0, byArray3.length);
        hMac.doFinal(byArray, 0);
        if (!Arrays.areEqual(byArray, Hex.decode(digests[n2]))) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + "Reset with vector " + n2 + " failed");
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }
}

