/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.crypto.generators.SCrypt;
import org.bouncycastle.test.TestResourceFinder;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class SCryptTest
extends SimpleTest {
    private void checkIllegal(String string, byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4) {
        try {
            SCrypt.generate(byArray, byArray2, n, n2, n3, n4);
            this.fail(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    private void checkOK(String string, byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4) {
        try {
            SCrypt.generate(byArray, byArray2, n, n2, n3, n4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            this.fail(string);
        }
    }

    private static int extractInteger(String string) {
        return Integer.parseInt(string.trim());
    }

    private static byte[] extractQuotedString(String string) {
        string = string.trim();
        string = string.substring(1, string.length() - 1);
        return Strings.toByteArray(string);
    }

    public String getName() {
        return "SCrypt";
    }

    private static boolean isEndData(String string) {
        return string == null || string.startsWith("scrypt");
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new SCryptTest());
    }

    public void performTest() throws Exception {
        this.testPermutations();
        this.testParameters();
        this.testVectors();
    }

    private void permute(List list, byte[] byArray, int n, int n2) {
        if (n == n2) {
            list.add(Arrays.clone(byArray));
        } else {
            int n3 = n;
            while (n3 <= n2) {
                this.swap(byArray, n, n3);
                this.permute(list, byArray, n + 1, n2);
                this.swap(byArray, n, n3);
                ++n3;
            }
        }
    }

    private void swap(byte[] byArray, int n, int n2) {
        byte by = byArray[n];
        byArray[n] = byArray[n2];
        byArray[n2] = by;
    }

    public void testParameters() {
        this.checkOK("Minimal values", new byte[0], new byte[0], 2, 1, 1, 1);
        this.checkIllegal("Cost parameter must be > 1", new byte[0], new byte[0], 1, 1, 1, 1);
        this.checkOK("Cost parameter 32768 OK for r == 1", new byte[0], new byte[0], 32768, 1, 1, 1);
        this.checkIllegal("Cost parameter must < 65536 for r == 1", new byte[0], new byte[0], 65536, 1, 1, 1);
        this.checkIllegal("Block size must be >= 1", new byte[0], new byte[0], 2, 0, 2, 1);
        this.checkIllegal("Parallelisation parameter must be >= 1", new byte[0], new byte[0], 2, 1, 0, 1);
        this.checkIllegal("Parallelisation parameter must be < 65535 for r = 4", new byte[0], new byte[0], 2, 32, 65536, 1);
        this.checkIllegal("Len parameter must be > 1", new byte[0], new byte[0], 2, 1, 1, 0);
    }

    public void testPermutations() throws Exception {
        byte[] byArray = Strings.toByteArray("aabcdd");
        byte[] byArray2 = null;
        byte[][] byArray3 = new byte[][]{new byte[16], new byte[16], new byte[16]};
        int n = 0;
        while (n < 16) {
            byArray3[1][n] = (byte)n;
            byArray3[2][n] = (byte)(16 - n);
            ++n;
        }
        int n2 = byArray.length - 1;
        while (n2 < byArray.length + 2) {
            byArray2 = new byte[n2];
            int n3 = 0;
            while (n3 < byArray.length) {
                int n4 = 0;
                while (n4 < byArray2.length) {
                    byArray2[n4] = byArray[(n3 + n4) % byArray.length];
                    ++n4;
                }
                ArrayList arrayList = new ArrayList();
                this.permute(arrayList, byArray2, 0, byArray2.length - 1);
                int n5 = 0;
                while (n5 != arrayList.size()) {
                    byte[] byArray4 = (byte[])arrayList.get(n5);
                    int n6 = 0;
                    while (n6 != byArray3.length) {
                        byte[] byArray5 = byArray3[n6];
                        byte[] byArray6 = SCrypt.generate(byArray, byArray5, 2, 1, 1, 32);
                        byte[] byArray7 = SCrypt.generate(byArray4, byArray5, 2, 1, 1, 32);
                        boolean bl = Arrays.areEqual(byArray, byArray4);
                        this.isTrue("expected same result", bl == Arrays.areEqual(byArray6, byArray7));
                        ++n6;
                    }
                    ++n5;
                }
                ++n3;
            }
            ++n2;
        }
    }

    public void testVectors() throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(TestResourceFinder.findTestResource("crypto", "SCryptTestVectors.txt")));
        int n = 0;
        String string = bufferedReader.readLine();
        while (string != null) {
            byte[] byArray;
            int n2;
            ++n;
            String string2 = string;
            StringBuffer stringBuffer = new StringBuffer();
            while (!SCryptTest.isEndData(string = bufferedReader.readLine())) {
                n2 = 0;
                while (n2 != string.length()) {
                    if (string.charAt(n2) != ' ') {
                        stringBuffer.append(string.charAt(n2));
                    }
                    ++n2;
                }
            }
            n2 = string2.indexOf(40) + 1;
            int n3 = string2.lastIndexOf(41);
            String string3 = string2.substring(n2, n3);
            String[] stringArray = Strings.split(string3, ',');
            byte[] byArray2 = SCryptTest.extractQuotedString(stringArray[0]);
            byte[] byArray3 = SCryptTest.extractQuotedString(stringArray[1]);
            int n4 = SCryptTest.extractInteger(stringArray[2]);
            int n5 = SCryptTest.extractInteger(stringArray[3]);
            int n6 = SCryptTest.extractInteger(stringArray[4]);
            int n7 = SCryptTest.extractInteger(stringArray[5]);
            byte[] byArray4 = Hex.decode(stringBuffer.toString());
            if (n4 > 16384 || this.areEqual(byArray4, byArray = SCrypt.generate(byArray2, byArray3, n4, n5, n6, n7))) continue;
            this.fail("Result does not match expected value in test case " + n);
        }
        bufferedReader.close();
    }
}

